/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.driver;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.utils.CommonUtils;

public class DriverClassLoader
extends URLClassLoader {
    private final DriverDescriptor driver;

    public DriverClassLoader(DriverDescriptor driver, URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.driver = driver;
    }

    @Override
    protected String findLibrary(String libname) {
        String nativeName = System.mapLibraryName(libname);
        for (DBPDriverLibrary dBPDriverLibrary : this.driver.getDriverLibraries()) {
            List<DriverDescriptor.DriverFileInfo> cachedFiles;
            if (dBPDriverLibrary.getType() != DBPDriverLibrary.FileType.lib || !dBPDriverLibrary.matchesCurrentPlatform()) continue;
            File localFile = dBPDriverLibrary.getLocalFile();
            if (localFile == null && !CommonUtils.isEmpty(cachedFiles = this.driver.getCachedFiles(dBPDriverLibrary))) {
                for (DriverDescriptor.DriverFileInfo fileInfo : cachedFiles) {
                    if (fileInfo.getFile() == null || !fileInfo.getFile().getName().equalsIgnoreCase(nativeName)) continue;
                    return fileInfo.getFile().getAbsolutePath();
                }
            }
            if (localFile == null || !localFile.exists() || !localFile.getName().equalsIgnoreCase(nativeName)) continue;
            return localFile.getAbsolutePath();
        }
        return super.findLibrary(libname);
    }
}

