/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data.formatters;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.Map;
import org.jkiss.dbeaver.model.data.DBDDataFormatter;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.time.ExtendedDateFormat;

public class DateTimeDataFormatter
implements DBDDataFormatter {
    public static final String PROP_PATTERN = "pattern";
    private String pattern;
    private DateFormat dateFormat;
    private StringBuffer buffer;
    private FieldPosition position;
    private DateTimeFormatter dateTimeFormatter;

    @Override
    public void init(DBSTypedObject type, Locale locale, Map<Object, Object> properties) {
        this.pattern = CommonUtils.toString((Object)properties.get(PROP_PATTERN));
        this.dateFormat = new ExtendedDateFormat(this.pattern, locale);
        this.dateFormat.setLenient(false);
        this.buffer = new StringBuffer();
        this.position = new FieldPosition(0);
        String java8DatePattern = this.pattern.replaceAll("f+", "n");
        this.dateTimeFormatter = DateTimeFormatter.ofPattern(java8DatePattern);
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String formatValue(Object value) {
        if (value instanceof TemporalAccessor) {
            return this.dateTimeFormatter.format((TemporalAccessor)value);
        }
        DateFormat dateFormat = this.dateFormat;
        synchronized (dateFormat) {
            this.buffer.setLength(0);
            return value == null ? null : this.dateFormat.format(value, this.buffer, this.position).toString();
        }
    }

    @Override
    public Object parseValue(String value, Class<?> typeHint) throws ParseException {
        if (typeHint != null && TemporalAccessor.class.isAssignableFrom(typeHint)) {
            try {
                return LocalDateTime.parse(value, this.dateTimeFormatter);
            }
            catch (DateTimeParseException e) {
                throw new ParseException(e.getParsedString(), e.getErrorIndex());
            }
        }
        return this.dateFormat.parse(value);
    }
}

