/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedureParameter;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class PostgreAggregate
implements PostgreObject {
    private long oid;
    private PostgreSchema schema;
    private String name;
    private boolean persisted;

    public PostgreAggregate(PostgreSchema schema, ResultSet dbResult) throws SQLException {
        this.schema = schema;
        this.loadInfo(dbResult);
    }

    private void loadInfo(ResultSet dbResult) throws SQLException {
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"proc_oid");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"proc_name");
        this.persisted = true;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public List<PostgreDataType> getInputTypes(DBRProgressMonitor monitor) throws DBException {
        PostgreProcedure function = this.getFunction(monitor);
        if (function == null) {
            return null;
        }
        ArrayList<PostgreDataType> result = new ArrayList<PostgreDataType>();
        for (PostgreProcedureParameter param : function.getInputParameters()) {
            result.add(param.getParameterType());
        }
        return result;
    }

    @Property(viewable=true, order=3)
    public PostgreDataType getOutputType(DBRProgressMonitor monitor) throws DBException {
        PostgreProcedure function = this.getFunction(monitor);
        return function == null ? null : function.getReturnType();
    }

    @Property(viewable=false, order=80)
    public long getObjectId() {
        return this.oid;
    }

    @Property(viewable=true, order=10)
    public PostgreProcedure getFunction(DBRProgressMonitor monitor) throws DBException {
        return this.schema.getProcedure(monitor, this.oid);
    }

    public DBSObject getParentObject() {
        return this.schema;
    }

    @Override
    @NotNull
    public PostgreDataSource getDataSource() {
        return this.schema.getDataSource();
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return this.schema.getDatabase();
    }

    public String getDescription() {
        return null;
    }

    @Property(viewable=true, multiline=true, order=100)
    public String getDescription(DBRProgressMonitor monitor) throws DBException {
        PostgreProcedure function = this.getFunction(monitor);
        return function == null ? null : function.getDescription();
    }

    public boolean isPersisted() {
        return this.persisted;
    }
}

