/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.editors.ExasolSourceObject;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableBase;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableColumn;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableForeignKey;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.format.SQLFormatUtils;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;

public class ExasolView
extends ExasolTableBase
implements ExasolSourceObject,
DBSView {
    private String owner;
    private Boolean hasRead = false;
    private String text;

    public ExasolView(ExasolSchema schema, String name, boolean persisted) {
        super(schema, name, persisted);
    }

    public ExasolView(DBRProgressMonitor monitor, ExasolSchema schema, ResultSet dbResult) {
        super(monitor, schema, dbResult);
        this.hasRead = false;
    }

    public ExasolView(ExasolSchema schema) {
        super(schema, null, false);
        this.text = "";
        this.hasRead = true;
    }

    public DBSObjectState getObjectState() {
        return DBSObjectState.NORMAL;
    }

    @Override
    @Property(viewable=true, editable=false, updatable=false, multiline=true, order=40)
    public String getDescription() {
        return super.getDescription();
    }

    @Property(viewable=true, order=100)
    @NotNull
    public String getOwner() throws DBCException {
        this.read();
        return this.owner;
    }

    private void read() throws DBCException {
        if (!this.hasRead.booleanValue()) {
            JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)new VoidProgressMonitor(), (DBSObject)this, (String)"Read Table Details");
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (JDBCStatement stmt = session.createStatement();){
                    String sql = String.format("/*snapshot execution*/ SELECT VIEW_OWNER,VIEW_TEXT FROM SYS.EXA_ALL_VIEWS WHERE VIEW_SCHEMA = '%s' and VIEW_NAME = '%s'", ExasolUtils.quoteString(this.getSchema().getName()), ExasolUtils.quoteString(this.getName()));
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (JDBCResultSet dbResult = stmt.executeQuery(sql);){
                        Boolean read = dbResult.next();
                        if (read.booleanValue()) {
                            this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"VIEW_OWNER");
                            this.text = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"VIEW_TEXT");
                            this.hasRead = true;
                        } else {
                            this.owner = "SYS OBJECT";
                            this.text = "No View Text for system objects available";
                        }
                        this.hasRead = true;
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
            }
        }
    }

    @Override
    public boolean isView() {
        return true;
    }

    @Override
    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
    }

    @Override
    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getSchema(), this});
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.refreshObject(monitor);
        this.hasRead = false;
        return this;
    }

    @Override
    public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return Collections.emptyList();
    }

    @Override
    public Collection<ExasolTableForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return Collections.emptyList();
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        this.read();
        return SQLFormatUtils.formatSQL((DBPDataSource)this.getDataSource(), (String)this.text);
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
        this.text = sourceText;
    }

    public String getSource() throws DBCException {
        this.read();
        return this.text;
    }

    public JDBCStructCache<ExasolSchema, ExasolView, ExasolTableColumn> getCache() {
        return ((ExasolSchema)this.getContainer()).getViewCache();
    }
}

