/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser.rules;

import java.util.HashMap;
import java.util.Map;
import org.jkiss.dbeaver.model.sql.parser.rules.SQLDelimiterRule;
import org.jkiss.dbeaver.model.text.parser.TPCharacterScanner;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenAbstract;

public class SQLWordRule
implements TPRule {
    private SQLDelimiterRule delimRule;
    private TPToken defaultToken;
    private Map<String, TPToken> fWords = new HashMap<String, TPToken>();
    private StringBuilder fBuffer = new StringBuilder();
    private char[][] delimiters;

    public SQLWordRule(SQLDelimiterRule delimRule, TPToken defaultToken) {
        this.delimRule = delimRule;
        this.defaultToken = defaultToken;
    }

    public boolean hasWord(String word) {
        return this.fWords.containsKey(word.toLowerCase());
    }

    public void addWord(String word, TPToken token) {
        this.fWords.put(word.toLowerCase(), token);
    }

    @Override
    public TPToken evaluate(TPCharacterScanner scanner) {
        int c = scanner.read();
        if (c != -1 && Character.isUnicodeIdentifierStart(c)) {
            this.fBuffer.setLength(0);
            this.delimiters = this.delimRule.getDelimiters();
            do {
                this.fBuffer.append((char)c);
            } while ((c = scanner.read()) != -1 && this.isWordPart((char)c, scanner));
            scanner.unread();
            String buffer = this.fBuffer.toString().toLowerCase();
            TPToken token = this.fWords.get(buffer);
            if (token != null) {
                return token;
            }
            if (this.defaultToken.isUndefined()) {
                this.unreadBuffer(scanner);
            }
            return this.defaultToken;
        }
        scanner.unread();
        return TPTokenAbstract.UNDEFINED;
    }

    private boolean isWordPart(char c, TPCharacterScanner scanner) {
        if (!Character.isUnicodeIdentifierPart(c) && c != '$') {
            return false;
        }
        char[][] cArray = this.delimiters;
        int n = this.delimiters.length;
        int n2 = 0;
        while (n2 < n) {
            char[] wordDelimiter = cArray[n2];
            if (!Character.isLetter(c) && c == wordDelimiter[0]) {
                if (wordDelimiter.length == 1) {
                    return false;
                }
                int charsRead = 0;
                boolean matches = true;
                int i = 1;
                while (i < wordDelimiter.length) {
                    int c2 = scanner.read();
                    ++charsRead;
                    if (c2 == -1) break;
                    if (c2 != wordDelimiter[i]) {
                        matches = false;
                        break;
                    }
                    ++i;
                }
                i = 0;
                while (i < charsRead) {
                    scanner.unread();
                    ++i;
                }
                if (matches) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private void unreadBuffer(TPCharacterScanner scanner) {
        int i = this.fBuffer.length() - 1;
        while (i >= 0) {
            scanner.unread();
            --i;
        }
    }
}

