/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreConstraintManager;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreTableColumnManager;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreIndex;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeignKey;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableReal;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTrigger;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreViewBase;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistActionComment;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.utils.CommonUtils;

public abstract class PostgreTableManagerBase
extends SQLTableManager<PostgreTableBase, PostgreSchema> {
    protected void addObjectExtraActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.NestedObjectCommand<PostgreTableBase, SQLObjectEditor.PropertyHandler> command, Map<String, Object> options) {
        boolean showComments;
        Object descProp;
        boolean isDDL = CommonUtils.getOption(options, (String)"ddl.source");
        PostgreTableBase table = (PostgreTableBase)command.getObject();
        String comment = !table.isPersisted() ? ((descProp = command.getProperty((Object)"description")) != null ? descProp.toString() : null) : table.getDescription();
        boolean bl = showComments = CommonUtils.getOption(options, (String)"pg.ddl.show.column.comments") || CommonUtils.getOption(options, (String)"object.save");
        if (showComments && comment != null) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment table", "COMMENT ON " + (table.isView() ? ((PostgreViewBase)table).getViewType() : "TABLE") + " " + table.getFullyQualifiedName(DBPEvaluationContext.DDL) + " IS " + SQLUtils.quoteString((DBSObject)table, (String)comment)));
        }
        if (isDDL || !table.isPersisted()) {
            try {
                Collection<PostgreTrigger> triggers;
                boolean hasComments;
                if (showComments) {
                    hasComments = false;
                    for (PostgreTableColumn column : CommonUtils.safeCollection(table.getAttributes(monitor))) {
                        if (CommonUtils.isEmpty((String)column.getDescription())) continue;
                        if (!hasComments) {
                            actions.add((DBEPersistAction)new SQLDatabasePersistActionComment(table.getDataSource(), "Column comments"));
                        }
                        PostgreTableColumnManager.addColumnCommentAction(actions, column);
                        hasComments = true;
                    }
                }
                if (showComments) {
                    hasComments = false;
                    for (PostgreTableConstraintBase constr : CommonUtils.safeCollection(table.getConstraints(monitor))) {
                        if (CommonUtils.isEmpty((String)constr.getDescription())) continue;
                        if (!hasComments) {
                            actions.add((DBEPersistAction)new SQLDatabasePersistActionComment(table.getDataSource(), "Constraint comments"));
                        }
                        PostgreConstraintManager.addConstraintCommentAction(actions, constr);
                        hasComments = true;
                    }
                    for (DBSEntityAssociation fk : CommonUtils.safeCollection(table.getAssociations(monitor))) {
                        if (!(fk instanceof PostgreTableForeignKey) || CommonUtils.isEmpty((String)fk.getDescription())) continue;
                        if (!hasComments) {
                            actions.add((DBEPersistAction)new SQLDatabasePersistActionComment(table.getDataSource(), "Foreign key comments"));
                        }
                        PostgreConstraintManager.addConstraintCommentAction(actions, (PostgreTableForeignKey)fk);
                        hasComments = true;
                    }
                }
                if (table instanceof PostgreTableReal && !CommonUtils.isEmpty(triggers = ((PostgreTableReal)table).getTriggers(monitor))) {
                    actions.add((DBEPersistAction)new SQLDatabasePersistActionComment(table.getDataSource(), "Table Triggers"));
                    for (PostgreTrigger trigger : triggers) {
                        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create trigger", trigger.getObjectDefinitionText(monitor, options)));
                    }
                }
                if (isDDL) {
                    PostgreUtils.getObjectGrantPermissionActions(monitor, table, actions, options);
                }
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
    }

    protected boolean isIncludeIndexInDDL(DBSTableIndex index) {
        return !((PostgreIndex)index).isPrimaryKeyIndex() && super.isIncludeIndexInDDL(index);
    }
}

