/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.dialogs.SelectObjectDialog;
import org.jkiss.utils.CommonUtils;

public class SelectDatabaseDialog
extends SelectObjectDialog<DBNDatabaseNode> {
    private static final Log log = Log.getLog(SelectDatabaseDialog.class);
    private final DBPDataSourceContainer dataSourceContainer;
    private String currentInstanceName;
    private Collection<? extends DBSObject> instanceObjects;

    public SelectDatabaseDialog(Shell parentShell, DBPDataSourceContainer dataSourceContainer, String currentInstanceName, Collection<DBNDatabaseNode> objects, Collection<DBNDatabaseNode> selected) {
        super(parentShell, UINavigatorMessages.label_choose_catalog, true, "SchemaSelector", objects, selected);
        this.dataSourceContainer = dataSourceContainer;
        this.currentInstanceName = currentInstanceName;
    }

    @Override
    protected void createUpperControls(Composite dialogArea) {
        DBPDataSource dataSource = this.dataSourceContainer.getDataSource();
        if (this.currentInstanceName != null && dataSource != null) {
            DBSObjectContainer instanceContainer = (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)dataSource);
            DBCExecutionContextDefaults contextDefaults = null;
            DBCExecutionContext defaultContext = DBUtils.getDefaultContext((DBSObject)instanceContainer, (boolean)true);
            if (defaultContext != null) {
                contextDefaults = defaultContext.getContextDefaults();
            }
            if (instanceContainer != null && contextDefaults != null && contextDefaults.supportsCatalogChange() && contextDefaults.supportsSchemaChange()) {
                Composite instancePanel = UIUtils.createComposite((Composite)dialogArea, (int)3);
                instancePanel.setLayoutData((Object)new GridData(768));
                UIUtils.createLabel((Composite)instancePanel, (DBPImage)this.dataSourceContainer.getDriver().getIcon());
                Combo instanceCombo = UIUtils.createLabelCombo((Composite)instancePanel, (String)UINavigatorMessages.label_instance, (String)UINavigatorMessages.label_active_service_instance, (int)12);
                instanceCombo.setLayoutData((Object)new GridData(768));
                try {
                    this.instanceObjects = instanceContainer.getChildren((DBRProgressMonitor)new VoidProgressMonitor());
                    if (this.instanceObjects != null) {
                        for (DBSObject dBSObject : this.instanceObjects) {
                            instanceCombo.add(dBSObject.getName());
                        }
                        instanceCombo.setText(this.currentInstanceName);
                    }
                }
                catch (DBException dBException) {
                    log.error((Object)UINavigatorMessages.label_error_list, (Throwable)dBException);
                }
                instanceCombo.addModifyListener(e -> {
                    String instanceName = instanceCombo.getText();
                    if (!CommonUtils.equalObjects((Object)instanceName, (Object)this.currentInstanceName)) {
                        this.currentInstanceName = instanceName;
                        this.objectList.loadData();
                    }
                });
                this.closeOnFocusLost(new Control[]{instanceCombo});
            }
        }
    }

    @Override
    protected Collection<DBNDatabaseNode> getObjects(DBRProgressMonitor monitor) throws DBException {
        Object rootObject = this.instanceObjects != null && this.currentInstanceName != null ? (DBSObject)DBUtils.findObject(this.instanceObjects, (String)this.currentInstanceName) : this.dataSourceContainer.getDataSource();
        if (rootObject instanceof DBSObjectContainer) {
            Collection objectList = ((DBSObjectContainer)rootObject).getChildren(monitor);
            if (objectList == null) {
                return Collections.emptyList();
            }
            ArrayList<DBNDatabaseNode> nodeList = new ArrayList<DBNDatabaseNode>(objectList.size());
            for (DBSObject object : objectList) {
                DBNDatabaseNode databaseNode;
                if (!(object instanceof DBSObjectContainer) || (databaseNode = DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)object, (boolean)false)) == null) continue;
                nodeList.add(databaseNode);
            }
            return nodeList;
        }
        return this.objects;
    }

    public String getCurrentInstanceName() {
        DBNDatabaseNode selectedObject = (DBNDatabaseNode)this.getSelectedObject();
        if (selectedObject.getObject() instanceof DBSCatalog) {
            return selectedObject.getObject().getName();
        }
        return this.currentInstanceName;
    }
}

