/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.navigator;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.jkiss.dbeaver.ext.erd.ERDMessages;
import org.jkiss.dbeaver.ext.erd.model.DiagramObjectCollector;
import org.jkiss.dbeaver.ext.erd.model.ERDDecoratorDefault;
import org.jkiss.dbeaver.ext.erd.model.EntityDiagram;
import org.jkiss.dbeaver.ext.erd.navigator.DiagramCreateWizardPage;
import org.jkiss.dbeaver.ext.erd.navigator.ERDResourceHandler;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLEditorHandlerOpenEditor;

public class DiagramCreateWizard
extends Wizard
implements INewWizard {
    private IFolder folder;
    private EntityDiagram diagram = new EntityDiagram(new ERDDecoratorDefault(), null, "");
    private DiagramCreateWizardPage pageContent;
    private String errorMessage;
    private IStructuredSelection entitySelection;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object element;
        this.setWindowTitle(ERDMessages.wizard_diagram_create_title);
        this.setNeedsProgressMonitor(true);
        IFolder diagramFolder = null;
        if (selection != null && (element = selection.getFirstElement()) != null) {
            diagramFolder = (IFolder)Platform.getAdapterManager().getAdapter(element, IFolder.class);
        }
        if (diagramFolder == null) {
            DBPProject activeProject = DBWorkbench.getPlatform().getWorkspace().getActiveProject();
            if (activeProject == null) {
                this.errorMessage = "Can't create diagram without active project";
            } else {
                try {
                    diagramFolder = ERDResourceHandler.getDiagramsFolder(activeProject, true);
                }
                catch (CoreException e) {
                    this.errorMessage = e.getMessage();
                }
            }
            if (selection != null && !selection.isEmpty() && Platform.getAdapterManager().getAdapter(selection.getFirstElement(), DBSEntity.class) != null) {
                this.entitySelection = selection;
            }
        }
        this.folder = diagramFolder;
    }

    public void addPages() {
        super.addPages();
        this.pageContent = new DiagramCreateWizardPage(this.diagram, this.entitySelection);
        this.addPage((IWizardPage)this.pageContent);
        if (this.getContainer() != null) {
            this.pageContent.setErrorMessage(this.errorMessage);
        }
    }

    public void setContainer(IWizardContainer wizardContainer) {
        super.setContainer(wizardContainer);
        if (this.pageContent != null) {
            this.pageContent.setErrorMessage(this.errorMessage);
        }
    }

    public boolean performFinish() {
        try {
            Collection<DBNNode> initialContent = this.pageContent.getInitialContent();
            ArrayList<DBSObject> rootObjects = new ArrayList<DBSObject>();
            for (DBNNode node : initialContent) {
                if (!(node instanceof DBNDatabaseNode)) continue;
                rootObjects.add(((DBNDatabaseNode)node).getObject());
            }
            DiagramCreator creator = new DiagramCreator(rootObjects);
            UIUtils.run((IRunnableContext)this.getContainer(), (boolean)true, (boolean)true, (DBRRunnableWithProgress)creator);
            SQLEditorHandlerOpenEditor.openResource((IResource)creator.diagramFile);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException ex) {
            DBWorkbench.getPlatformUI().showError("Create error", "Cannot create diagram", ex.getTargetException());
            return false;
        }
        return true;
    }

    private class DiagramCreator
    implements DBRRunnableWithProgress {
        Collection<DBSObject> roots;
        IFile diagramFile;

        private DiagramCreator(Collection<DBSObject> roots) {
            this.roots = roots;
        }

        public void run(DBRProgressMonitor monitor) throws InvocationTargetException {
            try {
                Collection<DBSEntity> tables = DiagramObjectCollector.collectTables(monitor, this.roots);
                DiagramCreateWizard.this.diagram.fillEntities(monitor, tables, null);
                this.diagramFile = ERDResourceHandler.createDiagram(DiagramCreateWizard.this.diagram, DiagramCreateWizard.this.diagram.getName(), DiagramCreateWizard.this.folder, monitor);
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
    }
}

