/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.athena.views;

import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.athena.AthenaActivator;
import org.jkiss.dbeaver.ext.athena.internal.AthenaMessages;
import org.jkiss.dbeaver.ext.athena.model.AWSRegion;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.ICompositeDialogPage;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class AthenaConnectionPage
extends ConnectionPageAbstract
implements ICompositeDialogPage {
    private Combo awsRegionCombo;
    private Text s3LocationText;
    private Text accessKeyText;
    private static ImageDescriptor logoImage = AthenaActivator.getImageDescriptor("icons/aws_athena_logo.png");
    private DriverPropertiesDialogPage driverPropsPage = new DriverPropertiesDialogPage((ConnectionPageAbstract)this);

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        Composite settingsGroup = new Composite(composite, 0);
        settingsGroup.setLayout((Layout)new GridLayout(1, false));
        settingsGroup.setLayoutData((Object)new GridData(1808));
        ModifyListener textListener = e -> this.site.updateButtons();
        Group addrGroup = UIUtils.createControlGroup((Composite)settingsGroup, (String)AthenaMessages.label_connection, (int)2, (int)0, (int)0);
        addrGroup.setLayoutData((Object)new GridData(768));
        this.awsRegionCombo = UIUtils.createLabelCombo((Composite)addrGroup, (String)AthenaMessages.label_region, (int)4);
        this.awsRegionCombo.addModifyListener(textListener);
        this.s3LocationText = UIUtils.createLabelText((Composite)addrGroup, (String)AthenaMessages.label_s3_location, (String)"");
        this.s3LocationText.setToolTipText(AthenaMessages.label_s3_output_location);
        this.s3LocationText.addModifyListener(textListener);
        addrGroup = UIUtils.createControlGroup((Composite)settingsGroup, (String)AthenaMessages.label_security, (int)2, (int)0, (int)0);
        addrGroup.setLayoutData((Object)new GridData(768));
        this.accessKeyText = UIUtils.createLabelText((Composite)addrGroup, (String)AthenaMessages.label_aws_access_key, (String)"");
        this.accessKeyText.setToolTipText(AthenaMessages.label_access_key);
        this.accessKeyText.addModifyListener(textListener);
        Text secretAccessKeyText = this.createPasswordText((Composite)addrGroup, AthenaMessages.label_secret_key);
        secretAccessKeyText.setToolTipText(AthenaMessages.label_access_key_id);
        secretAccessKeyText.addModifyListener(textListener);
        this.createPasswordControls((Composite)addrGroup, 2);
        this.createDriverPanel(settingsGroup);
        this.setControl((Control)settingsGroup);
    }

    public boolean isComplete() {
        return this.awsRegionCombo != null && !CommonUtils.isEmpty((String)this.awsRegionCombo.getText()) && this.s3LocationText != null && !CommonUtils.isEmpty((String)this.s3LocationText.getText()) && this.accessKeyText != null && !CommonUtils.isEmpty((String)this.accessKeyText.getText()) && this.passwordText != null && !CommonUtils.isEmpty((String)this.passwordText.getText());
    }

    public void loadSettings() {
        super.loadSettings();
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.awsRegionCombo != null) {
            this.awsRegionCombo.removeAll();
            AWSRegion[] aWSRegionArray = AWSRegion.values();
            int n = aWSRegionArray.length;
            int n2 = 0;
            while (n2 < n) {
                AWSRegion region = aWSRegionArray[n2];
                this.awsRegionCombo.add(region.getId());
                ++n2;
            }
            if (!CommonUtils.isEmpty((String)connectionInfo.getServerName())) {
                this.awsRegionCombo.setText(connectionInfo.getServerName());
            }
            if (this.awsRegionCombo.getText().isEmpty()) {
                this.awsRegionCombo.setText(AWSRegion.us_west_1.getId());
            }
        }
        if (this.s3LocationText != null) {
            String databaseName = connectionInfo.getDatabaseName();
            if (CommonUtils.isEmpty((String)databaseName)) {
                databaseName = "s3://";
            }
            this.s3LocationText.setText(databaseName);
        }
        if (this.accessKeyText != null) {
            this.accessKeyText.setText(CommonUtils.notEmpty((String)connectionInfo.getUserName()));
        }
        if (this.passwordText != null) {
            this.passwordText.setText(CommonUtils.notEmpty((String)connectionInfo.getUserPassword()));
        }
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.awsRegionCombo != null) {
            connectionInfo.setServerName(this.awsRegionCombo.getText().trim());
        }
        if (this.s3LocationText != null) {
            connectionInfo.setDatabaseName(this.s3LocationText.getText().trim());
        }
        if (this.accessKeyText != null) {
            connectionInfo.setUserName(this.accessKeyText.getText().trim());
        }
        if (this.passwordText != null && this.savePasswordCheck.getSelection()) {
            connectionInfo.setUserPassword(this.passwordText.getText().trim());
        }
        super.saveSettings(dataSource);
    }

    public IDialogPage[] getSubPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{this.driverPropsPage};
    }
}

