/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDBinaryFormatter;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.impl.data.formatters.BinaryFormatterHexNative;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLStateType;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameter;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameterKind;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public abstract class AbstractSQLDialect
implements SQLDialect {
    public static final String ID = "basic";
    private static final String[] DEFAULT_LINE_COMMENTS = new String[]{"//"};
    private static final String[] QUERY_KEYWORDS = new String[]{"SELECT"};
    private static final String[] EXEC_KEYWORDS = new String[0];
    private static final String[] DDL_KEYWORDS = new String[0];
    public static final String[][] DEFAULT_IDENTIFIER_QUOTES = new String[][]{{"\"", "\""}};
    public static final String[][] DEFAULT_STRING_QUOTES = new String[][]{{"'", "'"}};
    private static final String[][] DEFAULT_BEGIN_END_BLOCK = new String[0][];
    private static final String[] CORE_NON_TRANSACTIONAL_KEYWORDS = new String[0];
    public static final String[] DML_KEYWORDS = new String[0];
    private TreeMap<String, DBPKeywordType> allKeywords = new TreeMap();
    private final TreeSet<String> reservedWords = new TreeSet();
    protected final TreeSet<String> functions = new TreeSet();
    protected final TreeSet<String> types = new TreeSet();
    protected final TreeSet<String> tableQueryWords = new TreeSet();
    protected final TreeSet<String> columnQueryWords = new TreeSet();
    private Pair<String, String> multiLineComments = new Pair((Object)"/*", (Object)"*/");
    private Map<String, Integer> keywordsIndent = new HashMap<String, Integer>();

    protected AbstractSQLDialect() {
    }

    @Override
    @Nullable
    public String[][] getIdentifierQuoteStrings() {
        return DEFAULT_IDENTIFIER_QUOTES;
    }

    @Override
    @NotNull
    public String[][] getStringQuoteStrings() {
        return DEFAULT_STRING_QUOTES;
    }

    @Override
    @NotNull
    public String[] getQueryKeywords() {
        return QUERY_KEYWORDS;
    }

    @Override
    @NotNull
    public String[] getExecuteKeywords() {
        return EXEC_KEYWORDS;
    }

    @Override
    @NotNull
    public String[] getDDLKeywords() {
        return DDL_KEYWORDS;
    }

    protected void addSQLKeyword(String keyword) {
        this.reservedWords.add(keyword);
        this.allKeywords.put(keyword, DBPKeywordType.KEYWORD);
    }

    protected void removeSQLKeyword(String keyword) {
        this.reservedWords.remove(keyword);
        this.allKeywords.remove(keyword);
    }

    protected void addSQLKeywords(Collection<String> allKeywords) {
        for (String kw : allKeywords) {
            this.addSQLKeyword(kw);
        }
    }

    protected void setKeywordIndent(String ketyword, int indent) {
        this.keywordsIndent.put(ketyword, indent);
    }

    protected void addFunctions(Collection<String> allFunctions) {
        this.functions.addAll(allFunctions);
        this.addKeywords(allFunctions, DBPKeywordType.FUNCTION);
    }

    protected void addDataTypes(Collection<String> allTypes) {
        for (String type : allTypes) {
            this.types.add(type.toUpperCase(Locale.ENGLISH));
        }
        this.addKeywords(allTypes, DBPKeywordType.TYPE);
    }

    protected void addKeywords(Collection<String> set, DBPKeywordType type) {
        if (set != null) {
            for (String keyword : set) {
                keyword = keyword.toUpperCase(Locale.ENGLISH);
                this.reservedWords.add(keyword);
                DBPKeywordType oldType = this.allKeywords.get(keyword);
                if (oldType == DBPKeywordType.KEYWORD) continue;
                this.allKeywords.put(keyword, type);
            }
        }
    }

    @Override
    @NotNull
    public Set<String> getReservedWords() {
        return this.reservedWords;
    }

    @Override
    @NotNull
    public Set<String> getFunctions(@Nullable DBPDataSource dataSource) {
        return this.functions;
    }

    @NotNull
    public TreeSet<String> getDataTypes(@Nullable DBPDataSource dataSource) {
        return this.types;
    }

    @Override
    public DBPKeywordType getKeywordType(@NotNull String word) {
        return this.allKeywords.get(word.toUpperCase(Locale.ENGLISH));
    }

    @Override
    @NotNull
    public List<String> getMatchedKeywords(@NotNull String word) {
        word = word.toUpperCase(Locale.ENGLISH);
        ArrayList<String> result = new ArrayList<String>();
        for (String keyword : this.allKeywords.tailMap(word).keySet()) {
            if (!keyword.startsWith(word)) break;
            result.add(keyword);
        }
        return result;
    }

    @Override
    public boolean isKeywordStart(@NotNull String word) {
        SortedMap<String, DBPKeywordType> map = this.allKeywords.tailMap(word.toUpperCase(Locale.ENGLISH));
        return !map.isEmpty() && map.firstKey().startsWith(word);
    }

    @Override
    public boolean isEntityQueryWord(@NotNull String word) {
        return this.tableQueryWords.contains(word.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public boolean isAttributeQueryWord(@NotNull String word) {
        return this.columnQueryWords.contains(word.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public int getKeywordNextLineIndent(@NotNull String word) {
        Integer indent = this.keywordsIndent.get(word.toUpperCase(Locale.ENGLISH));
        return indent == null ? 0 : indent;
    }

    @Override
    @NotNull
    public String getSearchStringEscape() {
        return "";
    }

    @Override
    public char getStringEscapeCharacter() {
        return '\u0000';
    }

    @Override
    public int getCatalogUsage() {
        return 0;
    }

    @Override
    public int getSchemaUsage() {
        return 0;
    }

    @Override
    @NotNull
    public String getCatalogSeparator() {
        return String.valueOf('.');
    }

    @Override
    public char getStructSeparator() {
        return '.';
    }

    @Override
    @NotNull
    public String[] getParametersPrefixes() {
        return new String[0];
    }

    @Override
    public boolean isCatalogAtStart() {
        return true;
    }

    @Override
    @NotNull
    public SQLStateType getSQLStateType() {
        return SQLStateType.SQL99;
    }

    @Override
    @NotNull
    public String getScriptDelimiter() {
        return ";";
    }

    @Override
    @Nullable
    public String getScriptDelimiterRedefiner() {
        return null;
    }

    @Override
    public String[][] getBlockBoundStrings() {
        return DEFAULT_BEGIN_END_BLOCK;
    }

    @Override
    @Nullable
    public String[] getBlockHeaderStrings() {
        return null;
    }

    @Override
    public boolean validIdentifierStart(char c) {
        return Character.isLetter(c);
    }

    @Override
    public boolean validIdentifierPart(char c, boolean quoted) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '_';
    }

    @Override
    public boolean supportsUnquotedMixedCase() {
        return true;
    }

    @Override
    public boolean supportsQuotedMixedCase() {
        return true;
    }

    @Override
    @NotNull
    public DBPIdentifierCase storesUnquotedCase() {
        return DBPIdentifierCase.UPPER;
    }

    @Override
    @NotNull
    public DBPIdentifierCase storesQuotedCase() {
        return DBPIdentifierCase.MIXED;
    }

    @Override
    @NotNull
    public String escapeString(String string) {
        return string.replace("'", "''");
    }

    @Override
    @NotNull
    public String unEscapeString(String string) {
        return CommonUtils.notEmpty((String)string).replace("''", "'");
    }

    @Override
    @NotNull
    public String escapeScriptValue(DBSAttributeBase attribute, @NotNull Object value, @NotNull String strValue) {
        if (value instanceof UUID) {
            return String.valueOf('\'') + this.escapeString(strValue) + '\'';
        }
        return strValue;
    }

    @Override
    @NotNull
    public SQLDialect.MultiValueInsertMode getMultiValueInsertMode() {
        return SQLDialect.MultiValueInsertMode.NOT_SUPPORTED;
    }

    @Override
    public String addFiltersToQuery(DBPDataSource dataSource, String query, DBDDataFilter filter) {
        return SQLSemanticProcessor.addFiltersToQuery(dataSource, query, filter);
    }

    @Override
    public boolean supportsSubqueries() {
        return true;
    }

    @Override
    public boolean supportsAliasInSelect() {
        return false;
    }

    @Override
    public boolean supportsAliasInUpdate() {
        return false;
    }

    @Override
    public boolean supportsTableDropCascade() {
        return false;
    }

    @Override
    public boolean supportsOrderByIndex() {
        return true;
    }

    @Override
    public boolean supportsCommentQuery() {
        return false;
    }

    @Override
    public boolean supportsNullability() {
        return true;
    }

    @Override
    public Pair<String, String> getMultiLineComments() {
        return this.multiLineComments;
    }

    @Override
    public String[] getSingleLineComments() {
        return DEFAULT_LINE_COMMENTS;
    }

    @Override
    public boolean isDelimiterAfterQuery() {
        return false;
    }

    @Override
    public boolean isDelimiterAfterBlock() {
        return false;
    }

    @Override
    @NotNull
    public DBDBinaryFormatter getNativeBinaryFormatter() {
        return BinaryFormatterHexNative.INSTANCE;
    }

    @Override
    public String getTestSQL() {
        return null;
    }

    @Override
    @Nullable
    public String getDualTableName() {
        return null;
    }

    @Override
    public boolean isTransactionModifyingQuery(String queryString) {
        if ((queryString = SQLUtils.stripComments(this, queryString)).isEmpty()) {
            return false;
        }
        String firstKeyword = SQLUtils.getFirstKeyword(this, queryString);
        if (firstKeyword.isEmpty()) {
            return false;
        }
        firstKeyword = firstKeyword.toUpperCase(Locale.ENGLISH);
        return this.isTransactionModifyingKeyword(firstKeyword);
    }

    protected boolean isTransactionModifyingKeyword(String firstKeyword) {
        if (this.getKeywordType(firstKeyword) != DBPKeywordType.KEYWORD) {
            return false;
        }
        if (this.containsKeyword(this.getDDLKeywords(), firstKeyword) || this.containsKeyword(this.getDMLKeywords(), firstKeyword) || this.containsKeyword(this.getExecuteKeywords(), firstKeyword) || this.containsKeyword(this.getBlockHeaderStrings(), firstKeyword)) {
            return true;
        }
        String[][] blockBoundStrings = this.getBlockBoundStrings();
        if (blockBoundStrings != null) {
            String[][] stringArray = blockBoundStrings;
            int n = blockBoundStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String[] bb = stringArray[n2];
                if (bb.length > 0 && firstKeyword.equals(bb[0])) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean containsKeyword(String[] keywords, String keyword) {
        if (keywords == null) {
            return false;
        }
        int i = 0;
        while (i < keywords.length) {
            if (keyword.equals(keywords[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    @NotNull
    public String[] getDMLKeywords() {
        return DML_KEYWORDS;
    }

    @NotNull
    public String[] getNonTransactionKeywords() {
        return CORE_NON_TRANSACTIONAL_KEYWORDS;
    }

    @Override
    public boolean isQuoteReservedWords() {
        return true;
    }

    @Override
    public boolean isCRLFBroken() {
        return false;
    }

    @Override
    public String getColumnTypeModifiers(@NotNull DBPDataSource dataSource, @NotNull DBSTypedObject column, @NotNull String typeName, @NotNull DBPDataKind dataKind) {
        DBSDataType dataType;
        typeName = CommonUtils.notEmpty((String)typeName).toUpperCase(Locale.ENGLISH);
        if (column instanceof DBSObject && (dataType = column instanceof DBSTypedObjectEx ? ((DBSTypedObjectEx)((Object)column)).getDataType() : DBUtils.getLocalDataType(((DBSObject)((Object)column)).getDataSource(), column.getTypeName())) != null && CommonUtils.equalObjects((Object)dataType.getScale(), (Object)column.getScale()) && (CommonUtils.toInt((Object)dataType.getPrecision()) > 0 && CommonUtils.equalObjects((Object)dataType.getPrecision(), (Object)column.getPrecision()) || dataType.getMaxLength() > 0L && dataType.getMaxLength() == column.getMaxLength())) {
            return null;
        }
        if (dataKind == DBPDataKind.STRING) {
            long maxLength;
            if (typeName.indexOf(40) == -1 && (maxLength = column.getMaxLength()) > 0L && maxLength != Integer.MAX_VALUE && maxLength != Long.MAX_VALUE) {
                Object maxStringLength = dataSource.getDataSourceFeature("datasource.max-string-type-length");
                if (maxStringLength instanceof Number) {
                    int lengthLimit = ((Number)maxStringLength).intValue();
                    if (lengthLimit < 0) {
                        return null;
                    }
                    if ((long)lengthLimit < maxLength) {
                        maxLength = lengthLimit;
                    }
                }
                return "(" + maxLength + ")";
            }
        } else if (!(dataKind != DBPDataKind.CONTENT && dataKind != DBPDataKind.BINARY || typeName.contains("LOB"))) {
            long maxLength = column.getMaxLength();
            if (maxLength > 0L && maxLength < Integer.MAX_VALUE) {
                return "(" + maxLength + ')';
            }
        } else if (dataKind == DBPDataKind.NUMERIC) {
            int precision;
            if (typeName.equals("DECIMAL") || typeName.equals("NUMERIC") || typeName.equals("NUMBER")) {
                Integer scale = column.getScale();
                int precision2 = CommonUtils.toInt((Object)column.getPrecision());
                if (precision2 == 0) {
                    precision2 = (int)column.getMaxLength();
                }
                if (scale != null && scale >= 0 && precision2 >= 0 && (scale != 0 || precision2 != 0)) {
                    return "(" + precision2 + ',' + scale + ')';
                }
            } else if (typeName.equals("BIT") && (precision = CommonUtils.toInt((Object)column.getPrecision())) > 1) {
                return "(" + precision + ')';
            }
        }
        return null;
    }

    @Override
    public String formatStoredProcedureCall(DBPDataSource dataSource, String sqlText) {
        return sqlText;
    }

    protected int getMaxParameterLength(Collection<? extends DBSProcedureParameter> parameters, List<DBSProcedureParameter> inParameters) {
        int maxParamLength = 0;
        for (DBSProcedureParameter dBSProcedureParameter : parameters) {
            if (dBSProcedureParameter.getParameterKind() != DBSProcedureParameterKind.IN) continue;
            inParameters.add(dBSProcedureParameter);
            if (dBSProcedureParameter.getName().length() <= maxParamLength) continue;
            maxParamLength = dBSProcedureParameter.getName().length();
        }
        return maxParamLength;
    }

    protected boolean useBracketsForExec() {
        return false;
    }

    protected String getStoredProcedureCallInitialClause(DBSProcedure proc) {
        Object[] executeKeywords = this.getExecuteKeywords();
        if (proc.getProcedureType() == DBSProcedureType.FUNCTION || ArrayUtils.isEmpty((Object[])executeKeywords)) {
            return "SELECT " + proc.getFullyQualifiedName(DBPEvaluationContext.DML);
        }
        return String.valueOf(executeKeywords[0]) + " " + proc.getFullyQualifiedName(DBPEvaluationContext.DML);
    }

    @Override
    public void generateStoredProcedureCall(StringBuilder sql, DBSProcedure proc, Collection<? extends DBSProcedureParameter> parameters) {
        boolean useBrackets;
        block10: {
            ArrayList<? extends DBSProcedureParameter> inParameters = new ArrayList<DBSProcedureParameter>();
            if (parameters != null) {
                inParameters.addAll(parameters);
            }
            if (useBrackets = this.useBracketsForExec()) {
                sql.append("{ ");
            }
            sql.append(this.getStoredProcedureCallInitialClause(proc)).append("(");
            if (inParameters.isEmpty()) break block10;
            boolean first = true;
            int i = 0;
            while (i < inParameters.size()) {
                block11: {
                    DBSProcedureParameter parameter = (DBSProcedureParameter)inParameters.get(i);
                    if (!first) {
                        sql.append(",");
                    }
                    switch (parameter.getParameterKind()) {
                        case IN: {
                            sql.append(":").append(CommonUtils.escapeIdentifier((String)parameter.getName()));
                            break;
                        }
                        case RETURN: {
                            break block11;
                        }
                        default: {
                            sql.append("?");
                        }
                    }
                    parameter.getParameterType().getFullTypeName();
                    first = false;
                }
                ++i;
            }
        }
        sql.append(")");
        if (!useBrackets) {
            sql.append(";");
        } else {
            sql.append(" }");
        }
        sql.append("\n\n");
    }

    @Override
    public boolean isDisableScriptEscapeProcessing() {
        return false;
    }

    @Override
    public boolean supportsAlterTableConstraint() {
        return true;
    }
}

