/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hive.model;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.hive.model.HiveDataSourceInfo;
import org.jkiss.dbeaver.ext.hive.model.HiveSQLDialect;
import org.jkiss.dbeaver.ext.hive.model.jdbc.HiveJdbcFactory;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCFactory;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLState;

public class HiveDataSource
extends GenericDataSource {
    private static final Log log = Log.getLog(HiveDataSource.class);

    public HiveDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container, GenericMetaModel metaModel) throws DBException {
        super(monitor, container, metaModel, (SQLDialect)new HiveSQLDialect());
    }

    protected DBPDataSourceInfo createDataSourceInfo(DBRProgressMonitor monitor, @NotNull JDBCDatabaseMetaData metaData) {
        return new HiveDataSourceInfo(monitor, (DBPDataSource)this, metaData);
    }

    @NotNull
    protected JDBCFactory createJdbcFactory() {
        return new HiveJdbcFactory();
    }

    public DBPErrorAssistant.ErrorType discoverErrorType(@NotNull Throwable error) {
        String sqlState = SQLState.getStateFromException((Throwable)error);
        if (SQLState.SQL_08S01.getCode().equals(sqlState)) {
            return DBPErrorAssistant.ErrorType.NORMAL;
        }
        return super.discoverErrorType(error);
    }
}

