/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameterValues;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProcessor;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseProducerSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferProducer;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferNodeDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferRegistry;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporter;
import org.jkiss.dbeaver.tools.transfer.stream.StreamConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferConsumer;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelection;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetDataContainer;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetDataContainerOptions;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetHandlerMain;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.utils.CommonUtils;

public class ResultSetHandlerCopyAs
extends AbstractHandler
implements IElementUpdater {
    private static final Log log = Log.getLog(ResultSetHandlerCopyAs.class);
    public static final String CMD_COPY_AS = "org.jkiss.dbeaver.core.resultset.copyAs";
    public static final String PARAM_PROCESSOR_ID = "processorId";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IResultSetController resultSet = ResultSetHandlerMain.getActiveResultSet(HandlerUtil.getActivePart((ExecutionEvent)event));
        if (resultSet == null) {
            return null;
        }
        DataTransferProcessorDescriptor processor = ResultSetHandlerCopyAs.getActiveProcessor(event.getParameter(PARAM_PROCESSOR_ID));
        if (processor == null) {
            return null;
        }
        switch (event.getCommand().getId()) {
            case "org.jkiss.dbeaver.core.resultset.copyAs": {
                ResultSetHandlerCopyAs.openResultsWith(resultSet, processor);
            }
        }
        return null;
    }

    static DataTransferProcessorDescriptor getActiveProcessor(String processorId) {
        if (CommonUtils.isEmpty((String)processorId)) {
            return null;
        }
        return DataTransferRegistry.getInstance().getProcessor(processorId);
    }

    private static void openResultsWith(final IResultSetController resultSet, final DataTransferProcessorDescriptor processor) {
        ResultSetDataContainer dataContainer;
        final ResultSetDataContainerOptions options = new ResultSetDataContainerOptions();
        IResultSetSelection rsSelection = resultSet.getSelection();
        List<ResultSetRow> rsSelectedRows = rsSelection.getSelectedRows();
        List<DBDAttributeBinding> rsSelectedAttributes = rsSelection.getSelectedAttributes();
        if (rsSelectedRows.size() > 1 || rsSelectedAttributes.size() > 1) {
            ArrayList<Long> selectedRows = new ArrayList<Long>();
            for (ResultSetRow selectedRow : rsSelectedRows) {
                selectedRows.add(Long.valueOf(selectedRow.getRowNumber()));
            }
            ArrayList<String> selectedAttributes = new ArrayList<String>();
            for (DBDAttributeBinding attributeBinding : rsSelectedAttributes) {
                selectedAttributes.add(attributeBinding.getName());
            }
            options.setSelectedRows(selectedRows);
            options.setSelectedColumns(selectedAttributes);
        }
        if ((dataContainer = new ResultSetDataContainer(resultSet, options)).getDataSource() == null) {
            DBWorkbench.getPlatformUI().showError("Copy As " + processor.getName(), ModelMessages.error_not_connected_to_database);
            return;
        }
        AbstractJob exportJob = new AbstractJob("Copy As " + processor.getName()){
            {
                super($anonymous0);
                this.setUser(true);
                this.setSystem(false);
            }

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    IDataTransferProcessor processorInstance = processor.getInstance();
                    if (!(processorInstance instanceof IStreamDataExporter)) {
                        return Status.CANCEL_STATUS;
                    }
                    IStreamDataExporter exporter = (IStreamDataExporter)processorInstance;
                    StreamTransferConsumer consumer = new StreamTransferConsumer();
                    StreamConsumerSettings settings = new StreamConsumerSettings();
                    settings.setOutputClipboard(true);
                    settings.setOutputEncodingBOM(false);
                    settings.setOpenFolderOnFinish(false);
                    HashMap<Object, Object> properties = new HashMap<Object, Object>();
                    DBPPropertyDescriptor[] dBPPropertyDescriptorArray = processor.getProperties();
                    int n = dBPPropertyDescriptorArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DBPPropertyDescriptor prop = dBPPropertyDescriptorArray[n2];
                        properties.put(prop.getId(), prop.getDefaultValue());
                        ++n2;
                    }
                    consumer.initTransfer((DBSObject)dataContainer, settings, new IDataTransferConsumer.TransferParameters(processor.isBinaryFormat(), processor.isHTMLFormat()), exporter, properties);
                    DBDDataFilter dataFilter = resultSet.getModel().getDataFilter();
                    DatabaseTransferProducer producer = new DatabaseTransferProducer((DBSDataContainer)dataContainer, dataFilter);
                    DatabaseProducerSettings producerSettings = new DatabaseProducerSettings();
                    producerSettings.setOpenNewConnections(false);
                    producerSettings.setExtractType(DatabaseProducerSettings.ExtractType.SINGLE_QUERY);
                    producerSettings.setQueryRowCount(false);
                    producerSettings.setSelectedRowsOnly(!CommonUtils.isEmpty(options.getSelectedRows()));
                    producerSettings.setSelectedColumnsOnly(!CommonUtils.isEmpty(options.getSelectedColumns()));
                    producer.transferData(monitor, (IDataTransferConsumer)consumer, null, producerSettings, null);
                    consumer.finishTransfer(monitor, false);
                    consumer.finishTransfer(monitor, true);
                }
                catch (Exception e) {
                    DBWorkbench.getPlatformUI().showError("Error opening in " + processor.getAppName(), null, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        exportJob.schedule();
    }

    public void updateElement(UIElement element, Map parameters) {
        DataTransferProcessorDescriptor processor = ResultSetHandlerCopyAs.getActiveProcessor((String)parameters.get(PARAM_PROCESSOR_ID));
        if (processor != null) {
            String commandName = ActionUtils.findCommandName((String)CMD_COPY_AS);
            element.setText(String.valueOf(commandName) + " " + processor.getName());
            if (!CommonUtils.isEmpty((String)processor.getDescription())) {
                element.setTooltip(processor.getDescription());
            }
            if (processor.getIcon() != null) {
                element.setIcon(DBeaverIcons.getImageDescriptor((DBPImage)processor.getIcon()));
            }
        }
    }

    public static class CopyAsMenuContributor
    extends CompoundContributionItem {
        protected IContributionItem[] getContributionItems() {
            ResultSetViewer rsv = (ResultSetViewer)ResultSetHandlerMain.getActiveResultSet(UIUtils.getActiveWorkbenchWindow().getActivePage().getActivePart());
            if (rsv == null) {
                return new IContributionItem[0];
            }
            MenuManager menu = new MenuManager();
            rsv.fillCopyAsMenu((IContributionManager)menu);
            return menu.getItems();
        }
    }

    public static class CopyAsParameterValues
    implements IParameterValues {
        public Map<String, String> getParameterValues() {
            HashMap<String, String> values = new HashMap<String, String>();
            for (DataTransferNodeDescriptor consumerNode : DataTransferRegistry.getInstance().getNodes(DataTransferNodeDescriptor.NodeType.CONSUMER)) {
                DataTransferProcessorDescriptor[] dataTransferProcessorDescriptorArray = consumerNode.getProcessors();
                int n = dataTransferProcessorDescriptorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DataTransferProcessorDescriptor processor = dataTransferProcessorDescriptorArray[n2];
                    if (!processor.isBinaryFormat()) {
                        values.put(processor.getName(), processor.getFullId());
                    }
                    ++n2;
                }
            }
            return values;
        }
    }
}

