/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser.rules;

import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLParameterToken;
import org.jkiss.dbeaver.model.text.parser.TPCharacterScanner;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenAbstract;

public class SQLParameterRule
implements TPRule {
    private final SQLSyntaxManager syntaxManager;
    private final SQLParameterToken parameterToken;
    private final StringBuilder buffer;
    private final char anonymousParameterMark;
    private final String namedParameterPrefix;

    public SQLParameterRule(SQLSyntaxManager syntaxManager, SQLParameterToken parameterToken, String prefix) {
        this.syntaxManager = syntaxManager;
        this.parameterToken = parameterToken;
        this.buffer = new StringBuilder();
        this.anonymousParameterMark = syntaxManager.getAnonymousParameterMark();
        this.namedParameterPrefix = prefix;
    }

    @Override
    public TPToken evaluate(TPCharacterScanner scanner) {
        scanner.unread();
        int prevChar = scanner.read();
        if (Character.isJavaIdentifierPart(prevChar) || prevChar == this.namedParameterPrefix.charAt(0) || prevChar == this.anonymousParameterMark || prevChar == 92 || prevChar == 47) {
            return TPTokenAbstract.UNDEFINED;
        }
        int c = scanner.read();
        if (c != -1 && (c == this.anonymousParameterMark || c == this.namedParameterPrefix.charAt(0))) {
            this.buffer.setLength(0);
            do {
                this.buffer.append((char)c);
            } while ((c = scanner.read()) != -1 && Character.isJavaIdentifierPart(c));
            scanner.unread();
            if (this.syntaxManager.isAnonymousParametersEnabled() && this.buffer.length() == 1 && this.buffer.charAt(0) == this.anonymousParameterMark) {
                return this.parameterToken;
            }
            if (this.syntaxManager.isParametersEnabled() && this.buffer.charAt(0) == this.namedParameterPrefix.charAt(0) && this.buffer.length() > 1) {
                boolean validChars = true;
                int i = 1;
                while (i < this.buffer.length()) {
                    if (!Character.isJavaIdentifierPart(this.buffer.charAt(i))) {
                        validChars = false;
                        break;
                    }
                    ++i;
                }
                if (validChars) {
                    return this.parameterToken;
                }
            }
            int i = this.buffer.length() - 1;
            while (i >= 0) {
                scanner.unread();
                --i;
            }
        } else {
            scanner.unread();
        }
        return TPTokenAbstract.UNDEFINED;
    }
}

