/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.scripts;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.scripts.ScriptsImportData;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CSmartCombo;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

class ScriptsImportWizardPage
extends WizardPage {
    private Text directoryText;
    private Text extensionsText;
    private CSmartCombo<DBPDataSourceContainer> scriptsDataSources;
    private Button overwriteCheck;
    private DBNNode importRoot = null;

    protected ScriptsImportWizardPage() {
        super(CoreMessages.dialog_scripts_import_wizard_name);
        this.setTitle(CoreMessages.dialog_scripts_import_wizard_title);
        this.setDescription(CoreMessages.dialog_scripts_import_wizard_description);
    }

    public boolean isPageComplete() {
        return !CommonUtils.isEmpty((String)this.directoryText.getText()) && !CommonUtils.isEmpty((String)this.extensionsText.getText()) && this.importRoot instanceof DBNResource && ((DBNResource)this.importRoot).getResource() instanceof IFolder;
    }

    public void createControl(Composite parent) {
        String externalDir = DBWorkbench.getPlatform().getPreferenceStore().getString("export.scripts.out.dir");
        if (CommonUtils.isEmpty((String)externalDir)) {
            externalDir = RuntimeUtils.getUserHomeDir().getAbsolutePath();
        }
        Composite placeholder = UIUtils.createPlaceholder((Composite)parent, (int)1);
        placeholder.setLayout((Layout)new GridLayout(1, false));
        Composite generalSettings = UIUtils.createPlaceholder((Composite)placeholder, (int)3);
        generalSettings.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)generalSettings, (String)CoreMessages.dialog_scripts_import_wizard_label_input_directory);
        this.directoryText = new Text(generalSettings, 2048);
        this.directoryText.setText(externalDir);
        this.directoryText.setLayoutData((Object)new GridData(768));
        this.directoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ScriptsImportWizardPage.this.updateState();
            }
        });
        Button openFolder = new Button(generalSettings, 8);
        openFolder.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_FOLDER));
        openFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ScriptsImportWizardPage.this.getShell(), 0);
                dialog.setMessage(CoreMessages.dialog_scripts_import_wizard_dialog_choose_dir_message);
                dialog.setText(CoreMessages.dialog_scripts_import_wizard_dialog_choose_dir_text);
                String directory = ScriptsImportWizardPage.this.directoryText.getText();
                if (!CommonUtils.isEmpty((String)directory)) {
                    dialog.setFilterPath(directory);
                }
                if ((directory = dialog.open()) != null) {
                    ScriptsImportWizardPage.this.directoryText.setText(directory);
                }
            }
        });
        this.extensionsText = UIUtils.createLabelText((Composite)generalSettings, (String)CoreMessages.dialog_scripts_import_wizard_label_file_mask, (String)"*.sql,*.txt");
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.extensionsText.setLayoutData((Object)gd);
        UIUtils.createControlLabel((Composite)generalSettings, (String)CoreMessages.dialog_scripts_import_wizard_label_default_connection);
        this.scriptsDataSources = new CSmartCombo(generalSettings, 2060, (ILabelProvider)new ConnectionLabelProvider());
        for (DBPDataSourceContainer dataSourceDescriptor : DataSourceRegistry.getAllDataSources()) {
            this.scriptsDataSources.addItem((Object)dataSourceDescriptor);
        }
        if (this.scriptsDataSources.getItemCount() > 0) {
            this.scriptsDataSources.select(0);
        }
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.verticalIndent = 2;
        this.scriptsDataSources.setLayoutData((Object)gd);
        UIUtils.createControlLabel((Composite)placeholder, (String)CoreMessages.dialog_scripts_import_wizard_label_root_folder);
        this.importRoot = DBWorkbench.getPlatform().getNavigatorModel().getRoot();
        DatabaseNavigatorTree scriptsNavigator = new DatabaseNavigatorTree(placeholder, this.importRoot, 2052, false);
        scriptsNavigator.setLayoutData((Object)new GridData(1808));
        scriptsNavigator.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel == null || sel.isEmpty()) {
                    ScriptsImportWizardPage.this.importRoot = null;
                } else {
                    ScriptsImportWizardPage.this.importRoot = (DBNNode)sel.getFirstElement();
                }
                ScriptsImportWizardPage.this.updateState();
            }
        });
        scriptsNavigator.getViewer().addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof DBNResource && ((DBNResource)element).getResource() instanceof IContainer;
            }
        });
        scriptsNavigator.getViewer().expandToLevel(2);
        this.overwriteCheck = UIUtils.createCheckbox((Composite)placeholder, (String)CoreMessages.dialog_project_export_wizard_page_checkbox_overwrite_files, (boolean)false);
        gd = new GridData(1);
        gd.horizontalSpan = 3;
        this.overwriteCheck.setLayoutData((Object)gd);
        this.setControl((Control)placeholder);
        this.updateState();
    }

    private void updateState() {
        this.getContainer().updateButtons();
    }

    public ScriptsImportData getImportData() {
        DBPDataSourceContainer dataSourceContainer = null;
        int dsIndex = this.scriptsDataSources.getSelectionIndex();
        if (dsIndex >= 0) {
            dataSourceContainer = (DBPDataSourceContainer)this.scriptsDataSources.getItem(dsIndex);
        }
        String outputDir = this.directoryText.getText();
        DBWorkbench.getPlatform().getPreferenceStore().setValue("export.scripts.out.dir", outputDir);
        return new ScriptsImportData(new File(outputDir), this.extensionsText.getText(), this.overwriteCheck.getSelection(), (DBNResource)this.importRoot, dataSourceContainer);
    }

    private static class ConnectionLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private ConnectionLabelProvider() {
        }

        public Image getImage(Object element) {
            DBNDatabaseNode node = DBWorkbench.getPlatform().getNavigatorModel().findNode((DBSObject)((DataSourceDescriptor)element));
            return node == null ? null : DBeaverIcons.getImage((DBPImage)node.getNodeIcon());
        }

        public String getText(Object element) {
            return ((DataSourceDescriptor)element).getName();
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            return element == null ? null : UIUtils.getConnectionColor((DBPConnectionConfiguration)((DataSourceDescriptor)element).getConnectionConfiguration());
        }
    }
}

