/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.snowflake.views;

import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.snowflake.SnowflakeUIActivator;
import org.jkiss.dbeaver.ext.snowflake.views.SnowlfakeMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.ui.ICompositeDialogPage;
import org.jkiss.dbeaver.ui.IDataSourceConnectionTester;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class SnowflakeConnectionPage
extends ConnectionPageAbstract
implements ICompositeDialogPage,
IDataSourceConnectionTester {
    private static final Log log = Log.getLog(SnowflakeConnectionPage.class);
    private Text hostText;
    private Text portText;
    private Combo dbText;
    private Combo warehouseText;
    private Combo schemaText;
    private Combo roleText;
    private Combo authTypeCombo;
    private Text usernameText;
    private Text passwordText;
    private static ImageDescriptor logoImage = SnowflakeUIActivator.getImageDescriptor("icons/snowflake_logo.png");

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        Composite control = new Composite(composite, 0);
        control.setLayout((Layout)new GridLayout(1, false));
        control.setLayoutData((Object)new GridData(1808));
        ModifyListener textListener = e -> this.site.updateButtons();
        Group addrGroup = UIUtils.createControlGroup((Composite)control, (String)SnowlfakeMessages.label_connection, (int)4, (int)0, (int)0);
        GridData gd = new GridData(768);
        addrGroup.setLayoutData((Object)gd);
        UIUtils.createControlLabel((Composite)addrGroup, (String)SnowlfakeMessages.label_host);
        this.hostText = new Text((Composite)addrGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.hostText.setLayoutData((Object)gd);
        this.hostText.addModifyListener(textListener);
        UIUtils.createControlLabel((Composite)addrGroup, (String)SnowlfakeMessages.label_port);
        this.portText = new Text((Composite)addrGroup, 2048);
        gd = new GridData(2);
        gd.widthHint = 40;
        this.portText.setLayoutData((Object)gd);
        this.portText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.portText.addModifyListener(textListener);
        UIUtils.createControlLabel((Composite)addrGroup, (String)SnowlfakeMessages.label_database);
        this.dbText = new Combo((Composite)addrGroup, 2052);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.dbText.setLayoutData((Object)gd);
        this.dbText.addModifyListener(textListener);
        UIUtils.createControlLabel((Composite)addrGroup, (String)SnowlfakeMessages.label_warehouse);
        this.warehouseText = new Combo((Composite)addrGroup, 2052);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.warehouseText.setLayoutData((Object)gd);
        this.warehouseText.addModifyListener(textListener);
        UIUtils.createControlLabel((Composite)addrGroup, (String)SnowlfakeMessages.label_schema);
        this.schemaText = new Combo((Composite)addrGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.schemaText.setLayoutData((Object)gd);
        this.schemaText.addModifyListener(textListener);
        Composite ph = UIUtils.createPlaceholder((Composite)control, (int)2);
        UIUtils.createInfoLabel((Composite)ph, (String)"");
        Link testLink = new Link(ph, 0);
        testLink.setText(SnowlfakeMessages.label_click_on_test_connection);
        GridData gd2 = new GridData(800);
        gd2.grabExcessHorizontalSpace = true;
        testLink.setLayoutData((Object)gd2);
        testLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SnowflakeConnectionPage.this.site.testConnection();
            }
        });
        addrGroup = UIUtils.createControlGroup((Composite)control, (String)SnowlfakeMessages.label_security, (int)4, (int)0, (int)0);
        addrGroup.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)addrGroup, (String)SnowlfakeMessages.label_user);
        this.usernameText = new Text((Composite)addrGroup, 2048);
        gd = new GridData(800);
        this.usernameText.setLayoutData((Object)gd);
        this.usernameText.addModifyListener(textListener);
        UIUtils.createEmptyLabel((Composite)addrGroup, (int)2, (int)1);
        UIUtils.createControlLabel((Composite)addrGroup, (String)SnowlfakeMessages.label_password);
        this.passwordText = new Text((Composite)addrGroup, 0x400800);
        gd = new GridData(800);
        this.passwordText.setLayoutData((Object)gd);
        this.passwordText.addModifyListener(textListener);
        this.createPasswordControls((Composite)addrGroup, this.passwordText, 2);
        UIUtils.createControlLabel((Composite)addrGroup, (String)SnowlfakeMessages.label_role);
        this.roleText = new Combo((Composite)addrGroup, 2052);
        gd = new GridData(800);
        this.roleText.setLayoutData((Object)gd);
        this.roleText.addModifyListener(textListener);
        UIUtils.createControlLabel((Composite)addrGroup, (String)SnowlfakeMessages.label_authenticator);
        this.authTypeCombo = new Combo((Composite)addrGroup, 2052);
        this.authTypeCombo.add("");
        this.authTypeCombo.add("snowflake");
        this.authTypeCombo.add("externalbrowser");
        gd = new GridData(800);
        this.authTypeCombo.setLayoutData((Object)gd);
        this.authTypeCombo.addModifyListener(textListener);
        this.createDriverPanel(control);
        this.setControl((Control)control);
    }

    public boolean isComplete() {
        return this.hostText != null && !CommonUtils.isEmpty((String)this.hostText.getText());
    }

    public void loadSettings() {
        super.loadSettings();
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.hostText != null) {
            if (CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                this.hostText.setText(".snowflakecomputing.com");
            } else {
                this.hostText.setText(connectionInfo.getHostName());
            }
        }
        if (this.portText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                this.portText.setText(String.valueOf(connectionInfo.getHostPort()));
            } else if (this.site.getDriver().getDefaultPort() != null) {
                this.portText.setText(this.site.getDriver().getDefaultPort());
            } else {
                this.portText.setText("");
            }
        }
        if (this.dbText != null) {
            String databaseName = connectionInfo.getDatabaseName();
            if (CommonUtils.isEmpty((String)databaseName)) {
                databaseName = "TEST_DB";
            }
            this.dbText.setText(databaseName);
        }
        if (this.warehouseText != null) {
            this.warehouseText.setText(CommonUtils.notEmpty((String)connectionInfo.getServerName()));
        }
        if (this.schemaText != null) {
            this.schemaText.setText(CommonUtils.notEmpty((String)connectionInfo.getProviderProperty("@dbeaver-schema@")));
        }
        if (this.usernameText != null) {
            this.usernameText.setText(CommonUtils.notEmpty((String)connectionInfo.getUserName()));
        }
        if (this.roleText != null) {
            this.roleText.setText(CommonUtils.notEmpty((String)connectionInfo.getProviderProperty("@dbeaver-role@")));
        }
        if (this.authTypeCombo != null) {
            this.authTypeCombo.setText(CommonUtils.notEmpty((String)connectionInfo.getProviderProperty("@dbeaver-authenticator@")));
        }
        if (this.passwordText != null) {
            this.passwordText.setText(CommonUtils.notEmpty((String)connectionInfo.getUserPassword()));
        }
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.hostText != null) {
            connectionInfo.setHostName(this.hostText.getText().trim());
        }
        if (this.portText != null) {
            connectionInfo.setHostPort(this.portText.getText().trim());
        }
        if (this.dbText != null) {
            connectionInfo.setDatabaseName(this.dbText.getText().trim());
        }
        if (this.warehouseText != null) {
            connectionInfo.setServerName(this.warehouseText.getText().trim());
        }
        if (this.schemaText != null) {
            connectionInfo.setProviderProperty("@dbeaver-schema@", this.schemaText.getText().trim());
        }
        if (this.usernameText != null) {
            connectionInfo.setUserName(this.usernameText.getText().trim());
        }
        if (this.roleText != null) {
            connectionInfo.setProviderProperty("@dbeaver-role@", this.roleText.getText().trim());
        }
        if (this.authTypeCombo != null) {
            connectionInfo.setProviderProperty("@dbeaver-authenticator@", this.authTypeCombo.getText().trim());
        }
        if (this.passwordText != null) {
            connectionInfo.setUserPassword(this.passwordText.getText());
        }
        super.saveSettings(dataSource);
    }

    public void testConnection(DBCSession session) {
        try {
            SnowflakeConnectionPage.loadDictList(session, this.dbText, "SHOW DATABASES");
            SnowflakeConnectionPage.loadDictList(session, this.warehouseText, "SHOW WAREHOUSES");
            SnowflakeConnectionPage.loadDictList(session, this.schemaText, "SHOW SCHEMAS");
            SnowflakeConnectionPage.loadDictList(session, this.roleText, "SHOW ROLES");
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private static void loadDictList(DBCSession session, Combo combo, String query) throws DBCException {
        ArrayList<String> result = new ArrayList<String>();
        session.getProgressMonitor().subTask("Exec " + query);
        Throwable throwable = null;
        Object var5_6 = null;
        try (DBCStatement dbStat = session.prepareStatement(DBCStatementType.QUERY, query, false, false, false);){
            dbStat.executeStatement();
            Throwable throwable2 = null;
            Object var8_11 = null;
            try (DBCResultSet dbResult = dbStat.openResultSet();){
                while (dbResult.nextRow()) {
                    result.add(CommonUtils.toString((Object)dbResult.getAttributeValue("name")));
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        UIUtils.asyncExec(() -> {
            String oldText = combo.getText();
            if (!result.contains(oldText)) {
                result.add(0, oldText);
            }
            if (!result.contains("")) {
                result.add(0, "");
            }
            combo.setItems(result.toArray(new String[0]));
            combo.setText(oldText);
        });
    }

    public IDialogPage[] getSubPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }
}

