/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.generator;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBPScriptObjectExt;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDRowIdentifier;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithResult;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelection;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.editors.sql.dialogs.ViewSQLDialog;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class GenerateSQLContributor
extends CompoundContributionItem {
    protected static final Log log = Log.getLog(GenerateSQLContributor.class);

    protected IContributionItem[] getContributionItems() {
        IWorkbenchPart part = UIUtils.getActiveWorkbenchWindow().getActivePage().getActivePart();
        IStructuredSelection structuredSelection = NavigatorUtils.getSelectionFromPart((IWorkbenchPart)part);
        if (structuredSelection == null || structuredSelection.isEmpty()) {
            return new IContributionItem[0];
        }
        ArrayList<IContributionItem> menu = new ArrayList<IContributionItem>();
        if (structuredSelection instanceof IResultSetSelection) {
            this.makeResultSetContributions(menu, (IResultSetSelection)structuredSelection);
        } else {
            ArrayList<DBSEntity> entities = new ArrayList<DBSEntity>();
            ArrayList<DBPScriptObject> scriptObjects = new ArrayList<DBPScriptObject>();
            Object[] objectArray = structuredSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object sel = objectArray[n2];
                DBSObject object = (DBSObject)RuntimeUtils.getObjectAdapter((Object)sel, DBSObject.class);
                if (object instanceof DBSEntity) {
                    entities.add((DBSEntity)object);
                }
                if (object instanceof DBPScriptObject) {
                    scriptObjects.add((DBPScriptObject)object);
                }
                ++n2;
            }
            if (!entities.isEmpty()) {
                this.makeTableContributions(menu, entities);
            }
            if (!scriptObjects.isEmpty()) {
                this.makeScriptContributions(menu, scriptObjects);
            }
        }
        return menu.toArray(new IContributionItem[0]);
    }

    private void makeTableContributions(List<IContributionItem> menu, List<DBSEntity> entities) {
        menu.add((IContributionItem)GenerateSQLContributor.makeAction("SELECT ", GenerateSQLContributor.SELECT_GENERATOR(entities, true)));
        menu.add((IContributionItem)GenerateSQLContributor.makeAction("INSERT ", GenerateSQLContributor.INSERT_GENERATOR(entities)));
        menu.add((IContributionItem)GenerateSQLContributor.makeAction("UPDATE ", GenerateSQLContributor.UPDATE_GENERATOR(entities)));
        menu.add((IContributionItem)GenerateSQLContributor.makeAction("DELETE ", this.DELETE_GENERATOR(entities)));
        menu.add((IContributionItem)GenerateSQLContributor.makeAction("MERGE", GenerateSQLContributor.MERGE_GENERATOR(entities)));
        if (entities.size() > 1) {
            menu.add((IContributionItem)new Separator());
            menu.add((IContributionItem)GenerateSQLContributor.makeAction("JOIN", GenerateSQLContributor.JOIN_GENERATOR(entities)));
        }
    }

    private void makeScriptContributions(List<IContributionItem> menu, List<DBPScriptObject> scriptObjects) {
        if (menu.size() > 0) {
            menu.add((IContributionItem)new Separator());
        }
        ArrayList<DBSProcedure> procedures = new ArrayList<DBSProcedure>();
        for (DBPScriptObject so : scriptObjects) {
            if (!(so instanceof DBSProcedure)) continue;
            procedures.add((DBSProcedure)so);
        }
        if (!procedures.isEmpty()) {
            menu.add((IContributionItem)GenerateSQLContributor.makeAction("CALL", GenerateSQLContributor.CALL_GENERATOR(procedures)));
        }
        menu.add((IContributionItem)GenerateSQLContributor.makeAction("DDL", new SQLGenerator<DBPScriptObject>(scriptObjects){

            @Override
            public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                boolean allTables = true;
                ArrayList<DBSTable> tableList = new ArrayList<DBSTable>();
                for (DBPScriptObject object : this.objects) {
                    if (!(object instanceof DBSTable)) {
                        allTables = false;
                        break;
                    }
                    tableList.add((DBSTable)object);
                }
                if (!allTables) {
                    super.run(monitor);
                    return;
                }
                StringBuilder sql = new StringBuilder(100);
                HashMap<String, Object> options = new HashMap<String, Object>();
                this.addOptions(options);
                try {
                    DBStructUtils.generateTableListDDL((DBRProgressMonitor)monitor, (StringBuilder)sql, tableList, options, (boolean)false);
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
                this.result = sql.toString();
            }

            @Override
            public void generateSQL(DBRProgressMonitor monitor, StringBuilder sql, DBPScriptObject object) throws DBException {
                if (sql.length() > 0) {
                    sql.append("\n");
                }
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("refresh", true);
                this.addOptions(options);
                String definitionText = CommonUtils.notEmpty((String)object.getObjectDefinitionText(monitor, options)).trim();
                sql.append(definitionText);
                if (!definitionText.endsWith(";")) {
                    sql.append(";");
                }
                sql.append("\n");
                if (object instanceof DBPScriptObjectExt) {
                    String definition2 = CommonUtils.notEmpty((String)((DBPScriptObjectExt)object).getExtendedDefinitionText(monitor)).trim();
                    sql.append("\n");
                    sql.append(definition2);
                    if (!definition2.endsWith(";")) {
                        sql.append(";");
                    }
                    sql.append("\n");
                }
            }

            @Override
            protected void addOptions(Map<String, Object> options) {
                super.addOptions(options);
                options.put("refresh", true);
                options.put("script.includeDrop", true);
            }
        }));
    }

    private void makeResultSetContributions(List<IContributionItem> menu, IResultSetSelection rss) {
        final IResultSetController rsv = rss.getController();
        DBSDataContainer dataContainer = rsv.getDataContainer();
        List visibleAttributes = rsv.getModel().getVisibleAttributes();
        final DBSEntity entity = rsv.getModel().getSingleSource();
        if (dataContainer != null && !visibleAttributes.isEmpty() && entity != null) {
            final ArrayList selectedRows = new ArrayList(rss.getSelectedRows());
            if (!CommonUtils.isEmpty(selectedRows)) {
                menu.add((IContributionItem)GenerateSQLContributor.makeAction("SELECT .. WHERE .. =", new ResultSetAnalysisRunner(dataContainer.getDataSource(), rsv.getModel()){

                    @Override
                    public void generateSQL(DBRProgressMonitor monitor, StringBuilder sql, ResultSetModel object) {
                        for (ResultSetRow firstRow : selectedRows) {
                            List<DBDAttributeBinding> keyAttributes = this.getKeyAttributes(monitor, object);
                            sql.append("SELECT ");
                            boolean hasAttr = false;
                            for (DBSAttributeBase dBSAttributeBase : this.getAllAttributes(monitor, object)) {
                                if (hasAttr) {
                                    sql.append(", ");
                                }
                                sql.append(DBUtils.getObjectFullName((DBPNamedObject)dBSAttributeBase, (DBPEvaluationContext)DBPEvaluationContext.DML));
                                hasAttr = true;
                            }
                            sql.append(this.getLineSeparator()).append("FROM ").append(this.getEntityName(entity));
                            sql.append(this.getLineSeparator()).append("WHERE ");
                            hasAttr = false;
                            for (DBDAttributeBinding dBDAttributeBinding : keyAttributes) {
                                if (hasAttr) {
                                    sql.append(" AND ");
                                }
                                this.appendValueCondition(rsv, sql, dBDAttributeBinding, firstRow);
                                hasAttr = true;
                            }
                            sql.append(";\n");
                        }
                    }
                }));
                if (selectedRows.size() > 1) {
                    menu.add((IContributionItem)GenerateSQLContributor.makeAction("SELECT .. WHERE .. IN", new ResultSetAnalysisRunner(dataContainer.getDataSource(), rsv.getModel()){

                        @Override
                        public void generateSQL(DBRProgressMonitor monitor, StringBuilder sql, ResultSetModel object) {
                            boolean bl;
                            List<DBDAttributeBinding> keyAttributes = this.getKeyAttributes(monitor, object);
                            sql.append("SELECT ");
                            boolean hasAttr = false;
                            for (DBSAttributeBase dBSAttributeBase : this.getAllAttributes(monitor, object)) {
                                if (hasAttr) {
                                    sql.append(", ");
                                }
                                sql.append(DBUtils.getObjectFullName((DBPNamedObject)dBSAttributeBase, (DBPEvaluationContext)DBPEvaluationContext.DML));
                                hasAttr = true;
                            }
                            sql.append(this.getLineSeparator()).append("FROM ").append(this.getEntityName(entity));
                            sql.append(this.getLineSeparator()).append("WHERE ");
                            boolean bl2 = bl = keyAttributes.size() > 1;
                            if (bl) {
                                sql.append("(");
                            }
                            hasAttr = false;
                            for (DBDAttributeBinding binding : keyAttributes) {
                                if (hasAttr) {
                                    sql.append(",");
                                }
                                sql.append(DBUtils.getObjectFullName((DBPNamedObject)binding.getAttribute(), (DBPEvaluationContext)DBPEvaluationContext.DML));
                                hasAttr = true;
                            }
                            if (bl) {
                                sql.append(")");
                            }
                            sql.append(" IN (");
                            if (bl) {
                                sql.append("\n");
                            }
                            int i = 0;
                            while (i < selectedRows.size()) {
                                ResultSetRow firstRow = (ResultSetRow)selectedRows.get(i);
                                if (bl) {
                                    sql.append("(");
                                }
                                hasAttr = false;
                                for (DBDAttributeBinding binding : keyAttributes) {
                                    if (hasAttr) {
                                        sql.append(",");
                                    }
                                    this.appendAttributeValue(rsv, sql, binding, firstRow);
                                    hasAttr = true;
                                }
                                if (bl) {
                                    sql.append(")");
                                }
                                if (i < selectedRows.size() - 1) {
                                    sql.append(",");
                                }
                                if (bl) {
                                    sql.append("\n");
                                }
                                ++i;
                            }
                            sql.append(");\n");
                        }
                    }));
                }
                menu.add((IContributionItem)GenerateSQLContributor.makeAction("INSERT", new ResultSetAnalysisRunner(dataContainer.getDataSource(), rsv.getModel()){

                    @Override
                    public void generateSQL(DBRProgressMonitor monitor, StringBuilder sql, ResultSetModel object) {
                        for (ResultSetRow firstRow : selectedRows) {
                            Collection<? extends DBSAttributeBase> allAttributes = this.getAllAttributes(monitor, object);
                            sql.append("INSERT INTO ").append(this.getEntityName(entity));
                            sql.append(this.getLineSeparator()).append("(");
                            boolean hasAttr = false;
                            for (DBSAttributeBase dBSAttributeBase : allAttributes) {
                                if (DBUtils.isPseudoAttribute((DBSAttributeBase)dBSAttributeBase) || DBUtils.isHiddenObject((Object)dBSAttributeBase)) continue;
                                if (hasAttr) {
                                    sql.append(", ");
                                }
                                sql.append(DBUtils.getObjectFullName((DBPNamedObject)dBSAttributeBase, (DBPEvaluationContext)DBPEvaluationContext.DML));
                                hasAttr = true;
                            }
                            sql.append(")").append(this.getLineSeparator()).append("VALUES(");
                            hasAttr = false;
                            for (DBSAttributeBase dBSAttributeBase : allAttributes) {
                                DBDAttributeBinding binding;
                                if (DBUtils.isPseudoAttribute((DBSAttributeBase)dBSAttributeBase) || DBUtils.isHiddenObject((Object)dBSAttributeBase)) continue;
                                if (hasAttr) {
                                    sql.append(", ");
                                }
                                if ((binding = rsv.getModel().getAttributeBinding(dBSAttributeBase)) == null) {
                                    this.appendDefaultValue(sql, dBSAttributeBase);
                                } else {
                                    this.appendAttributeValue(rsv, sql, binding, firstRow);
                                }
                                hasAttr = true;
                            }
                            sql.append(");\n");
                        }
                    }
                }));
                menu.add((IContributionItem)GenerateSQLContributor.makeAction("UPDATE", new ResultSetAnalysisRunner(dataContainer.getDataSource(), rsv.getModel()){

                    @Override
                    public void generateSQL(DBRProgressMonitor monitor, StringBuilder sql, ResultSetModel object) throws DBException {
                        for (ResultSetRow firstRow : selectedRows) {
                            List<DBDAttributeBinding> keyAttributes = this.getKeyAttributes(monitor, object);
                            Collection<DBSAttributeBase> valueAttributes = this.getValueAttributes(monitor, object, keyAttributes);
                            sql.append("UPDATE ").append(this.getEntityName(entity));
                            sql.append(this.getLineSeparator()).append("SET ");
                            boolean hasAttr = false;
                            for (DBSAttributeBase dBSAttributeBase : valueAttributes) {
                                if (DBUtils.isPseudoAttribute((DBSAttributeBase)dBSAttributeBase) || DBUtils.isHiddenObject((Object)dBSAttributeBase)) continue;
                                if (hasAttr) {
                                    sql.append(", ");
                                }
                                sql.append(DBUtils.getObjectFullName((DBPNamedObject)dBSAttributeBase, (DBPEvaluationContext)DBPEvaluationContext.DML)).append("=");
                                DBDAttributeBinding binding = rsv.getModel().getAttributeBinding(dBSAttributeBase);
                                if (binding == null) {
                                    this.appendDefaultValue(sql, dBSAttributeBase);
                                } else {
                                    this.appendAttributeValue(rsv, sql, binding, firstRow);
                                }
                                hasAttr = true;
                            }
                            sql.append(this.getLineSeparator()).append("WHERE ");
                            hasAttr = false;
                            for (DBDAttributeBinding dBDAttributeBinding : keyAttributes) {
                                if (hasAttr) {
                                    sql.append(" AND ");
                                }
                                this.appendValueCondition(rsv, sql, dBDAttributeBinding, firstRow);
                                hasAttr = true;
                            }
                            sql.append(";\n");
                        }
                    }
                }));
                menu.add((IContributionItem)GenerateSQLContributor.makeAction("DELETE by Unique Key", new ResultSetAnalysisRunner(dataContainer.getDataSource(), rsv.getModel()){

                    @Override
                    public void generateSQL(DBRProgressMonitor monitor, StringBuilder sql, ResultSetModel object) {
                        for (ResultSetRow firstRow : selectedRows) {
                            List<DBDAttributeBinding> keyAttributes = this.getKeyAttributes(monitor, object);
                            sql.append("DELETE FROM ").append(this.getEntityName(entity));
                            sql.append(this.getLineSeparator()).append("WHERE ");
                            boolean hasAttr = false;
                            for (DBDAttributeBinding binding : keyAttributes) {
                                if (hasAttr) {
                                    sql.append(" AND ");
                                }
                                this.appendValueCondition(rsv, sql, binding, firstRow);
                                hasAttr = true;
                            }
                            sql.append(";\n");
                        }
                    }
                }));
            }
        } else {
            String message = dataContainer == null ? "no data container" : (visibleAttributes.isEmpty() ? "empty attribute list" : "can't resolve table");
            Action disabledAction = new Action("Not available - " + message){};
            disabledAction.setEnabled(false);
            menu.add((IContributionItem)new ActionContributionItem((IAction)disabledAction));
        }
    }

    public static boolean hasContributions(IStructuredSelection selection) {
        DBSObject object = (DBSObject)RuntimeUtils.getObjectAdapter((Object)selection.getFirstElement(), DBSObject.class);
        return object instanceof DBSTable || object instanceof DBPScriptObject;
    }

    private static ContributionItem makeAction(String text, final SQLGenerator<?> sqlGenerator) {
        return new ActionContributionItem((IAction)new Action(text, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SQL_TEXT)){

            public void run() {
                DBSObject selectedObject;
                ISelectionProvider selectionProvider;
                IWorkbenchPage activePage = UIUtils.getActiveWorkbenchWindow().getActivePage();
                IEditorPart activeEditor = activePage.getActiveEditor();
                DBCExecutionContext executionContext = null;
                IWorkbenchPart activePart = activePage.getActivePart();
                if (activePart != null && (selectionProvider = activePart.getSite().getSelectionProvider()) != null && (selectedObject = NavigatorUtils.getSelectedObject((ISelection)selectionProvider.getSelection())) != null) {
                    executionContext = DBUtils.getDefaultContext((DBSObject)selectedObject, (boolean)false);
                }
                if (executionContext == null && activeEditor instanceof DBPContextProvider) {
                    executionContext = ((DBPContextProvider)activeEditor).getExecutionContext();
                }
                if (executionContext != null) {
                    GenerateSQLDialog dialog = new GenerateSQLDialog(activePage.getActivePart().getSite(), executionContext, sqlGenerator);
                    dialog.open();
                }
            }
        });
    }

    @NotNull
    public static SQLGenerator<DBSEntity> SELECT_GENERATOR(List<DBSEntity> entities, final boolean columnList) {
        return new TableAnalysisRunner(entities){

            @Override
            public void generateSQL(DBRProgressMonitor monitor, StringBuilder sql, DBSEntity object) throws DBException {
                sql.append("SELECT ");
                boolean hasAttr = false;
                if (columnList) {
                    for (DBSEntityAttribute dBSEntityAttribute : this.getAllAttributes(monitor, object)) {
                        if (DBUtils.isHiddenObject((Object)dBSEntityAttribute)) continue;
                        if (hasAttr) {
                            sql.append(", ");
                        }
                        sql.append(DBUtils.getObjectFullName((DBPNamedObject)dBSEntityAttribute, (DBPEvaluationContext)DBPEvaluationContext.DML));
                        hasAttr = true;
                    }
                    if (hasAttr) {
                        sql.append(this.getLineSeparator());
                    }
                }
                if (!hasAttr) {
                    sql.append("* ");
                }
                sql.append("FROM ").append(this.getEntityName(object));
                sql.append(";\n");
            }
        };
    }

    @NotNull
    private SQLGenerator<DBSEntity> DELETE_GENERATOR(List<DBSEntity> entities) {
        return new TableAnalysisRunner(entities){

            @Override
            public void generateSQL(DBRProgressMonitor monitor, StringBuilder sql, DBSEntity object) throws DBException {
                sql.append("DELETE FROM ").append(this.getEntityName(object)).append(this.getLineSeparator()).append("WHERE ");
                Collection<? extends DBSEntityAttribute> keyAttributes = this.getKeyAttributes(monitor, object);
                if (CommonUtils.isEmpty(keyAttributes)) {
                    keyAttributes = this.getAllAttributes(monitor, object);
                }
                boolean hasAttr = false;
                for (DBSEntityAttribute dBSEntityAttribute : keyAttributes) {
                    if (hasAttr) {
                        sql.append(" AND ");
                    }
                    sql.append(DBUtils.getObjectFullName((DBPNamedObject)dBSEntityAttribute, (DBPEvaluationContext)DBPEvaluationContext.DML)).append("=");
                    this.appendDefaultValue(sql, (DBSAttributeBase)dBSEntityAttribute);
                    hasAttr = true;
                }
                sql.append(";\n");
            }
        };
    }

    @NotNull
    private static SQLGenerator<DBSEntity> INSERT_GENERATOR(List<DBSEntity> entities) {
        return new TableAnalysisRunner((List)entities){

            @Override
            public void generateSQL(DBRProgressMonitor monitor, StringBuilder sql, DBSEntity object) throws DBException {
                sql.append("INSERT INTO ").append(this.getEntityName(object)).append(this.getLineSeparator()).append("(");
                boolean hasAttr = false;
                for (DBSEntityAttribute dBSEntityAttribute : this.getAllAttributes(monitor, object)) {
                    if (DBUtils.isPseudoAttribute((DBSAttributeBase)dBSEntityAttribute) || DBUtils.isHiddenObject((Object)dBSEntityAttribute) || dBSEntityAttribute.isAutoGenerated()) continue;
                    if (hasAttr) {
                        sql.append(", ");
                    }
                    sql.append(DBUtils.getObjectFullName((DBPNamedObject)dBSEntityAttribute, (DBPEvaluationContext)DBPEvaluationContext.DML));
                    hasAttr = true;
                }
                sql.append(")").append(this.getLineSeparator()).append("VALUES(");
                hasAttr = false;
                for (DBSEntityAttribute dBSEntityAttribute : this.getAllAttributes(monitor, object)) {
                    if (DBUtils.isPseudoAttribute((DBSAttributeBase)dBSEntityAttribute) || DBUtils.isHiddenObject((Object)dBSEntityAttribute) || dBSEntityAttribute.isAutoGenerated()) continue;
                    if (hasAttr) {
                        sql.append(", ");
                    }
                    this.appendDefaultValue(sql, (DBSAttributeBase)dBSEntityAttribute);
                    hasAttr = true;
                }
                sql.append(");\n");
            }
        };
    }

    @NotNull
    private static SQLGenerator<DBSEntity> UPDATE_GENERATOR(List<DBSEntity> entities) {
        return new TableAnalysisRunner((List)entities){

            @Override
            public void generateSQL(DBRProgressMonitor monitor, StringBuilder sql, DBSEntity object) throws DBException {
                Collection<? extends DBSEntityAttribute> keyAttributes = this.getKeyAttributes(monitor, object);
                sql.append("UPDATE ").append(this.getEntityName(object)).append(this.getLineSeparator()).append("SET ");
                boolean hasAttr = false;
                for (DBSAttributeBase dBSAttributeBase : this.getValueAttributes(monitor, object, keyAttributes)) {
                    if (DBUtils.isPseudoAttribute((DBSAttributeBase)dBSAttributeBase) || DBUtils.isHiddenObject((Object)dBSAttributeBase)) continue;
                    if (hasAttr) {
                        sql.append(", ");
                    }
                    sql.append(DBUtils.getObjectFullName((DBPNamedObject)dBSAttributeBase, (DBPEvaluationContext)DBPEvaluationContext.DML)).append("=");
                    this.appendDefaultValue(sql, dBSAttributeBase);
                    hasAttr = true;
                }
                if (!CommonUtils.isEmpty(keyAttributes)) {
                    sql.append(this.getLineSeparator()).append("WHERE ");
                    hasAttr = false;
                    for (DBSEntityAttribute dBSEntityAttribute : keyAttributes) {
                        if (hasAttr) {
                            sql.append(" AND ");
                        }
                        sql.append(DBUtils.getObjectFullName((DBPNamedObject)dBSEntityAttribute, (DBPEvaluationContext)DBPEvaluationContext.DML)).append("=");
                        this.appendDefaultValue(sql, (DBSAttributeBase)dBSEntityAttribute);
                        hasAttr = true;
                    }
                }
                sql.append(";\n");
            }
        };
    }

    @NotNull
    private static SQLGenerator<DBSEntity> MERGE_GENERATOR(List<DBSEntity> entities) {
        return new TableAnalysisRunner((List)entities){

            @Override
            public void generateSQL(DBRProgressMonitor monitor, StringBuilder sql, DBSEntity object) throws DBException {
                boolean hasAttr = false;
                sql.append("MERGE INTO ").append(this.getEntityName(object)).append(" AS tgt").append(this.getLineSeparator());
                sql.append("USING SOURCE_TABLE AS src").append(this.getLineSeparator());
                Collection<? extends DBSEntityAttribute> keyAttributes = this.getKeyAttributes(monitor, object);
                if (!CommonUtils.isEmpty(keyAttributes)) {
                    sql.append("ON (");
                    for (DBSEntityAttribute dBSEntityAttribute : keyAttributes) {
                        if (hasAttr) {
                            sql.append(" AND ");
                        }
                        sql.append("tgt.").append(DBUtils.getQuotedIdentifier((DBSObject)dBSEntityAttribute)).append("=src.").append(DBUtils.getQuotedIdentifier((DBSObject)dBSEntityAttribute));
                        hasAttr = true;
                    }
                    sql.append(")\n");
                }
                sql.append("WHEN MATCHED\nTHEN UPDATE SET").append(this.getLineSeparator());
                hasAttr = false;
                for (DBSAttributeBase dBSAttributeBase : this.getValueAttributes(monitor, object, keyAttributes)) {
                    if (hasAttr) {
                        sql.append(", ");
                    }
                    sql.append("tgt.").append(DBUtils.getQuotedIdentifier((DBPDataSource)object.getDataSource(), (String)dBSAttributeBase.getName())).append("=src.").append(DBUtils.getQuotedIdentifier((DBPDataSource)object.getDataSource(), (String)dBSAttributeBase.getName()));
                    hasAttr = true;
                }
                sql.append(this.getLineSeparator()).append("WHEN NOT MATCHED").append(this.getLineSeparator()).append("THEN INSERT (");
                hasAttr = false;
                for (DBSEntityAttribute dBSEntityAttribute : this.getAllAttributes(monitor, object)) {
                    if (hasAttr) {
                        sql.append(", ");
                    }
                    sql.append(DBUtils.getQuotedIdentifier((DBSObject)dBSEntityAttribute));
                    hasAttr = true;
                }
                sql.append(")").append(this.getLineSeparator()).append("VALUES (");
                hasAttr = false;
                for (DBSEntityAttribute dBSEntityAttribute : this.getAllAttributes(monitor, object)) {
                    if (hasAttr) {
                        sql.append(", ");
                    }
                    sql.append("src.").append(DBUtils.getQuotedIdentifier((DBSObject)dBSEntityAttribute));
                    hasAttr = true;
                }
                sql.append(");\n");
            }
        };
    }

    @NotNull
    private static SQLGenerator<DBSEntity> JOIN_GENERATOR(List<DBSEntity> entities) {
        return new SQLGenerator<DBSEntity>(entities){

            @Override
            public void run(DBRProgressMonitor monitor) throws InvocationTargetException {
                StringBuilder sql = new StringBuilder(100);
                try {
                    sql.append("SELECT ");
                    int i = 0;
                    while (i < this.objects.size()) {
                        if (i > 0) {
                            sql.append(", ");
                        }
                        sql.append(SQLUtils.getTableAlias((DBSEntity)((DBSEntity)this.objects.get(i)))).append(".*");
                        ++i;
                    }
                    sql.append(this.getLineSeparator()).append("FROM ");
                    i = 0;
                    while (i < this.objects.size()) {
                        DBSEntity entity = (DBSEntity)this.objects.get(i);
                        if (i > 0) {
                            sql.append(", ");
                        }
                        sql.append(this.getEntityName(entity)).append(" ").append(SQLUtils.getTableAlias((DBSEntity)entity));
                        ++i;
                    }
                    sql.append(this.getLineSeparator()).append("WHERE ");
                    boolean hasCond = false;
                    int i2 = 1;
                    while (i2 < this.objects.size()) {
                        boolean foundJoin = false;
                        int k = 0;
                        while (k < i2) {
                            String tableJoin = SQLUtils.generateTableJoin((DBRProgressMonitor)monitor, (DBSEntity)((DBSEntity)this.objects.get(k)), (String)SQLUtils.getTableAlias((DBSEntity)((DBSEntity)this.objects.get(k))), (DBSEntity)((DBSEntity)this.objects.get(i2)), (String)SQLUtils.getTableAlias((DBSEntity)((DBSEntity)this.objects.get(i2))));
                            if (tableJoin != null) {
                                sql.append(this.getLineSeparator()).append("\t");
                                if (hasCond) {
                                    sql.append("AND ");
                                }
                                sql.append(tableJoin);
                                hasCond = true;
                                foundJoin = true;
                                break;
                            }
                            ++k;
                        }
                        if (!foundJoin) {
                            sql.append("\n-- Can't determine condition to join table ").append(DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)this.objects.get(i2))));
                        }
                        ++i2;
                    }
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
                this.result = sql.toString();
            }

            @Override
            public void generateSQL(DBRProgressMonitor monitor, StringBuilder sql, DBSEntity object) {
            }
        };
    }

    @NotNull
    public static SQLGenerator<DBSProcedure> CALL_GENERATOR(List<DBSProcedure> entities) {
        return new ProcedureAnalysisRunner((List)entities){

            @Override
            protected void generateSQL(DBRProgressMonitor monitor, StringBuilder sql, DBSProcedure proc) throws DBException {
                Collection parameters = proc.getParameters(monitor);
                DBPDataSource dataSource = proc.getDataSource();
                SQLDialect sqlDialect = dataSource.getSQLDialect();
                sqlDialect.generateStoredProcedureCall(sql, proc, CommonUtils.safeCollection((Collection)parameters));
            }
        };
    }

    private static abstract class BaseAnalysisRunner<OBJECT>
    extends SQLGenerator<OBJECT> {
        BaseAnalysisRunner(List<OBJECT> objects) {
            super(objects);
        }

        protected abstract Collection<? extends DBSAttributeBase> getAllAttributes(DBRProgressMonitor var1, OBJECT var2) throws DBException;

        protected abstract Collection<? extends DBSAttributeBase> getKeyAttributes(DBRProgressMonitor var1, OBJECT var2) throws DBException;

        protected Collection<? extends DBSAttributeBase> getValueAttributes(DBRProgressMonitor monitor, OBJECT object, Collection<? extends DBSAttributeBase> keyAttributes) throws DBException {
            if (CommonUtils.isEmpty(keyAttributes)) {
                return this.getAllAttributes(monitor, object);
            }
            ArrayList<DBSAttributeBase> valueAttributes = new ArrayList<DBSAttributeBase>(this.getAllAttributes(monitor, object));
            valueAttributes.removeIf(keyAttributes::contains);
            return valueAttributes;
        }

        protected void appendDefaultValue(StringBuilder sql, DBSAttributeBase attr) {
            String defValue = null;
            if (attr instanceof DBSEntityAttribute) {
                defValue = ((DBSEntityAttribute)attr).getDefaultValue();
            }
            if (!CommonUtils.isEmpty(defValue)) {
                sql.append(defValue);
            } else {
                switch (attr.getDataKind()) {
                    case BOOLEAN: {
                        sql.append("false");
                        break;
                    }
                    case NUMERIC: {
                        sql.append("0");
                        break;
                    }
                    case STRING: 
                    case DATETIME: 
                    case CONTENT: {
                        sql.append("''");
                        break;
                    }
                    default: {
                        sql.append("?");
                    }
                }
            }
        }

        protected void appendAttributeValue(IResultSetController rsv, StringBuilder sql, DBDAttributeBinding binding, ResultSetRow row) {
            DBPDataSource dataSource = binding.getDataSource();
            Object value = rsv.getModel().getCellValue(binding, row);
            sql.append(SQLUtils.convertValueToSQL((DBPDataSource)dataSource, (DBSAttributeBase)binding.getAttribute(), (Object)value));
        }
    }

    private static class GenerateSQLDialog
    extends ViewSQLDialog {
        private static final String PROP_USE_FQ_NAMES = "GenerateSQL.useFQNames";
        private static final String PROP_USE_COMPACT_SQL = "GenerateSQL.compactSQL";
        private final SQLGenerator<?> sqlGenerator;

        GenerateSQLDialog(IWorkbenchPartSite parentSite, DBCExecutionContext context, SQLGenerator<?> sqlGenerator) {
            super(parentSite, () -> context, "Generated SQL (" + context.getDataSource().getContainer().getName() + ")", null, "");
            this.sqlGenerator = sqlGenerator;
        }

        @Override
        protected Composite createDialogArea(Composite parent) {
            this.sqlGenerator.setFullyQualifiedNames(this.getDialogBoundsSettings().get(PROP_USE_FQ_NAMES) == null || this.getDialogBoundsSettings().getBoolean(PROP_USE_FQ_NAMES));
            this.sqlGenerator.setCompactSQL(this.getDialogBoundsSettings().get(PROP_USE_COMPACT_SQL) != null && this.getDialogBoundsSettings().getBoolean(PROP_USE_COMPACT_SQL));
            UIUtils.runInUI(this.sqlGenerator);
            Object sql = this.sqlGenerator.getResult();
            if (sql != null) {
                this.setSQLText(CommonUtils.toString((Object)sql));
            }
            Composite composite = super.createDialogArea(parent);
            Group settings = UIUtils.createControlGroup((Composite)composite, (String)"Settings", (int)2, (int)768, (int)-1);
            final Button useFQNames = UIUtils.createCheckbox((Composite)settings, (String)"Use fully qualified names", (boolean)this.sqlGenerator.isFullyQualifiedNames());
            useFQNames.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    sqlGenerator.setFullyQualifiedNames(useFQNames.getSelection());
                    this.getDialogBoundsSettings().put(GenerateSQLDialog.PROP_USE_FQ_NAMES, useFQNames.getSelection());
                    UIUtils.runInUI((DBRRunnableWithProgress)sqlGenerator);
                    Object sql = sqlGenerator.getResult();
                    if (sql != null) {
                        this.setSQLText(CommonUtils.toString((Object)sql));
                        this.updateSQL();
                    }
                }
            });
            final Button useCompactSQL = UIUtils.createCheckbox((Composite)settings, (String)"Compact SQL", (boolean)this.sqlGenerator.isCompactSQL());
            useCompactSQL.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    sqlGenerator.setCompactSQL(useCompactSQL.getSelection());
                    this.getDialogBoundsSettings().put(GenerateSQLDialog.PROP_USE_COMPACT_SQL, useCompactSQL.getSelection());
                    UIUtils.runInUI((DBRRunnableWithProgress)sqlGenerator);
                    Object sql = sqlGenerator.getResult();
                    if (sql != null) {
                        this.setSQLText(CommonUtils.toString((Object)sql));
                        this.updateSQL();
                    }
                }
            });
            return composite;
        }
    }

    private static abstract class ProcedureAnalysisRunner
    extends BaseAnalysisRunner<DBSProcedure> {
        ProcedureAnalysisRunner(List<DBSProcedure> entities) {
            super(entities);
        }

        @Override
        protected Collection<? extends DBSEntityAttribute> getAllAttributes(DBRProgressMonitor monitor, DBSProcedure object) {
            return Collections.emptyList();
        }

        @Override
        protected Collection<? extends DBSEntityAttribute> getKeyAttributes(DBRProgressMonitor monitor, DBSProcedure object) {
            return Collections.emptyList();
        }
    }

    private static abstract class ResultSetAnalysisRunner
    extends BaseAnalysisRunner<ResultSetModel> {
        ResultSetAnalysisRunner(DBPDataSource dataSource, ResultSetModel model) {
            super(Collections.singletonList(model));
        }

        @Override
        protected abstract void generateSQL(DBRProgressMonitor var1, StringBuilder var2, ResultSetModel var3) throws DBException;

        @Override
        protected Collection<? extends DBSAttributeBase> getAllAttributes(DBRProgressMonitor monitor, ResultSetModel object) {
            return object.getVisibleAttributes();
        }

        void appendValueCondition(IResultSetController rsv, StringBuilder sql, DBDAttributeBinding binding, ResultSetRow firstRow) {
            Object value = rsv.getModel().getCellValue(binding, firstRow);
            sql.append(DBUtils.getObjectFullName((DBPNamedObject)binding.getAttribute(), (DBPEvaluationContext)DBPEvaluationContext.DML));
            if (DBUtils.isNullValue((Object)value)) {
                sql.append(" IS NULL");
            } else {
                sql.append("=");
                this.appendAttributeValue(rsv, sql, binding, firstRow);
            }
        }

        protected List<DBDAttributeBinding> getKeyAttributes(DBRProgressMonitor monitor, ResultSetModel object) {
            DBDRowIdentifier rowIdentifier = this.getDefaultRowIdentifier(object);
            if (rowIdentifier == null) {
                return Collections.emptyList();
            }
            return rowIdentifier.getAttributes();
        }

        @Nullable
        private DBDRowIdentifier getDefaultRowIdentifier(ResultSetModel object) {
            DBDAttributeBinding[] dBDAttributeBindingArray = object.getAttributes();
            int n = dBDAttributeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBDAttributeBinding attr = dBDAttributeBindingArray[n2];
                DBDRowIdentifier rowIdentifier = attr.getRowIdentifier();
                if (rowIdentifier != null) {
                    return rowIdentifier;
                }
                ++n2;
            }
            return null;
        }
    }

    public static abstract class SQLGenerator<OBJECT>
    extends DBRRunnableWithResult<String> {
        protected final List<OBJECT> objects;
        private boolean fullyQualifiedNames = true;
        private boolean compactSQL = false;

        SQLGenerator(List<OBJECT> objects) {
            this.objects = objects;
        }

        boolean isFullyQualifiedNames() {
            return this.fullyQualifiedNames;
        }

        void setFullyQualifiedNames(boolean fullyQualifiedNames) {
            this.fullyQualifiedNames = fullyQualifiedNames;
        }

        public boolean isCompactSQL() {
            return this.compactSQL;
        }

        public void setCompactSQL(boolean compactSQL) {
            this.compactSQL = compactSQL;
        }

        protected String getLineSeparator() {
            return this.compactSQL ? " " : "\n";
        }

        protected String getEntityName(DBSEntity entity) {
            if (this.fullyQualifiedNames) {
                return DBUtils.getObjectFullName((DBPNamedObject)entity, (DBPEvaluationContext)DBPEvaluationContext.DML);
            }
            return DBUtils.getQuotedIdentifier((DBSObject)entity);
        }

        protected void addOptions(Map<String, Object> options) {
            options.put("useFQN", this.isFullyQualifiedNames());
            options.put("script.format.compact", this.isCompactSQL());
        }

        public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            StringBuilder sql = new StringBuilder(100);
            try {
                for (OBJECT object : this.objects) {
                    this.generateSQL(monitor, sql, object);
                }
            }
            catch (DBException e) {
                throw new InvocationTargetException(e);
            }
            this.result = sql.toString();
        }

        protected abstract void generateSQL(DBRProgressMonitor var1, StringBuilder var2, OBJECT var3) throws DBException;
    }

    private static abstract class TableAnalysisRunner
    extends BaseAnalysisRunner<DBSEntity> {
        TableAnalysisRunner(List<DBSEntity> entities) {
            super(entities);
        }

        @Override
        protected Collection<? extends DBSEntityAttribute> getAllAttributes(DBRProgressMonitor monitor, DBSEntity object) throws DBException {
            return CommonUtils.safeCollection((Collection)object.getAttributes(monitor));
        }

        @Override
        protected Collection<? extends DBSEntityAttribute> getKeyAttributes(DBRProgressMonitor monitor, DBSEntity object) throws DBException {
            return DBUtils.getBestTableIdentifier((DBRProgressMonitor)monitor, (DBSEntity)object);
        }
    }
}

