/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.HashMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.ide.undo.UpdateMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.Util;

public class MarkersPropertyPage
extends PropertyPage {
    private Text descriptionText;
    private IMarker marker;
    Combo priorityCombo;
    Button completedCheckbox;
    Button copyButton;

    protected Control createContents(Composite parent) {
        IMarker element = (IMarker)Adapters.adapt((Object)this.getElement(), IMarker.class);
        IWorkspaceRoot resource = null;
        if (element != null) {
            this.marker = element;
            resource = this.marker.getResource();
        }
        if (resource == null) {
            resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        if (!Util.isEditable(this.marker)) {
            this.noDefaultAndApplyButton();
        }
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        this.initializeDialogUnits((Control)composite);
        this.createAttributesArea(composite);
        this.createResourceNameArea(composite);
        if (resource != null) {
            this.createResourceArea(composite);
        }
        if (element != null) {
            this.createCreationTimeArea(composite);
        }
        this.createSeparator(composite);
        this.createDescriptionArea(composite);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void createSeparator(Composite parent) {
        Label seperator = new Label(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        seperator.setLayoutData((Object)gridData);
    }

    private void createCreationTimeArea(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(MarkerMessages.propertiesDialog_creationTime_text);
        Text creationTime = MarkersPropertyPage.createReadOnlyText(parent);
        creationTime.setText(Util.getCreationTime(this.marker));
    }

    private static Text createReadOnlyText(Composite parent) {
        Text text = new Text(parent, 12);
        text.setBackground(text.getDisplay().getSystemColor(22));
        GridData gridData = new GridData(768);
        text.setLayoutData((Object)gridData);
        return text;
    }

    private void createDescriptionArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData cGridData = new GridData(4, 4, true, true);
        cGridData.horizontalSpan = 2;
        composite.setLayoutData((Object)cGridData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(MarkerMessages.propertiesDialog_description_text);
        GridData labelGridData = new GridData(16384, 128, false, false);
        label.setLayoutData((Object)labelGridData);
        Composite textContainer = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        textContainer.setLayout((Layout)layout);
        textContainer.setLayoutData((Object)new GridData(1808));
        this.descriptionText = new Text(textContainer, 2882);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 0;
        gridData.widthHint = 0;
        gridData.grabExcessHorizontalSpace = true;
        this.descriptionText.setLayoutData((Object)gridData);
        this.descriptionText.setText(Util.getProperty("message", this.marker));
        this.descriptionText.setEditable(Util.isEditable(this.marker));
        this.copyButton = new Button(textContainer, 8);
        this.copyButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_COPY"));
        this.copyButton.setLayoutData((Object)new GridData(1040));
        ((GridData)this.copyButton.getLayoutData()).verticalAlignment = 1024;
        this.copyButton.addListener(13, event -> {
            Clipboard clipboard = new Clipboard(event.display);
            try {
                clipboard.setContents(new Object[]{this.descriptionText.getText()}, new Transfer[]{TextTransfer.getInstance()});
            }
            finally {
                clipboard.dispose();
            }
        });
    }

    protected void createAttributesArea(Composite parent) {
        try {
            if (this.marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                this.createProblemAttributes(parent);
            }
            if (this.marker.isSubtypeOf("org.eclipse.core.resources.taskmarker")) {
                this.createTaskAttributes(parent);
            }
        }
        catch (CoreException e) {
            Policy.handle(e);
        }
    }

    private void createTaskAttributes(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(MarkerMessages.propertiesDialog_priority);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.priorityCombo = new Combo(composite, 8);
        this.priorityCombo.setItems(new String[]{MarkerMessages.propertiesDialog_priorityLow, MarkerMessages.propertiesDialog_priorityNormal, MarkerMessages.propertiesDialog_priorityHigh});
        this.priorityCombo.select(this.marker.getAttribute("priority", 1));
        this.priorityCombo.setEnabled(Util.isEditable(this.marker));
        this.completedCheckbox = new Button(composite, 32);
        this.completedCheckbox.setText(MarkerMessages.propertiesDialog_completed);
        GridData gridData = new GridData();
        gridData.horizontalIndent = this.convertHorizontalDLUsToPixels(20);
        this.completedCheckbox.setLayoutData((Object)gridData);
        this.completedCheckbox.setEnabled(Util.isEditable(this.marker));
        try {
            Object done = this.marker.getAttribute("done");
            this.completedCheckbox.setSelection(done != null && done instanceof Boolean && (Boolean)done != false);
        }
        catch (CoreException e) {
            Policy.handle(e);
        }
    }

    private void createProblemAttributes(Composite parent) {
        new Label(parent, 0).setText(MarkerMessages.propertiesDialog_severityLabel);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Label severityImage = new Label(composite, 0);
        severityImage.setImage(Util.getImage(this.marker.getAttribute("severity", -1)));
        Text severityLabel = MarkersPropertyPage.createReadOnlyText(composite);
        int severity = this.marker.getAttribute("severity", -1);
        if (severity == 2) {
            severityLabel.setText(MarkerMessages.propertiesDialog_errorLabel);
        } else if (severity == 1) {
            severityLabel.setText(MarkerMessages.propertiesDialog_warningLabel);
        } else if (severity == 0) {
            severityLabel.setText(MarkerMessages.propertiesDialog_infoLabel);
        } else {
            severityLabel.setText(MarkerMessages.propertiesDialog_noseverityLabel);
        }
    }

    private void createResourceArea(Composite parent) {
        this.createResourcePathArea(parent);
        Label locationLabel = new Label(parent, 0);
        locationLabel.setText(MarkerMessages.propertiesDialog_location_text);
        Text locationText = MarkersPropertyPage.createReadOnlyText(parent);
        String line = Util.getProperty("lineNumber", this.marker);
        if (line.length() == 0) {
            String location = Util.getProperty("location", this.marker);
            if (location.length() == 0) {
                locationText.setText("");
            } else {
                locationText.setText(location);
            }
        } else {
            locationText.setText(NLS.bind((String)MarkerMessages.label_lineNumber, (Object)line));
        }
    }

    private void createResourcePathArea(Composite parent) {
        String containerName = Util.getContainerName(this.marker);
        if (!containerName.isEmpty()) {
            Label folderLabel = new Label(parent, 0);
            folderLabel.setText(MarkerMessages.propertiesDialog_folder_text);
            Text folderText = MarkersPropertyPage.createReadOnlyText(parent);
            folderText.setText(Util.getContainerName(this.marker));
        }
    }

    private void createResourceNameArea(Composite parent) {
        Label resourceLabel = new Label(parent, 0);
        resourceLabel.setText(MarkerMessages.propertiesDialog_resource_text);
        Text resourceText = MarkersPropertyPage.createReadOnlyText(parent);
        resourceText.setText(Util.getResourceName(this.marker));
    }

    public boolean performOk() {
        if (this.marker == null || Util.isEditable(this.marker)) {
            this.saveChanges();
        }
        return super.performOk();
    }

    private void saveChanges() {
        HashMap<String, String> attrs;
        try {
            attrs = this.marker.getAttributes();
        }
        catch (CoreException e) {
            attrs = new HashMap<String, String>();
            Policy.handle(e);
        }
        attrs.put("message", this.descriptionText.getText());
        if (this.priorityCombo != null) {
            int priority = 1;
            int index = this.priorityCombo.getSelectionIndex();
            if (index == this.priorityCombo.indexOf(MarkerMessages.propertiesDialog_priorityHigh)) {
                priority = 2;
            } else if (index == this.priorityCombo.indexOf(MarkerMessages.propertiesDialog_priorityLow)) {
                priority = 0;
            }
            attrs.put("priority", (String)((Object)Integer.valueOf(priority)));
        }
        if (this.completedCheckbox != null) {
            attrs.put("done", (String)((Object)(this.completedCheckbox.getSelection() ? Boolean.TRUE : Boolean.FALSE)));
        }
        UpdateMarkersOperation op = new UpdateMarkersOperation(this.marker, attrs, NLS.bind((String)MarkerMessages.qualifiedMarkerCommand_title, (Object[])new Object[]{MarkerMessages.DialogMarkerProperties_Modify, Util.getResourceName(this.marker)}), true);
        try {
            PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)op, (IProgressMonitor)new NullProgressMonitor(), WorkspaceUndoUtil.getUIInfoAdapter(this.getShell()));
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof CoreException) {
                StatusManager.getManager().handle(((CoreException)cause).getStatus(), 2);
            }
            StatusManager.getManager().handle(StatusUtil.newError(e));
        }
    }
}

