/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreConstants;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreClass;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreCollation;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataTypeAttribute;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreScriptObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTypeAlign;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTypeCategory;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTypeStorage;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTypeType;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCDataType;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreDataType
extends JDBCDataType<PostgreSchema>
implements PostgreClass,
PostgreScriptObject,
DBPQualifiedObject,
DBPImageProvider {
    private static final Log log = Log.getLog(PostgreDataType.class);
    private static final String CAT_MISC = "Miscellaneous";
    private static final String CAT_MODIFIERS = "Modifiers";
    private static final String CAT_FUNCTIONS = "Functions";
    private static final String CAT_ARRAY = "Array";
    private static String[] OID_TYPES = new String[]{"regproc", "regprocedure", "regoper", "regoperator", "regnamespace", "regclass", "regtype", "regconfig", "regdictionary"};
    private final boolean alias;
    private long typeId;
    private PostgreTypeType typeType;
    private PostgreTypeCategory typeCategory;
    private DBPDataKind dataKind;
    private final long ownerId;
    private boolean isByValue;
    private boolean isPreferred;
    private String arrayDelimiter;
    private long classId;
    private long elementTypeId;
    private long arrayItemTypeId;
    private String inputFunc;
    private String outputFunc;
    private String receiveFunc;
    private String sendFunc;
    private String modInFunc;
    private String modOutFunc;
    private String analyzeFunc;
    private PostgreTypeAlign align = PostgreTypeAlign.c;
    private PostgreTypeStorage storage = PostgreTypeStorage.p;
    private boolean isNotNull;
    private long baseTypeId;
    private int typeMod;
    private int arrayDim;
    private long collationId;
    private String defaultValue;
    private String canonicalName;
    private String constraintText;
    private final AttributeCache attributeCache;
    private Object[] enumValues;

    public PostgreDataType(@NotNull JDBCSession session, @NotNull PostgreSchema owner, long typeId, int valueType, String name, int length, JDBCResultSet dbResult) throws DBException {
        super((DBSObject)owner, valueType, name, null, false, true, length, -1, -1);
        String typStorageStr;
        this.alias = false;
        if (owner.isCatalogSchema()) {
            this.canonicalName = PostgreConstants.DATA_TYPE_CANONICAL_NAMES.get(name);
        }
        this.typeId = typeId;
        this.typeType = PostgreTypeType.b;
        String typTypeStr = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"typtype");
        try {
            if (typTypeStr != null && !typTypeStr.isEmpty()) {
                this.typeType = PostgreTypeType.valueOf(typTypeStr.toLowerCase(Locale.ENGLISH));
            }
        }
        catch (Throwable e) {
            log.debug((Object)("Invalid type type [" + typTypeStr + "] - " + e.getMessage()));
        }
        this.typeCategory = PostgreTypeCategory.X;
        boolean supportsCategory = session.getDataSource().isServerVersionAtLeast(8, 4);
        if (supportsCategory) {
            String typCategoryStr = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"typcategory");
            try {
                if (typCategoryStr != null && !typCategoryStr.isEmpty()) {
                    this.typeCategory = PostgreTypeCategory.valueOf(typCategoryStr.toUpperCase(Locale.ENGLISH));
                }
            }
            catch (Throwable e) {
                log.debug((Object)("Invalid type category [" + typCategoryStr + "] - " + e.getMessage()));
            }
        }
        if (this.typeType == PostgreTypeType.e) {
            this.dataKind = DBPDataKind.STRING;
        } else {
            this.dataKind = JDBCDataSource.getDataKind((String)this.getName(), (int)valueType);
            if (this.dataKind == DBPDataKind.OBJECT) {
                if ("jsonb".equals(name) || "json".equals(name)) {
                    this.dataKind = DBPDataKind.CONTENT;
                } else if ("interval".equals(name)) {
                    this.dataKind = DBPDataKind.DATETIME;
                }
            }
        }
        this.ownerId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"typowner");
        this.isByValue = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"typbyval");
        if (this.getDataSource().isServerVersionAtLeast(8, 4)) {
            this.isPreferred = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"typispreferred");
        }
        this.arrayDelimiter = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"typdelim");
        this.classId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"typrelid");
        this.elementTypeId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"typelem");
        this.arrayItemTypeId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"typarray");
        this.inputFunc = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"typinput");
        this.outputFunc = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"typoutput");
        this.receiveFunc = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"typreceive");
        this.sendFunc = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"typsend");
        this.modInFunc = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"typmodin");
        this.modOutFunc = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"typmodout");
        this.analyzeFunc = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"typanalyze");
        String typAlignStr = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"typalign");
        if (!CommonUtils.isEmpty((String)typAlignStr)) {
            try {
                this.align = PostgreTypeAlign.valueOf(typAlignStr);
            }
            catch (Exception e) {
                log.debug((Object)("Invalid type align [" + typAlignStr + "] - " + e.getMessage()));
            }
        }
        if (!CommonUtils.isEmpty((String)(typStorageStr = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"typstorage")))) {
            try {
                this.storage = PostgreTypeStorage.valueOf(typStorageStr);
            }
            catch (Exception e) {
                log.debug((Object)("Invalid type storage [" + typStorageStr + "] - " + e.getMessage()));
            }
        }
        this.isNotNull = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"typnotnull");
        this.baseTypeId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"typbasetype");
        this.typeMod = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"typtypmod");
        this.arrayDim = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"typndims");
        if (this.getDataSource().getServerType().supportsCollations()) {
            this.collationId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"typcollation");
        }
        this.defaultValue = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"typdefault");
        AttributeCache attributeCache = this.attributeCache = this.hasAttributes() ? new AttributeCache() : null;
        if (this.typeCategory == PostgreTypeCategory.E) {
            this.readEnumValues(session);
        }
    }

    PostgreDataType(PostgreDataType realType, String aliasName) {
        super((DBSObject)((PostgreSchema)realType.getParentObject()), (DBSTypedObject)realType);
        this.setName(aliasName);
        this.alias = true;
        this.typeId = realType.typeId;
        this.typeType = realType.typeType;
        this.typeCategory = realType.typeCategory;
        this.dataKind = realType.dataKind;
        this.ownerId = realType.ownerId;
        this.isByValue = realType.isByValue;
        this.isPreferred = realType.isPreferred;
        this.arrayDelimiter = realType.arrayDelimiter;
        this.classId = realType.classId;
        this.elementTypeId = realType.elementTypeId;
        this.arrayItemTypeId = realType.arrayItemTypeId;
        this.inputFunc = realType.inputFunc;
        this.outputFunc = realType.outputFunc;
        this.receiveFunc = realType.receiveFunc;
        this.sendFunc = realType.sendFunc;
        this.modInFunc = realType.modInFunc;
        this.modOutFunc = realType.modOutFunc;
        this.analyzeFunc = realType.analyzeFunc;
        this.align = realType.align;
        this.storage = realType.storage;
        this.isNotNull = realType.isNotNull;
        this.baseTypeId = realType.baseTypeId;
        this.typeMod = realType.typeMod;
        this.arrayDim = realType.arrayDim;
        this.collationId = realType.collationId;
        this.defaultValue = realType.defaultValue;
        this.attributeCache = null;
        this.enumValues = null;
    }

    void resolveValueTypeFromBaseType(DBRProgressMonitor monitor) {
        if (this.baseTypeId > 0L) {
            PostgreDataType baseType = this.getBaseType(monitor);
            if (baseType == null) {
                log.debug((Object)("Can't find type '" + this.getFullTypeName() + "' base type " + this.baseTypeId));
            } else if (this.getTypeID() != baseType.getTypeID()) {
                this.setTypeID(baseType.getTypeID());
            }
        }
    }

    public boolean isAlias() {
        return this.alias;
    }

    private void readEnumValues(JDBCSession session) throws DBException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT e.enumlabel \nFROM pg_catalog.pg_enum e\nWHERE e.enumtypid=?\nORDER BY e.enumsortorder");){
                dbStat.setLong(1, this.getObjectId());
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JDBCResultSet rs = dbStat.executeQuery();){
                    ArrayList<String> values = new ArrayList<String>();
                    while (rs.nextRow()) {
                        values.add(JDBCUtils.safeGetString((ResultSet)rs, (int)1));
                    }
                    this.enumValues = values.toArray();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error reading enum values", (Throwable)e, (DBPDataSource)this.getDataSource());
        }
    }

    @Property(viewable=true, order=1)
    public String getName() {
        return super.getName();
    }

    public String getFullTypeName() {
        return super.getFullTypeName();
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    @Override
    @NotNull
    public PostgreDataSource getDataSource() {
        return (PostgreDataSource)super.getDataSource();
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return ((PostgreSchema)this.getParentObject()).getDatabase();
    }

    public DBPDataKind getDataKind() {
        if (this.dataKind != null) {
            return this.dataKind;
        }
        return super.getDataKind();
    }

    @Nullable
    public DBSDataType getComponentType(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getElementType(monitor);
    }

    @Nullable
    public Object geTypeExtension() {
        return this.typeCategory;
    }

    @Property(viewable=false, order=9)
    public long getObjectId() {
        return this.typeId;
    }

    @Property(viewable=true, order=10)
    public PostgreTypeType getTypeType() {
        return this.typeType;
    }

    @Property(viewable=true, order=11)
    public PostgreTypeCategory getTypeCategory() {
        return this.typeCategory;
    }

    @Property(viewable=true, optional=true, order=12)
    public PostgreDataType getBaseType(DBRProgressMonitor monitor) {
        return this.getDatabase().getDataType(monitor, this.baseTypeId);
    }

    @Property(viewable=true, optional=true, order=13)
    public PostgreDataType getElementType(DBRProgressMonitor monitor) {
        return this.elementTypeId == 0L ? null : this.getDatabase().getDataType(monitor, this.elementTypeId);
    }

    @Property(order=15)
    public PostgreRole getOwner(DBRProgressMonitor monitor) throws DBException {
        return this.getDatabase().getRoleById(monitor, this.ownerId);
    }

    @Property(category="Miscellaneous")
    public boolean isByValue() {
        return this.isByValue;
    }

    @Property(category="Miscellaneous")
    public boolean isPreferred() {
        return this.isPreferred;
    }

    @Property(category="Miscellaneous")
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Property(category="Functions")
    public String getInputFunc() {
        return this.inputFunc;
    }

    @Property(category="Functions")
    public String getOutputFunc() {
        return this.outputFunc;
    }

    @Property(category="Functions")
    public String getReceiveFunc() {
        return this.receiveFunc;
    }

    @Property(category="Functions")
    public String getSendFunc() {
        return this.sendFunc;
    }

    @Property(category="Functions")
    public String getModInFunc() {
        return this.modInFunc;
    }

    @Property(category="Functions")
    public String getModOutFunc() {
        return this.modOutFunc;
    }

    @Property(category="Functions")
    public String getAnalyzeFunc() {
        return this.analyzeFunc;
    }

    @Property(category="Modifiers")
    public PostgreTypeAlign getAlign() {
        return this.align;
    }

    @Property(category="Modifiers")
    public PostgreTypeStorage getStorage() {
        return this.storage;
    }

    @Property(category="Modifiers")
    public boolean isNotNull() {
        return this.isNotNull;
    }

    @Property(category="Modifiers")
    public int getTypeMod() {
        return this.typeMod;
    }

    @Property(category="Modifiers")
    public PostgreCollation getCollationId(DBRProgressMonitor monitor) throws DBException {
        if (this.collationId != 0L) {
            return this.getDatabase().getCollation(monitor, this.collationId);
        }
        return null;
    }

    @Property(category="Modifiers")
    public String getConstraint(DBRProgressMonitor monitor) throws DBException {
        if (this.typeType != PostgreTypeType.d) {
            return null;
        }
        if (this.constraintText != null) {
            return this.constraintText;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read domain constraint value");){
            try {
                this.constraintText = JDBCUtils.queryString((JDBCSession)session, (String)("SELECT pg_catalog.pg_get_constraintdef((SELECT oid FROM pg_catalog.pg_constraint WHERE contypid = " + this.getObjectId() + "), true)"), (Object[])new Object[0]);
            }
            catch (SQLException e) {
                throw new DBCException("Error reading domain constraint value", (Throwable)e, (DBCExecutionContext)session.getExecutionContext());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return this.constraintText;
    }

    @Property(category="Array")
    public String getArrayDelimiter() {
        return this.arrayDelimiter;
    }

    @Property(category="Array")
    public PostgreDataType getArrayItemType(DBRProgressMonitor monitor) {
        return this.arrayItemTypeId == 0L ? null : this.getDatabase().getDataType(monitor, this.arrayItemTypeId);
    }

    public boolean isPlainType() {
        return this.arrayItemTypeId != 0L;
    }

    @Property(category="Array")
    public int getArrayDim() {
        return this.arrayDim;
    }

    public boolean hasAttributes() {
        return this.typeType == PostgreTypeType.c && this.classId >= 0L;
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.TYPE;
    }

    public Collection<PostgreDataTypeAttribute> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.attributeCache == null ? null : this.attributeCache.getAllObjects(monitor, this);
    }

    public PostgreDataTypeAttribute getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return this.attributeCache == null ? null : (PostgreDataTypeAttribute)this.attributeCache.getObject(monitor, this, attributeName);
    }

    public Collection<? extends DBSEntityConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public Collection<? extends DBSEntityAssociation> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @NotNull
    public DBCLogicalOperator[] getSupportedOperators(DBSTypedObject attribute) {
        if (this.dataKind == DBPDataKind.STRING) {
            if (this.typeCategory == PostgreTypeCategory.S || this.typeCategory == PostgreTypeCategory.E || this.typeCategory == PostgreTypeCategory.X) {
                return new DBCLogicalOperator[]{DBCLogicalOperator.IS_NULL, DBCLogicalOperator.IS_NOT_NULL, DBCLogicalOperator.EQUALS, DBCLogicalOperator.NOT_EQUALS, DBCLogicalOperator.GREATER, DBCLogicalOperator.LESS, DBCLogicalOperator.LIKE, DBCLogicalOperator.IN};
            }
            return new DBCLogicalOperator[]{DBCLogicalOperator.IS_NULL, DBCLogicalOperator.IS_NOT_NULL};
        }
        return super.getSupportedOperators(attribute);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.attributeCache != null) {
            this.attributeCache.clearCache();
        }
        if (this.typeCategory == PostgreTypeCategory.E) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Refresh enum values");){
                this.readEnumValues(session);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return this;
    }

    @Property(viewable=true, optional=true, order=16)
    public Object[] getEnumValues() {
        return this.enumValues;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        PostgreSchema owner = (PostgreSchema)this.getParentObject();
        if (owner == null || owner.getName().equals("public") || owner.getName().equals("pg_catalog")) {
            return this.getName();
        }
        return String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)owner)) + "." + DBUtils.getQuotedIdentifier((DBSObject)this);
    }

    @Nullable
    public DBPImage getObjectImage() {
        if ("jsonb".equals(this.getName()) || "json".equals(this.getName())) {
            return DBIcon.TYPE_JSON;
        }
        return null;
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        StringBuilder sql = new StringBuilder();
        if (this.typeType == PostgreTypeType.d) {
            sql.append("-- DROP DOMAIN ").append(this.getFullyQualifiedName(DBPEvaluationContext.DDL)).append(";\n\n");
        } else {
            sql.append("-- DROP TYPE ").append(this.getFullyQualifiedName(DBPEvaluationContext.DDL)).append(";\n\n");
        }
        switch (this.typeType) {
            case p: {
                sql.append("CREATE TYPE ").append(this.getFullyQualifiedName(DBPEvaluationContext.DDL)).append(";");
                break;
            }
            case d: {
                String constraint;
                sql.append("CREATE DOMAIN ").append(this.getFullyQualifiedName(DBPEvaluationContext.DDL)).append(" AS ").append(this.getBaseType(monitor).getFullyQualifiedName(DBPEvaluationContext.DDL));
                PostgreCollation collation = this.getCollationId(monitor);
                if (collation != null) {
                    sql.append("\n\tCOLLATE ").append(collation.getName());
                }
                if (!CommonUtils.isEmpty((String)this.defaultValue)) {
                    sql.append("\n\tDEFAULT ").append(this.defaultValue);
                }
                if (!CommonUtils.isEmpty((String)(constraint = this.getConstraint(monitor)))) {
                    sql.append("\n\tCONSTRAINT ").append(constraint);
                }
                sql.append(";");
                break;
            }
            case e: {
                sql.append("CREATE TYPE ").append(this.getFullyQualifiedName(DBPEvaluationContext.DDL)).append(" AS ENUM (\n");
                if (this.enumValues != null) {
                    int i = 0;
                    while (i < this.enumValues.length) {
                        Object item = this.enumValues[i];
                        sql.append("\t").append(SQLUtils.quoteString((DBSObject)this, (String)CommonUtils.toString((Object)item)));
                        if (i < this.enumValues.length - 1) {
                            sql.append(",\n");
                        }
                        ++i;
                    }
                }
                sql.append(");\n");
                break;
            }
            case r: {
                sql.append("CREATE TYPE ").append(this.getFullyQualifiedName(DBPEvaluationContext.DDL)).append(" AS RANGE (\n");
                PostgreCollation collation = this.getCollationId(monitor);
                this.appendCreateTypeParameter(sql, "COLLATION ", collation.getName());
                this.appendCreateTypeParameter(sql, "CANONICAL", this.canonicalName);
                sql.append(");\n");
                break;
            }
            case b: {
                sql.append("CREATE TYPE ").append(this.getFullyQualifiedName(DBPEvaluationContext.DDL)).append(" (");
                if (this.isValidFuncRef(this.inputFunc)) {
                    this.appendCreateTypeParameter(sql, "INPUT", this.inputFunc);
                }
                if (this.isValidFuncRef(this.outputFunc)) {
                    this.appendCreateTypeParameter(sql, "OUTPUT", this.outputFunc);
                }
                if (this.isValidFuncRef(this.receiveFunc)) {
                    this.appendCreateTypeParameter(sql, "RECEIVE", this.receiveFunc);
                }
                if (this.isValidFuncRef(this.sendFunc)) {
                    this.appendCreateTypeParameter(sql, "SEND", this.sendFunc);
                }
                if (this.isValidFuncRef(this.modInFunc)) {
                    this.appendCreateTypeParameter(sql, "TYPMOD_IN", this.modInFunc);
                }
                if (this.isValidFuncRef(this.modOutFunc)) {
                    this.appendCreateTypeParameter(sql, "TYPMOD_OUT", this.modOutFunc);
                }
                if (this.isValidFuncRef(this.analyzeFunc)) {
                    this.appendCreateTypeParameter(sql, "ANALYZE", this.analyzeFunc);
                }
                if (this.getMaxLength() > 0L) {
                    this.appendCreateTypeParameter(sql, "INTERNALLENGTH", this.getMaxLength());
                }
                if (this.isByValue) {
                    this.appendCreateTypeParameter(sql, "PASSEDBYVALUE");
                }
                if (this.align != null && this.align.getBytes() > 1) {
                    this.appendCreateTypeParameter(sql, "ALIGNMENT", this.align.getBytes());
                }
                if (this.storage != null) {
                    this.appendCreateTypeParameter(sql, "STORAGE", this.storage.getName());
                }
                if (this.typeCategory != null) {
                    this.appendCreateTypeParameter(sql, "CATEGORY", this.typeCategory.name());
                }
                if (this.isPreferred) {
                    this.appendCreateTypeParameter(sql, "PREFERRED", this.isPreferred);
                }
                this.appendCreateTypeParameter(sql, "DEFAULT", this.defaultValue);
                PostgreDataType elementType = this.getElementType(monitor);
                if (elementType != null) {
                    this.appendCreateTypeParameter(sql, "ELEMENT", elementType.getFullyQualifiedName(DBPEvaluationContext.DDL));
                }
                if (!CommonUtils.isEmpty((String)this.arrayDelimiter)) {
                    this.appendCreateTypeParameter(sql, "DELIMITER", SQLUtils.quoteString((DBPDataSource)this.getDataSource(), (String)this.arrayDelimiter));
                }
                if (this.collationId != 0L) {
                    this.appendCreateTypeParameter(sql, "COLLATABLE", true);
                }
                sql.append(");\n");
                break;
            }
            case c: {
                sql.append("CREATE TYPE ").append(this.getFullyQualifiedName(DBPEvaluationContext.DDL)).append(" AS (");
                Collection<PostgreDataTypeAttribute> attributes = this.getAttributes(monitor);
                if (!CommonUtils.isEmpty(attributes)) {
                    boolean first = true;
                    for (PostgreDataTypeAttribute attr : attributes) {
                        if (!first) {
                            sql.append(",");
                        }
                        first = false;
                        sql.append("\n\t").append(DBUtils.getQuotedIdentifier((DBSObject)attr)).append(" ").append(attr.getTypeName());
                        String modifiers = SQLUtils.getColumnTypeModifiers((DBPDataSource)this.getDataSource(), (DBSTypedObject)attr, (String)attr.getTypeName(), (DBPDataKind)attr.getDataKind());
                        if (modifiers == null) continue;
                        sql.append(modifiers);
                    }
                }
                sql.append(");\n");
                break;
            }
            default: {
                sql.append("-- Data type ").append(this.getFullyQualifiedName(DBPEvaluationContext.UI)).append(" (").append(this.typeType.getName()).append(") DDL is not supported\n");
            }
        }
        String description = this.getDescription();
        if (!CommonUtils.isEmpty((String)description)) {
            sql.append("\nCOMMENT ON TYPE ").append(this.getFullyQualifiedName(DBPEvaluationContext.DDL)).append(" IS ").append(SQLUtils.quoteString((DBSObject)this, (String)description));
        }
        return sql.toString();
    }

    private boolean isValidFuncRef(String func) {
        return !CommonUtils.isEmpty((String)func) && !func.equals("-");
    }

    private void appendCreateTypeParameter(@NotNull StringBuilder sql, @NotNull String name, @Nullable Object value) {
        if (value == null) {
            return;
        }
        if (sql.charAt(sql.length() - 1) != '(') {
            sql.append(",");
        }
        sql.append("\n\t").append(name).append(" = ").append(value);
    }

    private void appendCreateTypeParameter(@NotNull StringBuilder sql, @NotNull String name) {
        if (Character.isLetterOrDigit(sql.charAt(sql.length() - 1))) {
            sql.append(",");
        }
        sql.append("\n\t").append(name);
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
        throw new DBCFeatureNotSupportedException();
    }

    public static PostgreDataType readDataType(@NotNull JDBCSession session, @NotNull PostgreSchema schema, @NotNull JDBCResultSet dbResult, boolean skipTables) throws SQLException, DBException {
        int valueType;
        int typeLength;
        String name;
        long typeId;
        block68: {
            PostgreTypeCategory typeCategory;
            block69: {
                block67: {
                    String catString;
                    String relKind;
                    typeId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
                    name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"typname");
                    if (CommonUtils.isEmpty((String)name)) {
                        log.debug((Object)("Empty name for data type " + typeId));
                        return null;
                    }
                    if (skipTables && (relKind = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"relkind")) != null) {
                        try {
                            PostgreClass.RelKind tableType = PostgreClass.RelKind.valueOf(relKind);
                            if (tableType != PostgreClass.RelKind.c) {
                                return null;
                            }
                        }
                        catch (Exception e) {
                            log.debug((Object)e.getMessage());
                        }
                    }
                    typeLength = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"typlen");
                    String string = catString = PostgreUtils.supportsTypeCategory(session.getDataSource()) ? JDBCUtils.safeGetString((ResultSet)dbResult, (String)"typcategory") : null;
                    if (catString == null) {
                        typeCategory = null;
                    } else {
                        try {
                            typeCategory = PostgreTypeCategory.valueOf(catString.toUpperCase());
                        }
                        catch (IllegalArgumentException e) {
                            log.debug((Object)e);
                            typeCategory = null;
                        }
                    }
                    if (!ArrayUtils.contains((Object[])OID_TYPES, (Object)name) && !name.equals("hstore")) break block67;
                    valueType = 12;
                    break block68;
                }
                if (typeCategory != null) break block69;
                long typElem = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"typelem");
                switch ((int)typeId) {
                    case 1560: {
                        valueType = -7;
                        break;
                    }
                    case 16: {
                        valueType = 16;
                        break;
                    }
                    case 21: {
                        valueType = 5;
                        break;
                    }
                    case 23: {
                        valueType = 4;
                        break;
                    }
                    case 20: {
                        valueType = -5;
                        break;
                    }
                    case 700: {
                        valueType = 6;
                        break;
                    }
                    case 701: {
                        valueType = 8;
                        break;
                    }
                    case 1700: {
                        valueType = 2;
                        break;
                    }
                    case 18: {
                        valueType = 1;
                        break;
                    }
                    case 1043: {
                        valueType = 12;
                        break;
                    }
                    case 1082: {
                        valueType = 91;
                        break;
                    }
                    case 1083: 
                    case 1266: {
                        valueType = 92;
                        break;
                    }
                    case 1114: 
                    case 1184: {
                        valueType = 93;
                        break;
                    }
                    case 17: {
                        valueType = -2;
                        break;
                    }
                    case 1002: {
                        valueType = 1;
                        break;
                    }
                    case 1042: {
                        valueType = 1;
                        break;
                    }
                    case 142: {
                        valueType = 2009;
                        break;
                    }
                    default: {
                        if (typElem > 0L) {
                            valueType = 2003;
                            break;
                        }
                        valueType = 1111;
                        break;
                    }
                }
                break block68;
            }
            block21 : switch (typeCategory) {
                case A: {
                    valueType = 2003;
                    break;
                }
                case P: {
                    valueType = 1111;
                    break;
                }
                case B: {
                    valueType = 16;
                    break;
                }
                case C: {
                    valueType = 2002;
                    break;
                }
                case D: {
                    if (typeLength == 4) {
                        valueType = 91;
                        break;
                    }
                    switch ((int)typeId) {
                        case 1082: {
                            valueType = 91;
                            break block21;
                        }
                        case 1083: 
                        case 1266: {
                            valueType = 92;
                            break block21;
                        }
                        case 1114: 
                        case 1184: {
                            valueType = 93;
                            break block21;
                        }
                    }
                    valueType = 93;
                    break;
                }
                case N: {
                    valueType = 2;
                    String outputF = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"typoutput");
                    if (name.equals("numeric")) {
                        valueType = 2;
                        break;
                    }
                    if (outputF != null && outputF.startsWith("float")) {
                        switch (typeLength) {
                            case 4: {
                                valueType = 6;
                                break;
                            }
                            case 8: {
                                valueType = 8;
                            }
                        }
                        break;
                    }
                    switch (typeLength) {
                        case 2: {
                            valueType = 5;
                            break;
                        }
                        case 4: {
                            valueType = 4;
                            break;
                        }
                        case 8: {
                            valueType = -5;
                        }
                    }
                    break;
                }
                case S: {
                    valueType = 12;
                    break;
                }
                case U: {
                    switch (name) {
                        case "bytea": {
                            valueType = -2;
                            break block21;
                        }
                        case "xml": {
                            valueType = 2009;
                            break block21;
                        }
                    }
                    valueType = 1111;
                    break;
                }
                case V: {
                    valueType = 2;
                    break;
                }
                default: {
                    valueType = 1111;
                }
            }
        }
        return new PostgreDataType(session, schema, typeId, valueType, name, typeLength, dbResult);
    }

    class AttributeCache
    extends JDBCObjectCache<PostgreDataType, PostgreDataTypeAttribute> {
        AttributeCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDataType postgreDataType) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT c.relname,a.*,pg_catalog.pg_get_expr(ad.adbin, ad.adrelid, true) as def_value,dsc.description\nFROM pg_catalog.pg_attribute a\nINNER JOIN pg_catalog.pg_class c ON (a.attrelid=c.oid)\nLEFT OUTER JOIN pg_catalog.pg_attrdef ad ON (a.attrelid=ad.adrelid AND a.attnum = ad.adnum)\nLEFT OUTER JOIN pg_catalog.pg_description dsc ON (c.oid=dsc.objoid AND a.attnum = dsc.objsubid)\nWHERE a.attnum > 0 AND NOT a.attisdropped AND c.oid=?\nORDER BY a.attnum");
            dbStat.setLong(1, postgreDataType.classId);
            return dbStat;
        }

        protected PostgreDataTypeAttribute fetchObject(@NotNull JDBCSession session, @NotNull PostgreDataType postgreDataType, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new PostgreDataTypeAttribute(session.getProgressMonitor(), postgreDataType, resultSet);
        }
    }
}

