/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.wizard;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomTableEditor;
import org.jkiss.dbeaver.ui.controls.TableColumnSortListener;
import org.jkiss.utils.CommonUtils;

public class EditTaskVariablesDialog
extends StatusDialog {
    private static final String DIALOG_ID = "DBeaver.SQLQueryParameterBindDialog";
    private static final Log log = Log.getLog(EditTaskVariablesDialog.class);
    private final Map<String, Object> variables;
    private Table variablesTable;

    public EditTaskVariablesDialog(Shell shell, Map<String, Object> variables) {
        super(shell);
        this.setTitle("Task variables");
        this.variables = new LinkedHashMap<String, Object>(variables);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite paramsComposite = UIUtils.createComposite((Composite)composite, (int)1);
        paramsComposite.setLayoutData((Object)new GridData(1808));
        this.variablesTable = new Table(paramsComposite, 68356);
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 200;
        this.variablesTable.setLayoutData((Object)gd);
        this.variablesTable.setHeaderVisible(true);
        this.variablesTable.setLinesVisible(!UIStyles.isDarkTheme());
        TableColumn nameColumn = UIUtils.createTableColumn((Table)this.variablesTable, (int)16384, (String)"Variable");
        nameColumn.addListener(13, (Listener)new TableColumnSortListener(this.variablesTable, 1));
        nameColumn.setWidth(100);
        TableColumn valueColumn = UIUtils.createTableColumn((Table)this.variablesTable, (int)16384, (String)"Value");
        valueColumn.setWidth(300);
        final CustomTableEditor tableEditor = new CustomTableEditor(this.variablesTable){
            {
                this.firstTraverseIndex = 0;
                this.lastTraverseIndex = 1;
                this.editOnEnter = false;
            }

            protected Control createEditor(Table table, int index, TableItem item) {
                Text editor = new Text((Composite)table, 0);
                editor.setText(item.getText(index));
                editor.selectAll();
                editor.addTraverseListener(e -> {
                    if (e.detail == 4 && (e.stateMask & 0x40000) == 262144) {
                        UIUtils.asyncExec(EditTaskVariablesDialog.this::okPressed);
                    }
                });
                editor.addModifyListener(e -> this.saveEditorValue((Control)editor, index, item));
                return editor;
            }

            protected void saveEditorValue(Control control, int index, TableItem item) {
                String newValue = ((Text)control).getText();
                item.setText(index, newValue);
            }
        };
        ToolBar toolbar = new ToolBar(composite, 0x800100);
        ToolItem newButton = new ToolItem(toolbar, 0);
        newButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.ROW_ADD));
        final ToolItem deleteButton = new ToolItem(toolbar, 0);
        deleteButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.ROW_DELETE));
        deleteButton.setEnabled(false);
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem newItem = new TableItem(EditTaskVariablesDialog.this.variablesTable, 0);
                EditTaskVariablesDialog.this.variablesTable.setSelection(newItem);
                tableEditor.showEditor(newItem);
                deleteButton.setEnabled(true);
            }
        });
        deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                tableEditor.closeEditor();
                int selectionIndex = EditTaskVariablesDialog.this.variablesTable.getSelectionIndex();
                if (selectionIndex >= 0) {
                    EditTaskVariablesDialog.this.variablesTable.remove(selectionIndex);
                    deleteButton.setEnabled(false);
                }
            }
        });
        this.variablesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                deleteButton.setEnabled(EditTaskVariablesDialog.this.variablesTable.getSelectionIndex() >= 0);
            }
        });
        for (Map.Entry<String, Object> param : this.variables.entrySet()) {
            TableItem item = new TableItem(this.variablesTable, 0);
            item.setText(0, param.getKey());
            item.setText(1, CommonUtils.toString((Object)param.getValue()));
        }
        if (this.variablesTable.getItemCount() == 0) {
            new TableItem(this.variablesTable, 0);
        }
        tableEditor.showEditor(this.variablesTable.getItem(0));
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
    }

    protected void okPressed() {
        this.variables.clear();
        TableItem[] tableItemArray = this.variablesTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            String name = item.getText(0);
            if (!CommonUtils.isEmpty((String)name)) {
                this.variables.put(name, item.getText(1));
            }
            ++n2;
        }
        super.okPressed();
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }
}

