/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.view;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.task.DBTScheduler;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskCategory;
import org.jkiss.dbeaver.model.task.DBTTaskEvent;
import org.jkiss.dbeaver.model.task.DBTTaskListener;
import org.jkiss.dbeaver.model.task.DBTTaskManager;
import org.jkiss.dbeaver.model.task.DBTTaskRun;
import org.jkiss.dbeaver.model.task.DBTTaskScheduleInfo;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.registry.task.TaskRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.ui.view.TaskHandlerGroupBy;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DatabaseTasksView
extends ViewPart
implements DBTTaskListener {
    private static final Log log = Log.getLog(DatabaseTasksView.class);
    public static final String VIEW_ID = "org.jkiss.dbeaver.tasks";
    private static final String TASKS_VIEW_MENU_ID = "org.jkiss.dbeaver.tasks.menu";
    public static final String CREATE_TASK_CMD_ID = "org.jkiss.dbeaver.task.create";
    public static final String COPY_TASK_CMD_ID = "org.jkiss.dbeaver.task.copy";
    public static final String EDIT_TASK_CMD_ID = "org.jkiss.dbeaver.task.edit";
    public static final String RUN_TASK_CMD_ID = "org.jkiss.dbeaver.task.run";
    public static final String GROUP_TASK_CMD_ID = "org.jkiss.dbeaver.task.group";
    private static final ArrayList<Object> EMPTY_TASK_RUN_LIST = new ArrayList();
    private TreeViewer taskViewer;
    private ViewerColumnController taskColumnController;
    private TreeViewer taskRunViewer;
    private ViewerColumnController taskRunColumnController;
    private final List<DBTTask> allTasks = new ArrayList<DBTTask>();
    private boolean groupByProject = false;
    private boolean groupByType = false;
    private boolean groupByCategory = false;
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
    private Color colorError;

    public TreeViewer getTaskViewer() {
        return this.taskViewer;
    }

    public TreeViewer getTaskRunViewer() {
        return this.taskRunViewer;
    }

    public void createPartControl(Composite parent) {
        ColorRegistry colorRegistry = this.getSite().getWorkbenchWindow().getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        this.colorError = colorRegistry.get("org.jkiss.dbeaver.txn.color.reverted.background");
        CustomSashForm sashForm = UIUtils.createPartDivider((IWorkbenchPart)this, (Composite)parent, (int)256);
        this.createTaskTree((Composite)sashForm);
        this.createTaskRunTable((Composite)sashForm);
        sashForm.setWeights(new int[]{700, 300});
        this.loadViewConfig();
        this.loadTasks();
    }

    private void createTaskTree(Composite composite) {
        FilteredTree filteredTree = new FilteredTree(composite, 65538, (PatternFilter)new NamedObjectPatternFilter(), true);
        filteredTree.setInitialText("Tasks: type a part of task name here");
        this.taskViewer = filteredTree.getViewer();
        Tree taskTree = this.taskViewer.getTree();
        taskTree.setHeaderVisible(true);
        taskTree.setLayoutData((Object)new GridData(1808));
        this.taskColumnController = new ViewerColumnController("tasks", (ColumnViewer)filteredTree.getViewer());
        this.taskColumnController.addColumn("Name", "Task name", 16384, true, true, (CellLabelProvider)new TaskLabelProvider(this){

            @Override
            protected String getCellText(Object element) {
                if (element instanceof DBPProject) {
                    return ((DBPProject)element).getName();
                }
                if (element instanceof DBTTask) {
                    return ((DBTTask)element).getName();
                }
                return element.toString();
            }

            @Override
            protected DBPImage getCellImage(Object element) {
                if (element instanceof DBPProject) {
                    return DBIcon.PROJECT;
                }
                if (element instanceof DBTTask) {
                    return ((DBTTask)element).getType().getIcon();
                }
                if (element instanceof TaskCategoryNode) {
                    return ((TaskCategoryNode)element).category.getIcon();
                }
                if (element instanceof TaskTypeNode) {
                    return ((TaskTypeNode)element).type.getIcon();
                }
                return null;
            }

            public String getToolTipText(Object element) {
                if (element instanceof DBTTask) {
                    String description = ((DBTTask)element).getDescription();
                    if (CommonUtils.isEmpty((String)description)) {
                        description = ((DBTTask)element).getName();
                    }
                    return description;
                }
                return null;
            }
        });
        this.taskColumnController.addColumn("Created", "Task create time", 16384, false, false, (CellLabelProvider)new TaskLabelProvider(this){

            @Override
            protected String getCellText(Object element) {
                if (element instanceof DBTTask) {
                    return dateFormat.format(((DBTTask)element).getCreateTime());
                }
                return null;
            }
        });
        this.taskColumnController.addColumn("Last Run", "Task last start time", 16384, true, false, (CellLabelProvider)new TaskLabelProvider(this){

            @Override
            protected String getCellText(Object element) {
                if (element instanceof DBTTask) {
                    DBTTaskRun lastRun = ((DBTTask)element).getLastRun();
                    if (lastRun == null) {
                        return "N/A";
                    }
                    return dateFormat.format(lastRun.getStartTime());
                }
                return null;
            }
        });
        this.taskColumnController.addColumn("Last Duration", "Task last run duration", 16384, false, false, (CellLabelProvider)new TaskLabelProvider(this){

            @Override
            protected String getCellText(Object element) {
                if (element instanceof DBTTask) {
                    DBTTaskRun lastRun = ((DBTTask)element).getLastRun();
                    if (lastRun == null) {
                        return "N/A";
                    }
                    return RuntimeUtils.formatExecutionTime((long)lastRun.getRunDuration());
                }
                return null;
            }
        });
        this.taskColumnController.addColumn("Last Result", "Task last result", 16384, true, false, (CellLabelProvider)new TaskLabelProvider(this){

            @Override
            protected String getCellText(Object element) {
                if (element instanceof DBTTask) {
                    DBTTaskRun lastRun = ((DBTTask)element).getLastRun();
                    if (lastRun == null) {
                        return "N/A";
                    }
                    if (lastRun.isRunSuccess()) {
                        return "Success";
                    }
                    return CommonUtils.notEmpty((String)lastRun.getErrorMessage());
                }
                return null;
            }
        });
        final DBTScheduler scheduler = TaskRegistry.getInstance().getActiveSchedulerInstance();
        if (scheduler != null) {
            this.taskColumnController.addColumn("Next Run", "Task next scheduled run", 16384, true, false, (CellLabelProvider)new TaskLabelProvider(this){

                @Override
                protected String getCellText(Object element) {
                    if (element instanceof DBTTask) {
                        DBTTaskScheduleInfo scheduledTask = scheduler.getScheduledTaskInfo((DBTTask)element);
                        if (scheduledTask == null) {
                            return "";
                        }
                        return scheduledTask.getNextRunInfo();
                    }
                    return null;
                }
            });
        }
        this.taskColumnController.addColumn("Description", "Task description", 16384, false, false, (CellLabelProvider)new TaskLabelProvider(this){

            @Override
            protected String getCellText(Object element) {
                if (element instanceof DBTTask) {
                    return CommonUtils.notEmpty((String)((DBTTask)element).getDescription());
                }
                return null;
            }
        });
        this.taskColumnController.addColumn("Type", "Task type", 16384, true, false, (CellLabelProvider)new TaskLabelProvider(this){

            @Override
            protected String getCellText(Object element) {
                if (element instanceof DBTTask) {
                    return ((DBTTask)element).getType().getName();
                }
                return null;
            }
        });
        this.taskColumnController.addColumn("Category", "Task category", 16384, false, false, (CellLabelProvider)new TaskLabelProvider(this){

            @Override
            protected String getCellText(Object element) {
                if (element instanceof DBTTask) {
                    return ((DBTTask)element).getType().getCategory().getName();
                }
                return null;
            }
        });
        this.taskColumnController.addColumn("Project", "Task container project", 16384, true, false, (CellLabelProvider)new TaskLabelProvider(this){

            @Override
            protected String getCellText(Object element) {
                if (element instanceof DBTTask) {
                    return ((DBTTask)element).getProject().getName();
                }
                return null;
            }
        });
        this.taskColumnController.createColumns(true);
        this.taskViewer.setContentProvider((IContentProvider)new TreeListContentProvider());
        MenuManager menuMgr = this.createTaskContextMenu(this.taskViewer);
        this.getSite().registerContextMenu(TASKS_VIEW_MENU_ID, menuMgr, (ISelectionProvider)this.taskViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)filteredTree.getViewer());
        this.taskViewer.addDoubleClickListener(event -> ActionUtils.runCommand((String)EDIT_TASK_CMD_ID, (ISelection)this.getSite().getSelectionProvider().getSelection(), (IServiceLocator)this.getSite()));
        this.taskViewer.addSelectionChangedListener(event -> this.loadTaskRuns());
    }

    private void createTaskRunTable(Composite parent) {
        FilteredTree filteredTree = new FilteredTree(parent, 65540, (PatternFilter)new NamedObjectPatternFilter(), true);
        filteredTree.setInitialText("Task executions: type a part of error message");
        this.taskRunViewer = filteredTree.getViewer();
        Tree taskrunTree = this.taskRunViewer.getTree();
        taskrunTree.setHeaderVisible(true);
        taskrunTree.setLayoutData((Object)new GridData(1808));
        this.taskRunColumnController = new ViewerColumnController("taskruns", (ColumnViewer)this.taskRunViewer);
        this.taskRunColumnController.addColumn("Time", "Task start time", 16384, true, true, (CellLabelProvider)new TaskRunLabelProvider(this){

            @Override
            protected void update(ViewerCell cell, DBTTaskRun taskRun) {
                cell.setText(dateFormat.format(taskRun.getStartTime()));
            }
        });
        this.taskRunColumnController.addColumn("Duration", "Task last run duration", 16384, true, false, (CellLabelProvider)new TaskRunLabelProvider(this){

            @Override
            protected void update(ViewerCell cell, DBTTaskRun taskRun) {
                cell.setText(RuntimeUtils.formatExecutionTime((long)taskRun.getRunDuration()));
            }
        });
        this.taskRunColumnController.addColumn("Result", "Task result", 16384, true, false, (CellLabelProvider)new TaskRunLabelProvider(this){

            @Override
            protected void update(ViewerCell cell, DBTTaskRun taskRun) {
                if (taskRun.isRunSuccess()) {
                    cell.setText("Success");
                } else {
                    cell.setText(CommonUtils.notEmpty((String)taskRun.getErrorMessage()));
                }
            }
        });
        this.taskRunColumnController.setForceAutoSize(true);
        this.taskRunColumnController.createColumns(true);
        this.taskRunViewer.setContentProvider((IContentProvider)new TreeRunContentProvider());
        MenuManager menuMgr = this.createTaskRunContextMenu(this.taskRunViewer);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.taskRunViewer);
        this.taskRunViewer.addDoubleClickListener(event -> new ViewRunLogAction().run());
    }

    private MenuManager createTaskContextMenu(TreeViewer viewer) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(manager -> {
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)RUN_TASK_CMD_ID));
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)EDIT_TASK_CMD_ID));
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)CREATE_TASK_CMD_ID));
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)COPY_TASK_CMD_ID));
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.eclipse.ui.edit.delete", (String)"Delete task", null));
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)new Separator("additions"));
            manager.add((IContributionItem)new Separator());
            TaskHandlerGroupBy.GroupBy[] groupByArray = TaskHandlerGroupBy.GroupBy.values();
            int n = groupByArray.length;
            int n2 = 0;
            while (n2 < n) {
                TaskHandlerGroupBy.GroupBy gb = groupByArray[n2];
                manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)GROUP_TASK_CMD_ID, (int)32, null, null, null, (boolean)true, Collections.singletonMap("group", gb.name())));
                ++n2;
            }
            manager.add((IContributionItem)new Separator());
            this.taskColumnController.fillConfigMenu((IContributionManager)manager);
        });
        Control control = viewer.getControl();
        control.setMenu(menuMgr.createContextMenu(control));
        return menuMgr;
    }

    private MenuManager createTaskRunContextMenu(TreeViewer viewer) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(manager -> {
            DBTTask task = this.getSelectedTask();
            DBTTaskRun taskRun = this.getSelectedTaskRun();
            if (task != null && taskRun != null) {
                manager.add((IAction)new ViewRunLogAction());
                manager.add((IAction)new DeleteRunLogAction());
            }
            if (task != null && task.getLastRun() != null) {
                manager.add((IAction)new ClearRunLogAction());
                manager.add((IAction)new OpenRunLogFolderAction());
            }
            manager.add((IContributionItem)new Separator("additions"));
            manager.add((IContributionItem)new Separator());
            this.taskRunColumnController.fillConfigMenu((IContributionManager)manager);
        });
        Control control = viewer.getControl();
        control.setMenu(menuMgr.createContextMenu(control));
        return menuMgr;
    }

    @Nullable
    private DBTTask getSelectedTask() {
        ISelection selection = this.taskViewer.getSelection();
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return null;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        return element instanceof DBTTask ? (DBTTask)element : null;
    }

    @Nullable
    private DBTTaskRun getSelectedTaskRun() {
        ISelection selection = this.taskRunViewer.getSelection();
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return null;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        return element instanceof DBTTaskRun ? (DBTTaskRun)element : null;
    }

    public void setFocus() {
        this.taskViewer.getControl().setFocus();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return adapter.cast(new WorkbenchAdapter(){

                public String getLabel(Object o) {
                    return "Database Tasks";
                }
            });
        }
        return (T)super.getAdapter(adapter);
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        TaskRegistry.getInstance().addTaskListener((DBTTaskListener)this);
    }

    public void dispose() {
        TaskRegistry.getInstance().removeTaskListener((DBTTaskListener)this);
        super.dispose();
    }

    public void handleTaskEvent(DBTTaskEvent event) {
        UIUtils.asyncExec(() -> {
            DBTTask task = event.getTask();
            switch (event.getAction()) {
                case TASK_ADD: {
                    this.refresh();
                    this.taskViewer.setSelection((ISelection)new StructuredSelection((Object)task), true);
                    break;
                }
                case TASK_REMOVE: {
                    this.refresh();
                    break;
                }
                case TASK_UPDATE: {
                    this.taskViewer.refresh((Object)task);
                    if (task != this.getSelectedTask()) break;
                    this.loadTaskRuns();
                    break;
                }
                case TASK_EXECUTE: {
                    this.refresh();
                }
            }
        });
    }

    public boolean isGroupByProject() {
        return this.groupByProject;
    }

    public void setGroupByProject(boolean groupByProject) {
        this.groupByProject = groupByProject;
        this.saveViewConfig();
    }

    public boolean isGroupByType() {
        return this.groupByType;
    }

    public void setGroupByType(boolean groupByType) {
        this.groupByType = groupByType;
        this.saveViewConfig();
    }

    public boolean isGroupByCategory() {
        return this.groupByCategory;
    }

    public void setGroupByCategory(boolean groupByCategory) {
        this.groupByCategory = groupByCategory;
        this.saveViewConfig();
    }

    private void loadViewConfig() {
        DBPPreferenceStore preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
        this.groupByProject = preferenceStore.getBoolean("dbeaver.tasks.view.groupByProject");
        this.groupByCategory = preferenceStore.getBoolean("dbeaver.tasks.view.groupByCategory");
        this.groupByType = preferenceStore.getBoolean("dbeaver.tasks.view.groupByType");
    }

    private void saveViewConfig() {
        DBPPreferenceStore preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
        preferenceStore.setValue("dbeaver.tasks.view.groupByProject", this.groupByProject);
        preferenceStore.setValue("dbeaver.tasks.view.groupByCategory", this.groupByCategory);
        preferenceStore.setValue("dbeaver.tasks.view.groupByType", this.groupByType);
        try {
            preferenceStore.save();
        }
        catch (IOException e) {
            log.debug((Object)e);
        }
    }

    public void refresh() {
        this.refreshTasks();
        this.regroupTasks();
        this.taskViewer.refresh(true);
        if (this.refreshScheduledTasks()) {
            this.taskViewer.refresh(true);
        }
        this.loadTaskRuns();
    }

    private void loadTasks() {
        this.refreshTasks();
        this.refreshScheduledTasks();
        this.regroupTasks();
    }

    public void regroupTasks() {
        this.taskViewer.getTree().setRedraw(false);
        try {
            ArrayList<Object> rootObjects = new ArrayList<Object>();
            if (this.groupByProject) {
                rootObjects.addAll(this.getTaskProjects(this.allTasks));
            } else if (this.groupByCategory) {
                for (DBTTaskCategory category : DatabaseTasksView.getTaskCategories(null, null, this.allTasks)) {
                    rootObjects.add(new TaskCategoryNode(null, null, category));
                }
            } else if (this.groupByType) {
                for (DBTTaskType type : DatabaseTasksView.getTaskTypes(null, null, this.allTasks)) {
                    rootObjects.add(new TaskTypeNode(null, null, type));
                }
            } else {
                rootObjects.addAll(this.allTasks);
            }
            this.taskViewer.setInput(rootObjects);
            this.taskViewer.expandAll();
            this.taskColumnController.repackColumns();
        }
        finally {
            this.taskViewer.getTree().setRedraw(true);
        }
    }

    private List<DBPProject> getTaskProjects(List<DBTTask> tasks) {
        LinkedHashSet projects = new LinkedHashSet();
        tasks.forEach(task -> {
            boolean bl = projects.add(task.getProject());
        });
        return new ArrayList<DBPProject>(projects);
    }

    private static List<DBTTaskCategory> getTaskCategories(DBPProject project, DBTTaskCategory parentCategory, List<DBTTask> tasks) {
        LinkedHashSet categories = new LinkedHashSet();
        tasks.forEach(task -> {
            DBTTaskCategory category;
            if ((project == null || project == task.getProject()) && parentCategory == (category = task.getType().getCategory()).getParent()) {
                categories.add(category);
            }
        });
        return new ArrayList<DBTTaskCategory>(categories);
    }

    private static List<DBTTaskType> getTaskTypes(DBPProject project, DBTTaskCategory category, List<DBTTask> tasks) {
        LinkedHashSet types = new LinkedHashSet();
        tasks.forEach(task -> {
            if (!(project != null && project != task.getProject() || category != null && category != task.getType().getCategory())) {
                types.add(task.getType());
            }
        });
        return new ArrayList<DBTTaskType>(types);
    }

    private void refreshTasks() {
        this.allTasks.clear();
        for (DBPProject project : DBWorkbench.getPlatform().getWorkspace().getProjects()) {
            DBTTaskManager taskManager = project.getTaskManager();
            DBTTask[] tasks = taskManager.getAllTasks();
            if (tasks.length == 0) continue;
            Collections.addAll(this.allTasks, tasks);
        }
        this.allTasks.sort((o1, o2) -> o2.getCreateTime().compareTo(o1.getCreateTime()));
    }

    private boolean refreshScheduledTasks() {
        DBTScheduler scheduler = TaskRegistry.getInstance().getActiveSchedulerInstance();
        if (scheduler != null) {
            try {
                UIUtils.runInProgressService(monitor -> {
                    try {
                        scheduler.refreshScheduledTasks(monitor);
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
            }
            catch (InvocationTargetException e) {
                DBWorkbench.getPlatformUI().showError("Scheduled tasks", "Error reading scheduled tasks", (Throwable)e);
                return false;
            }
            catch (InterruptedException interruptedException) {}
            return true;
        }
        return false;
    }

    private void loadTaskRuns() {
        DBTTask selectedTask = this.getSelectedTask();
        if (selectedTask == null) {
            this.taskRunViewer.setInput(EMPTY_TASK_RUN_LIST);
        } else {
            Object[] runs = selectedTask.getRunStatistics();
            if (ArrayUtils.isEmpty((Object[])runs)) {
                this.taskRunViewer.setInput(EMPTY_TASK_RUN_LIST);
            } else {
                Arrays.sort(runs, Comparator.comparing(DBTTaskRun::getStartTime).reversed());
                this.taskRunViewer.setInput(Arrays.asList(runs));
            }
        }
    }

    private class ClearRunLogAction
    extends Action {
        ClearRunLogAction() {
            super("Clear logs", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ERASE));
        }

        public void run() {
            DBTTask task = DatabaseTasksView.this.getSelectedTask();
            if (task == null || !UIUtils.confirmAction((String)"Clear task runs", (String)("Are you sure you want to delete all log of task '" + task.getName() + "'?"))) {
                return;
            }
            task.cleanRunStatistics();
        }
    }

    private class DeleteRunLogAction
    extends Action {
        DeleteRunLogAction() {
            super("Delete run log", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.DELETE));
        }

        public void run() {
            DBTTask task = DatabaseTasksView.this.getSelectedTask();
            DBTTaskRun taskRun = DatabaseTasksView.this.getSelectedTaskRun();
            if (task != null && taskRun != null && UIUtils.confirmAction((String)"Remove task run", (String)("Are you sure you want to delete task '" + task.getName() + "' run at '" + DatabaseTasksView.this.dateFormat.format(taskRun.getStartTime()) + "'?"))) {
                task.removeRunLog(taskRun);
            }
        }
    }

    public class NamedObjectPatternFilter
    extends PatternFilter {
        NamedObjectPatternFilter() {
            this.setIncludeLeadingWildcard(true);
        }

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            if (element instanceof DBTTask) {
                return this.wordMatches(((DBTTask)element).getName());
            }
            if (element instanceof DBTTaskRun) {
                return this.wordMatches(element.toString());
            }
            return true;
        }
    }

    private class OpenRunLogFolderAction
    extends Action {
        OpenRunLogFolderAction() {
            super("Open logs folder");
        }

        public void run() {
            DBTTask task = DatabaseTasksView.this.getSelectedTask();
            if (task != null) {
                DBWorkbench.getPlatformUI().executeShellProgram(task.getRunLogFolder().getAbsolutePath());
            }
        }
    }

    private static class TaskCategoryNode {
        final DBPProject project;
        final TaskCategoryNode parent;
        final DBTTaskCategory category;

        TaskCategoryNode(DBPProject project, TaskCategoryNode parent, DBTTaskCategory category) {
            this.project = project;
            this.parent = parent;
            this.category = category;
        }

        public String toString() {
            return this.category.getName();
        }

        public int hashCode() {
            return (this.project == null ? 0 : this.project.hashCode()) + (this.parent == null ? 0 : this.parent.hashCode()) + (this.category == null ? 0 : this.category.hashCode());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TaskCategoryNode)) {
                return false;
            }
            TaskCategoryNode cmp = (TaskCategoryNode)obj;
            return this.project == cmp.project && CommonUtils.equalObjects((Object)this.parent, (Object)cmp.parent) && this.category == cmp.category;
        }
    }

    private abstract class TaskLabelProvider
    extends ColumnLabelProvider {
        private TaskLabelProvider() {
        }

        public final void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (element instanceof DBTTask) {
                DBTTaskRun lastRun = ((DBTTask)element).getLastRun();
                if (lastRun != null && !lastRun.isRunSuccess()) {
                    cell.setBackground(DatabaseTasksView.this.colorError);
                } else {
                    cell.setBackground(null);
                }
            }
            cell.setText(CommonUtils.notEmpty((String)this.getCellText(element)));
            DBPImage cellImage = this.getCellImage(element);
            if (cellImage != null) {
                cell.setImage(DBeaverIcons.getImage((DBPImage)cellImage));
            }
        }

        protected DBPImage getCellImage(Object element) {
            return null;
        }

        protected abstract String getCellText(Object var1);

        public String getText(Object element) {
            return this.getCellText(element);
        }
    }

    private abstract class TaskRunLabelProvider
    extends ColumnLabelProvider {
        private TaskRunLabelProvider() {
        }

        public final void update(ViewerCell cell) {
            DBTTaskRun taskRun = (DBTTaskRun)cell.getElement();
            if (taskRun != null && !taskRun.isRunSuccess()) {
                cell.setBackground(DatabaseTasksView.this.colorError);
            } else {
                cell.setBackground(null);
            }
            this.update(cell, taskRun);
        }

        protected abstract void update(ViewerCell var1, DBTTaskRun var2);
    }

    private static class TaskTypeNode {
        final DBPProject project;
        final TaskCategoryNode parent;
        final DBTTaskType type;

        TaskTypeNode(DBPProject project, TaskCategoryNode parent, DBTTaskType type) {
            this.project = project;
            this.parent = parent;
            this.type = type;
        }

        public String toString() {
            return this.type.getName();
        }

        public int hashCode() {
            return (this.project == null ? 0 : this.project.hashCode()) + (this.parent == null ? 0 : this.parent.hashCode()) + (this.type == null ? 0 : this.type.hashCode());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TaskTypeNode)) {
                return false;
            }
            TaskTypeNode cmp = (TaskTypeNode)obj;
            return this.project == cmp.project && CommonUtils.equalObjects((Object)this.parent, (Object)cmp.parent) && this.type == cmp.type;
        }
    }

    private class TreeListContentProvider
    implements ITreeContentProvider {
        private TreeListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList<Object> children;
            block14: {
                block15: {
                    block13: {
                        children = new ArrayList<Object>();
                        if (!(parentElement instanceof DBPProject)) break block13;
                        DBPProject project = (DBPProject)parentElement;
                        if (DatabaseTasksView.this.groupByCategory) {
                            for (DBTTaskCategory category : DatabaseTasksView.getTaskCategories(project, null, DatabaseTasksView.this.allTasks)) {
                                children.add(new TaskCategoryNode(project, null, category));
                            }
                        } else if (DatabaseTasksView.this.groupByType) {
                            for (DBTTaskType type : DatabaseTasksView.getTaskTypes(project, null, DatabaseTasksView.this.allTasks)) {
                                children.add(new TaskTypeNode(project, null, type));
                            }
                        } else {
                            for (DBTTask task : DatabaseTasksView.this.allTasks) {
                                if (task.getProject() != parentElement) continue;
                                children.add(task);
                            }
                        }
                        break block14;
                    }
                    if (!(parentElement instanceof TaskCategoryNode)) break block15;
                    TaskCategoryNode parentCat = (TaskCategoryNode)parentElement;
                    for (DBTTaskCategory childCat : DatabaseTasksView.getTaskCategories(parentCat.project, parentCat.category, DatabaseTasksView.this.allTasks)) {
                        children.add(new TaskCategoryNode(parentCat.project, parentCat, childCat));
                    }
                    if (DatabaseTasksView.this.groupByType) {
                        for (DBTTaskType type : DatabaseTasksView.getTaskTypes(parentCat.project, parentCat.category, DatabaseTasksView.this.allTasks)) {
                            children.add(new TaskTypeNode(parentCat.project, parentCat, type));
                        }
                    } else {
                        for (DBTTask task : DatabaseTasksView.this.allTasks) {
                            if (parentCat.project != null && task.getProject() != parentCat.project || task.getType().getCategory() != parentCat.category) continue;
                            children.add(task);
                        }
                    }
                    break block14;
                }
                if (!(parentElement instanceof TaskTypeNode)) break block14;
                TaskTypeNode parentType = (TaskTypeNode)parentElement;
                for (DBTTask task : DatabaseTasksView.this.allTasks) {
                    if (parentType.project != null && task.getProject() != parentType.project || task.getType() != parentType.type) continue;
                    children.add(task);
                }
            }
            return children.toArray();
        }

        public Object getParent(Object element) {
            if (element instanceof TaskTypeNode) {
                if (((TaskTypeNode)element).parent != null) {
                    return ((TaskTypeNode)element).parent;
                }
                return ((TaskTypeNode)element).project;
            }
            if (element instanceof TaskCategoryNode) {
                if (((TaskCategoryNode)element).parent != null) {
                    return ((TaskCategoryNode)element).parent;
                }
                return ((TaskCategoryNode)element).project;
            }
            return null;
        }

        public boolean hasChildren(Object parentElement) {
            return !(parentElement instanceof DBTTask);
        }
    }

    private class TreeRunContentProvider
    implements ITreeContentProvider {
        private TreeRunContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private class ViewRunLogAction
    extends Action {
        ViewRunLogAction() {
            super("View log");
        }

        public void run() {
            DBTTask task = DatabaseTasksView.this.getSelectedTask();
            DBTTaskRun taskRun = DatabaseTasksView.this.getSelectedTaskRun();
            if (task != null && taskRun != null) {
                File runLog = task.getRunLog(taskRun);
                if (runLog.exists()) {
                    try {
                        EditorUtils.openExternalFileEditor((File)runLog, (IWorkbenchWindow)DatabaseTasksView.this.getSite().getWorkbenchWindow());
                    }
                    catch (Exception e) {
                        DBWorkbench.getPlatformUI().showError("Open log error", "Error while opening task execution log", (Throwable)e);
                    }
                } else {
                    UIUtils.showMessageBox((Shell)DatabaseTasksView.this.getSite().getShell(), (String)"Lof file not found", (String)("Can't find log file '" + runLog.getAbsolutePath() + "'"), (int)1);
                }
            }
        }
    }
}

