/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.core.application.update;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.application.internal.CoreApplicationActivator;
import org.jkiss.dbeaver.core.application.update.CheckForUpdateAction;
import org.jkiss.dbeaver.registry.updater.VersionDescriptor;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Version;

public class VersionUpdateDialog
extends Dialog {
    private static final int INFO_ID = 1000;
    private static final int UPGRADE_ID = 1001;
    private static final int CHECK_EA_ID = 1002;
    private VersionDescriptor currentVersion;
    @Nullable
    private VersionDescriptor newVersion;
    private Font boldFont;
    private boolean showConfig;
    private Button dontShowAgainCheck;
    private final String earlyAccessURL;

    public VersionUpdateDialog(Shell parentShell, VersionDescriptor currentVersion, @Nullable VersionDescriptor newVersion, boolean showConfig) {
        super(parentShell);
        this.currentVersion = currentVersion;
        this.newVersion = newVersion;
        this.showConfig = showConfig;
        this.earlyAccessURL = Platform.getProduct().getProperty("earlyAccessURL");
    }

    public Version getCurrentVersion() {
        return GeneralUtils.getProductVersion();
    }

    @Nullable
    public VersionDescriptor getNewVersion() {
        return this.newVersion;
    }

    public boolean isShowConfig() {
        return this.showConfig;
    }

    public Font getBoldFont() {
        return this.boldFont;
    }

    protected boolean isResizable() {
        return true;
    }

    private boolean isNewVersionAvailable() {
        return this.newVersion != null && this.newVersion.getProgramVersion().compareTo(this.getCurrentVersion()) > 0;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(CoreMessages.dialog_version_update_title);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, false));
        Group propGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.dialog_version_update_title, (int)2, (int)1808, (int)0);
        this.createTopArea(composite);
        this.boldFont = UIUtils.makeBoldFont((Font)composite.getFont());
        Label titleLabel = new Label((Composite)propGroup, 0);
        titleLabel.setText(NLS.bind((String)(!this.isNewVersionAvailable() ? CoreMessages.dialog_version_update_no_new_version : CoreMessages.dialog_version_update_available_new_version), (Object)GeneralUtils.getProductName()));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        titleLabel.setLayoutData((Object)gd);
        titleLabel.setFont(this.boldFont);
        String versionStr = this.getCurrentVersion().toString();
        UIUtils.createControlLabel((Composite)propGroup, (String)CoreMessages.dialog_version_update_current_version);
        new Label((Composite)propGroup, 0).setText(versionStr);
        UIUtils.createControlLabel((Composite)propGroup, (String)CoreMessages.dialog_version_update_new_version);
        new Label((Composite)propGroup, 0).setText(this.newVersion == null ? versionStr : String.valueOf(this.newVersion.getProgramVersion().toString()) + "    (" + this.newVersion.getUpdateTime() + ")");
        if (this.isNewVersionAvailable()) {
            Label notesLabel = UIUtils.createControlLabel((Composite)propGroup, (String)CoreMessages.dialog_version_update_notes);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            notesLabel.setLayoutData((Object)gd);
            Text notesText = new Text((Composite)propGroup, 584);
            String releaseNotes = CommonUtils.notEmpty((String)this.newVersion.getReleaseNotes());
            if (releaseNotes.isEmpty()) {
                releaseNotes = "No release notes";
            }
            releaseNotes = VersionUpdateDialog.formatReleaseNotes(releaseNotes);
            notesText.setText(releaseNotes);
            gd = new GridData(1808);
            gd.horizontalSpan = 2;
            notesText.setLayoutData((Object)gd);
            Label hintLabel = new Label((Composite)propGroup, 0);
            hintLabel.setText(NLS.bind((String)CoreMessages.dialog_version_update_press_more_info_, (Object)CoreMessages.dialog_version_update_button_more_info, (Object)this.newVersion.getPlainVersion()));
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            hintLabel.setLayoutData((Object)gd);
            hintLabel.setFont(this.boldFont);
        }
        this.createBottomArea(composite);
        return parent;
    }

    private static String formatReleaseNotes(String releaseNotes) {
        while (releaseNotes.startsWith("\n")) {
            releaseNotes = releaseNotes.substring(1);
        }
        String[] rnLines = releaseNotes.split("\n");
        int leadSpacesNum = 0;
        int i = 0;
        while (i < rnLines[0].length()) {
            if (rnLines[0].charAt(i) != ' ') break;
            ++leadSpacesNum;
            ++i;
        }
        StringBuilder result = new StringBuilder();
        String[] stringArray = rnLines;
        int n = rnLines.length;
        int n2 = 0;
        while (n2 < n) {
            String rnLine = stringArray[n2];
            if (rnLine.length() > leadSpacesNum) {
                if (result.length() > 0) {
                    result.append("\n");
                }
                result.append(rnLine.substring(leadSpacesNum));
            }
            ++n2;
        }
        return result.toString();
    }

    protected void createTopArea(Composite composite) {
    }

    protected void createBottomArea(Composite composite) {
    }

    public boolean close() {
        this.boldFont.dispose();
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.showConfig && this.isNewVersionAvailable()) {
            ++((GridLayout)parent.getLayout()).numColumns;
            this.dontShowAgainCheck = UIUtils.createCheckbox((Composite)parent, (String)("Don't show for the version " + this.newVersion.getPlainVersion()), (boolean)false);
        }
        if (this.isNewVersionAvailable()) {
            this.createButton(parent, 1001, "Upgrade ...", true);
        } else if (!CommonUtils.isEmpty((String)this.earlyAccessURL)) {
            this.createButton(parent, 1002, "Early Access", false);
        }
        this.createButton(parent, 1000, CoreMessages.dialog_version_update_button_more_info, false);
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, !this.isNewVersionAvailable());
    }

    protected void buttonPressed(int buttonId) {
        if (this.dontShowAgainCheck != null && this.dontShowAgainCheck.getSelection() && this.newVersion != null) {
            CoreApplicationActivator.getDefault().getPreferenceStore().setValue("suppressUpdateCheck." + this.newVersion.getPlainVersion(), true);
        }
        if (buttonId == 1000) {
            if (this.newVersion != null) {
                UIUtils.launchProgram((String)this.newVersion.getBaseURL());
            } else if (this.currentVersion != null) {
                UIUtils.launchProgram((String)this.currentVersion.getBaseURL());
            }
        } else if (buttonId == 1001) {
            if (this.newVersion != null) {
                UIUtils.launchProgram((String)this.makeDownloadURL(this.newVersion.getBaseURL()));
            }
        } else if (buttonId == 1002) {
            if (!CommonUtils.isEmpty((String)this.earlyAccessURL)) {
                UIUtils.launchProgram((String)this.earlyAccessURL);
            }
        } else if (buttonId == 10) {
            IWorkbenchWindow window = UIUtils.getActiveWorkbenchWindow();
            CheckForUpdateAction.activateStandardHandler(window);
            try {
                ActionUtils.runCommand((String)"org.eclipse.equinox.p2.ui.sdk.update", (IServiceLocator)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            }
            finally {
                CheckForUpdateAction.deactivateStandardHandler(window);
            }
        }
        this.close();
    }

    private String makeDownloadURL(String baseURL) {
        String os;
        while (baseURL.endsWith("/")) {
            baseURL = baseURL.substring(0, baseURL.length() - 1);
        }
        switch (os = Platform.getOS()) {
            case "win32": {
                os = "win";
                break;
            }
            case "macosx": {
                os = "mac";
                break;
            }
            default: {
                os = "linux";
            }
        }
        String arch = Platform.getOSArch();
        String dist = null;
        if (os.equals("linux")) {
            try {
                RuntimeUtils.executeProcess((String)"/usr/bin/apt-get", (String[])new String[]{"--version"});
                dist = "deb";
            }
            catch (DBException dBException) {
                dist = "rpm";
            }
        }
        return String.valueOf(baseURL) + "?start" + "&os=" + os + "&arch=" + arch + (dist == null ? "" : "&dist=" + dist);
    }

    public static boolean isSuppressed(VersionDescriptor version) {
        CoreApplicationActivator activator = CoreApplicationActivator.getDefault();
        return activator != null && activator.getPreferenceStore().getBoolean("suppressUpdateCheck." + version.getPlainVersion());
    }
}

