/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.database;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.navigator.INavigatorListener;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithResult;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.AbstractUIJob;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.INavigatorFilter;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectRename;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorContent;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorContentProvider;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorLabelProvider;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DatabaseNavigatorTree
extends Composite
implements INavigatorListener {
    private static final Log log = Log.getLog(DatabaseNavigatorTree.class);
    private TreeViewer treeViewer;
    private DBNModel model;
    private TreeEditor treeEditor;
    private boolean checkEnabled;
    private INavigatorFilter navigatorFilter;
    private Text filterControl;
    private boolean inlineRenameEnabled = false;

    public DatabaseNavigatorTree(Composite parent, DBNNode rootNode, int style) {
        this(parent, rootNode, style, false);
    }

    public DatabaseNavigatorTree(Composite parent, DBNNode rootNode, int style, boolean showRoot) {
        this(parent, rootNode, style, showRoot, null);
    }

    public DatabaseNavigatorTree(Composite parent, DBNNode rootNode, int style, boolean showRoot, INavigatorFilter navigatorFilter) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.navigatorFilter = navigatorFilter;
        this.model = DBWorkbench.getPlatform().getNavigatorModel();
        this.model.addListener((INavigatorListener)this);
        this.addDisposeListener(e -> {
            if (this.model != null) {
                this.model.removeListener((INavigatorListener)this);
                this.model = null;
            }
        });
        this.treeViewer = this.doCreateTreeViewer(this, style);
        this.treeViewer.getTree().setCursor(this.getDisplay().getSystemCursor(0));
        this.treeViewer.setUseHashlookup(true);
        DatabaseNavigatorLabelProvider labelProvider = new DatabaseNavigatorLabelProvider((Viewer)this.treeViewer);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.treeViewer.setContentProvider((IContentProvider)new DatabaseNavigatorContentProvider(this, showRoot));
        this.treeViewer.getTree().addListener(42, (Listener)new TreeBackgroundColorPainter(labelProvider));
        if (rootNode != null) {
            this.setInput(rootNode);
        }
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        this.initEditor();
    }

    public void setInput(DBNNode rootNode) {
        this.treeViewer.setInput((Object)new DatabaseNavigatorContent(rootNode));
    }

    public INavigatorFilter getNavigatorFilter() {
        return this.navigatorFilter;
    }

    public void setNavigatorFilter(final INavigatorFilter navigatorFilter) {
        this.navigatorFilter = navigatorFilter;
        if (this.treeViewer != null) {
            this.treeViewer.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return navigatorFilter.select(element);
                }
            });
        }
    }

    @Nullable
    public Text getFilterControl() {
        return this.filterControl;
    }

    private TreeViewer doCreateTreeViewer(Composite parent, int style) {
        this.checkEnabled = (style & 0x20) != 0;
        int treeStyle = 0x300 | style;
        if (this.checkEnabled) {
            CheckboxTreeViewer checkboxTreeViewer = new CheckboxTreeViewer(parent, treeStyle);
            if (this.navigatorFilter != null) {
                checkboxTreeViewer.addFilter(new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        return DatabaseNavigatorTree.this.navigatorFilter.select(element);
                    }
                });
            }
            return checkboxTreeViewer;
        }
        if (this.navigatorFilter != null) {
            CustomFilteredTree filteredTree = new CustomFilteredTree(this, treeStyle);
            this.filterControl = filteredTree.getFilterControl();
            return filteredTree.getViewer();
        }
        return this.doCreateNavigatorTreeViewer(parent, style);
    }

    private TreeViewer doCreateNavigatorTreeViewer(Composite parent, int style) {
        return new TreeViewer(parent, style){

            public ISelection getSelection() {
                ISelection selection = super.getSelection();
                if (!selection.isEmpty()) {
                    return selection;
                }
                Object rootNode = this.getInput();
                if (rootNode instanceof DatabaseNavigatorContent) {
                    rootNode = ((DatabaseNavigatorContent)rootNode).getRootNode();
                }
                return rootNode == null ? new TreeSelection() : new TreeSelection(new TreePath(new Object[]{rootNode}));
            }

            protected void handleTreeExpand(TreeEvent event) {
                this.getTree().setRedraw(false);
                try {
                    super.handleTreeExpand(event);
                }
                finally {
                    this.getTree().setRedraw(true);
                }
            }

            protected void handleTreeCollapse(TreeEvent event) {
                this.getTree().setRedraw(false);
                try {
                    super.handleTreeCollapse(event);
                }
                finally {
                    this.getTree().setRedraw(true);
                }
            }
        };
    }

    public DBNNode getModel() {
        DatabaseNavigatorContent content = (DatabaseNavigatorContent)this.treeViewer.getInput();
        return content.getRootNode();
    }

    private void initEditor() {
        if (this.inlineRenameEnabled) {
            Tree treeControl = this.treeViewer.getTree();
            this.treeEditor = new TreeEditor(treeControl);
            this.treeEditor.horizontalAlignment = 16384;
            this.treeEditor.verticalAlignment = 128;
            this.treeEditor.grabHorizontal = false;
            this.treeEditor.minimumWidth = 50;
            if (!this.checkEnabled) {
                treeControl.addMouseListener((MouseListener)new TreeSelectionAdapter());
            }
        }
    }

    @NotNull
    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    public void nodeChanged(DBNEvent event) {
        switch (event.getAction()) {
            case ADD: 
            case REMOVE: {
                DBNNode node = event.getNode();
                DBNNode parentNode = node.getParentNode();
                if (parentNode == null || this.treeViewer.getControl().isDisposed() || parentNode.isDisposed()) break;
                this.treeViewer.refresh(this.getViewerObject(parentNode));
                if (event.getNodeChange() != DBNEvent.NodeChange.SELECT) break;
                this.treeViewer.reveal((Object)node);
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)node));
                break;
            }
            case UPDATE: {
                if (this.treeViewer.getControl().isDisposed() || this.treeViewer.isBusy()) break;
                if (event.getNode() != null) {
                    switch (event.getNodeChange()) {
                        case LOAD: {
                            this.treeViewer.refresh(this.getViewerObject(event.getNode()));
                            this.expandNodeOnLoad(event.getNode());
                            break;
                        }
                        case UNLOAD: {
                            this.treeViewer.collapseToLevel((Object)event.getNode(), -1);
                            this.treeViewer.update(this.getViewerObject(event.getNode()), null);
                            this.treeViewer.collapseToLevel((Object)event.getNode(), -1);
                            break;
                        }
                        case REFRESH: {
                            this.treeViewer.refresh(this.getViewerObject(event.getNode()), true);
                            break;
                        }
                        case STRUCT_REFRESH: 
                        case LOCK: 
                        case UNLOCK: {
                            this.treeViewer.refresh(this.getViewerObject(event.getNode()));
                        }
                    }
                    break;
                }
                log.warn((Object)"Null node object");
                break;
            }
        }
    }

    private void expandNodeOnLoad(final DBNNode node) {
        if (node instanceof DBNDataSource && DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.expand.on.connect")) {
            try {
                DBRRunnableWithResult<DBNNode> runnable = new DBRRunnableWithResult<DBNNode>(){

                    public void run(DBRProgressMonitor monitor) throws InvocationTargetException {
                        try {
                            this.result = DatabaseNavigatorTree.this.findActiveNode(monitor, node);
                        }
                        catch (DBException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                };
                UIUtils.runInProgressService((DBRRunnableWithProgress)runnable);
                if (runnable.getResult() != null && !this.treeViewer.getTree().isDisposed()) {
                    this.showNode((DBNNode)runnable.getResult());
                    this.treeViewer.expandToLevel(runnable.getResult(), 1);
                }
            }
            catch (InvocationTargetException e) {
                log.error((Object)"Can't expand node", e.getTargetException());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private DBNNode findActiveNode(DBRProgressMonitor monitor, DBNNode node) throws DBException {
        Object[] children = node.getChildren(monitor);
        if (!ArrayUtils.isEmpty((Object[])children)) {
            if (children[0] instanceof DBNContainer) {
                return this.findActiveNode(monitor, (DBNNode)children[0]);
            }
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (DBNUtils.isDefaultElement((Object)child)) {
                    return child;
                }
                ++n2;
            }
        }
        return node;
    }

    private Object getViewerObject(DBNNode node) {
        Object input = this.treeViewer.getInput();
        if (input instanceof DatabaseNavigatorContent && ((DatabaseNavigatorContent)input).getRootNode() == node) {
            return input;
        }
        return node;
    }

    void showNode(DBNNode node) {
        this.treeViewer.reveal((Object)node);
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)node));
    }

    public void reloadTree(DBNNode rootNode) {
        this.setInput(rootNode);
    }

    private void renameItem(TreeItem item) {
        this.disposeOldEditor();
        if (item.isDisposed()) {
            return;
        }
        final DBNNode node = (DBNNode)item.getData();
        Text text = new Text((Composite)this.treeViewer.getTree(), 2048);
        text.setText(node.getNodeName());
        text.selectAll();
        text.setFocus();
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                DatabaseNavigatorTree.this.disposeOldEditor();
            }
        });
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    Text text = (Text)DatabaseNavigatorTree.this.treeEditor.getEditor();
                    String newName = text.getText();
                    DatabaseNavigatorTree.this.disposeOldEditor();
                    DatabaseNavigatorTree.this.treeViewer.getTree().setFocus();
                    if (!CommonUtils.isEmpty((String)newName) && !newName.equals(node.getNodeName())) {
                        NavigatorHandlerObjectRename.renameNode(UIUtils.getActiveWorkbenchWindow(), DatabaseNavigatorTree.this.treeViewer.getControl().getShell(), node, newName);
                    }
                } else if (e.keyCode == 27) {
                    DatabaseNavigatorTree.this.disposeOldEditor();
                    DatabaseNavigatorTree.this.treeViewer.getTree().setFocus();
                }
            }
        });
        Rectangle itemBounds = item.getBounds(0);
        Rectangle treeBounds = this.treeViewer.getTree().getBounds();
        this.treeEditor.minimumWidth = Math.max(itemBounds.width, 50);
        this.treeEditor.minimumWidth = Math.min(this.treeEditor.minimumWidth, treeBounds.width - (itemBounds.x - treeBounds.x) - item.getImageBounds((int)0).width - 4);
        this.treeEditor.minimumHeight = text.computeSize((int)-1, (int)-1).y;
        this.treeEditor.setEditor((Control)text, item, 0);
    }

    private void disposeOldEditor() {
        Control oldEditor = this.treeEditor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
    }

    protected void onTreeRefresh() {
    }

    private static class CustomFilteredTree
    extends FilteredTree {
        CustomFilteredTree(DatabaseNavigatorTree navigatorTree, int treeStyle) {
            super((Composite)navigatorTree, treeStyle, (PatternFilter)new TreeFilter(navigatorTree.navigatorFilter), true);
            this.setInitialText(UINavigatorMessages.actions_navigator_search_tip);
            ((GridLayout)this.getLayout()).verticalSpacing = 0;
            UIUtils.addDefaultEditActionsSupport((IServiceLocator)UIUtils.getActiveWorkbenchWindow(), (Control)this.getFilterControl());
        }

        protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
            return ((DatabaseNavigatorTree)this.getParent()).doCreateNavigatorTreeViewer(parent, style);
        }

        protected WorkbenchJob doCreateRefreshJob() {
            return new WorkbenchJob("Refresh Filter"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    boolean initial;
                    if (treeViewer.getControl().isDisposed()) {
                        return Status.CANCEL_STATUS;
                    }
                    String text = this.getFilterString();
                    if (text == null) {
                        return Status.OK_STATUS;
                    }
                    boolean bl = initial = initialText != null && initialText.equals(text);
                    if (initial) {
                        this.getPatternFilter().setPattern(null);
                    } else {
                        this.getPatternFilter().setPattern(text);
                    }
                    Composite redrawFalseControl = treeComposite != null ? treeComposite : treeViewer.getControl();
                    try {
                        redrawFalseControl.setRedraw(false);
                        treeViewer.refresh(true);
                        if (text.length() > 0 && !initial) {
                            this.updateToolbar(true);
                        } else {
                            this.updateToolbar(false);
                        }
                        ((DatabaseNavigatorTree)this.getParent()).onTreeRefresh();
                    }
                    finally {
                        redrawFalseControl.setRedraw(true);
                    }
                    return Status.OK_STATUS;
                }
            };
        }
    }

    private static class TreeBackgroundColorPainter
    implements Listener {
        private DatabaseNavigatorLabelProvider labelProvider;

        TreeBackgroundColorPainter(DatabaseNavigatorLabelProvider labelProvider) {
            this.labelProvider = labelProvider;
        }

        public void handleEvent(Event event) {
            if ((event.detail & 2) == 0 && (event.detail & 0x20) == 0) {
                return;
            }
            TreeItem item = (TreeItem)event.item;
            Color colorBackground = this.labelProvider.getBackground(item.getData());
            if (colorBackground != null) {
                GC gc = event.gc;
                Color oldBackground = gc.getForeground();
                gc.setForeground(colorBackground);
                gc.drawRoundRectangle(event.x, event.y, event.width, event.height - 1, 3, 3);
                gc.setForeground(oldBackground);
            }
        }
    }

    private static class TreeFilter
    extends PatternFilter {
        private final INavigatorFilter filter;
        private boolean hasPattern = false;

        TreeFilter(INavigatorFilter filter) {
            this.setIncludeLeadingWildcard(true);
            this.filter = filter;
        }

        public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
            int size = elements.length;
            ArrayList<Object> out = new ArrayList<Object>(size);
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (this.select(viewer, parent, element)) {
                    out.add(element);
                }
                ++n2;
            }
            return out.toArray();
        }

        public void setPattern(String patternString) {
            this.hasPattern = !CommonUtils.isEmpty((String)patternString);
            super.setPattern(patternString);
        }

        public boolean isElementVisible(Viewer viewer, Object element) {
            if (this.hasPattern && this.filter.filterFolders() && element instanceof DBNLocalFolder) {
                return this.hasVisibleConnections(viewer, (DBNLocalFolder)element);
            }
            if (this.filter.select(element)) {
                return true;
            }
            return super.isLeafMatch(viewer, element);
        }

        private boolean hasVisibleConnections(Viewer viewer, DBNLocalFolder folder) {
            DBNNode[] children = folder.getChildren((DBRProgressMonitor)new VoidProgressMonitor());
            if (children == null) {
                return false;
            }
            DBNNode[] dBNNodeArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                DBNNode child = dBNNodeArray[n2];
                if (child instanceof DBNLocalFolder ? this.hasVisibleConnections(viewer, (DBNLocalFolder)child) : this.isLeafMatch(viewer, child)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    private class TreeSelectionAdapter
    implements MouseListener {
        private volatile TreeItem curSelection;
        private volatile RenameJob renameJob;

        private TreeSelectionAdapter() {
        }

        public synchronized void mouseDoubleClick(MouseEvent e) {
            this.curSelection = null;
            if (this.renameJob != null) {
                this.renameJob.canceled = true;
            }
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            if ((e.stateMask & 0x80000) == 0) {
                this.curSelection = null;
                return;
            }
            this.changeSelection(e);
        }

        void changeSelection(MouseEvent e) {
            DatabaseNavigatorTree.this.disposeOldEditor();
            TreeItem newSelection = DatabaseNavigatorTree.this.treeViewer.getTree().getItem(new Point(e.x, e.y));
            if (newSelection == null) {
                return;
            }
            IWorkbenchPart activePart = UIUtils.getActiveWorkbenchWindow().getActivePage().getActivePart();
            if (!(newSelection.getData() instanceof DBNNode) || activePart == null || !ActionUtils.isCommandEnabled((String)"org.eclipse.ui.edit.rename", (IWorkbenchPartSite)activePart.getSite())) {
                this.curSelection = null;
                return;
            }
            if (this.curSelection != null && this.curSelection == newSelection && (this.renameJob == null || this.renameJob.selection == null)) {
                if (this.renameJob == null) {
                    this.renameJob = new RenameJob();
                }
                this.renameJob.selection = this.curSelection;
                this.renameJob.schedule(1000L);
            }
            this.curSelection = newSelection;
        }

        private class RenameJob
        extends AbstractUIJob {
            private volatile boolean canceled;
            public TreeItem selection;

            RenameJob() {
                super("Rename ");
                this.canceled = false;
            }

            protected IStatus runInUIThread(DBRProgressMonitor monitor) {
                try {
                    if (!DatabaseNavigatorTree.this.treeViewer.getTree().isDisposed() && DatabaseNavigatorTree.this.treeViewer.getTree().isFocusControl() && TreeSelectionAdapter.this.curSelection == this.selection && !this.canceled) {
                        TreeItem itemToRename = this.selection;
                        UIUtils.asyncExec(() -> DatabaseNavigatorTree.this.renameItem(itemToRename));
                    }
                }
                finally {
                    this.canceled = false;
                    this.selection = null;
                }
                return Status.OK_STATUS;
            }
        }
    }
}

