/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.nativetool;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceMap;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractToolSettings<BASE_OBJECT extends DBSObject> {
    private static final Log log = Log.getLog(AbstractToolSettings.class);
    private DBPDataSourceContainer dataSourceContainer;
    private final List<BASE_OBJECT> databaseObjects = new ArrayList<BASE_OBJECT>();

    public List<BASE_OBJECT> getDatabaseObjects() {
        return this.databaseObjects;
    }

    public DBPProject getProject() {
        return this.dataSourceContainer == null ? null : this.dataSourceContainer.getProject();
    }

    public DBPDataSourceContainer getDataSourceContainer() {
        return this.dataSourceContainer;
    }

    public void setDataSourceContainer(DBPDataSourceContainer dataSourceContainer) {
        this.dataSourceContainer = dataSourceContainer;
    }

    protected void updateDataSourceContainer() {
        this.dataSourceContainer = this.databaseObjects.isEmpty() ? null : ((DBSObject)this.databaseObjects.get(0)).getDataSource().getContainer();
    }

    public void loadSettings(DBRRunnableContext runnableContext, DBPPreferenceStore preferenceStore) throws DBException {
        List databaseObjectList;
        String dsID;
        if (this.dataSourceContainer == null && !CommonUtils.isEmpty(this.databaseObjects)) {
            DBSObject baseObject = (DBSObject)this.databaseObjects.get(0);
            DBPDataSourceContainer dBPDataSourceContainer = this.dataSourceContainer = baseObject instanceof DBPDataSourceContainer ? (DBPDataSourceContainer)baseObject : baseObject.getDataSource().getContainer();
        }
        if (this.dataSourceContainer == null && !CommonUtils.isEmpty((String)(dsID = preferenceStore.getString("dataSource")))) {
            DBPProject project;
            String projectName = preferenceStore.getString("project");
            DBPProject dBPProject = project = CommonUtils.isEmpty((String)projectName) ? null : DBWorkbench.getPlatform().getWorkspace().getProject(projectName);
            if (project == null) {
                if (!CommonUtils.isEmpty((String)projectName)) {
                    log.error((Object)("Can't find project '" + projectName + "' for tool configuration"));
                }
                project = DBWorkbench.getPlatform().getWorkspace().getActiveProject();
            }
            this.dataSourceContainer = project.getDataSourceRegistry().getDataSource(dsID);
            if (this.dataSourceContainer == null) {
                log.error((Object)("Can't find datasource '" + dsID + "' in project '" + project.getName() + "' for tool configuration"));
            }
        }
        if (preferenceStore instanceof DBPPreferenceMap && this.dataSourceContainer != null && !CommonUtils.isEmpty((Collection)(databaseObjectList = (List)((DBPPreferenceMap)preferenceStore).getObject("databaseObjects")))) {
            DBPProject finalProject = this.dataSourceContainer.getProject();
            try {
                runnableContext.run(true, true, monitor -> {
                    try {
                        monitor.beginTask("Load database object list", databaseObjectList.size());
                        for (String objectId : databaseObjectList) {
                            monitor.subTask("Load " + objectId);
                            try {
                                DBSObject object = DBUtils.findObjectById((DBRProgressMonitor)monitor, (DBPProject)finalProject, (String)objectId);
                                if (object != null) {
                                    this.databaseObjects.add(object);
                                    this.dataSourceContainer = object.getDataSource().getContainer();
                                }
                            }
                            catch (Throwable e) {
                                throw new DBException("Can't find database object '" + objectId + "' in project '" + finalProject.getName() + "' for task configuration", e);
                            }
                            monitor.worked(1);
                        }
                        monitor.done();
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                });
            }
            catch (InvocationTargetException e) {
                throw new DBException("Error loading objects configuration", e.getTargetException());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void saveSettings(DBRRunnableContext runnableContext, DBPPreferenceStore preferenceStore) {
        preferenceStore.setValue("project", this.getProject().getName());
        if (this.dataSourceContainer != null) {
            preferenceStore.setValue("dataSource", this.dataSourceContainer.getId());
        }
        if (preferenceStore instanceof DBPPreferenceMap) {
            ArrayList<String> objectList = new ArrayList<String>();
            for (DBSObject object : this.databaseObjects) {
                objectList.add(DBUtils.getObjectFullId((DBSObject)object));
            }
            ((DBPPreferenceMap)preferenceStore).getPropertyMap().put("databaseObjects", objectList);
        }
    }
}

