/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tasks;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreDatabaseBackupHandler;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreDatabaseRestoreHandler;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolHandler;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolSettings;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public abstract class PostgreNativeToolHandler<SETTINGS extends AbstractNativeToolSettings<BASE_OBJECT>, BASE_OBJECT extends DBSObject, PROCESS_ARG>
extends AbstractNativeToolHandler<SETTINGS, BASE_OBJECT, PROCESS_ARG> {
    protected void setupProcessParameters(SETTINGS settings, PROCESS_ARG arg, ProcessBuilder process) {
        String userPassword = settings.getToolUserPassword();
        if (CommonUtils.isEmpty((String)userPassword)) {
            userPassword = settings.getDataSourceContainer().getActualConnectionConfiguration().getUserPassword();
        }
        if (!CommonUtils.isEmpty((String)userPassword)) {
            process.environment().put("PGPASSWORD", userPassword);
        }
    }

    public void fillProcessParameters(SETTINGS settings, PROCESS_ARG process_arg, List<String> cmd) throws IOException {
        String toolUserName;
        File dumpBinary = RuntimeUtils.getNativeClientBinary((DBPNativeClientLocation)settings.getClientHome(), (String)"bin", (String)(this instanceof PostgreDatabaseBackupHandler ? "pg_dump" : (this instanceof PostgreDatabaseRestoreHandler ? "pg_restore" : "psql")));
        String dumpPath = dumpBinary.getAbsolutePath();
        cmd.add(dumpPath);
        if (this.isVerbose()) {
            cmd.add("--verbose");
        }
        DBPConnectionConfiguration connectionInfo = settings.getDataSourceContainer().getActualConnectionConfiguration();
        cmd.add("--host=" + connectionInfo.getHostName());
        if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
            cmd.add("--port=" + connectionInfo.getHostPort());
        }
        if (CommonUtils.isEmpty((String)(toolUserName = settings.getToolUserName()))) {
            toolUserName = connectionInfo.getUserName();
        }
        cmd.add("--username=" + toolUserName);
        settings.addExtraCommandArgs(cmd);
    }

    protected abstract boolean isExportWizard();
}

