/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectStatus;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableConstraint;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLConstraintManager;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class OracleConstraintManager
extends SQLConstraintManager<OracleTableConstraint, OracleTableBase> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, OracleTableConstraint> getObjectsCache(OracleTableConstraint object) {
        return ((OracleTableBase)object.getParentObject()).getSchema().constraintCache;
    }

    protected OracleTableConstraint createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object from, Map<String, Object> options) {
        OracleTableBase table = (OracleTableBase)container;
        return new OracleTableConstraint(table, "", DBSEntityConstraintType.UNIQUE_KEY, null, OracleObjectStatus.ENABLED);
    }

    protected String getDropConstraintPattern(OracleTableConstraint constraint) {
        String clause = "CONSTRAINT";
        return "ALTER TABLE %TABLE% DROP " + clause + " " + "%CONSTRAINT%";
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        OracleTableConstraint constraint = (OracleTableConstraint)command.getObject();
        OracleTableBase table = (OracleTableBase)constraint.getTable();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction(ModelMessages.model_jdbc_create_new_constraint, "ALTER TABLE " + table.getFullyQualifiedName(DBPEvaluationContext.DDL) + " ADD " + this.getNestedDeclaration(monitor, table, (DBECommandAbstract)command, options) + " " + (constraint.getStatus() == OracleObjectStatus.ENABLED ? "ENABLE" : "DISABLE")));
    }
}

