/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.texteditor.templates.ITemplatesPage;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.IDataSourceContainerProvider;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLControlCommand;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryParameter;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionContext;
import org.jkiss.dbeaver.model.sql.parser.SQLParserPartitions;
import org.jkiss.dbeaver.model.sql.parser.SQLWordDetector;
import org.jkiss.dbeaver.model.sql.registry.SQLCommandsRegistry;
import org.jkiss.dbeaver.model.text.TextUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ICommentsSupport;
import org.jkiss.dbeaver.ui.IErrorVisualizer;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorContributor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorControl;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorSourceViewer;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorSourceViewerConfiguration;
import org.jkiss.dbeaver.ui.editors.sql.SQLMarkerAnnotationAccess;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLCharacterPairMatcher;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLEditorCompletionContext;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLPartitionScanner;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLRuleManager;
import org.jkiss.dbeaver.ui.editors.sql.syntax.tokens.SQLControlToken;
import org.jkiss.dbeaver.ui.editors.sql.syntax.tokens.SQLToken;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLTemplatesPage;
import org.jkiss.dbeaver.ui.editors.sql.util.SQLSymbolInserter;
import org.jkiss.dbeaver.ui.editors.text.BaseTextEditor;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public abstract class SQLEditorBase
extends BaseTextEditor
implements DBPContextProvider,
IErrorVisualizer {
    protected static final Log log = Log.getLog(SQLEditorBase.class);
    private static final long MAX_FILE_LENGTH_FOR_RULES = 2000000L;
    public static final String STATS_CATEGORY_SELECTION_STATE = "SelectionState";
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']', '<', '>'};
    private final Object LOCK_OBJECT = new Object();
    @NotNull
    private final SQLSyntaxManager syntaxManager;
    @NotNull
    private final SQLRuleManager ruleManager;
    private ProjectionSupport projectionSupport;
    private ProjectionAnnotationModel annotationModel;
    private boolean hasVerticalRuler = true;
    private SQLTemplatesPage templatesPage;
    private IPropertyChangeListener themeListener;
    private SQLEditorControl editorControl;
    private EditorSelectionChangedListener selectionChangedListener = new EditorSelectionChangedListener();
    private Annotation[] occurrenceAnnotations = null;
    private boolean markOccurrencesUnderCursor;
    private boolean markOccurrencesForSelection;
    private OccurrencesFinderJob occurrencesFinderJob;
    private OccurrencesFinderJobCanceler occurrencesFinderJobCanceler;
    private ICharacterPairMatcher characterPairMatcher;
    private SQLEditorCompletionContext completionContext;

    static {
        IPreferenceStore editorStore = EditorsUI.getPreferenceStore();
        editorStore.setDefault("SQLEditor.matchingBrackets", true);
    }

    public SQLEditorBase() {
        this.syntaxManager = new SQLSyntaxManager();
        this.ruleManager = new SQLRuleManager(this.syntaxManager);
        this.themeListener = new IPropertyChangeListener(){
            long lastUpdateTime = 0L;

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("CHANGE_CURRENT_THEME") || event.getProperty().startsWith("org.jkiss.dbeaver.sql.editor")) {
                    if (this.lastUpdateTime > 0L && System.currentTimeMillis() - this.lastUpdateTime < 500L) {
                        return;
                    }
                    this.lastUpdateTime = System.currentTimeMillis();
                    UIUtils.asyncExec(() -> {
                        ISourceViewer sourceViewer = SQLEditorBase.this.getSourceViewer();
                        if (sourceViewer != null) {
                            SQLEditorBase.this.reloadSyntaxRules();
                            sourceViewer.configure(SQLEditorBase.this.getSourceViewerConfiguration());
                        }
                    });
                }
            }
        };
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(this.themeListener);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new SQLEditorSourceViewerConfiguration(this, this.getPreferenceStore()));
        this.setKeyBindingScopes(this.getKeyBindingContexts());
        this.completionContext = new SQLEditorCompletionContext(this);
    }

    protected boolean isReadOnly() {
        IDocumentProvider provider = this.getDocumentProvider();
        return provider instanceof IDocumentProviderExtension && ((IDocumentProviderExtension)provider).isReadOnly((Object)this.getEditorInput());
    }

    public static boolean isBigScript(@Nullable IEditorInput editorInput) {
        File file;
        return editorInput != null && (file = EditorUtils.getLocalFileFromInput((Object)editorInput)) != null && file.length() > 2000000L;
    }

    static boolean isReadEmbeddedBinding() {
        return DBWorkbench.getPlatform().getPreferenceStore().getBoolean("SQLEditor.script.bind.embedded.read");
    }

    static boolean isWriteEmbeddedBinding() {
        return DBWorkbench.getPlatform().getPreferenceStore().getBoolean("SQLEditor.script.bind.embedded.write");
    }

    protected void handleInputChange(IEditorInput input) {
        if (SQLEditorBase.isBigScript(input)) {
            this.uninstallOccurrencesFinder();
        } else {
            this.setMarkingOccurrences(DBWorkbench.getPlatform().getPreferenceStore().getBoolean("SQLEditor.markOccurrences"), DBWorkbench.getPlatform().getPreferenceStore().getBoolean("SQLEditor.markOccurrences.forSelection"));
        }
    }

    protected void updateSelectionDependentActions() {
        super.updateSelectionDependentActions();
        this.updateStatusField(STATS_CATEGORY_SELECTION_STATE);
    }

    protected String[] getKeyBindingContexts() {
        return new String[]{"org.eclipse.ui.textEditorScope", "org.jkiss.dbeaver.ui.editors.sql", "org.jkiss.dbeaver.ui.editors.sql.script", "org.jkiss.dbeaver.ui.editors.sql.script.focused"};
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.markOccurrencesUnderCursor = DBWorkbench.getPlatform().getPreferenceStore().getBoolean("SQLEditor.markOccurrences");
        this.markOccurrencesForSelection = DBWorkbench.getPlatform().getPreferenceStore().getBoolean("SQLEditor.markOccurrences.forSelection");
        this.setEditorContextMenuId("#SQLEditorContext");
        this.setRulerContextMenuId("#SQLRulerContext");
    }

    public DBPDataSource getDataSource() {
        DBCExecutionContext context = this.getExecutionContext();
        return context == null ? null : context.getDataSource();
    }

    public DBPPreferenceStore getActivePreferenceStore() {
        DBPDataSourceContainer container;
        if (this instanceof IDataSourceContainerProvider && (container = ((IDataSourceContainerProvider)this).getDataSourceContainer()) != null) {
            return container.getPreferenceStore();
        }
        DBPDataSource dataSource = this.getDataSource();
        return dataSource == null ? DBWorkbench.getPlatform().getPreferenceStore() : dataSource.getContainer().getPreferenceStore();
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("SQLEditor.markOccurrences".equals(property) || "SQLEditor.markOccurrences.forSelection".equals(property)) {
            this.setMarkingOccurrences(DBWorkbench.getPlatform().getPreferenceStore().getBoolean("SQLEditor.markOccurrences"), DBWorkbench.getPlatform().getPreferenceStore().getBoolean("SQLEditor.markOccurrences.forSelection"));
        } else {
            super.handlePreferenceStoreChanged(event);
        }
    }

    @NotNull
    public SQLDialect getSQLDialect() {
        DBPDataSource dataSource = this.getDataSource();
        if (dataSource instanceof SQLDataSource) {
            return ((SQLDataSource)dataSource).getSQLDialect();
        }
        return BasicSQLDialect.INSTANCE;
    }

    @NotNull
    public SQLSyntaxManager getSyntaxManager() {
        return this.syntaxManager;
    }

    @NotNull
    public SQLRuleManager getRuleManager() {
        return this.ruleManager;
    }

    public ProjectionAnnotationModel getAnnotationModel() {
        return this.annotationModel;
    }

    public SQLEditorSourceViewerConfiguration getViewerConfiguration() {
        return (SQLEditorSourceViewerConfiguration)super.getSourceViewerConfiguration();
    }

    public void createPartControl(Composite parent) {
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.editorControl = new SQLEditorControl(parent, this);
        super.createPartControl((Composite)this.editorControl);
        this.selectionChangedListener = new EditorSelectionChangedListener();
        this.selectionChangedListener.install(this.getSelectionProvider());
        if (this.markOccurrencesUnderCursor || this.markOccurrencesForSelection) {
            this.installOccurrencesFinder();
        }
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.projectionSupport.install();
        viewer.doOperation(19);
        this.annotationModel = viewer.getProjectionAnnotationModel();
        SQLSymbolInserter symbolInserter = new SQLSymbolInserter(this);
        DBPPreferenceStore preferenceStore = this.getActivePreferenceStore();
        boolean closeSingleQuotes = preferenceStore.getBoolean("SQLEditor.closeSingleQuotes");
        boolean closeDoubleQuotes = preferenceStore.getBoolean("SQLEditor.closeDoubleQuotes");
        boolean closeBrackets = preferenceStore.getBoolean("SQLEditor.closeBrackets");
        symbolInserter.setCloseSingleQuotesEnabled(closeSingleQuotes);
        symbolInserter.setCloseDoubleQuotesEnabled(closeDoubleQuotes);
        symbolInserter.setCloseBracketsEnabled(closeBrackets);
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).prependVerifyKeyListener((VerifyKeyListener)symbolInserter);
        }
        EditorUtils.trackControlContext((IWorkbenchSite)this.getSite(), (Control)this.getViewer().getTextWidget(), (String)"org.jkiss.dbeaver.ui.editors.sql.script.focused");
    }

    public SQLEditorControl getEditorControlWrapper() {
        return this.editorControl;
    }

    public void updatePartControl(IEditorInput input) {
        super.updatePartControl(input);
    }

    protected IOverviewRuler createOverviewRuler(ISharedTextColors sharedColors) {
        if (this.isOverviewRulerVisible()) {
            return super.createOverviewRuler(sharedColors);
        }
        return new OverviewRuler(this.getAnnotationAccess(), 0, sharedColors);
    }

    protected boolean isOverviewRulerVisible() {
        return false;
    }

    protected IVerticalRulerColumn createAnnotationRulerColumn(CompositeRuler ruler) {
        if (this.isAnnotationRulerVisible()) {
            return super.createAnnotationRulerColumn(ruler);
        }
        return new AnnotationRulerColumn(0, this.getAnnotationAccess());
    }

    protected boolean isAnnotationRulerVisible() {
        return false;
    }

    protected IVerticalRuler createVerticalRuler() {
        return this.hasVerticalRuler ? super.createVerticalRuler() : new VerticalRuler(0);
    }

    public void setHasVerticalRuler(boolean hasVerticalRuler) {
        this.hasVerticalRuler = hasVerticalRuler;
    }

    protected ISharedTextColors getSharedColors() {
        return UIUtils.getSharedTextColors();
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        this.handleInputChange(input);
        super.doSetInput(input);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
        this.handleInputChange(this.getEditorInput());
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.getAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        SQLEditorSourceViewer sourceViewer = this.createSourceViewer(parent, ruler, styles, this.fOverviewRuler);
        this.getSourceViewerDecorationSupport((ISourceViewer)sourceViewer);
        return sourceViewer;
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        char[] matchChars = BRACKETS;
        try {
            this.characterPairMatcher = new SQLCharacterPairMatcher(this, matchChars, "___sql_partitioning", true);
        }
        catch (Throwable throwable) {
            this.characterPairMatcher = new SQLCharacterPairMatcher(this, matchChars, "___sql_partitioning");
        }
        support.setCharacterPairMatcher(this.characterPairMatcher);
        support.setMatchingCharacterPainterPreferenceKeys("SQLEditor.matchingBrackets", "AbstractTextEditor.Color.Foreground");
        super.configureSourceViewerDecorationSupport(support);
    }

    @NotNull
    protected SQLEditorSourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles, IOverviewRuler overviewRuler) {
        return new SQLEditorSourceViewer(parent, ruler, overviewRuler, true, styles);
    }

    protected IAnnotationAccess createAnnotationAccess() {
        return new SQLMarkerAnnotationAccess();
    }

    public <T> T getAdapter(Class<T> required) {
        Object adapter;
        if (this.projectionSupport != null && (adapter = this.projectionSupport.getAdapter(this.getSourceViewer(), required)) != null) {
            return (T)adapter;
        }
        if (ITemplatesPage.class.equals(required)) {
            return (T)((Object)this.getTemplatesPage());
        }
        return (T)super.getAdapter(required);
    }

    public SQLTemplatesPage getTemplatesPage() {
        if (this.templatesPage == null) {
            this.templatesPage = new SQLTemplatesPage(this);
        }
        return this.templatesPage;
    }

    public void dispose() {
        if (this.selectionChangedListener != null) {
            this.selectionChangedListener.uninstall(this.getSelectionProvider());
            this.selectionChangedListener = null;
        }
        if (this.themeListener != null) {
            PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(this.themeListener);
            this.themeListener = null;
        }
        super.dispose();
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle bundle = ResourceBundle.getBundle("org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages");
        TextOperationAction a = new TextOperationAction(bundle, SQLEditorContributor.getActionResourcePrefix("ContentAssistProposal"), (ITextEditor)this, 13);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)a);
        a = new TextOperationAction(bundle, SQLEditorContributor.getActionResourcePrefix("ContentAssistTip"), (ITextEditor)this, 14);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistTip", (IAction)a);
        a = new TextOperationAction(bundle, SQLEditorContributor.getActionResourcePrefix("ContentAssistInfo"), (ITextEditor)this, 16);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.showInformation");
        this.setAction("ContentAssistInfo", (IAction)a);
        a = new TextOperationAction(bundle, SQLEditorContributor.getActionResourcePrefix("ContentFormatProposal"), (ITextEditor)this, 15);
        a.setActionDefinitionId("org.jkiss.dbeaver.ui.editors.text.content.format");
        this.setAction("ContentFormatProposal", (IAction)a);
        this.setAction("Preferences.ContextAction", (IAction)new ShowPreferencesAction());
    }

    protected boolean isEditorInputIncludedInContextMenu() {
        return false;
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new GroupMarker("sql.additions"));
        super.editorContextMenuAboutToShow(menu);
        this.addAction(menu, "sql.extras", "ContentAssistProposal");
        this.addAction(menu, "sql.extras", "ContentAssistTip");
        this.addAction(menu, "sql.extras", "ContentAssistInfo");
        menu.insertBefore("group.copy", (IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.navigate.object"));
        if (!this.isReadOnly() && this.getTextViewer().isEditable()) {
            MenuManager formatMenu = new MenuManager(SQLEditorMessages.sql_editor_menu_format, "format");
            IAction formatAction = this.getAction("ContentFormatProposal");
            if (formatAction != null) {
                formatMenu.add(formatAction);
            }
            formatMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.morph.delimited.list"));
            formatMenu.add(this.getAction("UpperCase"));
            formatMenu.add(this.getAction("LowerCase"));
            formatMenu.add((IContributionItem)new Separator());
            formatMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.word.wrap"));
            formatMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.comment.single"));
            formatMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.comment.multi"));
            menu.insertAfter("sql.additions", (IContributionItem)formatMenu);
        }
    }

    public void reloadSyntaxRules() {
        SQLDialect dialect = this.getSQLDialect();
        this.syntaxManager.init(dialect, this.getActivePreferenceStore());
        this.ruleManager.refreshRules(this.getDataSource(), this.getEditorInput());
        IDocument document = this.getDocument();
        if (document instanceof IDocumentExtension3) {
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new SQLPartitionScanner(this.getDataSource(), dialect), SQLParserPartitions.SQL_CONTENT_TYPES);
            partitioner.connect(document);
            try {
                ((IDocumentExtension3)document).setDocumentPartitioner("___sql_partitioning", (IDocumentPartitioner)partitioner);
            }
            catch (Throwable e) {
                log.warn((Object)"Error setting SQL partitioner", e);
            }
            ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
            if (projectionViewer != null && projectionViewer.getAnnotationModel() != null && document.getLength() > 0) {
                try {
                    projectionViewer.reinitializeProjection();
                }
                catch (Throwable ex) {
                    log.warn((Object)"Can't initialize SQL syntax projection", ex);
                }
            }
        }
        IVerticalRuler verticalRuler = this.getVerticalRuler();
        if (this.getSourceViewerConfiguration() instanceof SQLEditorSourceViewerConfiguration) {
            ((SQLEditorSourceViewerConfiguration)this.getSourceViewerConfiguration()).onDataSourceChange();
        }
        if (verticalRuler != null) {
            verticalRuler.update();
        }
    }

    public boolean hasActiveQuery() {
        IDocument document = this.getDocument();
        if (document == null) {
            return false;
        }
        ISelectionProvider selectionProvider = this.getSelectionProvider();
        if (selectionProvider == null) {
            return false;
        }
        ITextSelection selection = (ITextSelection)selectionProvider.getSelection();
        String selText = selection.getText();
        if (CommonUtils.isEmpty((String)selText) && selection.getOffset() >= 0 && selection.getOffset() < document.getLength()) {
            try {
                IRegion lineRegion = document.getLineInformationOfOffset(selection.getOffset());
                selText = document.get(lineRegion.getOffset(), lineRegion.getLength());
            }
            catch (BadLocationException e) {
                log.warn((Object)e);
                return false;
            }
        }
        return !CommonUtils.isEmptyTrimmed((String)selText);
    }

    @Nullable
    public SQLScriptElement extractActiveQuery() {
        SQLScriptElement element;
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        String selText = selection.getText();
        if (this.getActivePreferenceStore().getBoolean("script.sql.query.remove.trailing.delimiter")) {
            selText = SQLUtils.trimQueryStatement((SQLSyntaxManager)this.getSyntaxManager(), (String)selText, (!this.syntaxManager.getDialect().isDelimiterAfterQuery() ? 1 : 0) != 0);
        }
        if (!CommonUtils.isEmpty((String)selText)) {
            SQLScriptElement parsedElement = this.parseQuery(this.getDocument(), selection.getOffset(), selection.getOffset() + selection.getLength(), selection.getOffset(), false, false);
            if (parsedElement instanceof SQLControlCommand) {
                element = parsedElement;
            } else {
                selText = SQLUtils.fixLineFeeds((String)selText);
                element = new SQLQuery(this.getDataSource(), selText, selection.getOffset(), selection.getLength());
            }
        } else {
            element = selection.getOffset() >= 0 ? this.extractQueryAtPos(selection.getOffset()) : null;
        }
        if (element == null || CommonUtils.isEmpty((String)element.getText())) {
            return null;
        }
        if (element instanceof SQLQuery && this.getActivePreferenceStore().getBoolean("sql.parameter.enabled")) {
            ((SQLQuery)element).setParameters(this.parseParameters(this.getDocument(), (SQLQuery)element));
        }
        return element;
    }

    public SQLScriptElement extractQueryAtPos(int currentPos) {
        int currentLine;
        int lastPos;
        String[] statementDelimiters;
        boolean useBlankLines;
        int startPos;
        IDocumentPartitioner partitioner;
        int docLength;
        IDocument document;
        block15: {
            block16: {
                document = this.getDocument();
                if (document == null || document.getLength() == 0) {
                    return null;
                }
                docLength = document.getLength();
                IDocumentPartitioner iDocumentPartitioner = partitioner = document instanceof IDocumentExtension3 ? ((IDocumentExtension3)document).getDocumentPartitioner("___sql_partitioning") : null;
                if (partitioner != null) {
                    while (currentPos < docLength && SQLEditorBase.isMultiCommentPartition(partitioner, currentPos)) {
                        ++currentPos;
                    }
                }
                startPos = 0;
                useBlankLines = this.syntaxManager.isBlankLineDelimiter();
                statementDelimiters = this.syntaxManager.getStatementDelimiters();
                lastPos = currentPos >= docLength ? docLength - 1 : currentPos;
                currentLine = document.getLineOfOffset(currentPos);
                if (!useBlankLines || !TextUtils.isEmptyLine((IDocument)document, (int)currentLine)) break block15;
                if (currentLine != 0) break block16;
                return null;
            }
            if (!TextUtils.isEmptyLine((IDocument)document, (int)(--currentLine))) break block15;
            return null;
        }
        try {
            int lineOffset = document.getLineOffset(currentLine);
            int firstLine = currentLine;
            while (firstLine > 0) {
                if (useBlankLines && TextUtils.isEmptyLine((IDocument)document, (int)firstLine) && SQLEditorBase.isDefaultPartition(partitioner, document.getLineOffset(firstLine))) break;
                if (currentLine == firstLine) {
                    String[] stringArray = statementDelimiters;
                    int n = statementDelimiters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int delimOffset;
                        int offset;
                        String delim = stringArray[n2];
                        if (!Character.isLetterOrDigit(delim.charAt(0)) && (offset = TextUtils.getOffsetOf((IDocument)document, (int)firstLine, (String)delim)) >= 0 && SQLEditorBase.isDefaultPartition(partitioner, delimOffset = document.getLineOffset(firstLine) + offset + delim.length()) && currentPos > startPos && docLength > delimOffset) {
                            boolean hasValuableChars = false;
                            int i = delimOffset;
                            while (i <= lastPos) {
                                if (!Character.isWhitespace(document.getChar(i))) {
                                    hasValuableChars = true;
                                    break;
                                }
                                ++i;
                            }
                            if (hasValuableChars) {
                                startPos = delimOffset;
                                break;
                            }
                        }
                        ++n2;
                    }
                }
                --firstLine;
            }
            if (startPos == 0) {
                startPos = document.getLineOffset(firstLine);
            }
            currentPos = lineOffset;
        }
        catch (BadLocationException e) {
            log.warn((Object)e);
        }
        return this.parseQuery(document, startPos, document.getLength(), currentPos, false, false);
    }

    public SQLScriptElement extractNextQuery(boolean next) {
        int curPos;
        block16: {
            ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
            int offset = selection.getOffset();
            SQLScriptElement curElement = this.extractQueryAtPos(offset);
            if (curElement == null) {
                return null;
            }
            IDocument document = this.getDocument();
            if (document == null) {
                return null;
            }
            try {
                int docLength = document.getLength();
                if (next) {
                    String[] statementDelimiters = this.syntaxManager.getStatementDelimiters();
                    curPos = curElement.getOffset() + curElement.getLength();
                    while (curPos < docLength) {
                        char c = document.getChar(curPos);
                        if (!Character.isWhitespace(c)) {
                            boolean isDelimiter = false;
                            String[] stringArray = statementDelimiters;
                            int n = statementDelimiters.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String delim = stringArray[n2];
                                if (delim.indexOf(c) != -1) {
                                    isDelimiter = true;
                                }
                                ++n2;
                            }
                            if (!isDelimiter) break;
                        }
                        ++curPos;
                    }
                } else {
                    curPos = curElement.getOffset() - 1;
                    while (curPos >= 0) {
                        char c = document.getChar(curPos);
                        if (Character.isWhitespace(c)) {
                            --curPos;
                            continue;
                        }
                        break;
                    }
                }
                if (curPos > 0 && curPos < docLength) break block16;
                return null;
            }
            catch (BadLocationException e) {
                log.warn((Object)e);
                return null;
            }
        }
        return this.extractQueryAtPos(curPos);
    }

    private static boolean isDefaultPartition(IDocumentPartitioner partitioner, int currentPos) {
        return partitioner == null || "__dftl_partition_content_type".equals(partitioner.getContentType(currentPos));
    }

    private static boolean isMultiCommentPartition(IDocumentPartitioner partitioner, int currentPos) {
        return partitioner != null && "sql_multiline_comment".equals(partitioner.getContentType(currentPos));
    }

    private void startScriptEvaluation() {
        this.ruleManager.startEval();
    }

    private void endScriptEvaluation() {
        this.ruleManager.endEval();
    }

    public List<SQLScriptElement> extractScriptQueries(int startOffset, int length, boolean scriptMode, boolean keepDelimiters, boolean parseParameters) {
        ArrayList<SQLScriptElement> queryList = new ArrayList<SQLScriptElement>();
        IDocument document = this.getDocument();
        if (document == null) {
            return queryList;
        }
        this.startScriptEvaluation();
        try {
            SQLScriptElement query;
            int queryOffset = startOffset;
            while ((query = this.parseQuery(document, queryOffset, startOffset + length, queryOffset, scriptMode, keepDelimiters)) != null) {
                queryList.add(query);
                queryOffset = query.getOffset() + query.getLength();
            }
        }
        finally {
            this.endScriptEvaluation();
        }
        if (parseParameters && this.getActivePreferenceStore().getBoolean("sql.parameter.enabled")) {
            for (SQLScriptElement query : queryList) {
                if (!(query instanceof SQLQuery)) continue;
                ((SQLQuery)query).setParameters(this.parseParameters(this.getDocument(), (SQLQuery)query));
            }
        }
        return queryList;
    }

    public SQLCompletionContext getCompletionContext() {
        return this.completionContext;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SQLScriptElement parseQuery(IDocument document, int startPos, int endPos, int currentPos, boolean scriptMode, boolean keepDelimiters) {
        length = endPos - startPos;
        if (length <= 0) return null;
        if (length > document.getLength()) {
            return null;
        }
        dialect = this.getSQLDialect();
        useBlankLines = scriptMode == false && this.syntaxManager.isBlankLineDelimiter() != false;
        this.ruleManager.setRange(document, startPos, endPos - startPos);
        statementStart = startPos;
        hasValuableTokens = false;
        curBlock = null;
        hasBlocks = false;
        blockTogglePattern = null;
        lastTokenLineFeeds = 0;
        prevNotEmptyTokenType = 1000;
        lastKeyword = null;
        while (true) {
            token = this.ruleManager.nextToken();
            tokenOffset = this.ruleManager.getTokenOffset();
            tokenLength = this.ruleManager.getTokenLength();
            v0 = tokenType = token instanceof SQLToken != false ? ((SQLToken)token).getType() : 1000;
            if (tokenOffset < startPos) {
                return null;
            }
            isDelimiter = tokenType == 1007;
            isControl = false;
            delimiterText = null;
            try {
                block72: {
                    block71: {
                        block70: {
                            if (isDelimiter) {
                                try {
                                    delimiterText = document.get(tokenOffset, tokenLength);
                                }
                                catch (BadLocationException e) {
                                    SQLEditorBase.log.debug((Object)e);
                                }
                            } else if (useBlankLines && token.isWhitespace() && tokenLength >= 1 && lastTokenLineFeeds + SQLEditorBase.countLineFeeds(document, tokenOffset, tokenLength) >= 2) {
                                isDelimiter = true;
                            }
                            lastTokenLineFeeds = 0;
                            if (tokenLength == 1) {
                                try {
                                    aChar = document.getChar(tokenOffset);
                                    if (aChar == '(' || aChar == '{' || aChar == '[') {
                                        curBlock = new ScriptBlockInfo(curBlock, false);
                                        break block70;
                                    }
                                    if ((aChar == ')' || aChar == '}' || aChar == ']') && curBlock != null) {
                                        curBlock = curBlock.parent;
                                    }
                                }
                                catch (BadLocationException e) {
                                    SQLEditorBase.log.warn((Object)e);
                                }
                            }
                        }
                        if (tokenType == 1001 && prevNotEmptyTokenType == 1002) {
                            tokenType = 1000;
                        }
                        if (tokenType == 1004) {
                            curBlock = new ScriptBlockInfo(curBlock, true);
                            hasBlocks = true;
                        } else if (tokenType == 1003) {
                            try {
                                togglePattern = document.get(tokenOffset, tokenLength);
                            }
                            catch (BadLocationException e) {
                                SQLEditorBase.log.warn((Object)e);
                                togglePattern = "";
                            }
                            if (curBlock != null && curBlock.parent == null && togglePattern.equals(blockTogglePattern)) {
                                curBlock = curBlock.parent;
                                blockTogglePattern = null;
                            } else if (curBlock == null && blockTogglePattern == null) {
                                curBlock = new ScriptBlockInfo(curBlock, false);
                                blockTogglePattern = togglePattern;
                            } else {
                                SQLEditorBase.log.debug((Object)"Block toggle token inside another block. Can't process it");
                            }
                            hasBlocks = true;
                        } else if (tokenType == 1001) {
                            if (curBlock == null || !curBlock.isHeader) {
                                curBlock = new ScriptBlockInfo(curBlock, false);
                            } else if (curBlock != null) {
                                curBlock.isHeader = false;
                            }
                            hasBlocks = true;
                        } else if (curBlock != null && tokenType == 1002) {
                            if (curBlock != null) {
                                curBlock = curBlock.parent;
                            }
                        } else {
                            if (isDelimiter && curBlock != null) continue;
                            if (tokenType == 1008 || tokenType == 1006) {
                                isDelimiter = true;
                                isControl = true;
                            } else if (tokenType == 1005) {
                                v1 = lastTokenLineFeeds = tokenLength < 2 ? 0 : SQLEditorBase.countLineFeeds(document, tokenOffset + tokenLength - 2, 2);
                            }
                        }
                        if (tokenLength > 0 && !token.isWhitespace()) {
                            switch (tokenType) {
                                case 1000: 
                                case 1001: 
                                case 1002: 
                                case 1003: 
                                case 1004: {
                                    try {
                                        lastKeyword = document.get(tokenOffset, tokenLength);
                                    }
                                    catch (BadLocationException e) {
                                        SQLEditorBase.log.error((Object)"Error getting first keyword", (Throwable)e);
                                    }
                                    break;
                                }
                            }
                        }
                        v2 = cursorInsideToken = currentPos >= tokenOffset && currentPos < tokenOffset + tokenLength;
                        if (isControl && (scriptMode || cursorInsideToken) && !hasValuableTokens) {
                            try {
                                controlText = document.get(tokenOffset, tokenLength);
                                commandId = null;
                                if (token instanceof SQLControlToken) {
                                    commandId = ((SQLControlToken)token).getCommandId();
                                }
                                if ((command = new SQLControlCommand(this.getDataSource(), this.syntaxManager, controlText.trim(), commandId, tokenOffset, tokenLength, tokenType == 1008)).isEmptyCommand() || command.getCommandId() != null && SQLCommandsRegistry.getInstance().getCommandHandler(command.getCommandId()) != null) {
                                    var30_38 = command;
                                    return var30_38;
                                }
                            }
                            catch (BadLocationException e) {
                                SQLEditorBase.log.warn((Object)"Can't extract control statement", (Throwable)e);
                                if (token.isWhitespace() != false) return null;
                                if (token.isEOF() != false) return null;
                                prevNotEmptyTokenType = tokenType;
                                return null;
                            }
                            {
                                isControl = false;
                            }
                        }
                        if (!hasValuableTokens || !token.isEOF() && (!isDelimiter || tokenOffset < currentPos) && tokenOffset <= endPos) break block72;
                        if (tokenOffset > endPos) {
                            tokenOffset = endPos;
                        }
                        if (tokenOffset >= document.getLength()) {
                            tokenOffset = document.getLength();
                        }
                        if (SQLEditorBase.$assertionsDisabled || tokenOffset >= currentPos) ** GOTO lbl-1000
                        throw new AssertionError();
lbl-1000:
                        // 1 sources

                        {
                            while (true) {
                                if (statementStart >= tokenOffset || !Character.isWhitespace(document.getChar(statementStart))) {
                                    if (tokenOffset == statementStart) {
                                        if (!token.isEOF()) break;
                                        return null;
                                    }
                                    break block71;
                                }
                                ++statementStart;
                            }
                        }
                        statementStart = tokenOffset + tokenLength;
                        continue;
                    }
                    queryText = document.get(statementStart, tokenOffset - statementStart);
                    queryText = SQLUtils.fixLineFeeds((String)queryText);
                    if (isDelimiter && (keepDelimiters || hasBlocks && dialect.isDelimiterAfterQuery() || dialect.isDelimiterAfterBlock() && "END".equals(lastKeyword)) && delimiterText != null && delimiterText.equals(";")) {
                        queryText = String.valueOf(queryText) + delimiterText;
                    }
                    queryEndPos = tokenOffset;
                    if (tokenType == 1007) {
                        queryEndPos += tokenLength;
                    }
                    var30_39 = new SQLQuery(this.getDataSource(), queryText, statementStart, queryEndPos - statementStart);
                    return var30_39;
                }
                if (isDelimiter) {
                    statementStart = tokenOffset + tokenLength;
                }
                if (token.isEOF()) {
                    return null;
                }
                if (hasValuableTokens || token.isWhitespace() || isControl) continue;
                if (tokenType == 1005) {
                    hasValuableTokens = dialect.supportsCommentQuery();
                    continue;
                }
                hasValuableTokens = true;
                continue;
            }
            finally {
                if (token.isWhitespace() || token.isEOF()) continue;
                prevNotEmptyTokenType = tokenType;
                continue;
            }
            break;
        }
    }

    private static int countLineFeeds(IDocument document, int offset, int length) {
        int lfCount = 0;
        try {
            int i = offset;
            while (i < offset + length) {
                if (document.getChar(i) == '\n') {
                    ++lfCount;
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            log.error((Object)e);
        }
        return lfCount;
    }

    protected List<SQLQueryParameter> parseParameters(IDocument document, int queryOffset, int queryLength) {
        SQLDialect sqlDialect = this.getSQLDialect();
        boolean supportParamsInDDL = this.getActivePreferenceStore().getBoolean("sql.parameter.ddl.enabled");
        boolean execQuery = false;
        boolean ddlQuery = false;
        ArrayList<Object> parameters = null;
        this.ruleManager.setRange(document, queryOffset, queryLength);
        boolean firstKeyword = true;
        while (true) {
            IToken token = this.ruleManager.nextToken();
            int tokenOffset = this.ruleManager.getTokenOffset();
            int tokenLength = this.ruleManager.getTokenLength();
            if (token.isEOF() || tokenOffset > queryOffset + queryLength) break;
            int tokenType = 1000;
            if (token instanceof SQLToken) {
                tokenType = ((SQLToken)token).getType();
            }
            if (token.isWhitespace() || tokenType == 1005) continue;
            if (!supportParamsInDDL && firstKeyword) {
                try {
                    String tokenText = document.get(tokenOffset, tokenLength);
                    if (ArrayUtils.containsIgnoreCase((String[])sqlDialect.getDDLKeywords(), (String)tokenText)) {
                        ddlQuery = true;
                    } else {
                        execQuery = ArrayUtils.containsIgnoreCase((String[])sqlDialect.getExecuteKeywords(), (String)tokenText);
                    }
                }
                catch (BadLocationException e) {
                    log.warn((Object)e);
                }
                firstKeyword = false;
            }
            if (tokenType != 1009 || tokenLength <= 0) continue;
            try {
                String paramName = document.get(tokenOffset, tokenLength);
                if (ddlQuery || execQuery && paramName.equals(String.valueOf(this.syntaxManager.getAnonymousParameterMark()))) continue;
                if (parameters == null) {
                    parameters = new ArrayList<SQLQueryParameter>();
                }
                SQLQueryParameter parameter = new SQLQueryParameter(this.syntaxManager, parameters.size(), paramName, tokenOffset - queryOffset, tokenLength);
                parameter.setPrevious(SQLEditorBase.getPreviousParameter(parameters, parameter));
                parameters.add(parameter);
            }
            catch (BadLocationException e) {
                log.warn((Object)"Can't extract query parameter", (Throwable)e);
            }
        }
        if (this.syntaxManager.isVariablesEnabled()) {
            try {
                String query = document.get(queryOffset, queryLength);
                Matcher matcher = SQLQueryParameter.getVariablePattern().matcher(query);
                int position = 0;
                while (matcher.find(position)) {
                    int start = matcher.start();
                    int orderPos = 0;
                    SQLQueryParameter param = null;
                    if (parameters != null) {
                        for (SQLQueryParameter sQLQueryParameter : parameters) {
                            if (sQLQueryParameter.getTokenOffset() == start) {
                                param = sQLQueryParameter;
                                break;
                            }
                            if (sQLQueryParameter.getTokenOffset() >= start) continue;
                            ++orderPos;
                        }
                    }
                    if (param == null) {
                        param = new SQLQueryParameter(this.syntaxManager, orderPos, matcher.group(0), start, matcher.end() - matcher.start());
                        if (parameters == null) {
                            parameters = new ArrayList();
                        }
                        param.setPrevious(SQLEditorBase.getPreviousParameter(parameters, param));
                        parameters.add(param.getOrdinalPosition(), param);
                    }
                    position = matcher.end();
                }
            }
            catch (BadLocationException e) {
                log.warn((Object)"Error parsing variables", (Throwable)e);
            }
        }
        return parameters;
    }

    private static SQLQueryParameter getPreviousParameter(List<SQLQueryParameter> parameters, SQLQueryParameter parameter) {
        String varName = parameter.getVarName();
        if (parameter.isNamed()) {
            int i = parameters.size();
            while (i > 0) {
                if (parameters.get(i - 1).getVarName().equals(varName)) {
                    return parameters.get(i - 1);
                }
                --i;
            }
        }
        return null;
    }

    protected List<SQLQueryParameter> parseParameters(IDocument document, SQLQuery query) {
        return this.parseParameters(document, query.getOffset(), query.getLength());
    }

    protected List<SQLQueryParameter> parseParameters(String query) {
        return this.parseParameters((IDocument)new Document(query), 0, query.length());
    }

    public boolean isDisposed() {
        return this.getSourceViewer() == null || this.getSourceViewer().getTextWidget() == null || this.getSourceViewer().getTextWidget().isDisposed();
    }

    @Nullable
    public ICommentsSupport getCommentsSupport() {
        final SQLDialect dialect = this.getSQLDialect();
        return new ICommentsSupport(){

            @Nullable
            public Pair<String, String> getMultiLineComments() {
                return dialect.getMultiLineComments();
            }

            public String[] getSingleLineComments() {
                return dialect.getSingleLineComments();
            }
        };
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] ids = super.collectContextMenuPreferencePages();
        String[] more = new String[ids.length + 6];
        more[ids.length] = "org.jkiss.dbeaver.preferences.main.sqleditor";
        more[ids.length + 1] = "org.jkiss.dbeaver.preferences.main.sqlexecute";
        more[ids.length + 2] = "org.jkiss.dbeaver.preferences.main.sql.completion";
        more[ids.length + 3] = "org.jkiss.dbeaver.preferences.main.sql.format";
        more[ids.length + 4] = "org.jkiss.dbeaver.preferences.main.sql.resources";
        more[ids.length + 5] = "org.jkiss.dbeaver.preferences.main.sql.templates";
        System.arraycopy(ids, 0, more, 0, ids.length);
        return more;
    }

    public boolean visualizeError(@NotNull DBRProgressMonitor monitor, @NotNull Throwable error) {
        IDocument document = this.getDocument();
        SQLQuery query = new SQLQuery(this.getDataSource(), document.get(), 0, document.getLength());
        return this.scrollCursorToError(monitor, query, error);
    }

    protected boolean scrollCursorToError(@NotNull DBRProgressMonitor monitor, @NotNull SQLQuery query, @NotNull Throwable error) {
        DBPErrorAssistant.ErrorPosition[] positions;
        DBCExecutionContext context;
        block13: {
            try {
                context = this.getExecutionContext();
                if (context != null) break block13;
                return false;
            }
            catch (Exception e) {
                log.warn((Object)"Error positioning on query error", (Throwable)e);
                return false;
            }
        }
        boolean scrolled = false;
        DBPErrorAssistant errorAssistant = (DBPErrorAssistant)DBUtils.getAdapter(DBPErrorAssistant.class, (Object)context.getDataSource());
        if (errorAssistant != null && (positions = errorAssistant.getErrorPosition(monitor, context, query.getText(), error)) != null && positions.length > 0) {
            int queryStartOffset = query.getOffset();
            int queryLength = query.getLength();
            DBPErrorAssistant.ErrorPosition pos = positions[0];
            if (pos.line < 0) {
                if (pos.position >= 0) {
                    this.getSelectionProvider().setSelection((ISelection)new TextSelection(queryStartOffset + pos.position, 0));
                    scrolled = true;
                }
            } else {
                IDocument document = this.getDocument();
                if (document != null) {
                    int errorLength;
                    int startLine = document.getLineOfOffset(queryStartOffset);
                    int errorOffset = document.getLineOffset(startLine + pos.line);
                    if (pos.position >= 0) {
                        errorOffset += pos.position;
                        errorLength = 1;
                    } else {
                        errorLength = document.getLineLength(startLine + pos.line);
                    }
                    if (errorOffset < queryStartOffset) {
                        errorOffset = queryStartOffset;
                    }
                    if (errorLength > queryLength) {
                        errorLength = queryLength;
                    }
                    if (errorOffset >= queryStartOffset + queryLength) {
                        errorOffset = queryStartOffset + queryLength - 1;
                    }
                    this.getSelectionProvider().setSelection((ISelection)new TextSelection(errorOffset, errorLength));
                    scrolled = true;
                }
            }
        }
        return scrolled;
    }

    public boolean isFoldingEnabled() {
        return this.getActivePreferenceStore().getBoolean("SQLEditor.Folding.enabled");
    }

    protected void updateStatusField(String category) {
        if (STATS_CATEGORY_SELECTION_STATE.equals(category)) {
            IStatusField field = this.getStatusField(category);
            if (field != null) {
                StringBuilder txt = new StringBuilder("Sel: ");
                ISelection selection = this.getSelectionProvider().getSelection();
                if (selection instanceof ITextSelection) {
                    ITextSelection textSelection = (ITextSelection)selection;
                    txt.append(textSelection.getLength()).append(" | ");
                    if (((ITextSelection)selection).getLength() <= 0) {
                        txt.append(0);
                    } else {
                        txt.append(textSelection.getEndLine() - textSelection.getStartLine() + 1);
                    }
                }
                field.setText(txt.toString());
            }
        } else {
            super.updateStatusField(category);
        }
    }

    protected void updateOccurrenceAnnotations(ITextSelection selection) {
        IDocument document;
        if (this.occurrencesFinderJob != null) {
            this.occurrencesFinderJob.cancel();
        }
        if ((this.markOccurrencesUnderCursor || this.markOccurrencesForSelection) && selection != null && (document = this.getSourceViewer().getDocument()) != null) {
            SQLWordDetector wordDetector = new SQLWordDetector();
            int startPos = selection.getOffset();
            int endPos = startPos + selection.getLength();
            try {
                int documentLength = document.getLength();
                while (startPos > 0 && wordDetector.isWordPart(document.getChar(startPos - 1))) {
                    --startPos;
                }
                while (endPos < documentLength && wordDetector.isWordPart(document.getChar(endPos))) {
                    ++endPos;
                }
            }
            catch (BadLocationException e) {
                log.debug((Object)("Error detecting current word: " + e.getMessage()));
            }
            String wordSelected = null;
            String wordUnderCursor = null;
            if (this.markOccurrencesUnderCursor) {
                try {
                    wordUnderCursor = document.get(startPos, endPos - startPos).trim();
                }
                catch (BadLocationException e) {
                    log.debug((Object)"Error detecting word under cursor", (Throwable)e);
                }
            }
            if (this.markOccurrencesForSelection) {
                wordSelected = selection.getText();
                int i = 0;
                while (i < wordSelected.length()) {
                    if (!wordDetector.isWordPart(wordSelected.charAt(i))) {
                        wordSelected = null;
                        break;
                    }
                    ++i;
                }
            }
            if (CommonUtils.isEmpty(wordSelected) || wordSelected.length() < 2) {
                this.removeOccurrenceAnnotations();
            } else {
                OccurrencesFinder finder = new OccurrencesFinder(document, wordUnderCursor, wordSelected);
                List<OccurrencePosition> positions = finder.perform();
                if (!CommonUtils.isEmpty(positions)) {
                    this.occurrencesFinderJob = new OccurrencesFinderJob(positions);
                    this.occurrencesFinderJob.run((IProgressMonitor)new NullProgressMonitor());
                } else {
                    this.removeOccurrenceAnnotations();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOccurrenceAnnotations() {
        IAnnotationModel annotationModel;
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider != null && (annotationModel = documentProvider.getAnnotationModel((Object)this.getEditorInput())) != null && this.occurrenceAnnotations != null) {
            Object object = this.LOCK_OBJECT;
            synchronized (object) {
                this.updateAnnotationModelForRemoves(annotationModel);
            }
        }
    }

    private void updateAnnotationModelForRemoves(IAnnotationModel annotationModel) {
        if (annotationModel instanceof IAnnotationModelExtension) {
            ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.occurrenceAnnotations, null);
        } else {
            int i = 0;
            int length = this.occurrenceAnnotations.length;
            while (i < length) {
                annotationModel.removeAnnotation(this.occurrenceAnnotations[i]);
                ++i;
            }
        }
        this.occurrenceAnnotations = null;
    }

    protected void installOccurrencesFinder() {
        ISelection selection;
        if (this.getSelectionProvider() != null && (selection = this.getSelectionProvider().getSelection()) instanceof ITextSelection) {
            this.updateOccurrenceAnnotations((ITextSelection)selection);
        }
        if (this.occurrencesFinderJobCanceler == null) {
            this.occurrencesFinderJobCanceler = new OccurrencesFinderJobCanceler();
            this.occurrencesFinderJobCanceler.install();
        }
    }

    protected void uninstallOccurrencesFinder() {
        this.markOccurrencesUnderCursor = false;
        this.markOccurrencesForSelection = false;
        if (this.occurrencesFinderJob != null) {
            this.occurrencesFinderJob.cancel();
            this.occurrencesFinderJob = null;
        }
        if (this.occurrencesFinderJobCanceler != null) {
            this.occurrencesFinderJobCanceler.uninstall();
            this.occurrencesFinderJobCanceler = null;
        }
        this.removeOccurrenceAnnotations();
    }

    public boolean isMarkingOccurrences() {
        return this.markOccurrencesUnderCursor;
    }

    public void setMarkingOccurrences(boolean markUnderCursor, boolean markSelection) {
        if (markUnderCursor != this.markOccurrencesUnderCursor || markSelection != this.markOccurrencesForSelection) {
            this.markOccurrencesUnderCursor = markUnderCursor;
            this.markOccurrencesForSelection = markSelection;
            if (this.markOccurrencesUnderCursor || this.markOccurrencesForSelection) {
                this.installOccurrencesFinder();
            } else {
                this.uninstallOccurrencesFinder();
            }
        }
    }

    public void gotoMatchingBracket() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        IRegion selection = SQLEditorBase.getSignedSelection(sourceViewer);
        IRegion region = this.characterPairMatcher.match(document, selection.getOffset());
        if (region == null) {
            return;
        }
        int offset = region.getOffset();
        int length = region.getLength();
        if (length < 1) {
            return;
        }
        int anchor = this.characterPairMatcher.getAnchor();
        int targetOffset = anchor == 0 ? offset + 1 : offset + length - 1;
        boolean visible = false;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            visible = extension.modelOffset2WidgetOffset(targetOffset) > -1;
        } else {
            IRegion visibleRegion = sourceViewer.getVisibleRegion();
            boolean bl = visible = targetOffset >= visibleRegion.getOffset() && targetOffset <= visibleRegion.getOffset() + visibleRegion.getLength();
        }
        if (!visible) {
            return;
        }
        int adjustment = SQLEditorBase.getOffsetAdjustment(document, selection.getOffset() + selection.getLength(), selection.getLength());
        int direction = Integer.compare(selection.getLength(), 0);
        sourceViewer.setSelectedRange(targetOffset += adjustment, direction);
        sourceViewer.revealRange(targetOffset, direction);
    }

    private static IRegion getSignedSelection(ISourceViewer sourceViewer) {
        Point viewerSelection = sourceViewer.getSelectedRange();
        StyledText text = sourceViewer.getTextWidget();
        Point selection = text.getSelectionRange();
        if (text.getCaretOffset() == selection.x) {
            viewerSelection.x += viewerSelection.y;
            viewerSelection.y = -viewerSelection.y;
        }
        return new Region(viewerSelection.x, viewerSelection.y);
    }

    private static int getOffsetAdjustment(IDocument document, int offset, int length) {
        block7: {
            block6: {
                if (length == 0 || Math.abs(length) > 1) {
                    return 0;
                }
                try {
                    if (length >= 0) break block6;
                    if (SQLEditorBase.isOpeningBracket(document.getChar(offset))) {
                        return 1;
                    }
                    break block7;
                }
                catch (BadLocationException badLocationException) {}
            }
            if (SQLEditorBase.isClosingBracket(document.getChar(offset - 1))) {
                return -1;
            }
        }
        return 0;
    }

    private static boolean isOpeningBracket(char character) {
        int i = 0;
        while (i < BRACKETS.length) {
            if (character == BRACKETS[i]) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    private static boolean isClosingBracket(char character) {
        int i = 1;
        while (i < BRACKETS.length) {
            if (character == BRACKETS[i]) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    private class EditorSelectionChangedListener
    implements ISelectionChangedListener {
        private EditorSelectionChangedListener() {
        }

        public void install(ISelectionProvider selectionProvider) {
            if (selectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else if (selectionProvider != null) {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else if (selectionProvider != null) {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            if (selection instanceof ITextSelection) {
                SQLEditorBase.this.updateOccurrenceAnnotations((ITextSelection)selection);
            }
        }
    }

    private static class OccurrencePosition
    extends Position {
        boolean forSelection;

        OccurrencePosition(int offset, int length, boolean forSelection) {
            super(offset, length);
            this.forSelection = forSelection;
        }
    }

    private static class OccurrencesFinder {
        private IDocument fDocument;
        private String wordUnderCursor;
        private String wordSelected;

        OccurrencesFinder(IDocument document, String wordUnderCursor, String wordSelected) {
            this.fDocument = document;
            this.wordUnderCursor = wordUnderCursor;
            this.wordSelected = wordSelected;
        }

        public List<OccurrencePosition> perform() {
            if (CommonUtils.isEmpty((String)this.wordUnderCursor) && CommonUtils.isEmpty((String)this.wordSelected)) {
                return null;
            }
            ArrayList<OccurrencePosition> positions = new ArrayList<OccurrencePosition>();
            try {
                if (CommonUtils.equalObjects((Object)this.wordUnderCursor, (Object)this.wordSelected)) {
                    this.findPositions(this.wordUnderCursor, positions, true);
                } else {
                    this.findPositions(this.wordUnderCursor, positions, false);
                    if (!CommonUtils.isEmpty((String)this.wordSelected)) {
                        this.findPositions(this.wordSelected, positions, true);
                    }
                }
            }
            catch (BadLocationException e) {
                log.debug((Object)("Error finding occurrences: " + e.getMessage()));
            }
            return positions;
        }

        private void findPositions(String searchFor, List<OccurrencePosition> positions, boolean forSelection) throws BadLocationException {
            IRegion region;
            FindReplaceDocumentAdapter findReplaceDocumentAdapter = new FindReplaceDocumentAdapter(this.fDocument);
            int offset = 0;
            while ((region = findReplaceDocumentAdapter.find(offset, searchFor, true, false, !forSelection, false)) != null) {
                positions.add(new OccurrencePosition(region.getOffset(), region.getLength(), forSelection));
                offset = region.getOffset() + region.getLength();
            }
        }
    }

    class OccurrencesFinderJob
    extends Job {
        private boolean isCanceled;
        private IProgressMonitor progressMonitor;
        private List<OccurrencePosition> positions;

        public OccurrencesFinderJob(List<OccurrencePosition> positions) {
            super("Occurrences Marker");
            this.isCanceled = false;
            this.positions = positions;
        }

        void doCancel() {
            this.isCanceled = true;
            this.cancel();
        }

        private boolean isCanceled() {
            return this.isCanceled || this.progressMonitor.isCanceled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor progressMonitor) {
            IAnnotationModel annotationModel;
            IDocumentProvider documentProvider;
            IDocument document;
            SourceViewer textViewer;
            this.progressMonitor = progressMonitor;
            if (!this.isCanceled() && (textViewer = SQLEditorBase.this.getViewer()) != null && (document = textViewer.getDocument()) != null && (documentProvider = SQLEditorBase.this.getDocumentProvider()) != null && (annotationModel = documentProvider.getAnnotationModel((Object)SQLEditorBase.this.getEditorInput())) != null) {
                LinkedHashMap<Annotation, Position> annotationMap = new LinkedHashMap<Annotation, Position>(this.positions.size());
                for (OccurrencePosition position : this.positions) {
                    if (this.isCanceled()) break;
                    try {
                        String message = document.get(position.offset, position.length);
                        annotationMap.put(new Annotation(position.forSelection ? "org.jkisss.dbeaver.ui.occurrences.forSelection" : "org.jkisss.dbeaver.ui.occurrences.underCursor", false, message), position);
                    }
                    catch (BadLocationException badLocationException) {}
                }
                if (!this.isCanceled()) {
                    Object object = SQLEditorBase.this.LOCK_OBJECT;
                    synchronized (object) {
                        this.updateAnnotations(annotationModel, annotationMap);
                    }
                    return Status.OK_STATUS;
                }
            }
            return Status.CANCEL_STATUS;
        }

        private void updateAnnotations(IAnnotationModel annotationModel, Map<Annotation, Position> annotationMap) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(SQLEditorBase.this.occurrenceAnnotations, annotationMap);
            } else {
                SQLEditorBase.this.removeOccurrenceAnnotations();
                for (Map.Entry<Annotation, Position> mapEntry : annotationMap.entrySet()) {
                    annotationModel.addAnnotation(mapEntry.getKey(), mapEntry.getValue());
                }
            }
            SQLEditorBase.this.occurrenceAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
        }
    }

    class OccurrencesFinderJobCanceler
    implements IDocumentListener,
    ITextInputListener {
        OccurrencesFinderJobCanceler() {
        }

        public void install() {
            StyledText text;
            ISourceViewer sourceViewer = SQLEditorBase.this.getSourceViewer();
            if (sourceViewer != null && (text = sourceViewer.getTextWidget()) != null && !text.isDisposed()) {
                sourceViewer.addTextInputListener((ITextInputListener)this);
                IDocument document = sourceViewer.getDocument();
                if (document != null) {
                    document.addDocumentListener((IDocumentListener)this);
                }
            }
        }

        public void uninstall() {
            IDocument document;
            IDocumentProvider documentProvider;
            ISourceViewer sourceViewer = SQLEditorBase.this.getSourceViewer();
            if (sourceViewer != null) {
                sourceViewer.removeTextInputListener((ITextInputListener)this);
            }
            if ((documentProvider = SQLEditorBase.this.getDocumentProvider()) != null && (document = documentProvider.getDocument((Object)SQLEditorBase.this.getEditorInput())) != null) {
                document.removeDocumentListener((IDocumentListener)this);
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            if (SQLEditorBase.this.occurrencesFinderJob != null) {
                SQLEditorBase.this.occurrencesFinderJob.doCancel();
            }
        }

        public void documentChanged(DocumentEvent event) {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput != null) {
                oldInput.removeDocumentListener((IDocumentListener)this);
            }
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (newInput != null) {
                newInput.addDocumentListener((IDocumentListener)this);
            }
        }
    }

    private static class ScriptBlockInfo {
        final ScriptBlockInfo parent;
        boolean isHeader;

        public ScriptBlockInfo(ScriptBlockInfo parent, boolean isHeader) {
            this.parent = parent;
            this.isHeader = isHeader;
        }
    }

    protected class ShowPreferencesAction
    extends Action {
        public ShowPreferencesAction() {
            super(SQLEditorMessages.editor_sql_preference, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.CONFIGURATION));
        }

        public void run() {
            Shell shell = SQLEditorBase.this.getSourceViewer().getTextWidget().getShell();
            String[] preferencePages = SQLEditorBase.this.collectContextMenuPreferencePages();
            if (!(preferencePages.length <= 0 || shell != null && shell.isDisposed())) {
                PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)preferencePages[0], (String[])preferencePages, (Object)SQLEditorBase.this.getEditorInput()).open();
            }
        }
    }
}

