/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.views.session;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSession;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionDetails;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionDetailsProvider;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.ObjectPropertyDescriptor;
import org.jkiss.dbeaver.runtime.properties.PropertyCollector;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ISearchExecutor;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.controls.autorefresh.AutoRefreshControl;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.plan.ExplainPlanViewer;
import org.jkiss.dbeaver.ui.navigator.itemlist.DatabaseObjectListControl;
import org.jkiss.dbeaver.ui.navigator.itemlist.ObjectListControl;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;
import org.jkiss.dbeaver.ui.views.session.AbstractSessionEditor;
import org.jkiss.dbeaver.ui.views.session.SessionManagerViewer;
import org.jkiss.dbeaver.ui.views.session.SessionTable;
import org.jkiss.dbeaver.ui.views.session.internal.SessionEditorMessages;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class SessionManagerViewer<SESSION_TYPE extends DBAServerSession> {
    private static final Log log = Log.getLog(SessionManagerViewer.class);
    private IWorkbenchPart workbenchPart;
    private final DBAServerSessionManager<SESSION_TYPE> sessionManager;
    private SessionListControl sessionTable;
    private IEditorSite subSite;
    private SQLEditorBase sqlViewer;
    private Font boldFont;
    private PropertyTreeViewer sessionProps;
    private DBAServerSession curSession;
    private AutoRefreshControl refreshControl;
    private final SashForm sashMain;
    private final SashForm sashDetails;
    private IDialogSettings settings;
    private CTabFolder previewFolder;
    private final CTabItem detailsItem;
    private final DBCQueryPlanner planner;
    private ExplainPlanViewer planViewer;
    private Object selectedPlanElement;
    private final CTabFolder detailsFolder;

    protected SessionManagerViewer(IWorkbenchPart part, Composite parent, final DBAServerSessionManager<SESSION_TYPE> sessionManager) {
        List sessionDetails;
        this.workbenchPart = part;
        this.sessionManager = sessionManager;
        this.subSite = new SubEditorSite(this.workbenchPart.getSite());
        this.boldFont = UIUtils.makeBoldFont((Font)parent.getFont());
        this.planner = (DBCQueryPlanner)DBUtils.getAdapter(DBCQueryPlanner.class, (Object)sessionManager.getDataSource());
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        this.sashMain = UIUtils.createPartDivider((IWorkbenchPart)this.workbenchPart, (Composite)composite, (int)66048);
        this.sashMain.setLayoutData((Object)new GridData(1808));
        this.refreshControl = new AutoRefreshControl((Control)this.sashMain, sessionManager.getClass().getSimpleName(), monitor -> UIUtils.syncExec(this::refreshSessions));
        this.sessionTable = new SessionListControl((Composite)this.sashMain, (IWorkbenchSite)this.workbenchPart.getSite(), sessionManager);
        this.sessionTable.getItemsViewer().addSelectionChangedListener(event -> this.onSessionSelect(this.getSelectedSession()));
        this.sessionTable.addDisposeListener(e -> this.saveSettings(this.settings));
        this.sessionTable.setLayoutData(new GridData(768));
        this.sessionTable.createProgressPanel(composite);
        this.sashDetails = UIUtils.createPartDivider((IWorkbenchPart)this.workbenchPart, (Composite)this.sashMain, (int)65792);
        this.sashDetails.setLayoutData((Object)new GridData(1808));
        this.previewFolder = new CTabFolder((Composite)this.sashDetails, 128);
        this.sqlViewer = new SQLEditorBase(){

            public DBCExecutionContext getExecutionContext() {
                return DBUtils.getDefaultContext((DBSObject)sessionManager.getDataSource(), (boolean)false);
            }

            public boolean isFoldingEnabled() {
                return false;
            }
        };
        this.updateSQL();
        this.sqlViewer.createPartControl((Composite)this.previewFolder);
        Object text = this.sqlViewer.getAdapter(Control.class);
        if (text instanceof StyledText) {
            ((StyledText)text).setWordWrap(true);
        }
        this.sqlViewer.reloadSyntaxRules();
        parent.addDisposeListener(e -> this.sqlViewer.dispose());
        CTabItem sqlViewItem = new CTabItem(this.previewFolder, 0);
        sqlViewItem.setText(SessionEditorMessages.viewer_view_item_sql);
        sqlViewItem.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.SQL_TEXT));
        sqlViewItem.setControl((Control)this.sqlViewer.getEditorControlWrapper());
        this.previewFolder.setSelection(sqlViewItem);
        if (this.planner != null) {
            this.createPlannerTab(this.previewFolder);
        }
        this.previewFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SessionManagerViewer.this.updatePreview();
            }
        });
        this.detailsFolder = new CTabFolder((Composite)this.sashDetails, 128);
        this.sessionProps = new PropertyTreeViewer((Composite)this.detailsFolder, 0);
        this.detailsItem = new CTabItem(this.detailsFolder, 0);
        this.detailsItem.setText(SessionEditorMessages.viewer_details_item_details);
        this.detailsItem.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.PROPERTIES));
        this.detailsItem.setControl(this.sessionProps.getControl());
        if (sessionManager instanceof DBAServerSessionDetailsProvider && (sessionDetails = ((DBAServerSessionDetailsProvider)sessionManager).getSessionDetails()) != null) {
            for (DBAServerSessionDetails detailsInfo : sessionDetails) {
                CTabItem extDetailsItem = new CTabItem(this.detailsFolder, 0);
                extDetailsItem.setData((Object)detailsInfo);
                extDetailsItem.setText(detailsInfo.getDetailsTitle());
                if (detailsInfo.getDetailsIcon() != null) {
                    extDetailsItem.setImage(DBeaverIcons.getImage((DBPImage)detailsInfo.getDetailsIcon()));
                }
                if (detailsInfo.getDetailsTooltip() != null) {
                    extDetailsItem.setToolTipText(detailsInfo.getDetailsTooltip());
                }
                DetailsListControl detailsProps = new DetailsListControl((Composite)this.detailsFolder, (IWorkbenchSite)this.workbenchPart.getSite(), detailsInfo);
                extDetailsItem.setControl((Control)detailsProps);
            }
        }
        this.detailsFolder.setSelection(this.detailsItem);
        this.detailsFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTabItem item = SessionManagerViewer.this.detailsFolder.getItem(SessionManagerViewer.this.detailsFolder.getSelectionIndex());
                Object data = item.getData();
                if (data instanceof DBAServerSessionDetails) {
                    DetailsListControl detailsViewer = (DetailsListControl)item.getControl();
                    detailsViewer.loadData();
                }
            }
        });
        this.sashMain.setWeights(new int[]{500, 500});
        this.sashMain.setWeights(new int[]{700, 300});
    }

    private void updatePreview() {
        CTabItem detailsItem;
        Object data;
        if (this.previewFolder.getSelectionIndex() == 0) {
            this.detailsItem.setText(SessionEditorMessages.viewer_details_item_session_details);
            this.updateSQL();
            if (this.curSession == null) {
                this.sessionProps.clearProperties();
            } else {
                PropertyCollector propCollector = new PropertyCollector((Object)this.curSession, true);
                propCollector.collectProperties();
                this.sessionProps.loadProperties((DBPPropertySource)propCollector);
            }
        } else if (this.planViewer != null) {
            String sqlText;
            String string = sqlText = this.curSession == null ? "" : CommonUtils.notEmpty((String)this.curSession.getActiveQuery());
            if (!CommonUtils.isEmpty((String)sqlText)) {
                this.planViewer.explainQueryPlan(new SQLQuery(this.sessionManager.getDataSource(), sqlText), this.curSession.getActiveQueryId());
            }
        }
        if (this.detailsFolder.getSelectionIndex() > 0 && (data = (detailsItem = this.detailsFolder.getItem(this.detailsFolder.getSelectionIndex())).getData()) instanceof DBAServerSessionDetails) {
            DetailsListControl detailsListControl = (DetailsListControl)detailsItem.getControl();
            detailsListControl.loadData();
        }
    }

    private void createPlannerTab(CTabFolder previewFolder) {
        this.planViewer = new ExplainPlanViewer(this.workbenchPart, (DBPContextProvider)this.sqlViewer, (Composite)previewFolder, 0);
        this.planViewer.addSelectionChangedListener(event -> this.showPlanNode());
        CTabItem sqlPlanItem = new CTabItem(previewFolder, 0);
        sqlPlanItem.setText(SessionEditorMessages.viewer_sql_plan_item_execution_plan);
        sqlPlanItem.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.SQL_PAGE_EXPLAIN_PLAN));
        sqlPlanItem.setControl(this.planViewer.getControl());
        sqlPlanItem.setData((Object)this.planViewer);
    }

    private void showPlanNode() {
        Object element;
        this.detailsItem.setText("Plan Details");
        ISelection selection = this.planViewer.getSelection();
        if (selection.isEmpty()) {
            this.sessionProps.clearProperties();
        } else if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) != this.selectedPlanElement) {
            PropertyCollector propertySource = new PropertyCollector(element, true);
            propertySource.collectProperties();
            this.sessionProps.loadProperties((DBPPropertySource)propertySource);
            this.selectedPlanElement = element;
        }
    }

    public DatabaseObjectListControl getSessionListControl() {
        return this.sessionTable;
    }

    public void dispose() {
        this.sessionTable.disposeControl();
        UIUtils.dispose((Resource)this.boldFont);
    }

    protected void onSessionSelect(DBAServerSession session) {
        if (this.curSession == session && this.selectedPlanElement == null) {
            return;
        }
        this.selectedPlanElement = null;
        this.previewFolder.setSelection(0);
        this.curSession = session;
        this.updatePreview();
    }

    protected void contributeToToolbar(DBAServerSessionManager sessionManager, IContributionManager contributionManager) {
    }

    public DBAServerSession getSelectedSession() {
        ISelection selection = this.sessionTable.getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            return (DBAServerSession)((IStructuredSelection)selection).getFirstElement();
        }
        return null;
    }

    public List<DBAServerSession> getSelectedSessions() {
        ISelection selection = this.sessionTable.getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            ArrayList<DBAServerSession> sessions = new ArrayList<DBAServerSession>();
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (item instanceof DBAServerSession) {
                    sessions.add((DBAServerSession)item);
                }
                ++n2;
            }
            return sessions;
        }
        return Collections.emptyList();
    }

    public void refreshSessions() {
        this.sessionTable.loadData();
        this.onSessionSelect(null);
        this.refreshControl.scheduleAutoRefresh(false);
    }

    public void alterSessions(List<SESSION_TYPE> sessions, Map<String, Object> options) {
        this.sessionTable.createAlterService(sessions, options).schedule();
    }

    private void updateSQL() {
        String text = this.curSession == null ? "" : CommonUtils.notEmpty((String)this.curSession.getActiveQuery());
        StringEditorInput sqlInput = new StringEditorInput(this.sessionTable.getShell().getText(), (CharSequence)text, true, GeneralUtils.getDefaultFileEncoding());
        if (this.sqlViewer.getSite() == null) {
            try {
                this.sqlViewer.init(this.subSite, (IEditorInput)sqlInput);
            }
            catch (PartInitException e) {
                DBWorkbench.getPlatformUI().showError(this.sessionTable.getShell().getText(), null, (Throwable)e);
            }
        } else {
            this.sqlViewer.setInput((IEditorInput)sqlInput);
        }
        if (this.sqlViewer.getTextViewer() != null) {
            this.sqlViewer.reloadSyntaxRules();
        }
    }

    public Composite getControl() {
        return this.sessionTable.getControl();
    }

    public Map<String, Object> getSessionOptions() {
        return null;
    }

    void loadSettings(AbstractSessionEditor sessionEditor) {
        this.settings = UIUtils.getDialogSettings((String)("DBeaver." + ((Object)((Object)sessionEditor)).getClass().getSimpleName()));
        this.loadSettings(this.settings);
    }

    protected void loadSettings(IDialogSettings settings) {
        int detailsSashRatio;
        int mainSashRatio = CommonUtils.toInt((Object)settings.get("MainSashRatio"), (int)0);
        if (mainSashRatio > 0) {
            this.sashMain.setWeights(new int[]{mainSashRatio, 1000 - mainSashRatio});
        }
        if ((detailsSashRatio = CommonUtils.toInt((Object)settings.get("DetailsSashRatio"), (int)0)) > 0) {
            this.sashDetails.setWeights(new int[]{detailsSashRatio, 1000 - detailsSashRatio});
        }
    }

    protected void saveSettings(IDialogSettings settings) {
        settings.put("MainSashRatio", this.sashMain.getWeights()[0]);
        settings.put("DetailsSashRatio", this.sashDetails.getWeights()[0]);
    }

    protected boolean sessionMatches(SESSION_TYPE element, Pattern searchPattern) {
        String activeQuery = element.getActiveQuery();
        return activeQuery != null && searchPattern.matcher(activeQuery).find();
    }

    private class DetailsListControl
    extends DatabaseObjectListControl<DBPObject> {
        private DBAServerSessionDetails sessionDetails;

        protected DetailsListControl(Composite parent, IWorkbenchSite site, DBAServerSessionDetails sessionDetails) {
            super(parent, 0x10000000, site, (IContentProvider)new ListContentProvider());
            this.sessionDetails = sessionDetails;
        }

        protected String getListConfigId(List<Class<?>> classList) {
            return "SessionDetails/" + SessionManagerViewer.this.sessionManager.getDataSource().getContainer().getDriver().getId() + "/" + this.sessionDetails.getDetailsTitle();
        }

        protected Class<?>[] getListBaseTypes(Collection<DBPObject> items) {
            return new Class[]{this.sessionDetails.getDetailsType()};
        }

        protected LoadingJob<Collection<DBPObject>> createLoadService() {
            return LoadingJob.createService((ILoadService)new SessionDetailsLoadService(this.sessionDetails), (ILoadVisualizer)new ObjectListControl.ObjectsLoadVisualizer((ObjectListControl)this));
        }
    }

    private class SessionDetailsLoadService
    extends DatabaseLoadService<Collection<DBPObject>> {
        private DBAServerSessionDetails sessionDetails;

        public SessionDetailsLoadService(DBAServerSessionDetails sessionDetails) {
            super("Load session details " + sessionDetails.getDetailsTitle(), SessionManagerViewer.this.sessionManager.getDataSource());
            this.sessionDetails = sessionDetails;
        }

        public Collection<DBPObject> evaluate(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            if (SessionManagerViewer.this.curSession == null) {
                return Collections.emptyList();
            }
            try {
                DBCExecutionContext context = DBUtils.getDefaultContext((DBSObject)SessionManagerViewer.this.sessionManager.getDataSource(), (boolean)false);
                Throwable throwable = null;
                Object var4_6 = null;
                try (DBCSession session = context.openSession(monitor, DBCExecutionPurpose.UTIL, "Load session details (" + this.sessionDetails.getDetailsTitle() + ")");){
                    List sessionDetails = this.sessionDetails.getSessionDetails(session, SessionManagerViewer.this.curSession);
                    ArrayList<DBPObject> result = new ArrayList<DBPObject>();
                    if (sessionDetails != null) {
                        result.addAll(sessionDetails);
                    }
                    return result;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable ex) {
                throw new InvocationTargetException(ex);
            }
        }
    }

    private class SessionListControl
    extends SessionTable<SESSION_TYPE> {
        private org.jkiss.dbeaver.ui.views.session.SessionManagerViewer$SessionListControl.SessionSearcher searcher;

        SessionListControl(Composite sash, IWorkbenchSite site, DBAServerSessionManager<SESSION_TYPE> sessionManager) {
            super(sash, 0x10000000, site, sessionManager);
            this.searcher = new SessionSearcher();
        }

        public void fillCustomActions(IContributionManager contributionManager) {
            SessionManagerViewer.this.contributeToToolbar(this.getSessionManager(), contributionManager);
            SessionManagerViewer.this.refreshControl.populateRefreshButton(contributionManager);
            contributionManager.add((IAction)new Action("Refresh sessions", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.REFRESH)){

                public void run() {
                    SessionManagerViewer.this.refreshSessions();
                }
            });
        }

        @Override
        protected final Map<String, Object> getSessionOptions() {
            return SessionManagerViewer.this.getSessionOptions();
        }

        protected ISearchExecutor getSearchRunner() {
            return this.searcher;
        }

        private class SearchFilter
        extends ViewerFilter {
            final Pattern pattern;

            public SearchFilter(String searchString, boolean caseSensitiveSearch) throws PatternSyntaxException {
                this.pattern = Pattern.compile(SQLUtils.makeLikePattern((String)searchString), caseSensitiveSearch ? 0 : 2);
            }

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                try {
                    if (element instanceof DBAServerSession) {
                        boolean matches = false;
                        for (DBPPropertyDescriptor property : SessionListControl.this.getAllProperties()) {
                            Object value;
                            if (!(property instanceof ObjectPropertyDescriptor) || (value = ((ObjectPropertyDescriptor)property).readValue(element, null, true)) == null || !this.pattern.matcher(CommonUtils.toString((Object)value)).find()) continue;
                            matches = true;
                            break;
                        }
                        return matches;
                    }
                    return false;
                }
                catch (Exception e) {
                    log.error((Object)e);
                    return false;
                }
            }
        }

        private class SessionSearcher
        implements ISearchExecutor {
            private SessionSearcher() {
            }

            public boolean performSearch(String searchString, int options) {
                try {
                    SearchFilter searchFilter = new SearchFilter(searchString, (options & 1) != 0);
                    SessionListControl.this.getItemsViewer().setFilters(new ViewerFilter[]{searchFilter});
                    return true;
                }
                catch (PatternSyntaxException e) {
                    log.error((Object)e.getMessage());
                    return false;
                }
            }

            public void cancelSearch() {
                SessionListControl.this.getItemsViewer().setFilters(new ViewerFilter[0]);
            }
        }
    }
}

