/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.Connection;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;

public class DB2ExecutionContext
extends JDBCExecutionContext
implements DBCExecutionContextDefaults<DBSCatalog, DB2Schema> {
    private static final Log log = Log.getLog(DB2ExecutionContext.class);
    private static final String GET_CURRENT_SCHEMA = "VALUES(CURRENT SCHEMA)";
    private static final String SET_CURRENT_SCHEMA = "SET CURRENT SCHEMA = %s";
    private static final String GET_CURRENT_USER = "VALUES(SYSTEM_USER)";
    private String activeSchemaName;

    DB2ExecutionContext(@NotNull JDBCRemoteInstance instance, String purpose) {
        super(instance, purpose);
    }

    @NotNull
    public DB2DataSource getDataSource() {
        return (DB2DataSource)super.getDataSource();
    }

    @Nullable
    public DBCExecutionContextDefaults getContextDefaults() {
        return this;
    }

    public String getActiveSchemaName() {
        return this.activeSchemaName;
    }

    public DBSCatalog getDefaultCatalog() {
        return null;
    }

    public DB2Schema getDefaultSchema() {
        return this.activeSchemaName == null ? null : (DB2Schema)this.getDataSource().getSchemaCache().getCachedObject(this.activeSchemaName);
    }

    public boolean supportsCatalogChange() {
        return false;
    }

    public boolean supportsSchemaChange() {
        return true;
    }

    public void setDefaultCatalog(DBRProgressMonitor monitor, DBSCatalog catalog, DB2Schema schema) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public void setDefaultSchema(DBRProgressMonitor monitor, DB2Schema schema) throws DBCException {
        DB2Schema oldSelectedEntity = this.getDefaultSchema();
        if (schema == null || oldSelectedEntity == schema) {
            return;
        }
        this.setCurrentSchema(monitor, schema);
        this.activeSchemaName = schema.getName();
        DBUtils.fireObjectSelectionChange((DBSObject)oldSelectedEntity, (DBSObject)schema);
    }

    public boolean refreshDefaults(DBRProgressMonitor monitor) throws DBException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.META, "Query active schema");){
                this.activeSchemaName = this.determineActiveSchema(session);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new DBCException((Throwable)e, (DBPDataSource)this.getDataSource());
        }
        return true;
    }

    void setCurrentSchema(DBRProgressMonitor monitor, DB2Schema object) throws DBCException {
        if (object == null) {
            log.debug((Object)"Null current schema");
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.UTIL, "Set active schema");){
                JDBCUtils.executeSQL((Connection)session, (String)String.format(SET_CURRENT_SCHEMA, object.getName()), (Object[])new Object[0]);
                this.activeSchemaName = object.getName();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException(e, (DBPDataSource)this.getDataSource());
        }
    }

    private String determineActiveSchema(JDBCSession session) throws SQLException {
        String defSchema = JDBCUtils.queryString((JDBCSession)session, (String)GET_CURRENT_SCHEMA, (Object[])new Object[0]);
        if (defSchema == null) {
            log.warn((Object)"VALUES(CURRENT SCHEMA) returned null! How can it be? Trying to set active schema to special register 'SYSTEM_USER'");
            defSchema = JDBCUtils.queryString((JDBCSession)session, (String)GET_CURRENT_USER, (Object[])new Object[0]);
            if (defSchema == null) {
                log.warn((Object)"Special registers 'CURRENT SCHEMA' and 'SYSTEM_USER' both returned null. Use connection username as active schema");
                defSchema = this.getDataSource().getContainer().getActualConnectionConfiguration().getUserName();
            }
        }
        return defSchema.trim();
    }
}

