/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObjectType;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerProcedure;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTable;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableCheckConstraint;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableForeignKey;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerView;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractObjectReference;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;

public class SQLServerStructureAssistant
implements DBSStructureAssistant {
    protected static final Log log = Log.getLog(SQLServerStructureAssistant.class);
    private final SQLServerDataSource dataSource;

    public SQLServerStructureAssistant(SQLServerDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DBSObjectType[] getSupportedObjectTypes() {
        return new DBSObjectType[]{SQLServerObjectType.S, SQLServerObjectType.U, SQLServerObjectType.IT, SQLServerObjectType.V, SQLServerObjectType.SN, SQLServerObjectType.P, SQLServerObjectType.FN, SQLServerObjectType.FT, SQLServerObjectType.FS, SQLServerObjectType.X};
    }

    public DBSObjectType[] getSearchObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_VIEW, SQLServerObjectType.SN, RelationalObjectType.TYPE_PROCEDURE};
    }

    public DBSObjectType[] getHyperlinkObjectTypes() {
        return new DBSObjectType[]{SQLServerObjectType.S, SQLServerObjectType.U, SQLServerObjectType.IT, SQLServerObjectType.V, RelationalObjectType.TYPE_PROCEDURE};
    }

    public DBSObjectType[] getAutoCompleteObjectTypes() {
        return new DBSObjectType[]{SQLServerObjectType.U, SQLServerObjectType.V, SQLServerObjectType.P};
    }

    @NotNull
    public List<DBSObjectReference> findObjectsByMask(DBRProgressMonitor monitor, DBSObject parentObject, DBSObjectType[] objectTypes, String objectNameMask, boolean caseSensitive, boolean globalSearch, int maxResults) throws DBException {
        SQLServerDatabase database;
        SQLServerDatabase sQLServerDatabase = parentObject instanceof SQLServerDatabase ? (SQLServerDatabase)parentObject : (database = parentObject instanceof SQLServerSchema ? ((SQLServerSchema)parentObject).getDatabase() : null);
        if (database == null) {
            database = this.dataSource.getDefaultDatabase(monitor);
        }
        if (database == null) {
            return Collections.emptyList();
        }
        SQLServerSchema schema = parentObject instanceof SQLServerSchema ? (SQLServerSchema)parentObject : null;
        Throwable throwable = null;
        Object var11_12 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this.dataSource, (String)"Find objects by name");){
            ArrayList<DBSObjectReference> objects = new ArrayList<DBSObjectReference>();
            this.searchAllObjects(session, database, schema, objectNameMask, objectTypes, caseSensitive, maxResults, objects);
            return objects;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void searchAllObjects(final JDBCSession session, final SQLServerDatabase database, SQLServerSchema schema, String objectNameMask, DBSObjectType[] objectTypes, boolean caseSensitive, int maxResults, List<DBSObjectReference> objects) throws DBException {
        ArrayList<SQLServerObjectType> supObjectTypes = new ArrayList<SQLServerObjectType>(objectTypes.length + 2);
        DBSObjectType[] dBSObjectTypeArray = objectTypes;
        int n = objectTypes.length;
        int n2 = 0;
        while (n2 < n) {
            DBSObjectType objectType = dBSObjectTypeArray[n2];
            if (objectType instanceof SQLServerObjectType) {
                supObjectTypes.add((SQLServerObjectType)objectType);
            } else if (objectType == RelationalObjectType.TYPE_PROCEDURE) {
                supObjectTypes.addAll(SQLServerObjectType.getTypesForClass(SQLServerProcedure.class));
            } else if (objectType == RelationalObjectType.TYPE_TABLE) {
                supObjectTypes.addAll(SQLServerObjectType.getTypesForClass(SQLServerTable.class));
            } else if (objectType == RelationalObjectType.TYPE_CONSTRAINT) {
                supObjectTypes.addAll(SQLServerObjectType.getTypesForClass(SQLServerTableCheckConstraint.class));
                supObjectTypes.addAll(SQLServerObjectType.getTypesForClass(SQLServerTableForeignKey.class));
            } else if (objectType == RelationalObjectType.TYPE_VIEW) {
                supObjectTypes.addAll(SQLServerObjectType.getTypesForClass(SQLServerView.class));
            }
            ++n2;
        }
        if (supObjectTypes.isEmpty()) {
            return;
        }
        StringBuilder objectTypeClause = new StringBuilder(100);
        for (SQLServerObjectType objectType : supObjectTypes) {
            if (objectTypeClause.length() > 0) {
                objectTypeClause.append(",");
            }
            objectTypeClause.append("'").append(objectType.getTypeID()).append("'");
        }
        if (objectTypeClause.length() == 0) {
            return;
        }
        try {
            Throwable objectType = null;
            Iterator iterator = null;
            try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM " + SQLServerUtils.getSystemTableName(database, "all_objects") + " o " + "\nWHERE o.type IN (" + objectTypeClause.toString() + ") AND o.name LIKE ?" + (schema == null ? "" : " AND o.schema_id=? ") + "\nORDER BY o.name");){
                dbStat.setString(1, objectNameMask);
                if (schema != null) {
                    dbStat.setLong(2, schema.getObjectId());
                }
                dbStat.setFetchSize(1000);
                Throwable throwable = null;
                Object var15_22 = null;
                try (JDBCResultSet dbResult = dbStat.executeQuery();){
                    while (objects.size() < maxResults && dbResult.next()) {
                        if (session.getProgressMonitor().isCanceled()) {
                            break;
                        }
                        long schemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"schema_id");
                        final String objectName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"name");
                        final String objectTypeName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"type");
                        final SQLServerObjectType objectType2 = SQLServerObjectType.valueOf(objectTypeName);
                        final SQLServerSchema objectSchema = schemaId == 0L ? null : database.getSchema(session.getProgressMonitor(), schemaId);
                        objects.add((DBSObjectReference)new AbstractObjectReference(objectName, (DBSObject)(objectSchema != null ? objectSchema : database), null, objectType2.getTypeClass(), objectType2){

                            public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                                DBSObject object = objectType2.findObject(session.getProgressMonitor(), database, objectSchema, objectName);
                                if (object == null) {
                                    throw new DBException(String.valueOf(objectTypeName) + " '" + objectName + "' not found");
                                }
                                return object;
                            }
                        });
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                if (objectType == null) {
                    objectType = throwable;
                } else if (objectType != throwable) {
                    objectType.addSuppressed(throwable);
                }
                throw objectType;
            }
        }
        catch (Throwable e) {
            throw new DBException("Error while searching in system catalog", e, (DBPDataSource)this.dataSource);
        }
    }
}

