/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.task;

import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.model.task.DBTTaskHandler;
import org.jkiss.dbeaver.tools.transfer.DataTransferJob;
import org.jkiss.dbeaver.tools.transfer.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;

public class DTTaskHandlerTransfer
implements DBTTaskHandler {
    public void executeTask(@NotNull DBRRunnableContext runnableContext, @NotNull DBTTask task, @NotNull Locale locale, @NotNull Log log, @NotNull Writer logStream, @NotNull DBTTaskExecutionListener listener) throws DBException {
        DataTransferSettings settings = new DataTransferSettings(runnableContext, task, log, Collections.emptyMap());
        this.executeWithSettings(runnableContext, locale, log, listener, settings);
    }

    public void executeWithSettings(@NotNull DBRRunnableContext runnableContext, @NotNull Locale locale, @NotNull Log log, @NotNull DBTTaskExecutionListener listener, DataTransferSettings settings) throws DBException {
        listener.taskStarted((Object)settings);
        log.debug((Object)"Data transfer initiated");
        List<DataTransferPipe> dataPipes = settings.getDataPipes();
        try {
            runnableContext.run(true, false, monitor -> {
                log.debug((Object)"Initialize data transfer sources");
                monitor.beginTask("Initialize pipes", dataPipes.size());
                try {
                    try {
                        int i = 0;
                        while (i < dataPipes.size()) {
                            DataTransferPipe pipe = (DataTransferPipe)dataPipes.get(i);
                            pipe.initPipe(settings, i, dataPipes.size());
                            pipe.getConsumer().startTransfer(monitor);
                            monitor.worked(1);
                            ++i;
                        }
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            throw new DBException("Error starting data transfer", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        int totalJobs = settings.getDataPipes().size();
        if (totalJobs > settings.getMaxJobCount()) {
            totalJobs = settings.getMaxJobCount();
        }
        Throwable error = null;
        int i = 0;
        while (i < totalJobs) {
            DataTransferJob job = new DataTransferJob(settings, locale, log, listener);
            try {
                runnableContext.run(true, true, (DBRRunnableWithProgress)job);
            }
            catch (InvocationTargetException e) {
                error = e.getTargetException();
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            listener.subTaskFinished(error);
            ++i;
        }
        listener.taskFinished((Object)settings, error);
        log.debug((Object)"Data transfer completed");
    }
}

