/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import java.util.ArrayList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ltk.core.refactoring.IValidationCheckResultQueryFactory;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPluginImages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.UIQueryFactory;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class RefactoringUIPlugin
extends AbstractUIPlugin {
    private static RefactoringUIPlugin fgDefault;

    public RefactoringUIPlugin() {
        fgDefault = this;
    }

    public static RefactoringUIPlugin getDefault() {
        return fgDefault;
    }

    public static String getPluginId() {
        return "org.eclipse.ltk.ui.refactoring";
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        RefactoringCore.internalSetQueryFactory((IValidationCheckResultQueryFactory)new UIQueryFactory(RefactoringCore.getQueryFactory()));
    }

    public void stop(BundleContext context) throws Exception {
        RefactoringCore.internalSetQueryFactory(null);
        super.stop(context);
    }

    public static void log(IStatus status) {
        RefactoringUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable t) {
        Status status = new Status(4, RefactoringUIPlugin.getPluginId(), 10000, RefactoringUIMessages.RefactoringUIPlugin_internal_error, t);
        ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
    }

    public static void logErrorMessage(String message) {
        RefactoringUIPlugin.log((IStatus)new Status(4, RefactoringUIPlugin.getPluginId(), 10000, message, null));
    }

    public static void logRemovedListener(Throwable t) {
        Status status = new Status(4, RefactoringUIPlugin.getPluginId(), 10000, RefactoringUIMessages.RefactoringUIPlugin_listener_removed, t);
        ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
    }

    public static IEditorPart[] getInstanciatedEditors() {
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int windowIndex = 0;
        while (windowIndex < windows.length) {
            IWorkbenchPage[] pages = windows[windowIndex].getPages();
            int pageIndex = 0;
            while (pageIndex < pages.length) {
                IEditorReference[] references = pages[pageIndex].getEditorReferences();
                int refIndex = 0;
                while (refIndex < references.length) {
                    IEditorPart editor = references[refIndex].getEditor(false);
                    if (editor != null) {
                        result.add(editor);
                    }
                    ++refIndex;
                }
                ++pageIndex;
            }
            ++windowIndex;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    protected ImageRegistry createImageRegistry() {
        return RefactoringPluginImages.getImageRegistry();
    }
}

