/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.wizard.IWizardPage;
import org.jkiss.dbeaver.ext.mysql.MySQLDataSourceProvider;
import org.jkiss.dbeaver.ext.mysql.MySQLServerHome;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.tasks.MySQLScriptExecuteSettings;
import org.jkiss.dbeaver.ext.mysql.tools.MySQLScriptExecuteWizardPageSettings;
import org.jkiss.dbeaver.ext.mysql.tools.MySQLToolScript;
import org.jkiss.dbeaver.ext.mysql.ui.internal.MySQLUIMessages;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractScriptExecuteWizard;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractToolWizard;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

class MySQLScriptExecuteWizard
extends AbstractScriptExecuteWizard<MySQLScriptExecuteSettings, MySQLCatalog, MySQLCatalog> {
    private MySQLScriptExecuteWizardPageSettings mainPage = new MySQLScriptExecuteWizardPageSettings(this);

    public MySQLScriptExecuteWizard(MySQLCatalog catalog, boolean isImport) {
        super(Collections.singleton(catalog), isImport ? MySQLUIMessages.tools_script_execute_wizard_db_import : MySQLUIMessages.tools_script_execute_wizard_execute_script);
        ((MySQLScriptExecuteSettings)this.getSettings()).setImport(isImport);
    }

    public MySQLScriptExecuteWizard(DBTTask task, boolean isImport) {
        super(new ArrayList(), isImport ? MySQLUIMessages.tools_script_execute_wizard_db_import : MySQLUIMessages.tools_script_execute_wizard_execute_script);
        ((MySQLScriptExecuteSettings)this.getSettings()).setImport(isImport);
    }

    public String getTaskTypeId() {
        return ((MySQLScriptExecuteSettings)this.getSettings()).isImport() ? "mysqlDatabaseRestore" : "mysqlScriptExecute";
    }

    public void saveTaskState(DBRRunnableContext runnableContext, Map<String, Object> state) {
    }

    public MySQLScriptExecuteSettings.LogLevel getLogLevel() {
        return ((MySQLScriptExecuteSettings)this.getSettings()).getLogLevel();
    }

    public boolean isImport() {
        return ((MySQLScriptExecuteSettings)this.getSettings()).isImport();
    }

    public boolean isVerbose() {
        return ((MySQLScriptExecuteSettings)this.getSettings()).isVerbose();
    }

    protected MySQLScriptExecuteSettings createSettings() {
        return new MySQLScriptExecuteSettings();
    }

    public void addPages() {
        this.addPage((IWizardPage)this.mainPage);
        super.addPages();
    }

    public void fillProcessParameters(List<String> cmd, MySQLCatalog arg) throws IOException {
        String dumpPath = RuntimeUtils.getNativeClientBinary((DBPNativeClientLocation)this.getClientHome(), (String)"bin", (String)"mysql").getAbsolutePath();
        cmd.add(dumpPath);
        if (((MySQLScriptExecuteSettings)this.getSettings()).getLogLevel() == MySQLScriptExecuteSettings.LogLevel.Debug) {
            cmd.add("--debug-info");
        }
        if (((MySQLScriptExecuteSettings)this.getSettings()).isNoBeep()) {
            cmd.add("--no-beep");
        }
        ((MySQLScriptExecuteSettings)this.getSettings()).addExtraCommandArgs(cmd);
    }

    protected void setupProcessParameters(ProcessBuilder process) {
        if (!CommonUtils.isEmpty((String)this.getToolUserPassword())) {
            process.environment().put("MYSQL_PWD", this.getToolUserPassword());
        }
    }

    public MySQLServerHome findNativeClientHome(String clientHomeId) {
        return MySQLDataSourceProvider.getServerHome((String)clientHomeId);
    }

    public Collection<MySQLCatalog> getRunInfo() {
        return this.getDatabaseObjects();
    }

    protected List<String> getCommandLine(MySQLCatalog arg) throws IOException {
        List<String> cmd = MySQLToolScript.getMySQLToolCommandLine(this, arg);
        cmd.add(arg.getName());
        return cmd;
    }

    protected void startProcessHandler(DBRProgressMonitor monitor, MySQLCatalog arg, ProcessBuilder processBuilder, Process process) {
        if (((MySQLScriptExecuteSettings)this.getSettings()).isImport()) {
            this.logPage.startLogReader(processBuilder, process.getInputStream());
            new AbstractToolWizard.BinaryFileTransformerJob((AbstractToolWizard)this, monitor, this.getInputFile(), process.getOutputStream()).start();
        } else {
            super.startProcessHandler(monitor, (Object)arg, processBuilder, process);
        }
    }
}

