/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.manager;

import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.ExasolMessages;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolUser;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.ext.exasol.ui.ExasolUserDialog;
import org.jkiss.dbeaver.ext.exasol.ui.ExasolUserQueryPassword;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class ExasolUserManager
extends SQLObjectEditor<ExasolUser, ExasolDataSource>
implements DBEObjectRenamer<ExasolUser> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    public DBSObjectCache<ExasolDataSource, ExasolUser> getObjectsCache(ExasolUser object) {
        ExasolDataSource ds = object.getDataSource();
        return ds.getUserCache();
    }

    protected ExasolUser createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, final Object container, Object copyFrom, Map<String, Object> options) throws DBException {
        return (ExasolUser)new UITask<ExasolUser>(){

            protected ExasolUser runTask() {
                ExasolUserDialog dialog = new ExasolUserDialog(UIUtils.getActiveWorkbenchShell(), (ExasolDataSource)((Object)container));
                if (dialog.open() != 0) {
                    return null;
                }
                ExasolUser user = new ExasolUser((ExasolDataSource)((Object)container), dialog.getName(), dialog.getComment(), dialog.getLDAPDN(), dialog.getPassword(), dialog.getKerberosPrincipal(), dialog.getUserType());
                return user;
            }
        }.execute();
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        ExasolUser obj = (ExasolUser)command.getObject();
        StringBuilder script = new StringBuilder("CREATE USER " + DBUtils.getQuotedIdentifier((DBSObject)obj) + " IDENTIFIED ");
        switch (obj.getType()) {
            case LOCAL: {
                script.append(" BY \"" + obj.getPassword() + "\"");
                break;
            }
            case LDAP: {
                script.append(" AT LDAP AS '" + obj.getDn() + "'");
                break;
            }
            default: {
                script.append(" BY KERBEROS PRINCIPAL '" + obj.getKerberosPrincipal() + "'");
            }
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create User", script.toString()));
        if (!CommonUtils.isEmpty((String)obj.getDescription())) {
            actions.add((DBEPersistAction)this.Comment(obj));
        }
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        ExasolUser obj = (ExasolUser)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop User", "DROP USER " + DBUtils.getQuotedIdentifier((DBSObject)obj)));
    }

    public void renameObject(DBECommandContext commandContext, ExasolUser object, String newName) throws DBException {
        this.processObjectRename(commandContext, object, newName);
    }

    protected void processObjectRename(DBECommandContext commandContext, ExasolUser object, String newName) throws DBException {
        SQLObjectEditor.ObjectRenameCommand command = new SQLObjectEditor.ObjectRenameCommand((SQLObjectEditor)this, (DBSObject)object, ModelMessages.model_jdbc_rename_object, newName);
        commandContext.addCommand((DBECommand)command, (DBECommandReflector)new SQLObjectEditor.RenameObjectReflector((SQLObjectEditor)this), true);
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        ExasolUser obj = (ExasolUser)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename User", "RENAME USER " + DBUtils.getQuotedIdentifier((DBPDataSource)obj.getDataSource(), (String)command.getOldName()) + " to " + DBUtils.getQuotedIdentifier((DBPDataSource)obj.getDataSource(), (String)command.getNewName())));
    }

    private SQLDatabasePersistAction Comment(ExasolUser obj) {
        return new SQLDatabasePersistAction("Comment on User", "COMMENT ON USER " + DBUtils.getQuotedIdentifier((DBSObject)obj) + " IS '" + ExasolUtils.quoteString(obj.getDescription()) + "'");
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        CharSequence script;
        ExasolUser obj = (ExasolUser)command.getObject();
        if (command.getProperties().containsKey("description")) {
            actionList.add((DBEPersistAction)this.Comment(obj));
        }
        if (command.getProperties().containsKey("priority")) {
            script = String.format("GRANT PRIORITY GROUP %s to %s", DBUtils.getQuotedIdentifier((DBSObject)obj.getPriority()), DBUtils.getQuotedIdentifier((DBSObject)obj));
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(ExasolMessages.manager_assign_priority_group, (String)script));
        }
        if (command.getProperties().containsKey("dn")) {
            script = String.format("ALTER USER " + DBUtils.getQuotedIdentifier((DBSObject)obj) + " IDENTIFIED AT LDAP AS '%s'", obj.getDn());
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("alter user", (String)script));
            return;
        }
        if (command.getProperties().containsKey("kerberosPrincipal")) {
            script = String.format("ALTER USER " + DBUtils.getQuotedIdentifier((DBSObject)obj) + " BY KERBEROS PRINCIPAL '%s'", obj.getKerberosPrincipal());
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("alter user", (String)script));
            return;
        }
        if (command.getProperties().containsKey("password")) {
            script = new StringBuilder("ALTER USER " + DBUtils.getQuotedIdentifier((DBSObject)obj) + " IDENTIFIED ");
            ((StringBuilder)script).append(" BY \"" + obj.getPassword() + "\" ");
            ExasolDataSource ds = obj.getDataSource();
            if (!ds.hasAlterUserPrivilege().booleanValue()) {
                String oldPassword = (String)new UITask<String>(){

                    protected String runTask() {
                        ExasolUserQueryPassword dialog = new ExasolUserQueryPassword(UIUtils.getActiveWorkbenchShell());
                        if (dialog.open() != 0) {
                            throw new IllegalStateException("Password has to be provided");
                        }
                        return dialog.getPassword();
                    }
                }.execute();
                if (CommonUtils.isEmpty((String)oldPassword)) {
                    throw new IllegalStateException("Old password can not be empty");
                }
                ((StringBuilder)script).append(" REPLACE \"" + oldPassword + "\"");
            }
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Modify User", ((StringBuilder)script).toString()));
        }
    }
}

