/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.managers;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentCached;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.storage.ExternalContentStorage;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.preferences.DBPPropertyManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.data.dialogs.TextViewDialog;
import org.jkiss.dbeaver.ui.data.editors.ContentInlineEditor;
import org.jkiss.dbeaver.ui.data.editors.ContentPanelEditor;
import org.jkiss.dbeaver.ui.data.editors.StringInlineEditor;
import org.jkiss.dbeaver.ui.data.managers.BaseValueManager;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.editors.content.ContentEditor;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class ContentValueManager
extends BaseValueManager {
    private static final Log log = Log.getLog(ContentValueManager.class);
    public static final String PROP_CATEGORY_CONTENT = "CONTENT";

    public static void contributeContentActions(@NotNull IContributionManager manager, final @NotNull IValueController controller, final IValueEditor activeEditor) throws DBCException {
        if (controller.getValue() instanceof DBDContent) {
            if (!((DBDContent)controller.getValue()).isNull()) {
                manager.add((IAction)new Action(ResultSetMessages.model_jdbc_save_to_file_, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SAVE_AS)){

                    public void run() {
                        ContentValueManager.saveToFile(controller);
                    }
                });
            }
            manager.add((IAction)new Action(ResultSetMessages.model_jdbc_load_from_file_, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.LOAD)){

                public void run() {
                    if (ContentValueManager.loadFromFile(controller) && activeEditor != null) {
                        try {
                            activeEditor.primeEditorValue(controller.getValue());
                        }
                        catch (DBException e) {
                            DBWorkbench.getPlatformUI().showError("Load from file", "Error loading contents from file", (Throwable)e);
                        }
                    }
                }
            });
            manager.add((IContributionItem)new Separator());
        }
    }

    public static IValueEditor openContentEditor(@NotNull IValueController controller) {
        Object value = controller.getValue();
        IValueController.EditType binaryEditType = IValueController.EditType.valueOf(controller.getExecutionContext().getDataSource().getContainer().getPreferenceStore().getString("resultset.binary.editor"));
        if (controller.getValueType().getDataKind() == DBPDataKind.STRING) {
            return new TextViewDialog(controller);
        }
        if (binaryEditType != IValueController.EditType.EDITOR && value instanceof DBDContentCached) {
            return new TextViewDialog(controller);
        }
        if (value instanceof DBDContent) {
            return ContentEditor.openEditor(controller);
        }
        controller.showMessage(ResultSetMessages.model_jdbc_unsupported_content_value_type_, DBPMessageType.ERROR);
        return null;
    }

    public static boolean loadFromFile(IValueController controller) {
        if (!(controller.getValue() instanceof DBDContent)) {
            log.error((Object)(String.valueOf(ResultSetMessages.model_jdbc_bad_content_value_) + controller.getValue()));
            return false;
        }
        Shell shell = UIUtils.getShell((IShellProvider)controller.getValueSite());
        File openFile = DialogUtils.openFile((Shell)shell);
        if (openFile == null) {
            return false;
        }
        DBDContent value = (DBDContent)controller.getValue();
        UIUtils.runInUI((IRunnableContext)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), monitor -> {
            try {
                ExternalContentStorage storage = ContentUtils.isTextContent((DBDContent)value) ? new ExternalContentStorage(DBWorkbench.getPlatform(), openFile, GeneralUtils.UTF8_ENCODING) : new ExternalContentStorage(DBWorkbench.getPlatform(), openFile);
                value.updateContents(monitor, (DBDContentStorage)storage);
                controller.updateValue(value, true);
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        });
        return true;
    }

    public static void saveToFile(IValueController controller) {
        if (!(controller.getValue() instanceof DBDContent)) {
            log.error((Object)(String.valueOf(ResultSetMessages.model_jdbc_bad_content_value_) + controller.getValue()));
            return;
        }
        Shell shell = UIUtils.getShell((IShellProvider)controller.getValueSite());
        File saveFile = DialogUtils.selectFileForSave((Shell)shell, (String)controller.getValueName());
        if (saveFile == null) {
            return;
        }
        DBDContent value = (DBDContent)controller.getValue();
        try {
            UIUtils.runInProgressService(monitor -> {
                block21: {
                    try {
                        DBDContentStorage storage = value.getContents(monitor);
                        if (ContentUtils.isTextContent((DBDContent)value)) {
                            Throwable throwable = null;
                            Object var5_9 = null;
                            try (Reader cr = storage.getContentReader();){
                                ContentUtils.saveContentToFile((Reader)cr, (File)saveFile, (String)GeneralUtils.UTF8_ENCODING, (DBRProgressMonitor)monitor);
                                break block21;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        Throwable throwable = null;
                        Object var5_11 = null;
                        try (InputStream cs = storage.getContentStream();){
                            ContentUtils.saveContentToFile((InputStream)cs, (File)saveFile, (DBRProgressMonitor)monitor);
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError(ResultSetMessages.model_jdbc_could_not_save_content, String.valueOf(ResultSetMessages.model_jdbc_could_not_save_content_to_file_) + saveFile.getAbsolutePath() + "'", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    public void contributeActions(@NotNull IContributionManager manager, @NotNull IValueController controller, @Nullable IValueEditor activeEditor) throws DBCException {
        super.contributeActions(manager, controller, activeEditor);
        ContentValueManager.contributeContentActions(manager, controller, activeEditor);
    }

    @Override
    public void contributeProperties(@NotNull DBPPropertyManager propertySource, @NotNull IValueController controller) {
        super.contributeProperties(propertySource, controller);
        try {
            Object value = controller.getValue();
            if (value instanceof DBDContent) {
                propertySource.addProperty(PROP_CATEGORY_CONTENT, (Object)"content_type", ResultSetMessages.model_jdbc_content_type, (Object)((DBDContent)value).getContentType());
                long contentLength = ((DBDContent)value).getContentLength();
                if (contentLength >= 0L) {
                    propertySource.addProperty(PROP_CATEGORY_CONTENT, (Object)"content_length", ResultSetMessages.model_jdbc_content_length, (Object)contentLength);
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)"Can't extract CONTENT value information", (Throwable)e);
        }
    }

    @Override
    @NotNull
    public IValueController.EditType[] getSupportedEditTypes() {
        return new IValueController.EditType[]{IValueController.EditType.PANEL, IValueController.EditType.EDITOR};
    }

    @Override
    public IValueEditor createEditor(@NotNull IValueController controller) throws DBException {
        switch (controller.getEditType()) {
            case INLINE: {
                Object value = controller.getValue();
                if (controller.getValueType().getDataKind() == DBPDataKind.STRING) {
                    return new StringInlineEditor(controller);
                }
                if (value instanceof DBDContentCached && ContentUtils.isTextValue((Object)((DBDContentCached)value).getCachedValue())) {
                    return new ContentInlineEditor(controller);
                }
                return null;
            }
            case EDITOR: {
                return ContentValueManager.openContentEditor(controller);
            }
            case PANEL: {
                return new ContentPanelEditor(controller);
            }
        }
        return null;
    }
}

