/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableKeyColumn;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableUniqueKey;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableConstraint;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;

public class ExasolTableForeignKey
extends JDBCTableConstraint<ExasolTable>
implements DBSTableForeignKey,
DBPScriptObject,
DBPNamedObject2 {
    private static final Log LOG = Log.getLog(ExasolTableForeignKey.class);
    private ExasolTable refTable;
    private String constName;
    private Boolean enabled;
    private List<ExasolTableKeyColumn> columns;
    private ExasolTableUniqueKey referencedKey;

    public ExasolTableForeignKey(DBRProgressMonitor monitor, ExasolTable exasolTable, ResultSet dbResult) throws DBException {
        super((JDBCTable)exasolTable, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_NAME"), null, DBSEntityConstraintType.FOREIGN_KEY, true);
        String refSchemaName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REFERENCED_SCHEMA");
        String refTableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REFERENCED_TABLE");
        this.constName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_NAME");
        this.refTable = ExasolUtils.findTableBySchemaNameAndName(monitor, (ExasolDataSource)exasolTable.getDataSource(), refSchemaName, refTableName);
        this.enabled = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"CONSTRAINT_ENABLED");
        this.referencedKey = null;
    }

    public ExasolTableForeignKey(ExasolTable exasolTable, ExasolTableUniqueKey referencedKey, Boolean enabled, String name) {
        super((JDBCTable)exasolTable, name, "", DBSEntityConstraintType.FOREIGN_KEY, true);
        this.referencedKey = referencedKey;
        this.enabled = enabled;
        this.constName = name;
        this.refTable = referencedKey.getTable();
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return ((ExasolTable)this.getTable()).getDataSource();
    }

    public ExasolTable getAssociatedEntity() {
        return this.refTable;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{((ExasolTable)this.getTable()).getContainer(), this.getTable(), this});
    }

    @NotNull
    public DBSForeignKeyModifyRule getUpdateRule() {
        if (this.enabled.booleanValue()) {
            return DBSForeignKeyModifyRule.RESTRICT;
        }
        return DBSForeignKeyModifyRule.NO_ACTION;
    }

    @NotNull
    public DBSForeignKeyModifyRule getDeleteRule() {
        if (this.enabled.booleanValue()) {
            return DBSForeignKeyModifyRule.RESTRICT;
        }
        return DBSForeignKeyModifyRule.NO_ACTION;
    }

    public List<? extends DBSEntityAttributeRef> getAttributeReferences(DBRProgressMonitor monitor) throws DBException {
        return this.columns;
    }

    public void setColumns(List<ExasolTableKeyColumn> columns) {
        this.columns = columns;
    }

    @Property(viewable=true, order=3)
    public ExasolTable getReferencedTable() {
        return this.refTable;
    }

    @Property(id="reference", viewable=true)
    @Nullable
    @NotNull
    public ExasolTableUniqueKey getReferencedConstraint() {
        if (this.referencedKey == null) {
            try {
                this.referencedKey = this.refTable.getPrimaryKey((DBRProgressMonitor)new VoidProgressMonitor());
            }
            catch (DBException e) {
                LOG.error((Object)"Error reading pk", (Throwable)e);
            }
        }
        return this.referencedKey;
    }

    public void setReferencedConstraint(ExasolTableUniqueKey referencedKey) {
        this.referencedKey = referencedKey;
    }

    @Property(viewable=true, editable=true, updatable=true)
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return ExasolUtils.getFKDdl(this, monitor);
    }

    @Property(viewable=true)
    public String getName() {
        return this.constName;
    }

    public void setName(String name) {
        this.constName = name;
    }
}

