/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.oracle.data.OracleBinaryFormatter;
import org.jkiss.dbeaver.model.data.DBDBinaryFormatter;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCSQLDialect;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.utils.ArrayUtils;

class OracleSQLDialect
extends JDBCSQLDialect {
    public static final String[] EXEC_KEYWORDS = new String[]{"call"};
    public static final String[] ORACLE_NON_TRANSACTIONAL_KEYWORDS = (String[])ArrayUtils.concatArrays((Object[])BasicSQLDialect.NON_TRANSACTIONAL_KEYWORDS, (Object[])new String[]{"CREATE", "ALTER", "DROP", "ANALYZE", "VALIDATE"});
    public static final String[][] ORACLE_BEGIN_END_BLOCK = new String[][]{{"BEGIN", "END"}, {"IF", "END"}, {"LOOP", "END LOOP"}, {"CASE", "END CASE"}};
    public static final String[] ORACLE_BLOCK_HEADERS = new String[]{"DECLARE", "FUNCTION", "PROCEDURE"};
    public static final String[] ADVANCED_KEYWORDS = new String[]{"REPLACE", "PACKAGE", "FUNCTION", "TYPE", "TRIGGER", "MATERIALIZED", "IF", "EACH", "RETURN", "WRAPPED", "AFTER", "BEFORE", "DATABASE", "ANALYZE", "VALIDATE", "STRUCTURE", "COMPUTE", "STATISTICS", "LOOP", "WHILE", "BULK", "ELSIF", "EXIT"};
    private boolean crlfBroken;
    private DBPPreferenceStore preferenceStore;

    public OracleSQLDialect() {
        super("Oracle");
    }

    public void initDriverSettings(JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(dataSource, metaData);
        this.crlfBroken = !dataSource.isServerVersionAtLeast(11, 0);
        this.preferenceStore = dataSource.getContainer().getPreferenceStore();
        this.addFunctions(Arrays.asList("SUBSTR", "APPROX_COUNT_DISTINCT", "REGEXP_SUBSTR", "REGEXP_INSTR", "REGEXP_REPLACE", "REGEXP_LIKE", "REGEXP_COUNT", "BITAND", "COSH", "NANVL", "REMAINDER", "SINH", "TANH", "TRUNC", "CHR", "INITCAP", "LPAD", "NLS_INITCAP", "NLS_LOWER", "NLSSORT", "NLS_UPPER", "RPAD", "REVERSE", "SUBSTRB", "SUBSTRC", "SUBSTR2", "SUBSTR4", "NLS_CHARSET_DECL_LEN", "NLS_CHARSET_ID", "NLS_CHARSET_NAME", "INSTR", "INSTRB", "INSTRC", "INSTR2", "INSTR4", "LENGTHB", "ADD_MONTHS", "DBTIMEZONE", "FROM_TZ", "LAST_DAY", "MONTHS_BETWEEN", "NEW_TIME", "NEXT_DAY", "NUMTODSINTERVAL", "NUMTOYMINTERVAL", "SESSIONTIMEZONE", "SYS_EXTRACT_UTC", "SYSDATE", "SYSTIMESTAMP", "TO_CHAR", "TO_TIMESTAMP", "TO_TIMESTAMP_TZ", "TO_DSINTERVAL", "TO_YMINTERVAL", "TRUNC", "TZ_OFFSET", "GREATEST", "LEAST", "ASCIISTR", "BIN_TO_NUM", "CHARTOROWID", "COMPOSE", "DECOMPOSE", "HEXTORAW", "NUMTODSINTERVAL", "NUMTOYMINTERVAL", "RAWTOHEX", "RAWTONHEX", "ROWIDTOCHAR", "ROWIDTONCHAR", "SCN_TO_TIMESTAMP", "TIMESTAMP_TO_SCN", "TO_BINARY_DOUBLE", "TO_BINARY_FLOAT", "TO_CHAR", "TO_CLOB", "TO_DATE", "TO_DSINTERVAL", "TO_LOB", "TO_MULTI_BYTE", "TO_NCHAR", "TO_NCLOB", "TO_NUMBER", "TO_DSINTERVAL", "TO_SINGLE_BYTE", "TO_TIMESTAMP", "TO_TIMESTAMP_TZ", "TO_YMINTERVAL", "TO_YMINTERVAL", "UNISTR", "BFILENAME", "EMPTY_BLOB", "EMPTY_CLOB", "POWERMULTISET", "POWERMULTISET_BY_CARDINALITY", "SYS_CONNECT_BY_PATH", "CLUSTER_ID", "CLUSTER_PROBABILITY", "CLUSTER_SET", "FEATURE_ID", "FEATURE_SET", "FEATURE_VALUE", "PREDICTION", "PREDICTION_COST", "PREDICTION_DETAILS", "PREDICTION_PROBABILITY", "PREDICTION_SET", "APPENDCHILDXML", "DELETEXML", "DEPTH", "EXISTSNODE", "EXTRACTVALUE", "INSERTCHILDXML", "INSERTXMLBEFORE", "PATH", "SYS_DBURIGEN", "SYS_XMLAGG", "SYS_XMLGEN", "UPDATEXML", "XMLAGG", "XMLCDATA", "XMLCOLATTVAL", "XMLCOMMENT", "XMLCONCAT", "XMLFOREST", "XMLPARSE", "XMLPI", "XMLQUERY", "XMLROOT", "XMLSEQUENCE", "XMLSERIALIZE", "XMLTABLE", "XMLTRANSFORM", "DECODE", "DUMP", "ORA_HASH", "VSIZE", "LNNVL", "NVL", "NVL2", "SYS_CONTEXT", "SYS_GUID", "SYS_TYPEID", "UID", "USERENV", "CORR_S", "CORR_K", "FIRST", "GROUP_ID", "GROUPING_ID", "LAST", "MEDIAN", "STATS_BINOMIAL_TEST", "STATS_CROSSTAB", "STATS_F_TEST", "STATS_KS_TEST", "STATS_MODE", "STATS_MW_TEST", "STATS_ONE_WAY_ANOVA", "STATS_T_TEST_ONE", "STATS_T_TEST_PAIRED", "STATS_T_TEST_INDEP", "STATS_T_TEST_INDEPU", "STATS_WSR_TEST", "STDDEV", "VARIANCE", "FIRST", "FIRST_VALUE", "LAG", "LAST", "LAST_VALUE", "LEAD", "NTILE", "RATIO_TO_REPORT", "STDDEV", "VARIANCE", "MAKE_REF", "REFTOHEX", "CV", "ITERATION_NUMBER", "PRESENTNNV", "PRESENTV", "PREVIOUS", "EXTRACT", "LISTAGG", "OVER"));
        this.removeSQLKeyword("SYSTEM");
        String[] stringArray = ADVANCED_KEYWORDS;
        int n = ADVANCED_KEYWORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String kw = stringArray[n2];
            this.addSQLKeyword(kw);
            ++n2;
        }
    }

    public String[][] getBlockBoundStrings() {
        return ORACLE_BEGIN_END_BLOCK;
    }

    public String[] getBlockHeaderStrings() {
        return ORACLE_BLOCK_HEADERS;
    }

    @NotNull
    public String[] getExecuteKeywords() {
        return EXEC_KEYWORDS;
    }

    @NotNull
    public SQLDialect.MultiValueInsertMode getMultiValueInsertMode() {
        return SQLDialect.MultiValueInsertMode.GROUP_ROWS;
    }

    public boolean supportsAliasInSelect() {
        return true;
    }

    public boolean supportsAliasInUpdate() {
        return true;
    }

    public boolean supportsTableDropCascade() {
        return true;
    }

    public boolean isDelimiterAfterBlock() {
        return true;
    }

    @NotNull
    public DBDBinaryFormatter getNativeBinaryFormatter() {
        return OracleBinaryFormatter.INSTANCE;
    }

    @Nullable
    public String getDualTableName() {
        return "DUAL";
    }

    @NotNull
    protected String[] getNonTransactionKeywords() {
        return ORACLE_NON_TRANSACTIONAL_KEYWORDS;
    }

    protected String getStoredProcedureCallInitialClause(DBSProcedure proc) {
        String schemaName = proc.getParentObject().getName();
        return "CALL " + schemaName + "." + proc.getName();
    }

    public boolean isDisableScriptEscapeProcessing() {
        return this.preferenceStore == null || this.preferenceStore.getBoolean("oracle.disable.script.escape");
    }

    @NotNull
    public String getScriptDelimiter() {
        return super.getScriptDelimiter();
    }

    public boolean isCRLFBroken() {
        return this.crlfBroken;
    }
}

