/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.database;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPProjectListener;
import org.jkiss.dbeaver.model.navigator.DBNEmptyNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIExecutionQueue;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.INavigatorFilter;
import org.jkiss.dbeaver.ui.navigator.NavigatorStatePersistor;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorContent;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTreeFilter;
import org.jkiss.dbeaver.ui.navigator.database.NavigatorViewBase;

public class DatabaseNavigatorView
extends NavigatorViewBase
implements DBPProjectListener {
    public static final String VIEW_ID = "org.jkiss.dbeaver.core.databaseNavigator";
    private IMemento memento;

    public DatabaseNavigatorView() {
        DBWorkbench.getPlatform().getWorkspace().addProjectListener((DBPProjectListener)this);
    }

    public void saveState(IMemento memento) {
        if (DBWorkbench.getPlatform().getPreferenceStore().getInt("navigator.restore.state.depth") > 0) {
            new NavigatorStatePersistor().saveState(this.getNavigatorViewer().getExpandedElements(), memento);
        }
    }

    private void restoreState() {
        int maxDepth = DBWorkbench.getPlatform().getPreferenceStore().getInt("navigator.restore.state.depth");
        if (maxDepth > 0) {
            new NavigatorStatePersistor().restoreState(this.getNavigatorViewer(), this.getRootNode(), maxDepth, this.memento);
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.memento = memento;
        super.init(site, memento);
    }

    @Override
    protected INavigatorFilter getNavigatorFilter() {
        return new DatabaseNavigatorTreeFilter();
    }

    @Override
    public DBNNode getRootNode() {
        DBNProject projectNode = this.getModel().getRoot().getProjectNode(DBWorkbench.getPlatform().getWorkspace().getActiveProject());
        return projectNode == null ? new DBNEmptyNode() : projectNode.getDatabases();
    }

    @Override
    public void dispose() {
        DBWorkbench.getPlatform().getWorkspace().removeProjectListener((DBPProjectListener)this);
        super.dispose();
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        UIUtils.setHelp((Control)parent, (String)"view-database-navigator");
        UIExecutionQueue.queueExec(this::restoreState);
    }

    public void handleProjectAdd(DBPProject project) {
    }

    public void handleProjectRemove(DBPProject project) {
    }

    public void handleActiveProjectChange(DBPProject oldValue, DBPProject newValue) {
        UIUtils.asyncExec(() -> {
            this.getNavigatorTree().getViewer().setInput((Object)new DatabaseNavigatorContent(this.getRootNode()));
            this.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection());
        });
    }
}

