/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dnd.TreeNodeTransfer;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectCreateBase;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class NavigatorHandlerObjectCreateCopy
extends NavigatorHandlerObjectCreateBase {
    static final Log log = Log.getLog(NavigatorHandlerObjectCreateCopy.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        DBNNode curNode = NavigatorUtils.getSelectedNode(selection);
        if (curNode != null) {
            Clipboard clipboard = new Clipboard(Display.getDefault());
            try {
                Collection cbNodes = (Collection)clipboard.getContents((Transfer)TreeNodeTransfer.getInstance());
                if (cbNodes != null) {
                    for (DBNNode nodeObject : cbNodes) {
                        if (nodeObject instanceof DBNDatabaseNode) {
                            this.createNewObject(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event), curNode, (DBNDatabaseNode)nodeObject);
                            continue;
                        }
                        if (!(nodeObject instanceof DBNResource) || !(curNode instanceof DBNResource)) continue;
                        this.pasteResource((DBNResource)nodeObject, (DBNResource)curNode);
                    }
                } else if (curNode instanceof DBNResource) {
                    String[] files = (String[])clipboard.getContents((Transfer)FileTransfer.getInstance());
                    if (files != null) {
                        String[] stringArray = files;
                        int n = files.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String fileName = stringArray[n2];
                            File file = new File(fileName);
                            if (file.exists()) {
                                this.pasteResource(file, (DBNResource)curNode);
                            }
                            ++n2;
                        }
                    } else {
                        log.debug((Object)"Paste error: unsupported clipboard format. File or folder were expected.");
                        Display.getCurrent().beep();
                    }
                } else {
                    log.debug((Object)"Paste error: clipboard contains data in unsupported format");
                    Display.getCurrent().beep();
                }
            }
            finally {
                clipboard.dispose();
            }
        }
        return null;
    }

    private void pasteResource(DBNResource resourceNode, DBNResource toFolder) {
        final IResource resource = resourceNode.getResource();
        IResource targetResource = toFolder.getResource();
        assert (resource != null);
        assert (targetResource != null);
        final IContainer targetFolder = targetResource instanceof IContainer ? (IContainer)targetResource : targetResource.getParent();
        try {
            UIUtils.runInProgressService((DBRRunnableWithProgress)new DBRRunnableWithProgress(){

                public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        NavigatorHandlerObjectCreateCopy.this.copyResource(monitor, resource, targetFolder);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Copy error", "Error copying resource", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
    }

    private void copyResource(@NotNull DBRProgressMonitor monitor, @NotNull IResource resource, @NotNull IContainer targetFolder) throws CoreException, IOException {
        block19: {
            String targetName;
            IProgressMonitor nestedMonitor;
            block18: {
                nestedMonitor = RuntimeUtils.getNestedMonitor((DBRProgressMonitor)monitor);
                String extension = resource.getFileExtension();
                targetName = resource.getName();
                if (resource.getParent().equals((Object)targetFolder)) {
                    String plainName = extension != null && !extension.isEmpty() && targetName.endsWith(extension) ? targetName.substring(0, targetName.length() - extension.length() - 1) : targetName;
                    int i = 1;
                    while (true) {
                        String testName = String.valueOf(plainName) + "-" + i;
                        if (!CommonUtils.isEmpty((String)extension)) {
                            testName = String.valueOf(testName) + "." + extension;
                        }
                        if (targetFolder.findMember(testName) == null) {
                            targetName = testName;
                            break block18;
                        }
                        ++i;
                    }
                }
                if (targetFolder.findMember(targetName) != null) {
                    throw new IOException("Target resource '" + targetName + "' already exists");
                }
            }
            if (resource instanceof IFile) {
                Map props;
                IFile targetFile = targetFolder.getFile((IPath)new Path(targetName));
                if (!targetFile.exists()) {
                    targetFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, nestedMonitor);
                }
                if ((props = resource.getPersistentProperties()) != null && !props.isEmpty()) {
                    for (Map.Entry prop : props.entrySet()) {
                        targetFile.setPersistentProperty((QualifiedName)prop.getKey(), (String)prop.getValue());
                    }
                }
                Throwable throwable = null;
                Iterator iterator = null;
                try (InputStream is = ((IFile)resource).getContents();){
                    targetFile.setContents(is, true, true, nestedMonitor);
                    break block19;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            boolean cfr_ignored_0 = resource instanceof IFolder;
        }
    }

    private void pasteResource(final File file, DBNResource toFolder) {
        IResource targetResource = toFolder.getResource();
        assert (targetResource != null);
        final IContainer targetFolder = targetResource instanceof IContainer ? (IContainer)targetResource : targetResource.getParent();
        try {
            UIUtils.runInProgressService((DBRRunnableWithProgress)new DBRRunnableWithProgress(){

                public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IFile targetFile = targetFolder.getFile((IPath)new Path(file.getName()));
                        if (targetFile.exists()) {
                            throw new IOException("Target file '" + targetFile.getFullPath() + "' already exists");
                        }
                        Throwable throwable = null;
                        Object var4_6 = null;
                        try (FileInputStream is = new FileInputStream(file);){
                            targetFile.create((InputStream)is, true, monitor.getNestedMonitor());
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Copy error", "Error copying resource", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
    }
}

