/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.IClippingStrategy;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.ViewportUtilities;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;

public class ViewportAwareConnectionLayerClippingStrategy
implements IClippingStrategy {
    private static final Insets PRIVATE_INSETS = new Insets(0, 0, 1, 1);
    private ConnectionLayer connectionLayer = null;

    public ViewportAwareConnectionLayerClippingStrategy(ConnectionLayer connectionLayer) {
        this.connectionLayer = connectionLayer;
    }

    public Rectangle[] getClip(IFigure figure) {
        Rectangle[] clipRect = null;
        clipRect = figure instanceof Connection ? this.getEdgeClippingRectangle((Connection)figure) : new Rectangle[]{this.getNodeClippingRectangle(figure)};
        int i = 0;
        while (i < clipRect.length) {
            figure.translateToRelative(clipRect[i]);
            ++i;
        }
        return clipRect;
    }

    protected Rectangle[] getEdgeClippingRectangle(Connection connection) {
        Viewport nearestEnclosingTargetViewport;
        Viewport nearestEnclosingSourceViewport;
        IFigure targetFigure;
        Rectangle clipRect = this.getAbsoluteBoundsAsCopy(connection);
        ConnectionAnchor sourceAnchor = connection.getSourceAnchor();
        ConnectionAnchor targetAnchor = connection.getTargetAnchor();
        if (sourceAnchor == null || sourceAnchor.getOwner() == null || targetAnchor == null || targetAnchor.getOwner() == null) {
            return new Rectangle[]{clipRect};
        }
        IFigure sourceFigure = sourceAnchor.getOwner();
        Viewport nearestEnclosingCommonViewport = ViewportUtilities.getNearestCommonViewport(sourceFigure, targetFigure = targetAnchor.getOwner());
        if (nearestEnclosingCommonViewport == null) {
            return new Rectangle[]{clipRect};
        }
        if (nearestEnclosingCommonViewport != this.getRootViewport()) {
            clipRect.intersect(this.getNodeClippingRectangle(nearestEnclosingCommonViewport));
        }
        if ((nearestEnclosingSourceViewport = ViewportUtilities.getNearestEnclosingViewport(sourceFigure)) != (nearestEnclosingTargetViewport = ViewportUtilities.getNearestEnclosingViewport(targetFigure))) {
            Rectangle sourceClipRect = clipRect.getCopy();
            if (nearestEnclosingSourceViewport != nearestEnclosingCommonViewport) {
                this.clipAtViewports(sourceClipRect, ViewportUtilities.getViewportsPath(nearestEnclosingSourceViewport, nearestEnclosingCommonViewport, false));
            }
            Rectangle targetClipRect = clipRect.getCopy();
            if (nearestEnclosingTargetViewport != nearestEnclosingCommonViewport) {
                this.clipAtViewports(targetClipRect, ViewportUtilities.getViewportsPath(nearestEnclosingTargetViewport, nearestEnclosingCommonViewport, false));
            }
            PointList absolutePointsAsCopy = this.getAbsolutePointsAsCopy(connection);
            boolean sourceAnchorVisible = sourceClipRect.getExpanded(PRIVATE_INSETS).contains(absolutePointsAsCopy.getFirstPoint());
            boolean targetAnchorVisible = targetClipRect.getExpanded(PRIVATE_INSETS).contains(absolutePointsAsCopy.getLastPoint());
            if (!sourceAnchorVisible || !targetAnchorVisible) {
                return new Rectangle[0];
            }
            return new Rectangle[]{clipRect};
        }
        return new Rectangle[]{clipRect};
    }

    protected Rectangle getNodeClippingRectangle(IFigure figure) {
        Rectangle clipRect = this.getAbsoluteBoundsAsCopy(figure);
        List enclosingViewportsPath = ViewportUtilities.getViewportsPath(ViewportUtilities.getNearestEnclosingViewport(figure), this.getRootViewport(), false);
        this.clipAtViewports(clipRect, enclosingViewportsPath);
        return clipRect;
    }

    protected void clipAtViewports(Rectangle clipRect, List enclosingViewportsPath) {
        Iterator iterator = enclosingViewportsPath.iterator();
        while (iterator.hasNext()) {
            Viewport viewport = (Viewport)iterator.next();
            clipRect.intersect(this.getAbsoluteViewportAreaAsCopy(viewport));
        }
    }

    protected Viewport getRootViewport() {
        return ViewportUtilities.getNearestEnclosingViewport(this.connectionLayer);
    }

    protected PointList getAbsolutePointsAsCopy(Connection connection) {
        PointList points = connection.getPoints().getCopy();
        connection.translateToAbsolute(points);
        return points;
    }

    protected Rectangle getAbsoluteViewportAreaAsCopy(Viewport viewport) {
        return this.getAbsoluteClientAreaAsCopy(viewport);
    }

    protected Rectangle getAbsoluteClientAreaAsCopy(IFigure figure) {
        Rectangle absoluteClientArea = figure.getClientArea();
        figure.translateToParent(absoluteClientArea);
        figure.translateToAbsolute(absoluteClientArea);
        return absoluteClientArea;
    }

    protected Rectangle getAbsoluteBoundsAsCopy(IFigure figure) {
        Rectangle absoluteFigureBounds = figure.getBounds().getCopy();
        figure.translateToAbsolute(absoluteFigureBounds);
        return absoluteFigureBounds;
    }
}

