/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLProcedure;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBPScriptObjectExt;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSPackage;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureContainer;

public class MySQLPackage
implements DBPScriptObject,
DBPScriptObjectExt,
DBSObjectContainer,
DBPRefreshableObject,
DBSProcedureContainer,
DBSPackage,
DBPQualifiedObject {
    private MySQLCatalog catalog;
    private String name;
    private String description;
    private boolean persisted;
    private final ProceduresCache proceduresCache = new ProceduresCache();
    private String sourceDeclaration;
    private String sourceDefinition;

    public MySQLPackage(MySQLCatalog catalog, ResultSet dbResult) {
        this.catalog = catalog;
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"name");
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"comment");
        this.persisted = true;
    }

    public MySQLPackage(MySQLCatalog catalog, String name) {
        this.catalog = catalog;
        this.name = name;
        this.persisted = false;
    }

    public DBPDataSource getDataSource() {
        return this.catalog.getDataSource();
    }

    public DBSObject getParentObject() {
        return this.catalog;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    @Property(viewable=true, order=1)
    public String getName() {
        return this.name;
    }

    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getCatalog(), this});
    }

    @Property(viewable=true, order=100)
    public String getDescription() {
        return this.description;
    }

    public MySQLCatalog getCatalog() {
        return this.catalog;
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBCException {
        if (this.sourceDeclaration == null && monitor != null) {
            this.sourceDeclaration = this.readSource(monitor, false);
        }
        return this.sourceDeclaration;
    }

    public void setObjectDefinitionText(String sourceDeclaration) {
        this.sourceDeclaration = sourceDeclaration;
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getExtendedDefinitionText(DBRProgressMonitor monitor) throws DBException {
        if (this.sourceDefinition == null && monitor != null) {
            this.sourceDefinition = this.readSource(monitor, true);
        }
        return this.sourceDefinition;
    }

    public void setExtendedDefinitionText(String source) {
        this.sourceDefinition = source;
    }

    @Association
    public Collection<MySQLProcedure> getProcedures(DBRProgressMonitor monitor) throws DBException {
        return this.proceduresCache.getAllObjects(monitor, (DBSObject)this);
    }

    public MySQLProcedure getProcedure(DBRProgressMonitor monitor, String uniqueName) throws DBException {
        return (MySQLProcedure)this.proceduresCache.getObject(monitor, (DBSObject)this, uniqueName);
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.proceduresCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.proceduresCache.getObject(monitor, (DBSObject)this, childName);
    }

    public Class<? extends DBSObject> getChildType(@NotNull DBRProgressMonitor monitor) throws DBException {
        return MySQLProcedure.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        this.proceduresCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.proceduresCache.clearCache();
        this.sourceDeclaration = null;
        this.sourceDefinition = null;
        return this;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readSource(DBRProgressMonitor monitor, boolean isBody) throws DBCException {
        try {
            var3_3 = null;
            var4_6 = null;
            try {
                session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read package declaration");
                try {
                    var6_9 = null;
                    var7_11 = null;
                    try {
                        dbStat = session.prepareStatement("SHOW CREATE PACKAGE" + (isBody != false ? " BODY" : "") + " " + this.getFullyQualifiedName(DBPEvaluationContext.DML));
                        try {
                            var9_14 = null;
                            var10_16 = null;
                            try {
                                block25: {
                                    dbResult = dbStat.executeQuery();
                                    try {
                                        if (dbResult.next()) {
                                            v0 = JDBCUtils.safeGetString((ResultSet)dbResult, (String)(isBody != false ? "Create Package Body" : "Create Package"));
                                            if (dbResult == null) break block25;
                                        }
                                        ** GOTO lbl-1000
                                    }
                                    catch (Throwable var9_15) {
                                        if (dbResult == null) throw var9_15;
                                        dbResult.close();
                                        throw var9_15;
                                    }
                                    dbResult.close();
                                }
                                if (dbStat == null) return v0;
                            }
                            catch (Throwable var10_17) {
                                if (var9_14 == null) {
                                    var9_14 = var10_17;
                                    throw var9_14;
                                }
                                if (var9_14 == var10_17) throw var9_14;
                                var9_14.addSuppressed(var10_17);
                                throw var9_14;
                            }
                        }
                        catch (Throwable var6_10) {
                            if (dbStat == null) throw var6_10;
                            dbStat.close();
                            throw var6_10;
                        }
                        dbStat.close();
                        return v0;
                    }
                    catch (Throwable var7_12) {
                        if (var6_9 == null) {
                            var6_9 = var7_12;
                            throw var6_9;
                        }
                        if (var6_9 == var7_12) throw var6_9;
                        var6_9.addSuppressed(var7_12);
                        throw var6_9;
                    }
lbl-1000:
                    // 1 sources

                    {
                        throw new DBCException("Package '" + this.getName() + "' not found");
                    }
                }
                finally {
                    if (session != null) {
                        session.close();
                    }
                }
            }
            catch (Throwable var4_7) {
                if (var3_3 == null) {
                    var3_3 = var4_7;
                    throw var3_3;
                }
                if (var3_3 == var4_7) throw var3_3;
                var3_3.addSuppressed(var4_7);
                throw var3_3;
            }
        }
        catch (SQLException e) {
            throw new DBCException(e, this.getDataSource());
        }
    }

    static class ProceduresCache
    extends JDBCObjectCache<MySQLPackage, MySQLProcedure> {
        ProceduresCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull MySQLPackage owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT P.*,CASE WHEN A.DATA_TYPE IS NULL THEN 'PROCEDURE' ELSE 'FUNCTION' END as PROCEDURE_TYPE FROM ALL_PROCEDURES P\nLEFT OUTER JOIN ALL_ARGUMENTS A ON A.OWNER=P.OWNER AND A.PACKAGE_NAME=P.OBJECT_NAME AND A.OBJECT_NAME=P.PROCEDURE_NAME AND A.ARGUMENT_NAME IS NULL AND A.DATA_LEVEL=0\nWHERE P.OWNER=? AND P.OBJECT_NAME=?\nORDER BY P.PROCEDURE_NAME");
            dbStat.setString(1, owner.getCatalog().getName());
            dbStat.setString(2, owner.getName());
            return dbStat;
        }

        protected MySQLProcedure fetchObject(@NotNull JDBCSession session, @NotNull MySQLPackage owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new MySQLProcedure(owner.getCatalog(), (ResultSet)dbResult);
        }
    }
}

