/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.util.List;
import java.util.regex.Pattern;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLPrivilege;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableBase;
import org.jkiss.dbeaver.ext.mysql.model.MySQLUser;
import org.jkiss.dbeaver.model.access.DBAPrivilegeGrant;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class MySQLGrant
implements DBAPrivilegeGrant {
    public static final Pattern TABLE_GRANT_PATTERN = Pattern.compile("GRANT\\s+(.+)\\s+ON\\s+`?([^`]+)`?\\.`?([^`]+)`?\\s+TO\\s+");
    public static final Pattern GLOBAL_GRANT_PATTERN = Pattern.compile("GRANT\\s+(.+)\\s+ON\\s+(.+)\\s+TO\\s+");
    private MySQLUser user;
    private List<MySQLPrivilege> privileges;
    @Nullable
    private String catalogName;
    @Nullable
    private String tableName;
    private boolean allPrivileges;
    private boolean grantOption;

    public MySQLGrant(MySQLUser user, List<MySQLPrivilege> privileges, @Nullable String catalogName, @Nullable String tableName, boolean allPrivileges, boolean grantOption) {
        this.user = user;
        this.privileges = privileges;
        this.catalogName = catalogName;
        this.tableName = tableName;
        this.allPrivileges = allPrivileges;
        this.grantOption = grantOption;
    }

    public MySQLUser getSubject(DBRProgressMonitor monitor) {
        return this.user;
    }

    public Object getObject(DBRProgressMonitor monitor) throws DBException {
        MySQLTable table;
        MySQLCatalog catalog;
        if (this.catalogName != null && !this.isAllCatalogs() && (catalog = this.user.getDataSource().getCatalog(this.catalogName)) != null && !this.isAllTables() && (table = catalog.getTable(monitor, this.tableName)) != null) {
            return table;
        }
        return String.valueOf(this.catalogName) + "." + this.tableName;
    }

    public MySQLPrivilege[] getPrivileges() {
        return this.privileges.toArray(new MySQLPrivilege[0]);
    }

    public boolean isGranted() {
        return true;
    }

    public boolean isAllCatalogs() {
        return "*".equals(this.catalogName);
    }

    @Nullable
    public String getCatalog() {
        return this.catalogName;
    }

    @Nullable
    public String getTable() {
        return this.tableName;
    }

    public boolean isAllTables() {
        return "*".equals(this.tableName);
    }

    public boolean isAllPrivileges() {
        return this.allPrivileges;
    }

    public void addPrivilege(MySQLPrivilege privilege) {
        this.privileges.add(privilege);
    }

    public void removePrivilege(MySQLPrivilege privilege) {
        this.privileges.remove(privilege);
    }

    public boolean isGrantOption() {
        return this.grantOption;
    }

    public void setGrantOption(boolean grantOption) {
        this.grantOption = grantOption;
    }

    public boolean isEmpty() {
        return this.privileges.isEmpty() && !this.isAllPrivileges() && !this.isGrantOption();
    }

    public boolean matches(MySQLCatalog catalog) {
        return catalog == null && this.isAllCatalogs() || catalog != null && catalog.getName().equalsIgnoreCase(this.catalogName);
    }

    public boolean matches(MySQLTableBase table) {
        return table == null && this.isAllTables() || table != null && table.getName().equalsIgnoreCase(this.tableName);
    }

    public boolean hasNonAdminPrivileges() {
        for (MySQLPrivilege priv : this.privileges) {
            if (priv.getKind() == MySQLPrivilege.Kind.ADMIN) continue;
            return true;
        }
        return false;
    }

    public boolean isStatic() {
        return CommonUtils.isEmpty((String)this.catalogName) || "*".equals(this.catalogName);
    }
}

