/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class MySQLDatabaseManager
extends SQLObjectEditor<MySQLCatalog, MySQLDataSource>
implements DBEObjectRenamer<MySQLCatalog> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    @Nullable
    public DBSObjectCache<MySQLDataSource, MySQLCatalog> getObjectsCache(MySQLCatalog object) {
        return object.getDataSource().getCatalogCache();
    }

    protected MySQLCatalog createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        return new MySQLCatalog((MySQLDataSource)((Object)container), null);
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        MySQLCatalog catalog = (MySQLCatalog)command.getObject();
        StringBuilder script = new StringBuilder("CREATE SCHEMA `" + catalog.getName() + "`");
        this.appendDatabaseModifiers(catalog, script);
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create schema", script.toString()));
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        MySQLCatalog catalog = (MySQLCatalog)command.getObject();
        StringBuilder script = new StringBuilder("ALTER DATABASE `" + catalog.getName() + "`");
        this.appendDatabaseModifiers(catalog, script);
        actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Alter database", script.toString()));
    }

    private void appendDatabaseModifiers(MySQLCatalog catalog, StringBuilder script) {
        if (catalog.getAdditionalInfo().getDefaultCharset() != null) {
            script.append("\nDEFAULT CHARACTER SET ").append(catalog.getAdditionalInfo().getDefaultCharset().getName());
        }
        if (catalog.getAdditionalInfo().getDefaultCollation() != null) {
            script.append("\nDEFAULT COLLATE ").append(catalog.getAdditionalInfo().getDefaultCollation().getName());
        }
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop schema", "DROP SCHEMA `" + ((MySQLCatalog)command.getObject()).getName() + "`"));
    }

    public void renameObject(DBECommandContext commandContext, MySQLCatalog catalog, String newName) throws DBException {
        throw new DBException("Direct database rename is not yet implemented in MySQL. You should use export/import functions for that.");
    }
}

