/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.sql.SQLControlCommand;
import org.jkiss.dbeaver.model.sql.SQLParametersProvider;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.registry.SQLCommandHandlerDescriptor;
import org.jkiss.dbeaver.model.sql.registry.SQLCommandsRegistry;
import org.jkiss.utils.CommonUtils;

public class SQLScriptContext {
    private final Map<String, Object> variables = new HashMap<String, Object>();
    private final Map<String, Object> pragmas = new HashMap<String, Object>();
    private Map<String, Object> statementPragmas;
    private final Map<String, Object> data = new HashMap<String, Object>();
    @Nullable
    private final SQLScriptContext parentContext;
    @NotNull
    private final DBPContextProvider contextProvider;
    @Nullable
    private final File sourceFile;
    @NotNull
    private final PrintWriter outputWriter;
    private SQLParametersProvider parametersProvider;
    private boolean ignoreParameters;

    public SQLScriptContext(@Nullable SQLScriptContext parentContext, @NotNull DBPContextProvider contextProvider, @Nullable File sourceFile, @NotNull Writer outputWriter, @Nullable SQLParametersProvider parametersProvider) {
        this.parentContext = parentContext;
        this.contextProvider = contextProvider;
        this.sourceFile = sourceFile;
        this.outputWriter = new PrintWriter(outputWriter);
        this.parametersProvider = parametersProvider;
    }

    @NotNull
    public DBCExecutionContext getExecutionContext() {
        return this.contextProvider.getExecutionContext();
    }

    @Nullable
    public File getSourceFile() {
        return this.sourceFile;
    }

    public boolean hasVariable(String name) {
        if (this.variables.containsKey(name)) {
            return true;
        }
        return this.parentContext != null && this.parentContext.hasVariable(name);
    }

    public Object getVariable(String name) {
        Object value = this.variables.get(name);
        if (value == null && this.parentContext != null) {
            value = this.parentContext.getVariable(name);
        }
        return value;
    }

    public void setVariable(String name, Object value) {
        this.variables.put(name, value);
        if (this.parentContext != null) {
            this.parentContext.setVariable(name, value);
        }
    }

    @NotNull
    public Map<String, Object> getPragmas() {
        return this.pragmas;
    }

    public void setStatementPragma(String name, Object value) {
        if (this.statementPragmas == null) {
            this.statementPragmas = new LinkedHashMap<String, Object>();
        }
        this.statementPragmas.put(name, value);
    }

    public Object getStatementPragma(String name) {
        return this.statementPragmas == null ? null : this.statementPragmas.get(name);
    }

    public Object getData(String key) {
        return this.data.get(key);
    }

    public void setData(String key, Object value) {
        this.data.put(key, value);
    }

    @NotNull
    public PrintWriter getOutputWriter() {
        return this.outputWriter;
    }

    public void clearStatementContext() {
        this.statementPragmas = null;
    }

    public boolean isIgnoreParameters() {
        return this.ignoreParameters;
    }

    public void setIgnoreParameters(boolean ignoreParameters) {
        this.ignoreParameters = ignoreParameters;
    }

    public boolean executeControlCommand(SQLControlCommand command) throws DBException {
        if (command.isEmptyCommand()) {
            return true;
        }
        SQLCommandHandlerDescriptor commandHandler = SQLCommandsRegistry.getInstance().getCommandHandler(command.getCommandId());
        if (commandHandler == null) {
            throw new DBException("Command '" + command.getCommand() + "' not supported");
        }
        return commandHandler.createHandler().handleCommand(command, this);
    }

    public void copyFrom(SQLScriptContext context) {
        this.variables.clear();
        this.variables.putAll(context.variables);
        this.data.clear();
        this.data.putAll(context.data);
        this.pragmas.clear();
        this.pragmas.putAll(context.pragmas);
    }

    public boolean fillQueryParameters(SQLQuery query) {
        if (this.ignoreParameters || this.parametersProvider == null) {
            return true;
        }
        List parameters = query.getParameters();
        if (CommonUtils.isEmpty((Collection)parameters)) {
            return true;
        }
        Boolean paramsResult = this.parametersProvider.prepareStatementParameters(this, query, parameters);
        if (paramsResult == null) {
            this.ignoreParameters = true;
            return true;
        }
        if (!paramsResult.booleanValue()) {
            return false;
        }
        SQLUtils.fillQueryParameters((SQLQuery)query, (List)parameters);
        return true;
    }
}

