/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.IDataSourceContainerProvider;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;

public abstract class AbstractDataSourceHandler
extends AbstractHandler {
    protected static final Log log = Log.getLog(AbstractDataSourceHandler.class);

    protected DBCExecutionContext getExecutionContext(ExecutionEvent event, boolean useEditor) {
        if (useEditor) {
            IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            if (editor instanceof DBPContextProvider) {
                return ((DBPContextProvider)editor).getExecutionContext();
            }
            return null;
        }
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof DBPContextProvider) {
            return ((DBPContextProvider)activePart).getExecutionContext();
        }
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        DBSObject selectedObject = NavigatorUtils.getSelectedObject(selection);
        if (selectedObject != null) {
            return DBUtils.getDefaultContext((DBSObject)selectedObject, (boolean)false);
        }
        return null;
    }

    protected static DBPDataSourceContainer getDataSourceContainer(ExecutionEvent event, boolean useEditor) {
        if (useEditor) {
            DBPDataSourceContainer container;
            IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            if (editor != null && (container = AbstractDataSourceHandler.getDataSourceContainer((IWorkbenchPart)editor)) != null) {
                return container;
            }
            return null;
        }
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        DBPDataSourceContainer container = AbstractDataSourceHandler.getDataSourceContainer(activePart);
        if (container != null) {
            return container;
        }
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        DBSObject selectedObject = NavigatorUtils.getSelectedObject(selection);
        if (selectedObject instanceof DBPDataSourceContainer) {
            return (DBPDataSourceContainer)selectedObject;
        }
        if (selectedObject != null) {
            DBPDataSource dataSource = selectedObject.getDataSource();
            return dataSource == null ? null : dataSource.getContainer();
        }
        return null;
    }

    public static DBCExecutionContext getExecutionContext(IWorkbenchPart activePart) {
        if (activePart instanceof DBPContextProvider) {
            return ((DBPContextProvider)activePart).getExecutionContext();
        }
        return null;
    }

    public static DBPDataSourceContainer getDataSourceContainer(IWorkbenchPart activePart) {
        if (activePart instanceof IDataSourceContainerProvider) {
            return ((IDataSourceContainerProvider)activePart).getDataSourceContainer();
        }
        if (activePart instanceof DBPContextProvider) {
            DBCExecutionContext context = ((DBPContextProvider)activePart).getExecutionContext();
            return context == null ? null : context.getDataSource().getContainer();
        }
        return null;
    }
}

