/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.internal.MergeViewerAction;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.ChangeEncodingAction;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.texteditor.ITextEditor;

public class MergeSourceViewer
implements ISelectionChangedListener,
ITextListener,
IMenuListener,
IOperationHistoryListener,
IAdaptable {
    public static final String UNDO_ID = "undo";
    public static final String REDO_ID = "redo";
    public static final String CUT_ID = "cut";
    public static final String COPY_ID = "copy";
    public static final String PASTE_ID = "paste";
    public static final String DELETE_ID = "delete";
    public static final String SELECT_ALL_ID = "selectAll";
    public static final String FIND_ID = "find";
    public static final String GOTO_LINE_ID = "gotoLine";
    public static final String CHANGE_ENCODING_ID = "changeEncoding";
    private ResourceBundle fResourceBundle;
    private ICompareContainer fContainer;
    private SourceViewer fSourceViewer;
    private Position fRegion;
    private boolean fEnabled = true;
    private HashMap<String, IAction> fActions = new HashMap();
    private IDocument fRememberedDocument;
    private boolean fAddSaveAction = true;
    private boolean isConfigured = false;
    private IPropertyChangeListener fPreferenceChangeListener;
    private boolean fShowLineNumber = false;
    private LineNumberRulerColumn fLineNumberColumn;
    private List<IAction> textActions = new ArrayList<IAction>();
    private CommandContributionItem fSaveContributionItem;

    public MergeSourceViewer(SourceViewer sourceViewer, ResourceBundle bundle, ICompareContainer container) {
        IOperationHistory history;
        Assert.isNotNull((Object)sourceViewer);
        this.fSourceViewer = sourceViewer;
        this.fResourceBundle = bundle;
        this.fContainer = container;
        MenuManager menu = new MenuManager();
        menu.setRemoveAllWhenShown(true);
        menu.addMenuListener((IMenuListener)this);
        StyledText te = this.getSourceViewer().getTextWidget();
        te.setMenu(menu.createContextMenu((Control)te));
        this.fContainer.registerContextMenu(menu, (ISelectionProvider)this.getSourceViewer());
        this.fPreferenceChangeListener = event -> this.handlePropertyChangeEvent(event);
        EditorsUI.getPreferenceStore().addPropertyChangeListener(this.fPreferenceChangeListener);
        this.fShowLineNumber = EditorsUI.getPreferenceStore().getBoolean("lineNumberRuler");
        if (this.fShowLineNumber) {
            this.updateLineNumberRuler();
        }
        if ((history = this.getHistory()) != null) {
            history.addOperationHistoryListener((IOperationHistoryListener)this);
        }
        this.fAddSaveAction = this.fContainer.getWorkbenchPart() != null;
    }

    public void rememberDocument(IDocument doc) {
        this.fRememberedDocument = doc;
    }

    public IDocument getRememberedDocument() {
        return this.fRememberedDocument;
    }

    public void hideSaveAction() {
        this.fAddSaveAction = false;
    }

    public void setFont(Font font) {
        StyledText te = this.getSourceViewer().getTextWidget();
        if (te != null) {
            te.setFont(font);
        }
        if (this.fLineNumberColumn != null) {
            this.fLineNumberColumn.setFont(font);
            this.layoutViewer();
        }
    }

    public void setBackgroundColor(Color color) {
        StyledText te = this.getSourceViewer().getTextWidget();
        if (te != null) {
            te.setBackground(color);
        }
        if (this.fLineNumberColumn != null) {
            this.fLineNumberColumn.setBackground(color);
        }
    }

    public void setForegroundColor(Color color) {
        StyledText te = this.getSourceViewer().getTextWidget();
        if (te != null) {
            te.setForeground(color);
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.fEnabled) {
            this.fEnabled = enabled;
            StyledText c = this.getSourceViewer().getTextWidget();
            if (c != null) {
                c.setEnabled(enabled);
                Display d = c.getDisplay();
                if (enabled) {
                    c.setBackground(d.getSystemColor(25));
                }
            }
        }
    }

    public boolean getEnabled() {
        return this.fEnabled;
    }

    public void setRegion(Position region) {
        this.fRegion = region;
    }

    public Position getRegion() {
        return this.fRegion;
    }

    public boolean isControlOkToUse() {
        StyledText t = this.getSourceViewer().getTextWidget();
        return t != null && !t.isDisposed();
    }

    public void setSelection(Position position) {
        if (position != null) {
            this.getSourceViewer().setSelectedRange(position.getOffset(), position.getLength());
        }
    }

    public void setLineBackground(Position position, Color c) {
        StyledText t = this.getSourceViewer().getTextWidget();
        if (t != null && !t.isDisposed()) {
            Point region = new Point(0, 0);
            this.getLineRange(position, region);
            region.x -= this.getDocumentRegionOffset();
            try {
                t.setLineBackground(region.x, region.y, c);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public void resetLineBackground() {
        StyledText t = this.getSourceViewer().getTextWidget();
        if (t != null && !t.isDisposed()) {
            int lines = this.getLineCount();
            t.setLineBackground(0, lines, null);
        }
    }

    public int getLineCount() {
        IRegion region = this.getSourceViewer().getVisibleRegion();
        int length = region.getLength();
        if (length == 0) {
            return 0;
        }
        IDocument doc = this.getSourceViewer().getDocument();
        int startLine = 0;
        int endLine = 0;
        int start = region.getOffset();
        try {
            startLine = doc.getLineOfOffset(start);
        }
        catch (BadLocationException badLocationException) {}
        try {
            endLine = doc.getLineOfOffset(start + length);
        }
        catch (BadLocationException badLocationException) {}
        return endLine - startLine + 1;
    }

    public int getViewportLines() {
        StyledText te = this.getSourceViewer().getTextWidget();
        Rectangle clArea = te.getClientArea();
        if (!clArea.isEmpty()) {
            return clArea.height / te.getLineHeight();
        }
        return 0;
    }

    public int getViewportHeight() {
        StyledText te = this.getSourceViewer().getTextWidget();
        Rectangle clArea = te.getClientArea();
        if (!clArea.isEmpty()) {
            return clArea.height;
        }
        return 0;
    }

    public int getDocumentRegionOffset() {
        int start = this.getSourceViewer().getVisibleRegion().getOffset();
        IDocument doc = this.getSourceViewer().getDocument();
        if (doc != null) {
            try {
                return doc.getLineOfOffset(start);
            }
            catch (BadLocationException badLocationException) {}
        }
        return 0;
    }

    public int getVerticalScrollOffset() {
        StyledText st = this.getSourceViewer().getTextWidget();
        int lineHeight = st.getLineHeight();
        return this.getSourceViewer().getTopInset() - (this.getDocumentRegionOffset() * lineHeight + st.getTopPixel());
    }

    public Point getLineRange(Position p, Point region) {
        IDocument doc = this.getSourceViewer().getDocument();
        if (p == null || doc == null) {
            region.x = 0;
            region.y = 0;
            return region;
        }
        int start = p.getOffset();
        int length = p.getLength();
        int startLine = 0;
        try {
            startLine = doc.getLineOfOffset(start);
        }
        catch (BadLocationException badLocationException) {}
        int lineCount = 0;
        if (length != 0) {
            int endLine = 0;
            try {
                endLine = doc.getLineOfOffset(start + length - 1);
            }
            catch (BadLocationException badLocationException) {}
            lineCount = endLine - startLine + 1;
        }
        region.x = startLine;
        region.y = lineCount;
        return region;
    }

    public void vscroll(int line) {
        int srcExtentSize;
        int srcViewSize = this.getLineCount();
        if (srcViewSize > (srcExtentSize = this.getViewportLines())) {
            int cp;
            if (line < 0) {
                line = 0;
            }
            if ((cp = this.getSourceViewer().getTopIndex()) != line) {
                this.getSourceViewer().setTopIndex(line + this.getDocumentRegionOffset());
            }
        }
    }

    public void addAction(String actionId, MergeViewerAction action) {
        this.fActions.put(actionId, (IAction)action);
    }

    public IAction getAction(String actionId) {
        MergeViewerAction mva;
        IAction action = this.fActions.get(actionId);
        if (action == null) {
            action = this.createAction(actionId);
            if (action == null) {
                return null;
            }
            if (action instanceof MergeViewerAction) {
                mva = (MergeViewerAction)action;
                if (mva.isContentDependent()) {
                    this.getSourceViewer().addTextListener((ITextListener)this);
                }
                if (mva.isSelectionDependent()) {
                    this.getSourceViewer().addSelectionChangedListener((ISelectionChangedListener)this);
                }
                Utilities.initAction(action, this.fResourceBundle, "action." + actionId + ".");
            }
            this.addAction(actionId, action);
        }
        if (action instanceof MergeViewerAction && (mva = (MergeViewerAction)action).isEditableDependent() && !this.getSourceViewer().isEditable()) {
            return null;
        }
        return action;
    }

    protected IAction createAction(String actionId) {
        if (UNDO_ID.equals(actionId)) {
            return new TextOperationAction(1, "org.eclipse.ui.edit.undo", true, false, true);
        }
        if (REDO_ID.equals(actionId)) {
            return new TextOperationAction(2, "org.eclipse.ui.edit.redo", true, false, true);
        }
        if (CUT_ID.equals(actionId)) {
            return new TextOperationAction(3, "org.eclipse.ui.edit.cut", true, true, false);
        }
        if (COPY_ID.equals(actionId)) {
            return new TextOperationAction(4, "org.eclipse.ui.edit.copy", false, true, false);
        }
        if (PASTE_ID.equals(actionId)) {
            return new TextOperationAction(5, "org.eclipse.ui.edit.paste", true, false, false);
        }
        if (DELETE_ID.equals(actionId)) {
            return new TextOperationAction(6, "org.eclipse.ui.edit.delete", true, false, false);
        }
        if (SELECT_ALL_ID.equals(actionId)) {
            return new TextOperationAction(7, "org.eclipse.ui.edit.selectAll", false, false, false);
        }
        return null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        for (IAction next : this.fActions.values()) {
            MergeViewerAction action;
            if (!(next instanceof MergeViewerAction) || !(action = (MergeViewerAction)next).isSelectionDependent()) continue;
            action.update();
        }
    }

    public void textChanged(TextEvent event) {
        this.updateContentDependantActions();
    }

    void updateContentDependantActions() {
        for (IAction next : this.fActions.values()) {
            MergeViewerAction action;
            if (!(next instanceof MergeViewerAction) || !(action = (MergeViewerAction)next).isContentDependent()) continue;
            action.update();
        }
    }

    public void menuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator(UNDO_ID));
        this.addMenu(menu, UNDO_ID);
        this.addMenu(menu, REDO_ID);
        menu.add((IContributionItem)new GroupMarker("save"));
        if (this.fAddSaveAction) {
            this.addSave(menu);
        }
        menu.add((IContributionItem)new Separator("file"));
        menu.add((IContributionItem)new Separator("ccp"));
        this.addMenu(menu, CUT_ID);
        this.addMenu(menu, COPY_ID);
        this.addMenu(menu, PASTE_ID);
        this.addMenu(menu, DELETE_ID);
        this.addMenu(menu, SELECT_ALL_ID);
        menu.add((IContributionItem)new Separator("edit"));
        this.addMenu(menu, CHANGE_ENCODING_ID);
        menu.add((IContributionItem)new Separator(FIND_ID));
        this.addMenu(menu, FIND_ID);
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("text"));
        for (IAction action : this.textActions) {
            menu.add(action);
        }
        menu.add((IContributionItem)new Separator("rest"));
        this.updateActions();
    }

    private void addMenu(IMenuManager menu, String actionId) {
        IAction action = this.getAction(actionId);
        if (action != null) {
            menu.add(action);
        }
    }

    private void addSave(IMenuManager menu) {
        ICommandService commandService = (ICommandService)this.fContainer.getWorkbenchPart().getSite().getService(ICommandService.class);
        Command command = commandService.getCommand("org.eclipse.ui.file.save");
        IHandler handler = command.getHandler();
        if (handler != null) {
            if (this.fSaveContributionItem == null) {
                this.fSaveContributionItem = new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)this.fContainer.getWorkbenchPart().getSite(), null, command.getId(), 8));
            }
            if (handler.isHandled() && this.getSourceViewer().isEditable()) {
                menu.add((IContributionItem)this.fSaveContributionItem);
            }
        }
    }

    public void dispose() {
        this.getSourceViewer().removeTextListener((ITextListener)this);
        this.getSourceViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        EditorsUI.getPreferenceStore().removePropertyChangeListener(this.fPreferenceChangeListener);
        IOperationHistory history = this.getHistory();
        if (history != null) {
            history.removeOperationHistoryListener((IOperationHistoryListener)this);
        }
    }

    public void updateActions() {
        for (IAction next : this.fActions.values()) {
            MergeViewerAction action;
            if (next instanceof MergeViewerAction) {
                action = (MergeViewerAction)next;
                action.update();
                continue;
            }
            if (next instanceof FindReplaceAction) {
                action = (FindReplaceAction)next;
                action.update();
                continue;
            }
            if (!(next instanceof ChangeEncodingAction)) continue;
            action = (ChangeEncodingAction)next;
            action.update();
        }
    }

    public void configure(SourceViewerConfiguration configuration) {
        if (this.isConfigured) {
            this.getSourceViewer().unconfigure();
        }
        this.isConfigured = true;
        this.getSourceViewer().configure(configuration);
    }

    public void setBounds(int x, int y, int width, int height) {
        if (this.getSourceViewer().getControl() instanceof Composite) {
            ((Composite)this.getSourceViewer().getControl()).setBounds(x, y, width, height);
        } else {
            this.getSourceViewer().getTextWidget().setBounds(x, y, width, height);
        }
    }

    protected void handlePropertyChangeEvent(PropertyChangeEvent event) {
        String key = event.getProperty();
        if (key.equals("lineNumberRuler")) {
            boolean b = EditorsUI.getPreferenceStore().getBoolean("lineNumberRuler");
            if (b != this.fShowLineNumber) {
                this.toggleLineNumberRuler();
            }
        } else if (key.equals("lineNumberColor")) {
            this.updateLineNumberColumnPresentation(true);
        }
    }

    private void updateLineNumberRuler() {
        if (!this.fShowLineNumber) {
            if (this.fLineNumberColumn != null) {
                this.getSourceViewer().removeVerticalRulerColumn((IVerticalRulerColumn)this.fLineNumberColumn);
            }
        } else {
            if (this.fLineNumberColumn == null) {
                this.fLineNumberColumn = new LineNumberRulerColumn();
                this.updateLineNumberColumnPresentation(false);
            }
            this.getSourceViewer().addVerticalRulerColumn((IVerticalRulerColumn)this.fLineNumberColumn);
        }
    }

    private void updateLineNumberColumnPresentation(boolean refresh) {
        if (this.fLineNumberColumn == null) {
            return;
        }
        RGB rgb = this.getColorFromStore(EditorsUI.getPreferenceStore(), "lineNumberColor");
        if (rgb == null) {
            rgb = new RGB(0, 0, 0);
        }
        ISharedTextColors sharedColors = this.getSharedColors();
        this.fLineNumberColumn.setForeground(sharedColors.getColor(rgb));
        if (refresh) {
            this.fLineNumberColumn.redraw();
        }
    }

    private void layoutViewer() {
        Control parent = this.getSourceViewer().getControl();
        if (parent instanceof Composite && !parent.isDisposed()) {
            ((Composite)parent).layout(true);
        }
    }

    private ISharedTextColors getSharedColors() {
        return EditorsUI.getSharedTextColors();
    }

    private RGB getColorFromStore(IPreferenceStore store, String key) {
        RGB rgb = null;
        if (store.contains(key)) {
            rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        }
        return rgb;
    }

    private void toggleLineNumberRuler() {
        this.fShowLineNumber = !this.fShowLineNumber;
        this.updateLineNumberRuler();
    }

    public void addTextAction(IAction textEditorPropertyAction) {
        this.textActions.add(textEditorPropertyAction);
    }

    public boolean removeTextAction(IAction textEditorPropertyAction) {
        return this.textActions.remove(textEditorPropertyAction);
    }

    public void addAction(String id, IAction action) {
        this.fActions.put(id, action);
    }

    private IOperationHistory getHistory() {
        if (PlatformUI.getWorkbench() == null) {
            return null;
        }
        return PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
    }

    public void historyNotification(OperationHistoryEvent event) {
        IUndoContext context = this.getUndoContext();
        if (context != null && event.getOperation().hasContext(context)) {
            Display.getDefault().asyncExec(() -> this.updateContentDependantActions());
        }
    }

    private IUndoContext getUndoContext() {
        IUndoManager undoManager = this.getSourceViewer().getUndoManager();
        if (undoManager instanceof IUndoManagerExtension) {
            return ((IUndoManagerExtension)undoManager).getUndoContext();
        }
        return null;
    }

    public SourceViewer getSourceViewer() {
        return this.fSourceViewer;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == ITextEditor.class) {
            return (T)new TextEditorAdapter();
        }
        return null;
    }

    class TextEditorAdapter
    implements ITextEditor {
        TextEditorAdapter() {
        }

        public void close(boolean save) {
        }

        public void doRevertToSaved() {
        }

        public IAction getAction(String actionId) {
            return null;
        }

        public IDocumentProvider getDocumentProvider() {
            return new IDocumentProvider(){

                public void aboutToChange(Object element) {
                }

                public void addElementStateListener(IElementStateListener listener) {
                }

                public boolean canSaveDocument(Object element) {
                    return false;
                }

                public void changed(Object element) {
                }

                public void connect(Object element) throws CoreException {
                }

                public void disconnect(Object element) {
                }

                public IAnnotationModel getAnnotationModel(Object element) {
                    return null;
                }

                public IDocument getDocument(Object element) {
                    return MergeSourceViewer.this.getSourceViewer().getDocument();
                }

                public long getModificationStamp(Object element) {
                    return 0L;
                }

                public long getSynchronizationStamp(Object element) {
                    return 0L;
                }

                public boolean isDeleted(Object element) {
                    return false;
                }

                public boolean mustSaveDocument(Object element) {
                    return false;
                }

                public void removeElementStateListener(IElementStateListener listener) {
                }

                public void resetDocument(Object element) throws CoreException {
                }

                public void saveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
                }
            };
        }

        public IRegion getHighlightRange() {
            return null;
        }

        public ISelectionProvider getSelectionProvider() {
            return MergeSourceViewer.this.getSourceViewer().getSelectionProvider();
        }

        public boolean isEditable() {
            return false;
        }

        public void removeActionActivationCode(String actionId) {
        }

        public void resetHighlightRange() {
        }

        public void selectAndReveal(int start, int length) {
            this.selectAndReveal(start, length, start, length);
        }

        private void selectAndReveal(int selectionStart, int selectionLength, int revealStart, int revealLength) {
            ITextSelection textSelection;
            ISelection selection = this.getSelectionProvider().getSelection();
            if (selection instanceof ITextSelection && ((textSelection = (ITextSelection)selection).getOffset() != 0 || textSelection.getLength() != 0)) {
                this.markInNavigationHistory();
            }
            StyledText widget = MergeSourceViewer.this.getSourceViewer().getTextWidget();
            widget.setRedraw(false);
            this.adjustHighlightRange(revealStart, revealLength);
            MergeSourceViewer.this.getSourceViewer().revealRange(revealStart, revealLength);
            MergeSourceViewer.this.getSourceViewer().setSelectedRange(selectionStart, selectionLength);
            this.markInNavigationHistory();
            widget.setRedraw(true);
        }

        private void markInNavigationHistory() {
            this.getSite().getPage().getNavigationHistory().markLocation((IEditorPart)this);
        }

        private void adjustHighlightRange(int offset, int length) {
            if (MergeSourceViewer.this instanceof ITextViewerExtension5) {
                ITextViewerExtension5 extension = (ITextViewerExtension5)MergeSourceViewer.this;
                extension.exposeModelRange((IRegion)new Region(offset, length));
            } else if (!this.isVisible((ITextViewer)MergeSourceViewer.this.getSourceViewer(), offset, length)) {
                MergeSourceViewer.this.getSourceViewer().resetVisibleRegion();
            }
        }

        private final boolean isVisible(ITextViewer viewer, int offset, int length) {
            if (viewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
                IRegion overlap = extension.modelRange2WidgetRange((IRegion)new Region(offset, length));
                return overlap != null;
            }
            return viewer.overlapsWithVisibleRegion(offset, length);
        }

        public void setAction(String actionID, IAction action) {
        }

        public void setActionActivationCode(String actionId, char activationCharacter, int activationKeyCode, int activationStateMask) {
        }

        public void setHighlightRange(int offset, int length, boolean moveCursor) {
        }

        public void showHighlightRangeOnly(boolean showHighlightRangeOnly) {
        }

        public boolean showsHighlightRangeOnly() {
            return false;
        }

        public IEditorInput getEditorInput() {
            if (MergeSourceViewer.this.fContainer.getWorkbenchPart() instanceof IEditorPart) {
                return ((IEditorPart)MergeSourceViewer.this.fContainer.getWorkbenchPart()).getEditorInput();
            }
            return null;
        }

        public IEditorSite getEditorSite() {
            return null;
        }

        public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        }

        public void addPropertyListener(IPropertyListener listener) {
        }

        public void createPartControl(Composite parent) {
        }

        public void dispose() {
        }

        public IWorkbenchPartSite getSite() {
            return MergeSourceViewer.this.fContainer.getWorkbenchPart().getSite();
        }

        public String getTitle() {
            return null;
        }

        public Image getTitleImage() {
            return null;
        }

        public String getTitleToolTip() {
            return null;
        }

        public void removePropertyListener(IPropertyListener listener) {
        }

        public void setFocus() {
        }

        public <T> T getAdapter(Class<T> adapter) {
            return null;
        }

        public void doSave(IProgressMonitor monitor) {
        }

        public void doSaveAs() {
        }

        public boolean isDirty() {
            return false;
        }

        public boolean isSaveAsAllowed() {
            return false;
        }

        public boolean isSaveOnCloseNeeded() {
            return false;
        }
    }

    class TextOperationAction
    extends MergeViewerAction {
        private int fOperationCode;

        TextOperationAction(int operationCode, boolean mutable, boolean selection, boolean content) {
            this(operationCode, null, mutable, selection, content);
        }

        public TextOperationAction(int operationCode, String actionDefinitionId, boolean mutable, boolean selection, boolean content) {
            super(mutable, selection, content);
            if (actionDefinitionId != null) {
                this.setActionDefinitionId(actionDefinitionId);
            }
            this.fOperationCode = operationCode;
            this.update();
        }

        public void run() {
            if (this.isEnabled()) {
                MergeSourceViewer.this.getSourceViewer().doOperation(this.fOperationCode);
            }
        }

        public boolean isEnabled() {
            return this.fOperationCode != -1 && MergeSourceViewer.this.getSourceViewer().canDoOperation(this.fOperationCode);
        }

        @Override
        public void update() {
            this.setEnabled(this.isEnabled());
        }
    }
}

