/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPExternalFileManager;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPProjectListener;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.app.DBPResourceHandlerDescriptor;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.virtual.DBVModel;
import org.jkiss.dbeaver.registry.ProjectMetadata;
import org.jkiss.dbeaver.registry.ResourceHandlerDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.SecurityUtils;

public abstract class BaseWorkspaceImpl
implements DBPWorkspace,
DBPExternalFileManager {
    private static final Log log = Log.getLog(BaseWorkspaceImpl.class);
    public static final String DEFAULT_RESOURCES_ROOT = "Resources";
    private static final String PROP_PROJECT_ACTIVE = "project.active";
    private static final String EXT_FILES_PROPS_STORE = "dbeaver-external-files.data";
    private static final String WORKSPACE_ID = "workspace-id";
    private final DBPPlatform platform;
    private final IWorkspace eclipseWorkspace;
    private final Map<IProject, ProjectMetadata> projects = new LinkedHashMap<IProject, ProjectMetadata>();
    private final ProjectListener projectListener;
    private ProjectMetadata activeProject;
    private final List<DBPProjectListener> projectListeners = new ArrayList<DBPProjectListener>();
    private final List<ResourceHandlerDescriptor> handlerDescriptors = new ArrayList<ResourceHandlerDescriptor>();
    private final Map<String, Map<String, Object>> externalFileProperties = new HashMap<String, Map<String, Object>>();

    protected BaseWorkspaceImpl(DBPPlatform platform, IWorkspace eclipseWorkspace) {
        this.platform = platform;
        this.eclipseWorkspace = eclipseWorkspace;
        String activeProjectName = platform.getPreferenceStore().getString(PROP_PROJECT_ACTIVE);
        IWorkspaceRoot root = eclipseWorkspace.getRoot();
        Object[] allProjects = root.getProjects();
        if (ArrayUtils.isEmpty((Object[])allProjects)) {
            try {
                this.refreshWorkspaceContents((DBRProgressMonitor)new LoggingProgressMonitor());
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
        }
        Object[] objectArray = allProjects;
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object project = objectArray[n2];
            if (project.exists() && !project.isHidden()) {
                ProjectMetadata projectMetadata = new ProjectMetadata(this, (IProject)project);
                this.projects.put((IProject)project, projectMetadata);
                if (this.activeProject == null || !CommonUtils.isEmpty((String)activeProjectName) && project.getName().equals(activeProjectName)) {
                    this.activeProject = projectMetadata;
                }
            }
            ++n2;
        }
        if (this.activeProject != null && !this.activeProject.isOpen()) {
            try {
                this.activeProject.ensureOpen();
            }
            catch (IllegalStateException e) {
                log.error((Object)"Error opening active project", (Throwable)e);
            }
        }
        this.projectListener = new ProjectListener();
        eclipseWorkspace.addResourceChangeListener((IResourceChangeListener)this.projectListener);
        this.loadExtensions(Platform.getExtensionRegistry());
        this.loadExternalFileProperties();
    }

    public void initializeProjects() {
        if (DBWorkbench.getPlatform().getApplication().isStandalone() && CommonUtils.isEmpty(this.projects)) {
            try {
                this.createDefaultProject((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                log.error((Object)"Can't create default project", (Throwable)e);
            }
        }
        if (this.activeProject == null && !this.projects.isEmpty()) {
            this.activeProject = this.projects.values().iterator().next();
            this.platform.getPreferenceStore().setValue(PROP_PROJECT_ACTIVE, this.activeProject.getName());
        }
    }

    public static Properties readWorkspaceInfo(File metadataFolder) {
        Properties props = new Properties();
        File versionFile = new File(metadataFolder, "dbeaver-workspace.properties");
        if (versionFile.exists()) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (FileInputStream is = new FileInputStream(versionFile);){
                    props.load(is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return props;
    }

    public static void writeWorkspaceInfo(File metadataFolder, Properties props) {
        File versionFile = new File(metadataFolder, "dbeaver-workspace.properties");
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileOutputStream os = new FileOutputStream(versionFile);){
                props.store(os, "DBeaver workspace version");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.resourceHandler");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            ResourceHandlerDescriptor handlerDescriptor = new ResourceHandlerDescriptor(ext);
            this.handlerDescriptors.add(handlerDescriptor);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.eclipseWorkspace.removeResourceChangeListener((IResourceChangeListener)this.projectListener);
        Map<IProject, ProjectMetadata> map = this.projects;
        synchronized (map) {
            for (ProjectMetadata project : this.projects.values()) {
                project.dispose();
            }
            this.projects.clear();
        }
        DBVModel.checkGlobalCacheIsEmpty();
        for (ResourceHandlerDescriptor handlerDescriptor : this.handlerDescriptors) {
            handlerDescriptor.dispose();
        }
        this.handlerDescriptors.clear();
        if (!this.projectListeners.isEmpty()) {
            log.warn((Object)("Some project listeners are still register: " + this.projectListeners));
            this.projectListeners.clear();
        }
    }

    @NotNull
    public IWorkspace getEclipseWorkspace() {
        return this.eclipseWorkspace;
    }

    public List<DBPProject> getProjects() {
        return new ArrayList<DBPProject>(this.projects.values());
    }

    public DBPProject getActiveProject() {
        return this.activeProject;
    }

    public void setActiveProject(DBPProject project) {
        ProjectMetadata oldActiveProject = this.activeProject;
        this.activeProject = (ProjectMetadata)project;
        this.platform.getPreferenceStore().setValue(PROP_PROJECT_ACTIVE, project == null ? "" : project.getName());
        this.fireActiveProjectChange(oldActiveProject, this.activeProject);
    }

    public DBPProject getProject(IProject project) {
        return this.projects.get(project);
    }

    public DBPProject getProject(String projectName) {
        IProject eProject = this.eclipseWorkspace.getRoot().getProject(projectName);
        if (!eProject.exists()) {
            return null;
        }
        return this.getProject(eProject);
    }

    public void refreshWorkspaceContents(DBRProgressMonitor monitor) throws DBException {
        block9: {
            try {
                IWorkspaceRoot root = this.eclipseWorkspace.getRoot();
                root.refreshLocal(1, monitor.getNestedMonitor());
                File workspaceLocation = root.getLocation().toFile();
                if (!workspaceLocation.exists()) {
                    return;
                }
                IProject[] iProjectArray = root.getProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    File projectDir = project.getLocation().toFile();
                    if (!projectDir.exists()) {
                        monitor.subTask("Removing unexistent project '" + project.getName() + "'");
                        project.delete(false, true, monitor.getNestedMonitor());
                    }
                    ++n2;
                }
                Object[] wsFiles = workspaceLocation.listFiles();
                if (ArrayUtils.isEmpty((Object[])wsFiles)) break block9;
                monitor.beginTask("Refreshing workspace contents", wsFiles.length);
                Object[] objectArray = wsFiles;
                int n3 = wsFiles.length;
                n = 0;
                while (n < n3) {
                    String projectName;
                    IProject project;
                    File projectConfig;
                    Object wsFile = objectArray[n];
                    if (((File)wsFile).isDirectory() && !((File)wsFile).isHidden() && !((File)wsFile).getName().startsWith(".") && (projectConfig = new File((File)wsFile, ".project")).exists() && !(project = root.getProject(projectName = ((File)wsFile).getName())).exists()) {
                        try {
                            monitor.subTask("Adding project '" + projectName + "'");
                            project.create(monitor.getNestedMonitor());
                        }
                        catch (CoreException coreException) {
                            log.error((Object)("Error adding project '" + projectName + "' to workspace"));
                        }
                    }
                    ++n;
                }
            }
            catch (Throwable e) {
                log.error((Object)"Error refreshing workspce contents", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProjectListener(DBPProjectListener listener) {
        List<DBPProjectListener> list = this.projectListeners;
        synchronized (list) {
            this.projectListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProjectListener(DBPProjectListener listener) {
        List<DBPProjectListener> list = this.projectListeners;
        synchronized (list) {
            this.projectListeners.remove(listener);
        }
    }

    @NotNull
    public DBPPlatform getPlatform() {
        return this.platform;
    }

    public boolean isActive() {
        return true;
    }

    @NotNull
    public File getAbsolutePath() {
        return this.eclipseWorkspace.getRoot().getLocation().toFile();
    }

    @NotNull
    public File getMetadataFolder() {
        return GeneralUtils.getMetadataFolder((File)this.getAbsolutePath());
    }

    public void save(DBRProgressMonitor monitor) throws DBException {
        try {
            this.eclipseWorkspace.save(true, monitor.getNestedMonitor());
        }
        catch (CoreException e) {
            throw new DBException("Error saving Eclipse workspace", (Throwable)e);
        }
    }

    private IProject createDefaultProject(IProgressMonitor monitor) throws CoreException {
        String baseProjectName;
        String projectName = baseProjectName = DBWorkbench.getPlatform().getApplication().getDefaultProjectName();
        int i = 1;
        while (true) {
            IProject project;
            if (!(project = this.eclipseWorkspace.getRoot().getProject(projectName)).exists()) {
                project.create(monitor);
                project.open(monitor);
                IProjectDescription description = this.eclipseWorkspace.newProjectDescription(project.getName());
                description.setComment("General DBeaver project");
                description.setNatureIds(new String[]{"org.jkiss.dbeaver.DBeaverNature"});
                project.setDescription(description, monitor);
                return project;
            }
            projectName = String.valueOf(baseProjectName) + i;
            ++i;
        }
    }

    private ResourceHandlerDescriptor getHandlerDescriptor(String id) {
        for (ResourceHandlerDescriptor rhd : this.handlerDescriptors) {
            if (!rhd.getId().equals(id)) continue;
            return rhd;
        }
        return null;
    }

    private ResourceHandlerDescriptor getHandlerDescriptorByRootPath(DBPProject project, String path) {
        for (ResourceHandlerDescriptor rhd : this.handlerDescriptors) {
            String defaultRoot = rhd.getDefaultRoot(project);
            if (defaultRoot == null || !defaultRoot.equals(path)) continue;
            return rhd;
        }
        return null;
    }

    public DBPResourceHandler getResourceHandler(IResource resource) {
        if (resource == null || resource.isHidden() || resource.isPhantom()) {
            return null;
        }
        if (resource.getParent() instanceof IProject && resource.getName().startsWith(".dbeaver-data-sources")) {
            return null;
        }
        if (resource instanceof IFile && !resource.isSynchronized(0)) {
            ContentUtils.syncFile((DBRProgressMonitor)new VoidProgressMonitor(), (IResource)resource);
        }
        DBPResourceHandler handler = null;
        for (ResourceHandlerDescriptor rhd : this.handlerDescriptors) {
            if (!rhd.canHandle(resource)) continue;
            handler = rhd.getHandler();
            break;
        }
        if (handler == null && resource instanceof IFolder) {
            IProject eclipseProject = resource.getProject();
            DBPProject project = this.projects.get(eclipseProject);
            IPath relativePath = resource.getFullPath().makeRelativeTo(eclipseProject.getFullPath());
            while (relativePath.segmentCount() > 0) {
                String folderPath = relativePath.toString();
                ResourceHandlerDescriptor handlerDescriptor = this.getHandlerDescriptorByRootPath(project, folderPath);
                if (handlerDescriptor != null) {
                    handler = handlerDescriptor.getHandler();
                }
                relativePath = relativePath.removeLastSegments(1);
            }
        }
        if (handler == null) {
            handler = DBWorkbench.getPlatform().getDefaultResourceHandler();
        }
        return handler;
    }

    public DBPResourceHandlerDescriptor[] getAllResourceHandlers() {
        return this.handlerDescriptors.toArray(new DBPResourceHandlerDescriptor[0]);
    }

    public IFolder getResourceDefaultRoot(DBPProject project, DBPResourceHandlerDescriptor rhd, boolean forceCreate) {
        if (project == null) {
            return null;
        }
        String defaultRoot = rhd.getDefaultRoot(project);
        if (defaultRoot == null) {
            return null;
        }
        IFolder realFolder = project.getEclipseProject().getFolder(defaultRoot);
        if (forceCreate && !realFolder.exists()) {
            try {
                realFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                log.error((Object)("Can't create '" + rhd.getName() + "' root folder '" + realFolder.getName() + "'"), (Throwable)e);
                return realFolder;
            }
        }
        return realFolder;
    }

    public IFolder getResourceDefaultRoot(DBPProject project, Class<? extends DBPResourceHandler> handlerType, boolean forceCreate) {
        if (project == null) {
            return null;
        }
        for (ResourceHandlerDescriptor rhd : this.handlerDescriptors) {
            DBPResourceHandler handler = rhd.getHandler();
            if (handler == null || handler.getClass() != handlerType) continue;
            String defaultRoot = rhd.getDefaultRoot(project);
            if (defaultRoot == null) {
                return null;
            }
            IFolder realFolder = project.getEclipseProject().getFolder(defaultRoot);
            if (forceCreate && !realFolder.exists()) {
                try {
                    realFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    log.error((Object)("Can't create '" + rhd.getName() + "' root folder '" + realFolder.getName() + "'"), (Throwable)e);
                    return realFolder;
                }
            }
            return realFolder;
        }
        return project.getEclipseProject().getFolder(DEFAULT_RESOURCES_ROOT);
    }

    public DBPDataSourceRegistry getDefaultDataSourceRegistry() {
        return this.activeProject == null ? null : this.activeProject.getDataSourceRegistry();
    }

    public DBPResourceHandlerDescriptor[] getResourceHandlerDescriptors() {
        DBPResourceHandlerDescriptor[] result = new DBPResourceHandlerDescriptor[this.handlerDescriptors.size()];
        int i = 0;
        while (i < this.handlerDescriptors.size()) {
            result[i] = this.handlerDescriptors.get(i);
            ++i;
        }
        return result;
    }

    public Map<String, Object> getFileProperties(File file) {
        return this.externalFileProperties.get(file.getAbsolutePath());
    }

    public Object getFileProperty(File file, String property) {
        Map<String, Object> fileProps = this.externalFileProperties.get(file.getAbsolutePath());
        return fileProps == null ? null : fileProps.get(property);
    }

    public void setFileProperty(File file, String property, Object value) {
        String filePath = file.getAbsolutePath();
        Map<String, Object> fileProps = this.externalFileProperties.get(filePath);
        if (fileProps == null) {
            fileProps = new HashMap<String, Object>();
            this.externalFileProperties.put(filePath, fileProps);
        }
        if (value == null) {
            fileProps.remove(property);
        } else {
            fileProps.put(property, value);
        }
        this.saveExternalFileProperties();
    }

    public Map<String, Map<String, Object>> getAllFiles() {
        return this.externalFileProperties;
    }

    private void loadExternalFileProperties() {
        this.externalFileProperties.clear();
        File propsFile = new File(GeneralUtils.getMetadataFolder(), EXT_FILES_PROPS_STORE);
        if (propsFile.exists()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileInputStream is = new FileInputStream(propsFile);){
                    Throwable throwable2 = null;
                    Object var6_10 = null;
                    try (ObjectInputStream ois = new ObjectInputStream(is);){
                        Object object = ois.readObject();
                        if (object instanceof Map) {
                            this.externalFileProperties.putAll((Map)object);
                        } else {
                            log.error((Object)("Bad external files properties data format: " + object));
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error((Object)"Error saving external files properties", (Throwable)e);
            }
        }
    }

    private void saveExternalFileProperties() {
        File propsFile = new File(GeneralUtils.getMetadataFolder(), EXT_FILES_PROPS_STORE);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream os = new FileOutputStream(propsFile);){
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (ObjectOutputStream oos = new ObjectOutputStream(os);){
                    oos.writeObject(this.externalFileProperties);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error saving external files properties", (Throwable)e);
        }
    }

    private void fireActiveProjectChange(ProjectMetadata oldActiveProject, ProjectMetadata activeProject) {
        DBPProjectListener[] dBPProjectListenerArray = this.getListenersCopy();
        int n = dBPProjectListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPProjectListener listener = dBPProjectListenerArray[n2];
            listener.handleActiveProjectChange((DBPProject)oldActiveProject, (DBPProject)activeProject);
            ++n2;
        }
    }

    private void fireProjectAdd(ProjectMetadata project) {
        DBPProjectListener[] dBPProjectListenerArray = this.getListenersCopy();
        int n = dBPProjectListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPProjectListener listener = dBPProjectListenerArray[n2];
            listener.handleProjectAdd((DBPProject)project);
            ++n2;
        }
    }

    private void fireProjectRemove(ProjectMetadata project) {
        DBPProjectListener[] dBPProjectListenerArray = this.getListenersCopy();
        int n = dBPProjectListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPProjectListener listener = dBPProjectListenerArray[n2];
            listener.handleProjectRemove((DBPProject)project);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private DBPProjectListener[] getListenersCopy() {
        DBPProjectListener[] listeners;
        List<DBPProjectListener> list = this.projectListeners;
        synchronized (list) {
            listeners = this.projectListeners.toArray(new DBPProjectListener[0]);
        }
        return listeners;
    }

    private void handleResourceChange(ProjectMetadata projectMetadata, IResourceDelta delta) {
        if (delta.getKind() == 2) {
            IPath movedToPath = delta.getMovedToPath();
            if (movedToPath != null) {
                IPath oldPath = delta.getProjectRelativePath();
                IPath newPath = movedToPath.makeRelativeTo(projectMetadata.getEclipseProject().getFullPath());
                projectMetadata.updateResourceCache(oldPath, newPath);
            } else {
                projectMetadata.removeResourceFromCache(delta.getProjectRelativePath());
            }
        } else {
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren(31, 8);
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta childDelta = iResourceDeltaArray[n2];
                this.handleResourceChange(projectMetadata, childDelta);
                ++n2;
            }
        }
    }

    public static String readWorkspaceId() {
        Properties workspaceInfo = BaseWorkspaceImpl.readWorkspaceInfo(GeneralUtils.getMetadataFolder());
        String workspaceId = workspaceInfo.getProperty(WORKSPACE_ID);
        if (CommonUtils.isEmpty((String)workspaceId)) {
            workspaceId = "D" + Long.toString(Math.abs(SecurityUtils.generateRandomLong()), 36).toUpperCase();
            workspaceInfo.setProperty(WORKSPACE_ID, workspaceId);
            BaseWorkspaceImpl.writeWorkspaceInfo(GeneralUtils.getMetadataFolder(), workspaceInfo);
        }
        return workspaceId;
    }

    private class ProjectListener
    implements IResourceChangeListener {
        private ProjectListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() == 1) {
                IResourceDelta delta = event.getDelta();
                IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
                int n = iResourceDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta childDelta = iResourceDeltaArray[n2];
                    if (childDelta.getResource() instanceof IProject) {
                        ProjectMetadata projectMetadata;
                        IProject project = (IProject)childDelta.getResource();
                        if (!BaseWorkspaceImpl.this.projects.containsKey(project)) {
                            if (childDelta.getKind() == 1) {
                                projectMetadata = new ProjectMetadata(BaseWorkspaceImpl.this, project);
                                BaseWorkspaceImpl.this.projects.put(project, projectMetadata);
                                BaseWorkspaceImpl.this.fireProjectAdd(projectMetadata);
                                if (BaseWorkspaceImpl.this.activeProject == null) {
                                    BaseWorkspaceImpl.this.activeProject = projectMetadata;
                                    BaseWorkspaceImpl.this.fireActiveProjectChange(null, BaseWorkspaceImpl.this.activeProject);
                                }
                            } else {
                                log.error((Object)("Project '" + childDelta.getResource().getName() + "' not found in workspace"));
                            }
                        } else if (childDelta.getKind() == 2) {
                            projectMetadata = (ProjectMetadata)BaseWorkspaceImpl.this.projects.remove(project);
                            BaseWorkspaceImpl.this.fireProjectRemove(projectMetadata);
                            if (projectMetadata == BaseWorkspaceImpl.this.activeProject) {
                                BaseWorkspaceImpl.this.activeProject = null;
                                BaseWorkspaceImpl.this.fireActiveProjectChange(projectMetadata, null);
                            }
                        } else {
                            projectMetadata = (ProjectMetadata)BaseWorkspaceImpl.this.projects.get(project);
                            if (projectMetadata != null) {
                                BaseWorkspaceImpl.this.handleResourceChange(projectMetadata, childDelta);
                            }
                        }
                    }
                    ++n2;
                }
            }
        }
    }
}

