/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime;

import java.security.Provider;
import java.security.Security;
import org.jkiss.dbeaver.Log;

public class SecurityProviderUtils {
    private static final Log log = Log.getLog(SecurityProviderUtils.class);
    public static final String BC_SECURITY_PROVIDER_CLASS = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    private static String securityProvider = null;
    private static boolean registrationDone;

    public static void registerSecurityProvider() {
        if (!registrationDone) {
            try {
                if (securityProvider == null) {
                    SecurityProviderUtils.registerSecurityProvider(BC_SECURITY_PROVIDER_CLASS);
                    if (securityProvider == null) {
                        log.debug("BouncyCastle not registered, using the default JCE provider");
                    }
                }
            }
            finally {
                registrationDone = true;
            }
        }
    }

    private static boolean registerSecurityProvider(String providerClassName) {
        Provider provider = null;
        try {
            Class<?> name = Class.forName(providerClassName);
            provider = (Provider)name.newInstance();
        }
        catch (Exception exception) {
            log.debug("Can't find BC security provider. Use default JCE.");
        }
        if (provider == null) {
            return false;
        }
        try {
            if (Security.getProvider(provider.getName()) == null) {
                Security.addProvider(provider);
            }
            if (securityProvider == null) {
                securityProvider = provider.getName();
                log.debug("BounceCastle bundle found. Use JCE provider " + provider.getName());
                return true;
            }
        }
        catch (Exception e) {
            log.warn("Registration of Security Provider '" + providerClassName + "' unexpectedly failed", e);
        }
        return false;
    }
}

