/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.impls;

import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreServerExtension;
import org.jkiss.dbeaver.ext.postgresql.model.impls.PostgreServerTypeRegistry;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.utils.CommonUtils;

public class PostgreServerType
extends AbstractDescriptor {
    private static final Log log = Log.getLog(PostgreServerTypeRegistry.class);
    private final AbstractDescriptor.ObjectType type;
    private final String id;
    private final String name;
    private final DBPImage icon;
    private final String defaultDatabase;
    private final String defaultUser;
    private final boolean supportsCustomConnectionURL;

    protected PostgreServerType(IConfigurationElement config) {
        super(config);
        this.type = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.id = config.getAttribute("id");
        this.name = config.getAttribute("name");
        this.icon = this.iconToImage(config.getAttribute("logo"));
        this.defaultDatabase = config.getAttribute("defaultDatabase");
        this.defaultUser = config.getAttribute("defaultUser");
        this.supportsCustomConnectionURL = CommonUtils.getBoolean((String)config.getAttribute("customURL"), (boolean)false);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    public String getDefaultDatabase() {
        return this.defaultDatabase;
    }

    public String getDefaultUser() {
        return this.defaultUser;
    }

    public PostgreServerExtension createServerExtension(PostgreDataSource dataSource) throws DBException {
        try {
            return (PostgreServerExtension)this.type.getObjectClass().getConstructor(PostgreDataSource.class).newInstance(new Object[]{dataSource});
        }
        catch (Throwable e) {
            throw new DBException("Error instantiating PG server type", e);
        }
    }

    public boolean supportsCustomConnectionURL() {
        return this.supportsCustomConnectionURL;
    }
}

