/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.data;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCAbstractValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;

public class PostgreBitStringValueHandler
extends JDBCAbstractValueHandler {
    public static final PostgreBitStringValueHandler INSTANCE = new PostgreBitStringValueHandler();

    protected String fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws SQLException {
        return resultSet.getString(index);
    }

    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException, SQLException {
        String strValue = CommonUtils.toString((Object)value);
        if (strValue.isEmpty()) {
            statement.setNull(paramIndex, 1111);
        } else {
            statement.setObject(paramIndex, (Object)strValue, 1111);
        }
    }

    @NotNull
    public Class<?> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return String.class;
    }

    public String getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy) throws DBCException {
        return CommonUtils.toString((Object)object);
    }
}

