/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.SelectionEnabler;
import org.eclipse.ui.internal.ISelectionConversionService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.WizardCollectionElement;
import org.eclipse.ui.internal.registry.KeywordRegistry;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.IWorkbenchAdapter2;
import org.eclipse.ui.model.IWorkbenchAdapter3;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class WorkbenchWizardElement
extends WorkbenchAdapter
implements IAdaptable,
IPluginContribution,
IWizardDescriptor {
    private String id;
    private ImageDescriptor imageDescriptor;
    private SelectionEnabler selectionEnabler;
    private IConfigurationElement configurationElement;
    private ImageDescriptor descriptionImage;
    private WizardCollectionElement parentCategory;
    public static final String TAG_PROJECT = "project";
    private static final String[] EMPTY_TAGS = new String[0];
    private static final String[] PROJECT_TAGS = new String[]{"project"};
    private String[] keywordLabels;

    public WorkbenchWizardElement(IConfigurationElement configurationElement) {
        this.configurationElement = configurationElement;
        this.id = configurationElement.getAttribute("id");
    }

    public boolean canHandleSelection(IStructuredSelection selection) {
        return this.getSelectionEnabler().isEnabledForSelection((ISelection)selection);
    }

    @Override
    public IStructuredSelection adaptedSelection(IStructuredSelection selection) {
        if (this.canHandleSelection(selection)) {
            return selection;
        }
        IStructuredSelection adaptedSelection = this.convertToResources(selection);
        if (this.canHandleSelection(adaptedSelection)) {
            return adaptedSelection;
        }
        return StructuredSelection.EMPTY;
    }

    public Object createExecutableExtension() throws CoreException {
        return WorkbenchPlugin.createExtension(this.configurationElement, "class");
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IWorkbenchAdapter.class || adapter == IWorkbenchAdapter2.class || adapter == IWorkbenchAdapter3.class) {
            return adapter.cast(this);
        }
        if (adapter == IPluginContribution.class) {
            return adapter.cast(this);
        }
        if (adapter == IConfigurationElement.class) {
            return adapter.cast(this.configurationElement);
        }
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    @Override
    public String getDescription() {
        return RegistryReader.getDescription(this.configurationElement);
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        if (this.imageDescriptor == null) {
            String iconName = this.configurationElement.getAttribute("icon");
            if (iconName == null) {
                return null;
            }
            this.imageDescriptor = ResourceLocator.imageDescriptorFromBundle((String)this.configurationElement.getNamespaceIdentifier(), (String)iconName).orElse(null);
        }
        return this.imageDescriptor;
    }

    @Override
    public ImageDescriptor getImageDescriptor(Object element) {
        return this.getImageDescriptor();
    }

    @Override
    public String getLabel(Object element) {
        return this.configurationElement.getAttribute("name");
    }

    protected SelectionEnabler getSelectionEnabler() {
        if (this.selectionEnabler == null) {
            this.selectionEnabler = new SelectionEnabler(this.configurationElement);
        }
        return this.selectionEnabler;
    }

    private IStructuredSelection convertToResources(IStructuredSelection originalSelection) {
        Object selectionService = PlatformUI.getWorkbench().getService(ISelectionConversionService.class);
        if (selectionService == null || originalSelection == null) {
            return StructuredSelection.EMPTY;
        }
        return ((ISelectionConversionService)selectionService).convertToResources(originalSelection);
    }

    @Override
    public String getLocalId() {
        return this.getId();
    }

    @Override
    public String getPluginId() {
        return this.configurationElement != null ? this.configurationElement.getNamespaceIdentifier() : null;
    }

    @Override
    public ImageDescriptor getDescriptionImage() {
        if (this.descriptionImage == null) {
            String descImage = this.configurationElement.getAttribute("descriptionImage");
            if (descImage == null) {
                return null;
            }
            this.descriptionImage = ResourceLocator.imageDescriptorFromBundle((String)this.configurationElement.getNamespaceIdentifier(), (String)descImage).orElse(null);
        }
        return this.descriptionImage;
    }

    @Override
    public String getHelpHref() {
        return this.configurationElement.getAttribute("helpHref");
    }

    @Override
    public IWorkbenchWizard createWizard() throws CoreException {
        return (IWorkbenchWizard)this.createExecutableExtension();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.getLabel(this);
    }

    @Override
    public IWizardCategory getCategory() {
        return (IWizardCategory)this.getParent(this);
    }

    public WizardCollectionElement getCollectionElement() {
        return (WizardCollectionElement)this.getParent(this);
    }

    @Override
    public String[] getTags() {
        String flag = this.configurationElement.getAttribute(TAG_PROJECT);
        if (Boolean.parseBoolean(flag)) {
            return PROJECT_TAGS;
        }
        return EMPTY_TAGS;
    }

    @Override
    public Object getParent(Object object) {
        return this.parentCategory;
    }

    public void setParent(WizardCollectionElement parent) {
        this.parentCategory = parent;
    }

    @Override
    public boolean canFinishEarly() {
        return Boolean.parseBoolean(this.configurationElement.getAttribute("canFinishEarly"));
    }

    @Override
    public boolean hasPages() {
        String hasPagesString = this.configurationElement.getAttribute("hasPages");
        if (hasPagesString == null) {
            return true;
        }
        return Boolean.parseBoolean(hasPagesString);
    }

    public String[] getKeywordLabels() {
        if (this.keywordLabels == null) {
            IConfigurationElement[] children = this.configurationElement.getChildren("keywordReference");
            this.keywordLabels = new String[children.length];
            KeywordRegistry registry = KeywordRegistry.getInstance();
            int i = 0;
            while (i < children.length) {
                String id = children[i].getAttribute("id");
                this.keywordLabels[i] = registry.getKeywordLabel(id);
                ++i;
            }
        }
        return this.keywordLabels;
    }
}

